/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.sse.ui.internal.reconcile;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.DocumentRewriteSessionEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentExtension4;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.text.IDocumentRewriteSessionListener;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextInputListener;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.jface.text.reconciler.DirtyRegion;
import org.eclipse.jface.text.reconciler.IReconciler;
import org.eclipse.jface.text.reconciler.IReconcilerExtension;
import org.eclipse.jface.text.reconciler.IReconcilingStrategy;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.sse.ui.internal.Logger;
import org.eclipse.wst.sse.ui.internal.SSEUIMessages;
import org.eclipse.wst.sse.ui.internal.reconcile.IConfigurableReconciler;

public class DirtyRegionProcessor
extends Job
implements IReconciler,
IReconcilerExtension,
IConfigurableReconciler {
    protected static final boolean DEBUG;
    private static final long UPDATE_DELAY = 500L;
    private long fDelay;
    private List fDirtyRegionQueue = Collections.synchronizedList(new ArrayList());
    private IDocument fDocument = null;
    private IDocumentListener fDocumentListener = new DocumentListener();
    private IDocumentRewriteSessionListener fDocumentRewriteSessionListener = new DocumentRewriteSessionListener();
    private boolean fIsInstalled = false;
    ITypedRegion[] fLastPartitions;
    List fNonIncrementalStrategiesAlreadyProcessed = new ArrayList(1);
    private String fPartitioning;
    Map fReconcilingStrategies = null;
    private TextInputListener fTextInputListener = null;
    private ITextViewer fViewer;
    boolean fInRewriteSession = false;
    boolean fReprocessAfterRewrite = false;
    private boolean fReset = false;
    private Object LOCK = new Object();

    static {
        String value = Platform.getDebugOption((String)"org.eclipse.wst.sse.ui/debug/reconcilerjob");
        DEBUG = value != null && value.equalsIgnoreCase("true");
    }

    public DirtyRegionProcessor() {
        super(SSEUIMessages.proc_dirty_regions_0);
        this.setPriority(30);
        this.setSystem(true);
        this.setDelay(500L);
        this.fReconcilingStrategies = new HashMap();
    }

    private synchronized void addRequest(DirtyRegion newDirtyRegion) {
        List dirtyRegionQueue = this.getDirtyRegionQueue();
        Iterator it = dirtyRegionQueue.iterator();
        while (it.hasNext()) {
            DirtyRegion currentExisting = (DirtyRegion)it.next();
            DirtyRegion outer = this.getOuterRegion(currentExisting, newDirtyRegion);
            if (outer == currentExisting) {
                return;
            }
            if (outer != newDirtyRegion) continue;
            it.remove();
        }
        dirtyRegionQueue.add(newDirtyRegion);
    }

    protected void beginProcessing() {
    }

    protected ITypedRegion[] computePartitioning(DirtyRegion dirtyRegion) {
        int drOffset = dirtyRegion.getOffset();
        int drLength = dirtyRegion.getLength();
        return this.computePartitioning(drOffset, drLength);
    }

    protected ITypedRegion[] computePartitioning(int drOffset, int drLength) {
        IDocument doc = this.getDocument();
        int docLength = doc.getLength();
        ITypedRegion[] tr = new ITypedRegion[]{};
        if (drOffset > docLength) {
            drOffset = docLength;
            drLength = 0;
        } else if (drOffset + drLength > docLength) {
            drLength = docLength - drOffset;
        }
        try {
            tr = TextUtilities.computePartitioning((IDocument)doc, (String)this.getDocumentPartitioning(), (int)drOffset, (int)drLength, (boolean)true);
        }
        catch (BadLocationException e) {
            String info = "dr: [" + drOffset + ":" + drLength + "] doc: [" + docLength + "] ";
            Logger.logException(info, e);
            tr = new ITypedRegion[]{};
        }
        return tr;
    }

    protected DirtyRegion getOuterRegion(DirtyRegion root, DirtyRegion possible) {
        DirtyRegion outer = null;
        if (this.isContained(root, possible)) {
            outer = root;
        } else if (this.isContained(possible, root)) {
            outer = possible;
        }
        return outer;
    }

    private boolean isContained(DirtyRegion root, DirtyRegion possible) {
        int rootStart = root.getOffset();
        int rootEnd = rootStart + root.getLength();
        int possStart = possible.getOffset();
        int possEnd = possStart + possible.getLength();
        return rootStart <= possStart && rootEnd >= possEnd;
    }

    protected DirtyRegion createDirtyRegion(int offset, int length, String type) {
        DirtyRegion durty = null;
        IDocument doc = this.getDocument();
        if (doc != null) {
            int docLen = doc.getLength();
            if (offset > docLen) {
                offset = docLen;
                length = 0;
            } else if (offset + length >= docLen) {
                length = docLen - offset;
            }
            try {
                durty = new DirtyRegion(offset, length, type, doc.get(offset, length));
            }
            catch (BadLocationException e) {
                String info = "dr: [" + offset + ":" + length + "] doc: [" + docLen + "] ";
                Logger.logException(info, e);
            }
        }
        return durty;
    }

    protected DirtyRegion createDirtyRegion(ITypedRegion tr, String type) {
        return this.createDirtyRegion(tr.getOffset(), tr.getLength(), type);
    }

    protected void flushDirtyRegionQueue() {
        this.fDirtyRegionQueue.clear();
    }

    protected void endProcessing() {
    }

    long getDelay() {
        return this.fDelay;
    }

    List getDirtyRegionQueue() {
        return this.fDirtyRegionQueue;
    }

    protected IDocument getDocument() {
        return this.fDocument;
    }

    public String getDocumentPartitioning() {
        if (this.fPartitioning == null) {
            return "__dftl_partitioning";
        }
        return this.fPartitioning;
    }

    protected String[] getPartitions(int drOffset, int drLength) {
        ITypedRegion[] regions = new ITypedRegion[]{};
        int docLength = this.getDocument().getLength();
        if (drOffset > docLength) {
            drOffset = docLength;
            drLength = 0;
        } else if (drOffset + drLength > docLength) {
            drLength = docLength - drOffset;
        }
        try {
            regions = TextUtilities.computePartitioning((IDocument)this.getDocument(), (String)this.getDocumentPartitioning(), (int)drOffset, (int)drLength, (boolean)true);
        }
        catch (BadLocationException e) {
            Logger.logException(e);
            regions = new ITypedRegion[]{};
        }
        String[] partitions = new String[regions.length];
        int i = 0;
        while (i < regions.length) {
            partitions[i] = regions[i].getType();
            ++i;
        }
        return partitions;
    }

    ITypedRegion[] getPartitionRegions(int drOffset, int drLength) {
        ITypedRegion[] regions = new ITypedRegion[]{};
        int docLength = this.getDocument().getLength();
        if (drOffset > docLength) {
            drOffset = docLength;
            drLength = 0;
        } else if (drOffset + drLength > docLength) {
            drLength = docLength - drOffset;
        }
        try {
            regions = TextUtilities.computePartitioning((IDocument)this.getDocument(), (String)this.getDocumentPartitioning(), (int)drOffset, (int)drLength, (boolean)true);
        }
        catch (BadLocationException e) {
            Logger.logException(e);
            regions = new ITypedRegion[]{};
        }
        return regions;
    }

    public IReconcilingStrategy getReconcilingStrategy(String partitionType) {
        if (partitionType == null) {
            return null;
        }
        return (IReconcilingStrategy)this.fReconcilingStrategies.get(partitionType);
    }

    private synchronized DirtyRegion[] getRequests() {
        DirtyRegion[] toRefresh = this.fDirtyRegionQueue.toArray(new DirtyRegion[this.fDirtyRegionQueue.size()]);
        this.flushDirtyRegionQueue();
        return toRefresh;
    }

    protected ITextViewer getTextViewer() {
        return this.fViewer;
    }

    void handleInputDocumentChanged(IDocument oldInput, IDocument newInput) {
        if (this.isInstalled()) {
            this.setDocument(newInput);
        }
    }

    public void install(ITextViewer textViewer) {
        if (!this.isInstalled()) {
            this.fViewer = textViewer;
            this.fTextInputListener = new TextInputListener();
            textViewer.addTextInputListener((ITextInputListener)this.fTextInputListener);
            this.setInstalled(true);
        }
    }

    public boolean isInstalled() {
        return this.fIsInstalled;
    }

    boolean isInRewriteSession() {
        return this.fInRewriteSession;
    }

    protected void process(DirtyRegion dirtyRegion) {
        if (this.isInRewriteSession()) {
            return;
        }
        ITypedRegion[] partitions = this.computePartitioning(dirtyRegion);
        int i = 0;
        while (i < partitions.length) {
            IReconcilingStrategy strategy = this.getReconcilingStrategy(partitions[i].getType());
            if (strategy != null) {
                strategy.reconcile((IRegion)partitions[i]);
            }
            ++i;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void processDirtyRegion(DirtyRegion dr) {
        if (dr == null) {
            return;
        }
        this.addRequest(dr);
        Object object = this.LOCK;
        synchronized (object) {
            this.fReset = true;
        }
        if (DEBUG) {
            System.out.println("added request for: [" + dr.getText() + "]");
            System.out.println("queue size is now: " + this.getDirtyRegionQueue().size());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    protected IStatus run(IProgressMonitor monitor) {
        IStatus status = Status.OK_STATUS;
        if (!PlatformUI.isWorkbenchRunning()) {
            return status;
        }
        boolean processed = false;
        try {
            block16: {
                try {
                    block15: {
                        Object object = this.LOCK;
                        // MONITORENTER : object
                        if (!this.fReset) break block15;
                        this.fReset = false;
                        IStatus iStatus = status;
                        // MONITOREXIT : object
                        Object var6_7 = null;
                        if (processed) {
                            this.endProcessing();
                        }
                        this.schedule(this.getDelay());
                        monitor.done();
                        return iStatus;
                    }
                    // MONITOREXIT : object
                    processed = true;
                    this.beginProcessing();
                    DirtyRegion[] toRefresh = this.getRequests();
                    int i = 0;
                    while (i < toRefresh.length) {
                        if (monitor.isCanceled()) {
                            throw new OperationCanceledException();
                        }
                        this.process(toRefresh[i]);
                        ++i;
                    }
                }
                catch (Exception e) {
                    if (e instanceof OperationCanceledException) break block16;
                    Logger.logException("problem with reconciling", e);
                }
            }
            Object var6_9 = null;
            if (processed) {
                this.endProcessing();
            }
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            if (processed) {
                this.endProcessing();
            }
            this.schedule(this.getDelay());
            monitor.done();
            throw throwable;
        }
        this.schedule(this.getDelay());
        monitor.done();
        return status;
    }

    public void setDelay(long delay) {
        this.fDelay = delay;
    }

    public void setDocument(IDocument doc) {
        if (this.fDocument != null) {
            this.fDocument.removeDocumentListener(this.fDocumentListener);
            if (this.fDocument instanceof IDocumentExtension4) {
                ((IDocumentExtension4)this.fDocument).removeDocumentRewriteSessionListener(this.fDocumentRewriteSessionListener);
            }
        }
        this.fDocument = doc;
        if (this.fDocument != null) {
            if (this.fDocument instanceof IDocumentExtension4) {
                ((IDocumentExtension4)this.fDocument).addDocumentRewriteSessionListener(this.fDocumentRewriteSessionListener);
            }
            this.fDocument.addDocumentListener(this.fDocumentListener);
        }
        this.setEntireDocumentDirty(doc);
    }

    public void setDocumentPartitioning(String partitioning) {
        this.fPartitioning = partitioning;
    }

    protected void setEntireDocumentDirty(IDocument document) {
        if (document != null && this.isInstalled()) {
            this.flushDirtyRegionQueue();
            if (this.fLastPartitions != null && document.getLength() == 0) {
                int i = 0;
                while (i < this.fLastPartitions.length) {
                    IReconcilingStrategy strategy = this.getReconcilingStrategy(this.fLastPartitions[i].getType());
                    if (strategy != null) {
                        strategy.reconcile((IRegion)this.fLastPartitions[i]);
                    }
                    ++i;
                }
            } else {
                DirtyRegion entireDocument = this.createDirtyRegion(0, document.getLength(), "__insert");
                this.processDirtyRegion(entireDocument);
            }
            this.schedule(this.getDelay());
        }
    }

    void setInstalled(boolean isInstalled) {
        this.fIsInstalled = isInstalled;
    }

    public void setReconcilingStrategy(String partitionType, IReconcilingStrategy strategy) {
        if (partitionType == null) {
            throw new IllegalArgumentException();
        }
        if (strategy == null) {
            this.fReconcilingStrategies.remove(partitionType);
        } else {
            this.fReconcilingStrategies.put(partitionType, strategy);
        }
    }

    public void uninstall() {
        if (this.isInstalled()) {
            this.getTextViewer().removeTextInputListener((ITextInputListener)this.fTextInputListener);
            this.setInstalled(false);
        }
        this.setDocument(null);
    }

    class DocumentListener
    implements IDocumentListener {
        DocumentListener() {
        }

        public void documentAboutToBeChanged(DocumentEvent event) {
            if (DirtyRegionProcessor.this.isInRewriteSession() && DirtyRegionProcessor.this.fReprocessAfterRewrite) {
                return;
            }
            DirtyRegionProcessor.this.fLastPartitions = DirtyRegionProcessor.this.getPartitionRegions(event.getOffset(), event.getLength());
        }

        public void documentChanged(DocumentEvent event) {
            if (DirtyRegionProcessor.this.isInRewriteSession() && DirtyRegionProcessor.this.fReprocessAfterRewrite) {
                return;
            }
            if (this.partitionsChanged(event)) {
                DirtyRegionProcessor.this.setEntireDocumentDirty(DirtyRegionProcessor.this.getDocument());
            } else {
                DirtyRegion dr = null;
                dr = event.getLength() == 0 ? DirtyRegionProcessor.this.createDirtyRegion(event.getOffset(), 0, "__insert") : ("".equals(event.getText()) ? DirtyRegionProcessor.this.createDirtyRegion(event.getOffset(), event.getLength(), "__remove") : DirtyRegionProcessor.this.createDirtyRegion(event.getOffset(), event.getLength(), "__insert"));
                if (DirtyRegionProcessor.this.isInRewriteSession()) {
                    if (!DirtyRegionProcessor.this.fReprocessAfterRewrite && dr != null) {
                        DirtyRegionProcessor.this.fReprocessAfterRewrite = true;
                    }
                } else {
                    DirtyRegionProcessor.this.processDirtyRegion(dr);
                }
            }
        }

        private boolean partitionsChanged(DocumentEvent event) {
            boolean changed = false;
            int length = event.getLength();
            if (event.getLength() == 0 && event.getText().length() > 0) {
                length = event.getText().length();
            }
            ITypedRegion[] newPartitions = DirtyRegionProcessor.this.getPartitionRegions(event.getOffset(), length);
            if (DirtyRegionProcessor.this.fLastPartitions != null) {
                if (DirtyRegionProcessor.this.fLastPartitions.length != newPartitions.length) {
                    changed = true;
                } else {
                    int i = 0;
                    while (i < DirtyRegionProcessor.this.fLastPartitions.length) {
                        if (!DirtyRegionProcessor.this.fLastPartitions[i].getType().equals(newPartitions[i].getType())) {
                            changed = true;
                            break;
                        }
                        ++i;
                    }
                }
            }
            return changed;
        }
    }

    class DocumentRewriteSessionListener
    implements IDocumentRewriteSessionListener {
        long time0 = 0L;

        DocumentRewriteSessionListener() {
        }

        public void documentRewriteSessionChanged(DocumentRewriteSessionEvent event) {
            boolean oldValue = DirtyRegionProcessor.this.fInRewriteSession;
            boolean bl = DirtyRegionProcessor.this.fInRewriteSession = event != null && event.getChangeType().equals(DocumentRewriteSessionEvent.SESSION_START);
            if (event.getChangeType().equals(DocumentRewriteSessionEvent.SESSION_START)) {
                if (DEBUG) {
                    this.time0 = System.currentTimeMillis();
                }
                if (!DirtyRegionProcessor.this.getDirtyRegionQueue().isEmpty()) {
                    DirtyRegionProcessor.this.flushDirtyRegionQueue();
                    DirtyRegionProcessor.this.fReprocessAfterRewrite = true;
                } else {
                    DirtyRegionProcessor.this.fReprocessAfterRewrite = false;
                }
            } else if (event.getChangeType().equals(DocumentRewriteSessionEvent.SESSION_STOP) && DirtyRegionProcessor.this.fInRewriteSession ^ oldValue && DirtyRegionProcessor.this.fDocument != null) {
                if (DEBUG) {
                    Logger.log(1, "Rewrite session lasted " + (System.currentTimeMillis() - this.time0) + "ms");
                    this.time0 = System.currentTimeMillis();
                }
                if (DirtyRegionProcessor.this.fReprocessAfterRewrite) {
                    DirtyRegion entireDocument = DirtyRegionProcessor.this.createDirtyRegion(0, DirtyRegionProcessor.this.fDocument.getLength(), "__insert");
                    DirtyRegionProcessor.this.processDirtyRegion(entireDocument);
                }
                if (DEBUG) {
                    Logger.log(1, "Full document reprocess took " + (System.currentTimeMillis() - this.time0) + "ms");
                }
                DirtyRegionProcessor.this.fReprocessAfterRewrite = false;
            }
        }
    }

    class TextInputListener
    implements ITextInputListener {
        TextInputListener() {
        }

        public void inputDocumentAboutToBeChanged(IDocument oldInput, IDocument newInput) {
        }

        public void inputDocumentChanged(IDocument oldInput, IDocument newInput) {
            DirtyRegionProcessor.this.handleInputDocumentChanged(oldInput, newInput);
        }
    }
}

