/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.internal.classpathdep;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jdt.core.IClasspathAttribute;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jst.common.jdt.internal.javalite.IJavaProjectLite;
import org.eclipse.jst.common.jdt.internal.javalite.JavaCoreLite;
import org.eclipse.jst.common.jdt.internal.javalite.JavaLiteUtilities;
import org.eclipse.jst.j2ee.classpathdep.ClasspathDependencyUtil;
import org.eclipse.jst.j2ee.classpathdep.IClasspathDependencyConstants;
import org.eclipse.jst.j2ee.internal.classpathdep.ClasspathDependencyEnablement;
import org.eclipse.jst.j2ee.internal.classpathdep.ClasspathDependencyExtensions;
import org.eclipse.jst.j2ee.internal.classpathdep.ClasspathDependencyValidatorHelper;
import org.eclipse.jst.j2ee.internal.plugin.J2EEPlugin;
import org.eclipse.jst.j2ee.project.JavaEEProjectUtilities;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.validation.internal.core.Message;
import org.eclipse.wst.validation.internal.core.ValidationException;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;
import org.eclipse.wst.validation.internal.provisional.core.IValidationContext;
import org.eclipse.wst.validation.internal.provisional.core.IValidator;
import org.eclipse.wst.validation.internal.provisional.core.IValidatorJob;

public class ClasspathDependencyValidator
implements IValidatorJob {
    public static final String AppClientProject = "AppClientProject";
    public static final String RootMappingNonEARWARRef = "RootMappingNonEARWARRef";
    public static final String NonTaggedExportedClasses = "NonTaggedExportedClasses";
    public static final String DuplicateArchiveName = "DuplicateArchiveName";
    public static final String ProjectClasspathEntry = "ProjectClasspathEntry";
    public static final String SourceEntry = "SourceEntry";
    public static final String FilteredContainer = "FilteredContainer";
    public static final String DuplicateClassFolderEntry = "DuplicateClassFolderEntry";
    public static final String NonWebNonExported = "NonWebNonExported";
    public static final String InvalidNonWebRuntimePath = "InvalidNonWebRuntimePath";
    public static final String InvalidWebRuntimePath = "InvalidWebRuntimePath";
    protected IReporter _reporter;

    public IStatus validateInJob(IValidationContext helper, IReporter reporter) throws ValidationException {
        this._reporter = reporter;
        this._reporter.removeAllMessages((IValidator)this);
        HashSet<String> archiveNames = new HashSet<String>();
        IProject proj = ((ClasspathDependencyValidatorHelper)helper).getProject();
        try {
            if (proj.isAccessible() && proj.hasNature("org.eclipse.wst.common.modulecore.ModuleCoreNature") && proj.hasNature(JavaCoreLite.NATURE_ID)) {
                IMessage[] msgs;
                IClasspathAttribute attrib;
                IJavaProjectLite javaProjectLite = JavaCoreLite.create((IProject)proj);
                boolean isWebApp = JavaEEProjectUtilities.isDynamicWebProject(proj);
                boolean webLibsOnly = false;
                if (!ClasspathDependencyEnablement.isAllowClasspathComponentDependency()) {
                    if (!isWebApp) {
                        return OK_STATUS;
                    }
                    webLibsOnly = true;
                }
                Map<IClasspathEntry, IClasspathAttribute> referencedRawEntries = ClasspathDependencyUtil.getRawComponentClasspathDependencies(javaProjectLite, IClasspathDependencyConstants.DependencyAttributeType.CLASSPATH_COMPONENT_DEPENDENCY, webLibsOnly);
                List<IClasspathEntry> potentialRawEntries = ClasspathDependencyUtil.getPotentialComponentClasspathDependencies(javaProjectLite, webLibsOnly);
                IVirtualComponent component = ComponentCore.createComponent((IProject)proj);
                ClasspathDependencyValidatorData data = new ClasspathDependencyValidatorData(proj);
                Iterator<IClasspathEntry> i = referencedRawEntries.keySet().iterator();
                boolean hasRootMapping = false;
                while (i.hasNext()) {
                    IClasspathEntry entry = i.next();
                    boolean isClassFolder = ClasspathDependencyUtil.isClassFolderEntry(entry);
                    attrib = referencedRawEntries.get(entry);
                    IPath runtimePath = ClasspathDependencyUtil.getRuntimePath(attrib, isWebApp, isClassFolder);
                    if (runtimePath.equals((Object)IClasspathDependencyConstants.RUNTIME_MAPPING_INTO_CONTAINER_PATH)) {
                        hasRootMapping = true;
                    }
                    msgs = ClasspathDependencyValidator.validateVirtualComponentEntry(entry, attrib, isWebApp, proj, data);
                    String cpEntryPath = entry.getPath().toString();
                    int j = 0;
                    while (j < msgs.length) {
                        msgs[j].setGroupName(cpEntryPath);
                        ++j;
                    }
                    this.reportMessages(msgs);
                    if (isWebApp || entry.isExported()) continue;
                    this._reporter.addMessage((IValidator)this, (IMessage)new Message("classpathdependencyvalidator", 2, NonWebNonExported, new String[]{cpEntryPath}, (Object)proj));
                }
                if (!referencedRawEntries.isEmpty()) {
                    if (JavaEEProjectUtilities.isApplicationClientProject(proj)) {
                        Message msg = new Message("classpathdependencyvalidator", 1, AppClientProject, null, (Object)proj);
                        this._reporter.addMessage((IValidator)this, (IMessage)msg);
                    }
                    if (hasRootMapping && component != null) {
                        boolean referencedFromEARorWAR = false;
                        ArrayList<IVirtualComponent> earWarRefs = new ArrayList<IVirtualComponent>();
                        IVirtualComponent[] refComponents = component.getReferencingComponents();
                        int j = 0;
                        while (j < refComponents.length) {
                            if (JavaEEProjectUtilities.isEARProject(refComponents[j].getProject()) || JavaEEProjectUtilities.isDynamicWebProject(refComponents[j].getProject())) {
                                referencedFromEARorWAR = true;
                                earWarRefs.add(refComponents[j]);
                            }
                            ++j;
                        }
                        if (!referencedFromEARorWAR) {
                            Message msg = new Message("classpathdependencyvalidator", 2, RootMappingNonEARWARRef, null, (Object)proj);
                            this._reporter.addMessage((IValidator)this, (IMessage)msg);
                        }
                    }
                }
                for (IClasspathEntry entry : potentialRawEntries) {
                    Message msg = new Message("classpathdependencyvalidator", 2, NonTaggedExportedClasses, new String[]{entry.getPath().toString()}, (Object)proj);
                    msg.setGroupName(entry.getPath().toString());
                    this._reporter.addMessage((IValidator)this, (IMessage)msg);
                }
                if (!referencedRawEntries.isEmpty()) {
                    Map<IClasspathEntry, IClasspathAttribute> referencedResolvedEntries = ClasspathDependencyUtil.getComponentClasspathDependencies(javaProjectLite, isWebApp, false);
                    for (IClasspathEntry entry : referencedResolvedEntries.keySet()) {
                        attrib = referencedResolvedEntries.get(entry);
                        String archivePath = ClasspathDependencyUtil.getArchiveName(entry);
                        if (archiveNames.contains(archivePath)) {
                            Message msg = new Message("classpathdependencyvalidator", 1, DuplicateArchiveName, new String[]{entry.getPath().toString()}, (Object)proj);
                            this._reporter.addMessage((IValidator)this, (IMessage)msg);
                        } else {
                            archiveNames.add(archivePath);
                        }
                        if (referencedRawEntries.containsKey(entry)) continue;
                        msgs = ClasspathDependencyValidator.validateVirtualComponentEntry(entry, attrib, isWebApp, proj, data);
                        this.reportMessages(msgs);
                    }
                }
            }
        }
        catch (CoreException e) {
            J2EEPlugin.logError(e);
        }
        return Status.OK_STATUS;
    }

    private void reportMessages(IMessage[] msgs) {
        int i = 0;
        while (i < msgs.length) {
            this._reporter.addMessage((IValidator)this, msgs[i]);
            ++i;
        }
    }

    public static IMessage[] validateVirtualComponentEntry(IClasspathEntry entry, IClasspathAttribute attrib, boolean isWebApp, IProject project) {
        return ClasspathDependencyValidator.validateVirtualComponentEntry(entry, attrib, isWebApp, project, new ClasspathDependencyValidatorData(project));
    }

    public static IMessage[] validateVirtualComponentEntry(IClasspathEntry entry, IClasspathAttribute attrib, boolean isWebApp, IProject project, ClasspathDependencyValidatorData data) {
        boolean isFile;
        ArrayList<Message> results = new ArrayList<Message>();
        if (entry == null) {
            return results.toArray(new IMessage[results.size()]);
        }
        int kind = entry.getEntryKind();
        boolean bl = isFile = !ClasspathDependencyUtil.isClassFolderEntry(entry);
        if (kind == 2) {
            results.add(new Message("classpathdependencyvalidator", 1, ProjectClasspathEntry, new String[]{entry.getPath().toString()}, (Object)project));
            return results.toArray(new IMessage[results.size()]);
        }
        if (kind == 3) {
            results.add(new Message("classpathdependencyvalidator", 1, SourceEntry, new String[]{entry.getPath().toString()}, (Object)project));
            return results.toArray(new IMessage[results.size()]);
        }
        if (kind == 5) {
            List filteredIDs = ClasspathDependencyExtensions.get().getFilteredClasspathContainerIDs();
            IPath path = entry.getPath();
            int i = 0;
            while (i < filteredIDs.size()) {
                String id = (String)filteredIDs.get(i);
                if (path.segment(0).equals(id)) {
                    results.add(new Message("classpathdependencyvalidator", 1, FilteredContainer, new String[]{entry.getPath().toString()}, (Object)project));
                    return results.toArray(new IMessage[results.size()]);
                }
                ++i;
            }
        } else if (kind == 1 && !isFile) {
            IContainer[] mappedClassFolders = data.getMappedClassFolders();
            IResource resource = ClasspathDependencyUtil.getEntryResource(entry);
            if (resource != null) {
                IPath fullClassFolderPath = resource.getFullPath();
                boolean alreadyMapped = false;
                int j = 0;
                while (j < mappedClassFolders.length) {
                    if (fullClassFolderPath.equals((Object)mappedClassFolders[j].getFullPath())) {
                        alreadyMapped = true;
                        break;
                    }
                    ++j;
                }
                if (alreadyMapped) {
                    results.add(new Message("classpathdependencyvalidator", 1, DuplicateClassFolderEntry, new String[]{entry.getPath().toString()}, (Object)project));
                }
            }
        }
        IPath runtimePath = ClasspathDependencyUtil.getRuntimePath(attrib, isWebApp, !isFile);
        if (!isWebApp) {
            if (!runtimePath.equals((Object)IClasspathDependencyConstants.RUNTIME_MAPPING_INTO_CONTAINER_PATH) && !runtimePath.equals((Object)IClasspathDependencyConstants.RUNTIME_MAPPING_INTO_COMPONENT_PATH)) {
                results.add(new Message("classpathdependencyvalidator", 1, InvalidNonWebRuntimePath, new String[]{entry.getPath().toString(), runtimePath.toString()}, (Object)project));
            }
        } else {
            String pathStr = runtimePath.toString();
            if (!(runtimePath.equals((Object)IClasspathDependencyConstants.RUNTIME_MAPPING_INTO_CONTAINER_PATH) || runtimePath.equals((Object)IClasspathDependencyConstants.WEB_INF_LIB_PATH) || runtimePath.equals((Object)IClasspathDependencyConstants.WEB_INF_CLASSES_PATH))) {
                results.add(new Message("classpathdependencyvalidator", 1, InvalidWebRuntimePath, new String[]{entry.getPath().toString(), pathStr}, (Object)project));
            }
        }
        return results.toArray(new IMessage[results.size()]);
    }

    public ISchedulingRule getSchedulingRule(IValidationContext helper) {
        return null;
    }

    public void cleanup(IReporter reporter) {
        this._reporter = null;
    }

    public void validate(IValidationContext helper, IReporter reporter) throws ValidationException {
        this.validateInJob(helper, reporter);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ClasspathDependencyValidatorData {
        private final IProject _project;
        private final List<IContainer> javaOutputFolders;

        public ClasspathDependencyValidatorData(IProject project) {
            this._project = project;
            this.javaOutputFolders = JavaLiteUtilities.getJavaOutputContainers((IVirtualComponent)ComponentCore.createComponent((IProject)project));
        }

        public IProject getProject() {
            return this._project;
        }

        public List<IContainer> getJavaOutputFolders() {
            return this.javaOutputFolders;
        }

        public IContainer[] getMappedClassFolders() {
            return this.javaOutputFolders.toArray(new IContainer[this.javaOutputFolders.size()]);
        }
    }
}

