/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.validation.internal.appconfig;

import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jst.jsf.facesconfig.emf.PropertyNameType;
import org.eclipse.jst.jsf.validation.internal.appconfig.DiagnosticFactory;
import org.eclipse.jst.jsf.validation.internal.appconfig.EObjectValidationVisitor;
import org.eclipse.jst.jsf.validation.internal.appconfig.PropertyValidationVisitor;

class PropertyNameValidationVisitor
extends EObjectValidationVisitor {
    private final EStructuralFeature _parentClassNameFeature;

    public PropertyNameValidationVisitor(EStructuralFeature feature, EStructuralFeature parentClassNameFeature, String version) {
        super(feature, version);
        this._parentClassNameFeature = parentClassNameFeature;
    }

    protected EObjectValidationVisitor[] getChildNodeValidators() {
        return PropertyValidationVisitor.NO_CHILDREN;
    }

    protected void doValidate(EObject object, List messages, IFile file) {
        String parentClassType = this.getParentClassType(object);
        if (parentClassType != null) {
            String typeSig = PropertyValidationVisitor.validateProperty((PropertyNameType)object, file.getProject(), parentClassType);
            String propertyName = ((PropertyNameType)object).getTextContent();
            if (typeSig == null) {
                PropertyValidationVisitor.addMessageInfo(messages, DiagnosticFactory.create_BEAN_PROPERTY_NOT_FOUND(propertyName, parentClassType), object, file);
            }
        }
    }

    private String getParentClassType(EObject object) {
        EStructuralFeature feature;
        EObject parentClassTypeObject;
        EObject owningObject;
        String parentClassType = null;
        EObject property = object.eContainer();
        if (property != null && (owningObject = property.eContainer()) != null && (parentClassTypeObject = (EObject)owningObject.eGet(this._parentClassNameFeature)) != null && (feature = parentClassTypeObject.eClass().getEStructuralFeature("textContent")) != null) {
            parentClassType = (String)parentClassTypeObject.eGet(feature);
        }
        return parentClassType;
    }
}

