/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.server.core.internal.facets;

import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.wst.common.project.facet.core.runtime.IRuntimeComponent;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.IRuntimeType;
import org.eclipse.wst.server.core.internal.Trace;
import org.eclipse.wst.server.core.internal.facets.RuntimeFacetComponentProviderDelegate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RuntimeComponentProviderWrapper {
    private IConfigurationElement element;
    private RuntimeFacetComponentProviderDelegate delegate;

    public RuntimeComponentProviderWrapper(IConfigurationElement element) {
        this.element = element;
    }

    protected IConfigurationElement getElement() {
        return this.element;
    }

    public String getId() {
        return this.element.getAttribute("id");
    }

    public String[] getRuntimeTypeIds() {
        try {
            ArrayList<String> list = new ArrayList<String>();
            StringTokenizer st = new StringTokenizer(this.element.getAttribute("runtimeTypeIds"), ",");
            while (st.hasMoreTokens()) {
                String str = st.nextToken();
                if (str == null || str.length() <= 0) continue;
                list.add(str.trim());
            }
            String[] s = new String[list.size()];
            list.toArray(s);
            return s;
        }
        catch (Exception exception) {
            Trace.trace(3, "Could not parse runtime type ids: " + this.element);
            return null;
        }
    }

    public boolean supportsRuntimeType(IRuntimeType runtimeType) {
        if (runtimeType == null) {
            return false;
        }
        String id = runtimeType.getId();
        if (id == null || id.length() == 0) {
            return false;
        }
        String[] s = this.getRuntimeTypeIds();
        if (s == null) {
            return false;
        }
        int size = s.length;
        int i = 0;
        while (i < size) {
            if (s[i].endsWith("*") ? id.length() >= s[i].length() && id.startsWith(s[i].substring(0, s[i].length() - 1)) : id.equals(s[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected RuntimeFacetComponentProviderDelegate getDelegate() {
        if (this.delegate == null) {
            try {
                this.delegate = (RuntimeFacetComponentProviderDelegate)this.element.createExecutableExtension("class");
            }
            catch (Throwable t) {
                Trace.trace(3, "Could not create delegate " + this.toString(), t);
            }
        }
        return this.delegate;
    }

    public List<IRuntimeComponent> getComponents(IRuntime runtime) {
        if (runtime == null) {
            return null;
        }
        try {
            return this.getDelegate().getRuntimeComponents(runtime);
        }
        catch (Exception e) {
            Trace.trace(3, "Error calling delegate " + this.toString(), e);
            return null;
        }
    }

    public String toString() {
        return "RuntimeComponentProviderWrapper[" + this.getId() + "]";
    }
}

