/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.server.core.internal;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.server.core.internal.IInstallableRuntime;
import org.eclipse.wst.server.core.internal.Messages;
import org.eclipse.wst.server.core.internal.Trace;
import org.eclipse.wst.server.core.internal.tar.TarEntry;
import org.eclipse.wst.server.core.internal.tar.TarInputStream;

public class InstallableRuntime2
implements IInstallableRuntime {
    private IConfigurationElement element;
    private byte[] BUFFER = null;

    public InstallableRuntime2(IConfigurationElement element) {
        this.element = element;
    }

    public String getId() {
        try {
            return this.element.getAttribute("id");
        }
        catch (Exception exception) {
            return null;
        }
    }

    public String getName() {
        return this.getArchivePath();
    }

    public String getArchiveUrl() {
        try {
            return this.element.getAttribute("archiveUrl");
        }
        catch (Exception exception) {
            return null;
        }
    }

    public String getArchivePath() {
        try {
            return this.element.getAttribute("archivePath");
        }
        catch (Exception exception) {
            return null;
        }
    }

    public String getLicenseURL() {
        try {
            return this.element.getAttribute("licenseUrl");
        }
        catch (Exception exception) {
            return null;
        }
    }

    /*
     * Loose catch block
     */
    public String getLicense(IProgressMonitor monitor) throws CoreException {
        String licenseURL;
        ByteArrayOutputStream out;
        URL url;
        block14: {
            url = null;
            out = null;
            licenseURL = this.getLicenseURL();
            if (licenseURL != null) break block14;
            try {
                if (out != null) {
                    out.close();
                }
            }
            catch (IOException iOException) {}
            return null;
        }
        url = new URL(licenseURL);
        InputStream in = url.openStream();
        out = new ByteArrayOutputStream();
        this.copy(in, out);
        String string = new String(out.toByteArray());
        try {
            if (out != null) {
                out.close();
            }
        }
        catch (IOException iOException) {}
        return string;
        catch (Exception e) {
            try {
                Trace.trace(2, "Error loading license", e);
                throw new CoreException((IStatus)new Status(4, "org.eclipse.wst.server.core", 0, NLS.bind((String)Messages.errorInstallingServer, (Object)e.getLocalizedMessage()), (Throwable)e));
            }
            catch (Throwable throwable) {
                try {
                    if (out != null) {
                        out.close();
                    }
                }
                catch (IOException iOException) {}
                throw throwable;
            }
        }
    }

    public void install(final IPath path) {
        Job installRuntimeJob = new Job(Messages.jobInstallingRuntime){

            public boolean belongsTo(Object family) {
                return "org.eclipse.wst.server.core".equals(family);
            }

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    InstallableRuntime2.this.install(path, monitor);
                }
                catch (CoreException ce) {
                    return ce.getStatus();
                }
                return Status.OK_STATUS;
            }
        };
        installRuntimeJob.schedule();
    }

    private void copy(InputStream in, OutputStream out) throws IOException {
        if (this.BUFFER == null) {
            this.BUFFER = new byte[8192];
        }
        int r = in.read(this.BUFFER);
        while (r >= 0) {
            out.write(this.BUFFER, 0, r);
            r = in.read(this.BUFFER);
        }
    }

    public void install(IPath path, IProgressMonitor monitor) throws CoreException {
        InputStream in;
        URL url = null;
        File temp = null;
        try {
            url = new URL(this.getArchiveUrl());
            temp = File.createTempFile("runtime", "");
            temp.deleteOnExit();
        }
        catch (IOException e) {
            Trace.trace(2, "Error creating url and temp file", e);
            throw new CoreException((IStatus)new Status(4, "org.eclipse.wst.server.core", 0, NLS.bind((String)Messages.errorInstallingServer, (Object)e.getLocalizedMessage()), (Throwable)e));
        }
        String name = url.getPath();
        FileOutputStream fout = null;
        try {
            try {
                in = url.openStream();
                fout = new FileOutputStream(temp);
                this.copy(in, fout);
            }
            catch (Exception e) {
                Trace.trace(2, "Error downloading runtime", e);
                throw new CoreException((IStatus)new Status(4, "org.eclipse.wst.server.core", 0, NLS.bind((String)Messages.errorInstallingServer, (Object)e.getLocalizedMessage()), (Throwable)e));
            }
        }
        catch (Throwable throwable) {
            try {
                if (fout != null) {
                    fout.close();
                }
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {
            if (fout != null) {
                fout.close();
            }
        }
        catch (IOException iOException) {}
        in = null;
        try {
            try {
                in = new FileInputStream(temp);
                if (name.endsWith("zip")) {
                    this.unzip(in, path, monitor);
                } else if (name.endsWith("tar")) {
                    this.untar(in, path, monitor);
                }
            }
            catch (Exception e) {
                Trace.trace(3, "Error uncompressing runtime", e);
                throw new CoreException((IStatus)new Status(4, "org.eclipse.wst.server.core", 0, NLS.bind((String)Messages.errorInstallingServer, (Object)e.getLocalizedMessage()), (Throwable)e));
            }
        }
        catch (Throwable throwable) {
            try {
                if (in != null) {
                    ((FileInputStream)in).close();
                }
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {
            if (in != null) {
                ((FileInputStream)in).close();
            }
        }
        catch (IOException iOException) {}
    }

    private void unzip(InputStream in, IPath path, IProgressMonitor monitor) throws IOException {
        String archivePath = this.getArchivePath();
        BufferedInputStream bin = new BufferedInputStream(in);
        ZipInputStream zin = new ZipInputStream(bin);
        ZipEntry entry = zin.getNextEntry();
        while (entry != null) {
            String name = entry.getName();
            monitor.setTaskName("Unzipping: " + name);
            if (archivePath != null && name.startsWith(archivePath) && (name = name.substring(archivePath.length())).length() > 1) {
                name = name.substring(1);
            }
            if (name != null && name.length() > 0) {
                if (entry.isDirectory()) {
                    path.append(name).toFile().mkdirs();
                } else {
                    FileOutputStream fout = new FileOutputStream(path.append(name).toFile());
                    this.copy(zin, fout);
                    fout.close();
                }
            }
            zin.closeEntry();
            entry = zin.getNextEntry();
        }
        zin.close();
    }

    protected void untar(InputStream in, IPath path, IProgressMonitor monitor) throws IOException {
        String archivePath = this.getArchivePath();
        BufferedInputStream bin = new BufferedInputStream(in);
        TarInputStream zin = new TarInputStream(bin);
        TarEntry entry = zin.getNextEntry();
        while (entry != null) {
            String name = entry.getName();
            monitor.setTaskName("Untarring: " + name);
            if (archivePath != null && name.startsWith(archivePath) && (name = name.substring(archivePath.length())).length() > 1) {
                name = name.substring(1);
            }
            if (name != null && name.length() > 0) {
                if (entry.getFileType() == 53) {
                    path.append(name).toFile().mkdirs();
                } else {
                    FileOutputStream fout = new FileOutputStream(path.append(name).toFile());
                    this.copy(zin, fout);
                    fout.close();
                }
            }
            zin.close();
            entry = zin.getNextEntry();
        }
        zin.close();
    }

    public String toString() {
        return "InstallableRuntime2[" + this.getId() + "]";
    }
}

