/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.classpathdep;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jdt.core.IClasspathAttribute;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jst.common.jdt.internal.javalite.IJavaProjectLite;
import org.eclipse.jst.common.jdt.internal.javalite.JavaCoreLite;
import org.eclipse.jst.j2ee.classpathdep.IClasspathDependencyConstants;
import org.eclipse.jst.j2ee.componentcore.J2EEModuleVirtualComponent;
import org.eclipse.jst.j2ee.internal.classpathdep.ClasspathDependencyEnablement;
import org.eclipse.jst.j2ee.internal.classpathdep.ClasspathDependencyValidator;
import org.eclipse.jst.j2ee.internal.classpathdep.ClasspathDependencyVirtualComponent;
import org.eclipse.jst.j2ee.model.ModelProviderManager;
import org.eclipse.jst.j2ee.project.EarUtilities;
import org.eclipse.jst.j2ee.project.JavaEEProjectUtilities;
import org.eclipse.jst.j2ee.project.WebUtilities;
import org.eclipse.jst.javaee.application.Application;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.internal.impl.ModuleURIUtil;
import org.eclipse.wst.common.componentcore.internal.resources.VirtualArchiveComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualReference;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClasspathDependencyUtil
implements IClasspathDependencyConstants {
    @Deprecated
    public static Map<IClasspathEntry, IClasspathAttribute> getRawComponentClasspathDependencies(IJavaProject javaProject) throws CoreException {
        return ClasspathDependencyUtil.getRawComponentClasspathDependencies(javaProject, IClasspathDependencyConstants.DependencyAttributeType.CLASSPATH_COMPONENT_DEPENDENCY);
    }

    @Deprecated
    public static Map<IClasspathEntry, IClasspathAttribute> getRawComponentClasspathDependencies(IJavaProject javaProject, IClasspathDependencyConstants.DependencyAttributeType attributeType) throws CoreException {
        return ClasspathDependencyUtil.getRawComponentClasspathDependencies(JavaCoreLite.create((IJavaProject)javaProject), attributeType);
    }

    public static Map<IClasspathEntry, IClasspathAttribute> getRawComponentClasspathDependencies(IJavaProjectLite javaProjectLite, IClasspathDependencyConstants.DependencyAttributeType attributeType) throws CoreException {
        return ClasspathDependencyUtil.getRawComponentClasspathDependencies(javaProjectLite, attributeType, false);
    }

    public static Map<IClasspathEntry, IClasspathAttribute> getRawComponentClasspathDependencies(IJavaProjectLite javaProjectLite, IClasspathDependencyConstants.DependencyAttributeType attributeType, boolean webLibsOnly) throws CoreException {
        IClasspathEntry[] entries;
        if (javaProjectLite == null || !webLibsOnly && !ClasspathDependencyEnablement.isAllowClasspathComponentDependency()) {
            return Collections.emptyMap();
        }
        HashMap<IClasspathEntry, IClasspathAttribute> referencedRawEntries = new HashMap<IClasspathEntry, IClasspathAttribute>();
        IClasspathEntry[] iClasspathEntryArray = entries = javaProjectLite.readRawClasspath();
        int n = entries.length;
        int n2 = 0;
        while (n2 < n) {
            IClasspathEntry entry = iClasspathEntryArray[n2];
            IClasspathAttribute attrib = ClasspathDependencyUtil.checkForComponentDependencyAttribute(entry, attributeType, webLibsOnly);
            if (attrib != null) {
                if (webLibsOnly) {
                    if (WebUtilities.WEBLIB.toString().equals(attrib.getValue())) {
                        referencedRawEntries.put(entry, attrib);
                    }
                } else {
                    referencedRawEntries.put(entry, attrib);
                }
            }
            ++n2;
        }
        return referencedRawEntries;
    }

    @Deprecated
    public static List<IClasspathEntry> getPotentialComponentClasspathDependencies(IJavaProject javaProject) throws CoreException {
        return ClasspathDependencyUtil.getPotentialComponentClasspathDependencies(JavaCoreLite.create((IJavaProject)javaProject));
    }

    public static List<IClasspathEntry> getPotentialComponentClasspathDependencies(IJavaProjectLite javaProjectLite) throws CoreException {
        return ClasspathDependencyUtil.getPotentialComponentClasspathDependencies(javaProjectLite, false);
    }

    public static List<IClasspathEntry> getPotentialComponentClasspathDependencies(IJavaProjectLite javaProjectLite, boolean webLibsOnly) throws CoreException {
        ArrayList<IClasspathEntry> potentialRawEntries = new ArrayList<IClasspathEntry>();
        if (javaProjectLite == null || !javaProjectLite.getProject().isAccessible() || !webLibsOnly && !ClasspathDependencyEnablement.isAllowClasspathComponentDependency()) {
            return Collections.emptyList();
        }
        IProject project = javaProjectLite.getProject();
        boolean isWebApp = JavaEEProjectUtilities.isDynamicWebProject(project);
        boolean isRAR = JavaEEProjectUtilities.isJCAProject(project);
        ClasspathDependencyValidator.ClasspathDependencyValidatorData data = new ClasspathDependencyValidator.ClasspathDependencyValidatorData(project);
        IClasspathEntry[] entries = javaProjectLite.readRawClasspath();
        int i = 0;
        while (i < entries.length) {
            block23: {
                IClasspathEntry entry;
                block24: {
                    IProject[] earProjects;
                    boolean foundEntry;
                    block25: {
                        boolean isFile;
                        entry = entries[i];
                        IClasspathAttribute attrib = ClasspathDependencyUtil.checkForComponentDependencyAttribute(entry, IClasspathDependencyConstants.DependencyAttributeType.DEPENDENCY_OR_NONDEPENDENCY, webLibsOnly);
                        if (attrib != null) break block23;
                        IMessage[] msgs = ClasspathDependencyValidator.validateVirtualComponentEntry(entry, null, true, project, data);
                        boolean error = false;
                        int j = 0;
                        while (j < msgs.length) {
                            if (msgs[j].getSeverity() == 1) {
                                error = true;
                                break;
                            }
                            ++j;
                        }
                        if (error) break block23;
                        if (1 != entry.getEntryKind()) break block24;
                        boolean bl = isFile = !ClasspathDependencyUtil.isClassFolderEntry(entry);
                        if (webLibsOnly && !isFile) break block23;
                        if (!isFile) break block24;
                        foundEntry = false;
                        IVirtualComponent component = ComponentCore.createComponent((IProject)project);
                        if (isWebApp) {
                            IContainer[] webLibFolders;
                            IContainer[] iContainerArray = webLibFolders = component.getRootFolder().getFolder(WEB_INF_LIB_PATH).getUnderlyingFolders();
                            int n = webLibFolders.length;
                            int n2 = 0;
                            while (n2 < n) {
                                IContainer webLib = iContainerArray[n2];
                                IPath webLibFolderPath = webLib.getFullPath();
                                if (webLibFolderPath.equals((Object)entry.getPath().removeLastSegments(1))) {
                                    foundEntry = true;
                                    break;
                                }
                                ++n2;
                            }
                        } else if (isRAR) {
                            IContainer[] rootFolders;
                            IContainer[] iContainerArray = rootFolders = component.getRootFolder().getUnderlyingFolders();
                            int n = rootFolders.length;
                            int n3 = 0;
                            while (n3 < n) {
                                IContainer root = iContainerArray[n3];
                                IPath rootPath = root.getFullPath();
                                if (rootPath.isPrefixOf(entry.getPath())) {
                                    foundEntry = true;
                                    break;
                                }
                                ++n3;
                            }
                        }
                        if (foundEntry) break block23;
                        List manifestRefs = J2EEModuleVirtualComponent.getManifestReferences(component, null);
                        if (manifestRefs == null) break block25;
                        int j2 = 0;
                        while (j2 < manifestRefs.size()) {
                            VirtualArchiveComponent archiveComponent;
                            IFile file;
                            IVirtualReference ref = (IVirtualReference)manifestRefs.get(j2);
                            IVirtualComponent c = ref.getReferencedComponent();
                            if (c.isBinary() && (file = (archiveComponent = (VirtualArchiveComponent)c).getUnderlyingWorkbenchFile()) != null && file.getFullPath().equals((Object)entry.getPath())) {
                                foundEntry = true;
                                break;
                            }
                            ++j2;
                        }
                        if (foundEntry) break block23;
                    }
                    IProject[] iProjectArray = earProjects = EarUtilities.getReferencingEARProjects(project);
                    int n = earProjects.length;
                    int n4 = 0;
                    while (n4 < n) {
                        IProject earProject = iProjectArray[n4];
                        String earDDVersion = EarUtilities.getJ2EEDDProjectVersion(earProject);
                        if (!(earDDVersion.equals("1.2") || earDDVersion.equals("1.3") || earDDVersion.equals("1.4"))) {
                            IContainer[] earLibFolders;
                            IVirtualComponent earComponent = ComponentCore.createComponent((IProject)earProject);
                            Application app = (Application)ModelProviderManager.getModelProvider(earComponent).getModelObject();
                            String libDir = app.getLibraryDirectory();
                            if (libDir == null) {
                                libDir = "lib";
                            }
                            IContainer[] iContainerArray = earLibFolders = earComponent.getRootFolder().getFolder((IPath)new Path(libDir)).getUnderlyingFolders();
                            int n5 = earLibFolders.length;
                            int n6 = 0;
                            while (n6 < n5) {
                                IContainer earLib = iContainerArray[n6];
                                IPath earLibFolderPath = earLib.getFullPath();
                                if (earLibFolderPath.equals((Object)entry.getPath().removeLastSegments(1))) {
                                    foundEntry = true;
                                    break;
                                }
                                ++n6;
                            }
                            if (foundEntry) break;
                        }
                        ++n4;
                    }
                    if (foundEntry) break block23;
                }
                potentialRawEntries.add(entry);
            }
            ++i;
        }
        return potentialRawEntries;
    }

    private static boolean isValid(IClasspathEntry entry, IClasspathAttribute attrib, boolean isWebApp, IProject project, ClasspathDependencyValidator.ClasspathDependencyValidatorData data) {
        IMessage[] msgs = ClasspathDependencyValidator.validateVirtualComponentEntry(entry, attrib, isWebApp, project, data);
        boolean valid = true;
        int j = 0;
        while (j < msgs.length) {
            if (msgs[j].getSeverity() == 1) {
                valid = false;
                break;
            }
            ++j;
        }
        return valid;
    }

    public static Map<IClasspathEntry, IClasspathAttribute> getComponentClasspathDependencies(IJavaProjectLite javaProjectLite, boolean isWebApp) throws CoreException {
        return ClasspathDependencyUtil.getComponentClasspathDependencies(javaProjectLite, isWebApp, true);
    }

    @Deprecated
    public static Map<IClasspathEntry, IClasspathAttribute> getComponentClasspathDependencies(IJavaProject javaProject, boolean isWebApp) throws CoreException {
        return ClasspathDependencyUtil.getComponentClasspathDependencies(JavaCoreLite.create((IJavaProject)javaProject), isWebApp);
    }

    @Deprecated
    public static Map<IClasspathEntry, IClasspathAttribute> getComponentClasspathDependencies(IJavaProject javaProject, boolean isWebApp, boolean onlyValid) throws CoreException {
        return ClasspathDependencyUtil.getComponentClasspathDependencies(JavaCoreLite.create((IJavaProject)javaProject), isWebApp, onlyValid);
    }

    public static Map<IClasspathEntry, IClasspathAttribute> getComponentClasspathDependencies(IJavaProjectLite javaProjectLite, boolean isWebApp, boolean onlyValid) throws CoreException {
        IPackageFragmentRoot[] roots;
        if (!isWebApp && !ClasspathDependencyEnablement.isAllowClasspathComponentDependency()) {
            return Collections.emptyMap();
        }
        boolean webLibsOnly = isWebApp && !ClasspathDependencyEnablement.isAllowClasspathComponentDependency();
        ClasspathDependencyValidator.ClasspathDependencyValidatorData data = new ClasspathDependencyValidator.ClasspathDependencyValidatorData(javaProjectLite.getProject());
        Map<IClasspathEntry, IClasspathAttribute> referencedRawEntries = ClasspathDependencyUtil.getRawComponentClasspathDependencies(javaProjectLite, IClasspathDependencyConstants.DependencyAttributeType.CLASSPATH_COMPONENT_DEPENDENCY, webLibsOnly);
        HashMap<IClasspathEntry, IClasspathAttribute> validRawEntries = new HashMap<IClasspathEntry, IClasspathAttribute>();
        for (IClasspathEntry entry : referencedRawEntries.keySet()) {
            IClasspathAttribute attrib;
            if (!ClasspathDependencyUtil.isValid(entry, attrib = referencedRawEntries.get(entry), isWebApp, javaProjectLite.getProject(), data)) continue;
            validRawEntries.put(entry, attrib);
        }
        if (validRawEntries.isEmpty()) {
            return Collections.emptyMap();
        }
        IJavaProject javaProject = JavaCore.create((IProject)javaProjectLite.getProject());
        IClasspathEntry[] entries = javaProject.getResolvedClasspath(true);
        HashMap<IPath, IClasspathEntry> pathToResolvedEntry = new HashMap<IPath, IClasspathEntry>();
        int j = 0;
        while (j < entries.length) {
            pathToResolvedEntry.put(entries[j].getPath(), entries[j]);
            ++j;
        }
        LinkedHashMap<IClasspathEntry, IClasspathAttribute> referencedEntries = new LinkedHashMap<IClasspathEntry, IClasspathAttribute>();
        IPackageFragmentRoot[] iPackageFragmentRootArray = roots = javaProject.getPackageFragmentRoots();
        int n = roots.length;
        int n2 = 0;
        while (n2 < n) {
            IPath pkgFragPath;
            IClasspathEntry resolvedEntry;
            IClasspathAttribute resolvedAttrib;
            IPackageFragmentRoot root = iPackageFragmentRootArray[n2];
            IClasspathEntry rawEntry = root.getRawClasspathEntry();
            IClasspathAttribute attrib = (IClasspathAttribute)validRawEntries.get(rawEntry);
            if (!(attrib == null || (resolvedAttrib = ClasspathDependencyUtil.checkForComponentDependencyAttribute(resolvedEntry = (IClasspathEntry)pathToResolvedEntry.get(pkgFragPath = root.getPath()), IClasspathDependencyConstants.DependencyAttributeType.DEPENDENCY_OR_NONDEPENDENCY, webLibsOnly)) != null && !resolvedAttrib.getName().equals("org.eclipse.jst.component.dependency") || onlyValid && !ClasspathDependencyUtil.isValid(resolvedEntry, resolvedAttrib != null ? resolvedAttrib : attrib, isWebApp, javaProjectLite.getProject(), data))) {
                if (resolvedAttrib != null) {
                    attrib = resolvedAttrib;
                }
                referencedEntries.put(resolvedEntry, attrib);
            }
            ++n2;
        }
        return referencedEntries;
    }

    public static IPath getEntryLocation(IClasspathEntry entry) {
        IPath entryPath;
        if (entry == null) {
            return null;
        }
        IPath entryLocation = entryPath = entry.getPath();
        IResource resource = ResourcesPlugin.getWorkspace().getRoot().findMember(entryPath);
        if (resource != null) {
            entryLocation = resource.getLocation();
        }
        return entryLocation;
    }

    public static IResource getEntryResource(IClasspathEntry entry) {
        if (entry == null) {
            return null;
        }
        IPath entryPath = entry.getPath();
        return ResourcesPlugin.getWorkspace().getRoot().findMember(entryPath);
    }

    public static IProject isClasspathProjectReference(IVirtualReference ref) {
        VirtualArchiveComponent comp;
        if (ref == null) {
            return null;
        }
        if (ref.getReferencedComponent() instanceof VirtualArchiveComponent && (comp = (VirtualArchiveComponent)ref.getReferencedComponent()).getArchiveType().equals("cpe") && comp.getUnderlyingDiskFile() == null) {
            return comp.getProject();
        }
        return null;
    }

    public static boolean isClassFolderEntry(IClasspathEntry entry) {
        IPath entryPath;
        if (entry == null || entry.getEntryKind() != 1) {
            return false;
        }
        IPath entryLocation = entryPath = entry.getPath();
        IResource resource = ResourcesPlugin.getWorkspace().getRoot().findMember(entryPath);
        if (resource != null) {
            entryLocation = resource.getLocation();
        }
        boolean isFile = true;
        if (entryLocation.toFile().isDirectory()) {
            isFile = false;
        }
        return !isFile;
    }

    public static IPath getClasspathVirtualReferenceLocation(IVirtualReference ref) {
        VirtualArchiveComponent comp;
        if (ref == null) {
            return null;
        }
        if (ref.getReferencedComponent() instanceof VirtualArchiveComponent && (comp = (VirtualArchiveComponent)ref.getReferencedComponent()).getArchiveType().equals("cpe")) {
            File cpEntryFile = comp.getUnderlyingDiskFile();
            IPath cpEntryPath = null;
            if (cpEntryFile != null && cpEntryFile.exists()) {
                cpEntryPath = new Path(cpEntryFile.getAbsolutePath());
            } else {
                IFile iFile = comp.getUnderlyingWorkbenchFile();
                if (iFile != null) {
                    cpEntryPath = iFile.getLocation();
                } else {
                    IContainer container = ClasspathDependencyUtil.getClassFolder((IVirtualComponent)comp);
                    if (container != null) {
                        return container.getLocation();
                    }
                }
            }
            return cpEntryPath;
        }
        return null;
    }

    public static IPath getRuntimePath(IClasspathAttribute attrib, boolean isWebApp, boolean isClassFolder) {
        if (attrib != null && !attrib.getName().equals("org.eclipse.jst.component.dependency")) {
            return null;
        }
        if (attrib == null || attrib.getValue() == null || attrib.getValue().length() == 0) {
            return ClasspathDependencyUtil.getDefaultRuntimePath(isWebApp, isClassFolder);
        }
        return new Path(attrib.getValue());
    }

    public static boolean isClassFolderReference(IVirtualReference ref) {
        IVirtualComponent comp = ref.getReferencedComponent();
        if (comp instanceof ClasspathDependencyVirtualComponent) {
            ClasspathDependencyVirtualComponent cpComp = (ClasspathDependencyVirtualComponent)comp;
            return cpComp.isClassFolder();
        }
        return false;
    }

    public static IContainer getClassFolder(IVirtualComponent comp) {
        if (comp instanceof ClasspathDependencyVirtualComponent) {
            ClasspathDependencyVirtualComponent cpComp = (ClasspathDependencyVirtualComponent)comp;
            return cpComp.getClassFolder();
        }
        return null;
    }

    public static IPath getDefaultRuntimePath(boolean isWebApp) {
        return ClasspathDependencyUtil.getDefaultRuntimePath(isWebApp, false);
    }

    public static IPath getDefaultRuntimePath(boolean isWebApp, boolean isClassFolder) {
        if (isWebApp) {
            return isClassFolder ? WEB_INF_CLASSES_PATH : WEB_INF_LIB_PATH;
        }
        return isClassFolder ? RUNTIME_MAPPING_INTO_COMPONENT_PATH : RUNTIME_MAPPING_INTO_CONTAINER_PATH;
    }

    public static String getArchiveName(IClasspathEntry entry) {
        if (entry == null) {
            return null;
        }
        boolean isClassFolder = ClasspathDependencyUtil.isClassFolderEntry(entry);
        if (isClassFolder) {
            IResource resource = ClasspathDependencyUtil.getEntryResource(entry);
            if (resource == null) {
                return ClasspathDependencyUtil.getEntryLocation(entry).lastSegment();
            }
            return resource.getFullPath().toString();
        }
        IPath entryLocation = ClasspathDependencyUtil.getEntryLocation(entry);
        return entryLocation.lastSegment();
    }

    public static IClasspathAttribute checkForComponentDependencyAttribute(IClasspathEntry entry) {
        return ClasspathDependencyUtil.checkForComponentDependencyAttribute(entry, IClasspathDependencyConstants.DependencyAttributeType.DEPENDENCY_OR_NONDEPENDENCY);
    }

    public static IClasspathAttribute checkForComponentDependencyAttribute(IClasspathEntry entry, IClasspathDependencyConstants.DependencyAttributeType attributeType) {
        return ClasspathDependencyUtil.checkForComponentDependencyAttribute(entry, attributeType, false);
    }

    public static IClasspathAttribute checkForComponentDependencyAttribute(IClasspathEntry entry, IClasspathDependencyConstants.DependencyAttributeType attributeType, boolean webLibsOnly) {
        if (entry == null || !webLibsOnly && !ClasspathDependencyEnablement.isAllowClasspathComponentDependency()) {
            return null;
        }
        IClasspathAttribute[] attributes = entry.getExtraAttributes();
        int i = 0;
        while (i < attributes.length) {
            IClasspathAttribute attribute = attributes[i];
            String name = attribute.getName();
            if (name.equals("org.eclipse.jst.component.dependency") ? attributeType == IClasspathDependencyConstants.DependencyAttributeType.DEPENDENCY_OR_NONDEPENDENCY || attributeType == IClasspathDependencyConstants.DependencyAttributeType.CLASSPATH_COMPONENT_DEPENDENCY : name.equals("org.eclipse.jst.component.nondependency") && (attributeType == IClasspathDependencyConstants.DependencyAttributeType.DEPENDENCY_OR_NONDEPENDENCY || attributeType == IClasspathDependencyConstants.DependencyAttributeType.CLASSPATH_COMPONENT_NONDEPENDENCY)) {
                return attribute;
            }
            ++i;
        }
        return null;
    }

    public static boolean isClasspathComponentDependency(IVirtualComponent component) {
        if (component == null) {
            return false;
        }
        if (component instanceof VirtualArchiveComponent) {
            VirtualArchiveComponent archiveComp = (VirtualArchiveComponent)component;
            return archiveComp.getArchiveType().equals("cpe");
        }
        return false;
    }

    public static String getClasspathComponentDependencyDisplayString(IVirtualComponent component) {
        URI archiveURI = URI.createURI((String)ModuleURIUtil.getHandleString((IVirtualComponent)component));
        return archiveURI.lastSegment();
    }
}

