/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.sse.core.internal.util;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;

public class ResourceUtil {
    public static IFile getFileFor(IStructuredModel model) {
        if (model == null) {
            return null;
        }
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IFile file = null;
        Path location = new Path(model.getBaseLocation());
        IFile[] files = root.findFilesForLocation((IPath)location);
        if (files.length > 0) {
            file = files[0];
        } else if (location.segmentCount() > 1) {
            file = root.getFile((IPath)location);
        }
        return file;
    }

    public static IFile[] getFilesFor(IStructuredModel model) {
        if (model == null) {
            return null;
        }
        IFile[] files = null;
        Path location = new Path(model.getBaseLocation());
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        files = !location.toFile().exists() && location.segmentCount() > 1 ? new IFile[]{root.getFile((IPath)location)} : root.findFilesForLocation((IPath)location);
        return files;
    }
}

