/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.core.hierarchy;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.wst.jsdt.core.IJavaScriptUnit;
import org.eclipse.wst.jsdt.core.IType;
import org.eclipse.wst.jsdt.core.JavaScriptModelException;
import org.eclipse.wst.jsdt.internal.compiler.ast.TypeDeclaration;
import org.eclipse.wst.jsdt.internal.compiler.env.ICompilationUnit;
import org.eclipse.wst.jsdt.internal.compiler.env.IGenericType;
import org.eclipse.wst.jsdt.internal.compiler.env.ISourceType;
import org.eclipse.wst.jsdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.wst.jsdt.internal.compiler.problem.DefaultProblemFactory;
import org.eclipse.wst.jsdt.internal.core.ClassFile;
import org.eclipse.wst.jsdt.internal.core.JavaElement;
import org.eclipse.wst.jsdt.internal.core.JavaProject;
import org.eclipse.wst.jsdt.internal.core.NameLookup;
import org.eclipse.wst.jsdt.internal.core.Openable;
import org.eclipse.wst.jsdt.internal.core.ResolvedBinaryType;
import org.eclipse.wst.jsdt.internal.core.SearchableEnvironment;
import org.eclipse.wst.jsdt.internal.core.SourceTypeElementInfo;
import org.eclipse.wst.jsdt.internal.core.hierarchy.HierarchyResolver;
import org.eclipse.wst.jsdt.internal.core.hierarchy.HierarchyType;
import org.eclipse.wst.jsdt.internal.core.hierarchy.TypeHierarchy;
import org.eclipse.wst.jsdt.internal.core.util.ResourceCompilationUnit;

public abstract class HierarchyBuilder {
    protected TypeHierarchy hierarchy;
    protected NameLookup nameLookup;
    protected HierarchyResolver hierarchyResolver;
    protected Map infoToHandle;
    protected String focusQualifiedName;

    public HierarchyBuilder(TypeHierarchy hierarchy) throws JavaScriptModelException {
        IJavaScriptUnit[] unitsToLookInside;
        this.hierarchy = hierarchy;
        JavaProject project = (JavaProject)hierarchy.javaProject();
        IType focusType = hierarchy.getType();
        IJavaScriptUnit unitToLookInside = focusType == null ? null : focusType.getJavaScriptUnit();
        IJavaScriptUnit[] workingCopies = this.hierarchy.workingCopies;
        ICompilationUnit mainFile = null;
        if (unitToLookInside != null) {
            int wcLength;
            int n = wcLength = workingCopies == null ? 0 : workingCopies.length;
            if (wcLength == 0) {
                unitsToLookInside = new IJavaScriptUnit[]{unitToLookInside};
            } else {
                unitsToLookInside = new IJavaScriptUnit[wcLength + 1];
                unitsToLookInside[0] = unitToLookInside;
                System.arraycopy(workingCopies, 0, unitsToLookInside, 1, wcLength);
            }
            mainFile = (ICompilationUnit)((Object)unitToLookInside);
        } else {
            unitsToLookInside = workingCopies;
            if (workingCopies != null && workingCopies.length > 0) {
                mainFile = (ICompilationUnit)((Object)workingCopies[0]);
            }
        }
        if (project != null) {
            SearchableEnvironment searchableEnvironment = project.newSearchableNameEnvironment(unitsToLookInside);
            if (mainFile != null) {
                searchableEnvironment.setCompilationUnit(mainFile);
            }
            this.nameLookup = searchableEnvironment.nameLookup;
            this.hierarchyResolver = new HierarchyResolver(searchableEnvironment, project.getOptions(true), this, new DefaultProblemFactory());
        }
        this.infoToHandle = new HashMap(5);
        this.focusQualifiedName = focusType == null ? null : focusType.getFullyQualifiedName();
    }

    public abstract void build(boolean var1) throws JavaScriptModelException, CoreException;

    protected void buildSupertypes() {
        IGenericType type;
        IType focusType = this.getType();
        if (focusType == null) {
            return;
        }
        try {
            type = (IGenericType)((JavaElement)((Object)focusType)).getElementInfo();
        }
        catch (JavaScriptModelException javaScriptModelException) {
            return;
        }
        this.hierarchyResolver.resolve(type);
        if (!this.hierarchy.contains(focusType)) {
            this.hierarchy.addRootClass(focusType);
        }
    }

    public void connect(IGenericType type, IType typeHandle, IType superclassHandle, IType[] superinterfaceHandles) {
        if (typeHandle == null) {
            return;
        }
        if (TypeHierarchy.DEBUG) {
            System.out.println("Connecting: " + ((JavaElement)((Object)typeHandle)).toStringWithAncestors());
            System.out.println("  to superclass: " + (superclassHandle == null ? "<None>" : ((JavaElement)((Object)superclassHandle)).toStringWithAncestors()));
            System.out.print("  and superinterfaces:");
            if (superinterfaceHandles == null || superinterfaceHandles.length == 0) {
                System.out.println(" <None>");
            } else {
                System.out.println();
                int i = 0;
                int length = superinterfaceHandles.length;
                while (i < length) {
                    if (superinterfaceHandles[i] != null) {
                        System.out.println("    " + ((JavaElement)((Object)superinterfaceHandles[i])).toStringWithAncestors());
                    }
                    ++i;
                }
            }
        }
        switch (TypeDeclaration.kind(type.getModifiers())) {
            case 1: 
            case 3: {
                if (superclassHandle == null) {
                    this.hierarchy.addRootClass(typeHandle);
                    break;
                }
                this.hierarchy.cacheSuperclass(typeHandle, superclassHandle);
                break;
            }
            case 2: 
            case 4: {
                this.hierarchy.addInterface(typeHandle);
            }
        }
        if (superinterfaceHandles == null) {
            superinterfaceHandles = TypeHierarchy.NO_TYPE;
        }
        this.hierarchy.cacheSuperInterfaces(typeHandle, superinterfaceHandles);
        this.hierarchy.cacheFlags(typeHandle, type.getModifiers());
    }

    protected IType getHandle(IGenericType genericType, ReferenceBinding binding) {
        if (genericType == null) {
            return null;
        }
        if (genericType instanceof HierarchyType) {
            IType handle = (IType)this.infoToHandle.get(genericType);
            if (handle == null) {
                handle = ((HierarchyType)genericType).typeHandle;
                handle = (IType)((Object)((JavaElement)((Object)handle)).resolved(binding));
                this.infoToHandle.put(genericType, handle);
            }
            return handle;
        }
        if (genericType.isBinaryType()) {
            ClassFile classFile = (ClassFile)this.infoToHandle.get(genericType);
            if (classFile == null) {
                IType handle = this.lookupBinaryHandle((ISourceType)genericType);
                if (handle == null) {
                    return null;
                }
                classFile = (ClassFile)handle.getParent();
                this.infoToHandle.put(genericType, classFile);
            }
            return new ResolvedBinaryType(classFile, classFile.getTypeName(), new String(binding.computeUniqueKey()));
        }
        if (genericType instanceof SourceTypeElementInfo) {
            IType handle = ((SourceTypeElementInfo)genericType).getHandle();
            return (IType)((Object)((JavaElement)((Object)handle)).resolved(binding));
        }
        return null;
    }

    protected IType getType() {
        return this.hierarchy.getType();
    }

    protected IType lookupBinaryHandle(ISourceType typeInfo) {
        int flag;
        switch (TypeDeclaration.kind(typeInfo.getModifiers())) {
            case 1: {
                flag = 2;
                break;
            }
            case 2: {
                flag = 4;
                break;
            }
            case 3: {
                flag = 8;
                break;
            }
            default: {
                flag = 16;
            }
        }
        char[] bName = typeInfo.getName();
        String qualifiedName = new String(ClassFile.translatedName(bName));
        if (qualifiedName.equals(this.focusQualifiedName)) {
            return this.getType();
        }
        NameLookup.Answer answer = this.nameLookup.findType(qualifiedName, false, flag, true, false, false, null);
        return answer == null || answer.type == null || !answer.type.isBinary() ? null : answer.type;
    }

    protected void worked(IProgressMonitor monitor, int work) {
        if (monitor != null) {
            if (monitor.isCanceled()) {
                throw new OperationCanceledException();
            }
            monitor.worked(work);
        }
    }

    protected ICompilationUnit createCompilationUnitFromPath(Openable handle, IFile file) {
        final char[] elementName = handle.getElementName().toCharArray();
        return new ResourceCompilationUnit(file, file.getLocationURI()){

            public char[] getFileName() {
                return elementName;
            }
        };
    }
}

