/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.validation.internal.appconfig;

import java.io.Reader;
import java.io.StringReader;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jst.jsf.common.util.TypeUtil;
import org.eclipse.jst.jsf.core.internal.JSFCorePlugin;
import org.eclipse.jst.jsf.facesconfig.emf.ListEntriesType;
import org.eclipse.jst.jsf.facesconfig.emf.ManagedBeanScopeType;
import org.eclipse.jst.jsf.facesconfig.emf.MapEntriesType;
import org.eclipse.jst.jsf.validation.internal.appconfig.DiagnosticFactory;
import org.eclipse.jst.jsf.validation.internal.appconfig.Messages;
import org.eclipse.jst.jsp.core.internal.java.jspel.JSPELParser;
import org.eclipse.jst.jsp.core.internal.java.jspel.ParseException;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.xml.core.internal.emf2xml.EMF2DOMSSEAdapter;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.w3c.dom.Node;

public final class AppConfigValidationUtil {
    public static IMessage validateClassName(String fullyQualifiedName, String instanceOf, boolean mustBeAClass, IProject project) {
        try {
            IType type = AppConfigValidationUtil.getType(project, fullyQualifiedName);
            if (type == null || !type.exists()) {
                return DiagnosticFactory.create_CANNOT_FIND_CLASS_NAME(fullyQualifiedName);
            }
            if (mustBeAClass && !type.isClass()) {
                return DiagnosticFactory.create_FULLY_QUALIFIED_NAME_MUST_BE_A_CLASS(fullyQualifiedName);
            }
            if (Flags.isAbstract((int)type.getFlags())) {
                return DiagnosticFactory.create_CLASS_MUST_BE_CONCRETE(fullyQualifiedName);
            }
            if (instanceOf != null && !AppConfigValidationUtil.isInstanceOf(type, instanceOf)) {
                return DiagnosticFactory.create_CLASS_MUST_BE_INSTANCE_OF(fullyQualifiedName, Messages.AppConfigValidationUtil_0, instanceOf);
            }
        }
        catch (JavaModelException jme) {
            JSFCorePlugin.log((Exception)((Object)jme), "Error resolving fully qualified class name: " + fullyQualifiedName);
        }
        return null;
    }

    private static IType getType(IProject project, String fullyQualifiedName) throws JavaModelException {
        IJavaProject javaProject = JavaCore.create((IProject)project);
        return javaProject.findType(fullyQualifiedName);
    }

    public static IMessage validateELExpression(String textContent) {
        ELResultWrapper result = AppConfigValidationUtil.extractELExpression(textContent);
        if (result.elText != null) {
            JSPELParser parser = new JSPELParser((Reader)new StringReader(result.elText));
            try {
                parser.Expression();
            }
            catch (ParseException parseException) {
                return DiagnosticFactory.create_SYNTAX_ERROR_IN_EL();
            }
            return null;
        }
        return result.message;
    }

    public static ELResultWrapper extractELExpression(String textContent) {
        Pattern pattern = Pattern.compile("#\\{(.*)\\}");
        Matcher matcher = pattern.matcher(textContent.trim());
        if (matcher.matches()) {
            String elText = matcher.group(1).trim();
            if ("".equals(elText) || elText == null) {
                return new ELResultWrapper(DiagnosticFactory.create_SYNTAX_ERROR_IN_EL(), null);
            }
            return new ELResultWrapper(null, elText);
        }
        return new ELResultWrapper(DiagnosticFactory.create_EL_EXPR_MUST_BE_IN_HASH_BRACES(), null);
    }

    public static int getStartOffset(EObject eObj) {
        IDOMNode node = AppConfigValidationUtil.getDomNode(eObj);
        if (node != null) {
            return node.getStartStructuredDocumentRegion().getStartOffset();
        }
        return -1;
    }

    public static int getLength(EObject eObj) {
        IDOMNode node = AppConfigValidationUtil.getDomNode(eObj);
        if (node != null) {
            return node.getEndStructuredDocumentRegion().getEndOffset() - node.getStartStructuredDocumentRegion().getStartOffset();
        }
        return -1;
    }

    public static IDOMNode getDomNode(EObject eObj) {
        for (Adapter adapter : eObj.eAdapters()) {
            EMF2DOMSSEAdapter sseAdapter;
            Node node;
            if (!(adapter instanceof EMF2DOMSSEAdapter) || !((node = (sseAdapter = (EMF2DOMSSEAdapter)adapter).getNode()) instanceof IDOMNode)) continue;
            return (IDOMNode)node;
        }
        return null;
    }

    public static IMessage validateManagedBeanScope(ManagedBeanScopeType scope) {
        if (!("request".equals(scope.getTextContent()) || "session".equals(scope.getTextContent()) || "application".equals(scope.getTextContent()) || "none".equals(scope.getTextContent()))) {
            return DiagnosticFactory.create_BEAN_SCOPE_NOT_VALID();
        }
        return null;
    }

    public static IMessage validateMapEntries(String targetName, String targetType, MapEntriesType mapEntries, IProject project) {
        if (mapEntries == null || targetType == null || project == null) {
            throw new AssertionError((Object)"Arguments to validateMapEntries can't be null");
        }
        try {
            IType type = AppConfigValidationUtil.getType(project, targetType);
            if (type != null && !AppConfigValidationUtil.isInstanceOf(type, Signature.toString((String)"Ljava.util.Map;"))) {
                return DiagnosticFactory.create_MAP_ENTRIES_CAN_ONLY_BE_SET_ON_MAP_TYPE(targetName);
            }
        }
        catch (JavaModelException jme) {
            JSFCorePlugin.log(new Exception(jme), "Exception while validating mapEntries");
        }
        return null;
    }

    public static IMessage validateListEntries(String targetName, String targetType, ListEntriesType listEntries, IProject project) {
        if (listEntries == null || targetType == null || project == null) {
            throw new AssertionError((Object)"Arguments to validateMapEntries can't be null");
        }
        try {
            IType type = AppConfigValidationUtil.getType(project, targetType);
            if (type != null && !AppConfigValidationUtil.isInstanceOf(type, Signature.toString((String)"Ljava.util.List;"))) {
                return DiagnosticFactory.create_LIST_ENTRIES_CAN_ONLY_BE_SET_ON_LIST_TYPE(targetName);
            }
        }
        catch (JavaModelException jme) {
            JSFCorePlugin.log(new Exception(jme), "Exception while validating mapEntries");
        }
        return null;
    }

    public static IMessage validateLocaleType(String localeType) {
        Matcher matcher = Pattern.compile("[a-z]{2}(_|-)?([\\p{L}\\-\\p{Nd}]{2})?").matcher(localeType);
        if (!matcher.matches()) {
            return DiagnosticFactory.create_LOCALE_FORMAT_NOT_VALID();
        }
        return null;
    }

    public static boolean isInstanceOf(IType type, String instanceOf) throws JavaModelException {
        if (instanceOf != null) {
            if (instanceOf.equals(type.getFullyQualifiedName())) {
                return true;
            }
            ITypeHierarchy typeHierarchy = type.newSupertypeHierarchy((IProgressMonitor)new NullProgressMonitor());
            IType[] supers = typeHierarchy.getAllSupertypes(type);
            int i = 0;
            while (i < supers.length) {
                if (instanceOf.equals(supers[i].getFullyQualifiedName())) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    public static String getBaseType(String inputStr) {
        String checkValue = inputStr.trim();
        try {
            if (Signature.getArrayCount((String)checkValue) > 0) {
                checkValue = Signature.getElementType((String)checkValue);
                checkValue = TypeUtil.getFullyQualifiedName((String)checkValue);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        return checkValue;
    }

    private AppConfigValidationUtil() {
    }

    public static class ELResultWrapper {
        private final IMessage message;
        private final String elText;

        ELResultWrapper(IMessage message, String elText) {
            this.message = message;
            this.elText = elText;
        }

        public IMessage getMessage() {
            return this.message;
        }

        public String getElText() {
            return this.elText;
        }
    }
}

