/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.core;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.wst.jsdt.core.CompletionRequestor;
import org.eclipse.wst.jsdt.core.IField;
import org.eclipse.wst.jsdt.core.IFunction;
import org.eclipse.wst.jsdt.core.IInitializer;
import org.eclipse.wst.jsdt.core.IJavaScriptElement;
import org.eclipse.wst.jsdt.core.IJavaScriptProject;
import org.eclipse.wst.jsdt.core.IJavaScriptUnit;
import org.eclipse.wst.jsdt.core.IMember;
import org.eclipse.wst.jsdt.core.IPackageFragment;
import org.eclipse.wst.jsdt.core.IType;
import org.eclipse.wst.jsdt.core.ITypeHierarchy;
import org.eclipse.wst.jsdt.core.ITypeParameter;
import org.eclipse.wst.jsdt.core.IWorkingCopy;
import org.eclipse.wst.jsdt.core.JavaScriptModelException;
import org.eclipse.wst.jsdt.core.Signature;
import org.eclipse.wst.jsdt.core.WorkingCopyOwner;
import org.eclipse.wst.jsdt.core.compiler.CategorizedProblem;
import org.eclipse.wst.jsdt.core.compiler.CharOperation;
import org.eclipse.wst.jsdt.core.search.SearchEngine;
import org.eclipse.wst.jsdt.internal.codeassist.CompletionEngine;
import org.eclipse.wst.jsdt.internal.codeassist.ISelectionRequestor;
import org.eclipse.wst.jsdt.internal.codeassist.SelectionEngine;
import org.eclipse.wst.jsdt.internal.compiler.ast.TypeDeclaration;
import org.eclipse.wst.jsdt.internal.compiler.env.ISourceType;
import org.eclipse.wst.jsdt.internal.compiler.lookup.Binding;
import org.eclipse.wst.jsdt.internal.core.BasicCompilationUnit;
import org.eclipse.wst.jsdt.internal.core.CompilationUnit;
import org.eclipse.wst.jsdt.internal.core.CreateFieldOperation;
import org.eclipse.wst.jsdt.internal.core.CreateMethodOperation;
import org.eclipse.wst.jsdt.internal.core.CreateTypeHierarchyOperation;
import org.eclipse.wst.jsdt.internal.core.CreateTypeOperation;
import org.eclipse.wst.jsdt.internal.core.DefaultWorkingCopyOwner;
import org.eclipse.wst.jsdt.internal.core.Initializer;
import org.eclipse.wst.jsdt.internal.core.JavaElement;
import org.eclipse.wst.jsdt.internal.core.JavaModelManager;
import org.eclipse.wst.jsdt.internal.core.JavaProject;
import org.eclipse.wst.jsdt.internal.core.NameLookup;
import org.eclipse.wst.jsdt.internal.core.NamedMember;
import org.eclipse.wst.jsdt.internal.core.ResolvedSourceType;
import org.eclipse.wst.jsdt.internal.core.SearchableEnvironment;
import org.eclipse.wst.jsdt.internal.core.SourceField;
import org.eclipse.wst.jsdt.internal.core.SourceMethod;
import org.eclipse.wst.jsdt.internal.core.SourceType;
import org.eclipse.wst.jsdt.internal.core.SourceTypeElementInfo;
import org.eclipse.wst.jsdt.internal.core.TypeParameter;
import org.eclipse.wst.jsdt.internal.core.TypeParameterElementInfo;
import org.eclipse.wst.jsdt.internal.core.hierarchy.TypeHierarchy;
import org.eclipse.wst.jsdt.internal.core.util.MementoTokenizer;
import org.eclipse.wst.jsdt.internal.core.util.Messages;
import org.eclipse.wst.jsdt.internal.core.util.Util;

public class SourceType
extends NamedMember
implements IType {
    protected SourceType(JavaElement parent, String name) {
        super(parent, name);
    }

    protected void closing(Object info) throws JavaScriptModelException {
        super.closing(info);
        SourceTypeElementInfo elementInfo = (SourceTypeElementInfo)info;
        ITypeParameter[] typeParameters = elementInfo.typeParameters;
        int i = 0;
        int length = typeParameters.length;
        while (i < length) {
            ((TypeParameter)typeParameters[i]).close();
            ++i;
        }
    }

    public void codeComplete(char[] snippet, int insertion, int position, char[][] localVariableTypeNames, char[][] localVariableNames, int[] localVariableModifiers, boolean isStatic, CompletionRequestor requestor) throws JavaScriptModelException {
        this.codeComplete(snippet, insertion, position, localVariableTypeNames, localVariableNames, localVariableModifiers, isStatic, requestor, DefaultWorkingCopyOwner.PRIMARY);
    }

    public void codeComplete(char[] snippet, int insertion, int position, char[][] localVariableTypeNames, char[][] localVariableNames, int[] localVariableModifiers, boolean isStatic, CompletionRequestor requestor, WorkingCopyOwner owner) throws JavaScriptModelException {
        if (requestor == null) {
            throw new IllegalArgumentException("Completion requestor cannot be null");
        }
        JavaProject project = (JavaProject)this.getJavaScriptProject();
        SearchableEnvironment environment = this.newSearchableNameEnvironment(owner);
        CompletionEngine engine = new CompletionEngine(environment, requestor, project.getOptions(true), project);
        String source = this.getJavaScriptUnit().getSource();
        if (source != null && insertion > -1 && insertion < source.length()) {
            char[] prefix = CharOperation.concat(source.substring(0, insertion).toCharArray(), new char[]{'{'});
            char[] suffix = CharOperation.concat(new char[]{'}'}, source.substring(insertion).toCharArray());
            char[] fakeSource = CharOperation.concat(prefix, snippet, suffix);
            BasicCompilationUnit cu = new BasicCompilationUnit(fakeSource, null, this.getElementName(), this.getParent());
            engine.complete(cu, prefix.length + position, prefix.length);
        } else {
            engine.complete(this, snippet, position, localVariableTypeNames, localVariableNames, localVariableModifiers, isStatic);
        }
        if (NameLookup.VERBOSE) {
            System.out.println(Thread.currentThread() + " TIME SPENT in NameLoopkup#seekTypesInSourcePackage: " + environment.nameLookup.timeSpentInSeekTypesInSourcePackage + "ms");
            System.out.println(Thread.currentThread() + " TIME SPENT in NameLoopkup#seekTypesInBinaryPackage: " + environment.nameLookup.timeSpentInSeekTypesInBinaryPackage + "ms");
        }
    }

    public IField createField(String contents, IJavaScriptElement sibling, boolean force, IProgressMonitor monitor) throws JavaScriptModelException {
        CreateFieldOperation op = new CreateFieldOperation(this, contents, force);
        if (sibling != null) {
            op.createBefore(sibling);
        }
        op.runOperation(monitor);
        return (IField)op.getResultElements()[0];
    }

    public IFunction createMethod(String contents, IJavaScriptElement sibling, boolean force, IProgressMonitor monitor) throws JavaScriptModelException {
        CreateMethodOperation op = new CreateMethodOperation(this, contents, force);
        if (sibling != null) {
            op.createBefore(sibling);
        }
        op.runOperation(monitor);
        return (IFunction)op.getResultElements()[0];
    }

    public IType createType(String contents, IJavaScriptElement sibling, boolean force, IProgressMonitor monitor) throws JavaScriptModelException {
        CreateTypeOperation op = new CreateTypeOperation(this, contents, force);
        if (sibling != null) {
            op.createBefore(sibling);
        }
        op.runOperation(monitor);
        return (IType)op.getResultElements()[0];
    }

    public boolean equals(Object o) {
        if (!(o instanceof SourceType)) {
            return false;
        }
        return super.equals(o);
    }

    public IFunction[] findMethods(IFunction method) {
        try {
            return SourceType.findMethods(method, this.getFunctions());
        }
        catch (JavaScriptModelException javaScriptModelException) {
            return null;
        }
    }

    public IJavaScriptElement[] getChildrenForCategory(String category) throws JavaScriptModelException {
        IJavaScriptElement[] children = this.getChildren();
        int length = children.length;
        if (length == 0) {
            return NO_ELEMENTS;
        }
        SourceTypeElementInfo info = (SourceTypeElementInfo)this.getElementInfo();
        HashMap categories = info.getCategories();
        if (categories == null) {
            return NO_ELEMENTS;
        }
        IJavaScriptElement[] result = new IJavaScriptElement[length];
        int index = 0;
        int i = 0;
        while (i < length) {
            IJavaScriptElement child = children[i];
            String[] elementCategories = (String[])categories.get(child);
            if (elementCategories != null) {
                int j = 0;
                int length2 = elementCategories.length;
                while (j < length2) {
                    if (elementCategories[j].equals(category)) {
                        result[index++] = child;
                    }
                    ++j;
                }
            }
            ++i;
        }
        if (index == 0) {
            return NO_ELEMENTS;
        }
        if (index < length) {
            IJavaScriptElement[] iJavaScriptElementArray = result;
            result = new IJavaScriptElement[index];
            System.arraycopy(iJavaScriptElementArray, 0, result, 0, index);
        }
        return result;
    }

    public IType getDeclaringType() {
        for (IJavaScriptElement parentElement = this.getParent(); parentElement != null; parentElement = parentElement.getParent()) {
            if (parentElement.getElementType() == 7) {
                return (IType)parentElement;
            }
            if (parentElement instanceof IMember) {
                continue;
            }
            return null;
        }
        return null;
    }

    public int getElementType() {
        return 7;
    }

    public IField getField(String fieldName) {
        return new SourceField(this, fieldName);
    }

    public IField[] getFields() throws JavaScriptModelException {
        ArrayList list = this.getChildrenOfType(8);
        IField[] array = new IField[list.size()];
        list.toArray(array);
        return array;
    }

    public String getFullyQualifiedName() {
        return this.getFullyQualifiedName('$');
    }

    public String getFullyQualifiedName(char enclosingTypeSeparator) {
        try {
            return this.getFullyQualifiedName(enclosingTypeSeparator, false);
        }
        catch (JavaScriptModelException javaScriptModelException) {
            return null;
        }
    }

    public String getFullyQualifiedParameterizedName() throws JavaScriptModelException {
        return this.getFullyQualifiedName('.', true);
    }

    public IJavaScriptElement getHandleFromMemento(String token, MementoTokenizer memento, WorkingCopyOwner workingCopyOwner) {
        switch (token.charAt(0)) {
            case '!': {
                return this.getHandleUpdatingCountFromMemento(memento, workingCopyOwner);
            }
            case '^': {
                if (!memento.hasMoreTokens()) {
                    return this;
                }
                String fieldName = memento.nextToken();
                JavaElement field = (JavaElement)((Object)this.getField(fieldName));
                return field.getHandleFromMemento(memento, workingCopyOwner);
            }
            case '|': {
                if (!memento.hasMoreTokens()) {
                    return this;
                }
                String count = memento.nextToken();
                JavaElement initializer = (JavaElement)((Object)this.getInitializer(Integer.parseInt(count)));
                return initializer.getHandleFromMemento(memento, workingCopyOwner);
            }
            case '~': {
                if (!memento.hasMoreTokens()) {
                    return this;
                }
                String selector = memento.nextToken();
                ArrayList<String> params = new ArrayList<String>();
                block15: while (memento.hasMoreTokens()) {
                    token = memento.nextToken();
                    switch (token.charAt(0)) {
                        case '[': 
                        case ']': {
                            break block15;
                        }
                        case '~': {
                            if (!memento.hasMoreTokens()) {
                                return this;
                            }
                            String param = memento.nextToken();
                            StringBuffer buffer = new StringBuffer();
                            while (param.length() == 1 && '[' == param.charAt(0)) {
                                buffer.append('[');
                                if (!memento.hasMoreTokens()) {
                                    return this;
                                }
                                param = memento.nextToken();
                            }
                            params.add(String.valueOf(buffer.toString()) + param);
                            break;
                        }
                        default: {
                            break block15;
                        }
                    }
                }
                String[] parameters = new String[params.size()];
                params.toArray(parameters);
                JavaElement method = (JavaElement)((Object)this.getFunction(selector, parameters));
                switch (token.charAt(0)) {
                    case '@': 
                    case '[': 
                    case ']': {
                        return method.getHandleFromMemento(token, memento, workingCopyOwner);
                    }
                }
                return method;
            }
            case '[': {
                String typeName;
                if (memento.hasMoreTokens()) {
                    typeName = memento.nextToken();
                    char firstChar = typeName.charAt(0);
                    if (firstChar == '^' || firstChar == '|' || firstChar == '~' || firstChar == '[' || firstChar == '!') {
                        token = typeName;
                        typeName = "";
                    } else {
                        token = null;
                    }
                } else {
                    typeName = "";
                    token = null;
                }
                JavaElement type = (JavaElement)((Object)this.getType(typeName));
                if (token == null) {
                    return type.getHandleFromMemento(memento, workingCopyOwner);
                }
                return type.getHandleFromMemento(token, memento, workingCopyOwner);
            }
            case ']': {
                if (!memento.hasMoreTokens()) {
                    return this;
                }
                String typeParameterName = memento.nextToken();
                TypeParameter typeParameter = new TypeParameter(this, typeParameterName);
                return typeParameter.getHandleFromMemento(memento, workingCopyOwner);
            }
        }
        return null;
    }

    public IInitializer getInitializer(int count) {
        return new Initializer(this, count);
    }

    public IInitializer[] getInitializers() throws JavaScriptModelException {
        ArrayList list = this.getChildrenOfType(10);
        IInitializer[] array = new IInitializer[list.size()];
        list.toArray(array);
        return array;
    }

    public String getKey() {
        try {
            return this.getKey(this, false);
        }
        catch (JavaScriptModelException javaScriptModelException) {
            return null;
        }
    }

    public IFunction getFunction(String selector, String[] parameterTypeSignatures) {
        return new SourceMethod(this, selector, parameterTypeSignatures);
    }

    public IFunction[] getMethods() throws JavaScriptModelException {
        return this.getFunctions();
    }

    public IFunction[] getFunctions() throws JavaScriptModelException {
        ArrayList list = this.getChildrenOfType(9);
        IFunction[] array = new IFunction[list.size()];
        list.toArray(array);
        return array;
    }

    public IPackageFragment getPackageFragment() {
        IJavaScriptElement parentElement = this.parent;
        while (parentElement != null) {
            if (parentElement.getElementType() == 4) {
                return (IPackageFragment)parentElement;
            }
            parentElement = parentElement.getParent();
        }
        Assert.isTrue((boolean)false);
        return null;
    }

    public IJavaScriptElement getPrimaryElement(boolean checkOwner) {
        CompilationUnit cu;
        if (checkOwner && (cu = (CompilationUnit)this.getAncestor(5)).isPrimary()) {
            return this;
        }
        IJavaScriptElement primaryParent = this.parent.getPrimaryElement(false);
        switch (primaryParent.getElementType()) {
            case 5: {
                return ((IJavaScriptUnit)primaryParent).getType(this.name);
            }
            case 7: {
                return ((IType)primaryParent).getType(this.name);
            }
            case 8: 
            case 9: 
            case 10: {
                return ((IMember)primaryParent).getType(this.name, this.occurrenceCount);
            }
        }
        return this;
    }

    public String getSuperclassName() throws JavaScriptModelException {
        SourceTypeElementInfo info = (SourceTypeElementInfo)this.getElementInfo();
        char[] superclassName = info.getSuperclassName();
        if (superclassName == null) {
            return null;
        }
        return new String(superclassName);
    }

    public String getSuperclassTypeSignature() throws JavaScriptModelException {
        SourceTypeElementInfo info = (SourceTypeElementInfo)this.getElementInfo();
        char[] superclassName = info.getSuperclassName();
        if (superclassName == null) {
            return null;
        }
        return new String(Signature.createTypeSignature(superclassName, false));
    }

    public String[] getSuperInterfaceNames() throws JavaScriptModelException {
        SourceTypeElementInfo info = (SourceTypeElementInfo)this.getElementInfo();
        char[][] names = info.getInterfaceNames();
        return CharOperation.toStrings(names);
    }

    public String[] getSuperInterfaceTypeSignatures() throws JavaScriptModelException {
        SourceTypeElementInfo info = (SourceTypeElementInfo)this.getElementInfo();
        char[][] names = info.getInterfaceNames();
        if (names == null) {
            return CharOperation.NO_STRINGS;
        }
        String[] strings = new String[names.length];
        int i = 0;
        while (i < names.length) {
            strings[i] = new String(Signature.createTypeSignature(names[i], false));
            ++i;
        }
        return strings;
    }

    public ITypeParameter[] getTypeParameters() throws JavaScriptModelException {
        SourceTypeElementInfo info = (SourceTypeElementInfo)this.getElementInfo();
        return info.typeParameters;
    }

    public String[] getTypeParameterSignatures() throws JavaScriptModelException {
        ITypeParameter[] typeParameters = this.getTypeParameters();
        int length = typeParameters.length;
        String[] typeParameterSignatures = new String[length];
        int i = 0;
        while (i < length) {
            TypeParameter typeParameter = (TypeParameter)typeParameters[i];
            TypeParameterElementInfo info = (TypeParameterElementInfo)typeParameter.getElementInfo();
            char[][] bounds = info.bounds;
            if (bounds == null) {
                typeParameterSignatures[i] = Signature.createTypeParameterSignature(typeParameter.getElementName(), CharOperation.NO_STRINGS);
            } else {
                int boundsLength = bounds.length;
                char[][] boundSignatures = new char[boundsLength][];
                int j = 0;
                while (j < boundsLength) {
                    boundSignatures[j] = Signature.createCharArrayTypeSignature(bounds[j], false);
                    ++j;
                }
                typeParameterSignatures[i] = new String(Signature.createTypeParameterSignature(typeParameter.getElementName().toCharArray(), boundSignatures));
            }
            ++i;
        }
        return typeParameterSignatures;
    }

    public IType getType(String typeName) {
        return new SourceType(this, typeName);
    }

    public ITypeParameter getTypeParameter(String typeParameterName) {
        return new TypeParameter(this, typeParameterName);
    }

    public String getTypeQualifiedName() {
        return this.getTypeQualifiedName('$');
    }

    public String getTypeQualifiedName(char enclosingTypeSeparator) {
        try {
            return this.getTypeQualifiedName(enclosingTypeSeparator, false);
        }
        catch (JavaScriptModelException javaScriptModelException) {
            return null;
        }
    }

    public IType[] getTypes() throws JavaScriptModelException {
        ArrayList list = this.getChildrenOfType(7);
        IType[] array = new IType[list.size()];
        list.toArray(array);
        return array;
    }

    public boolean isAnonymous() {
        return this.name.length() == 0 || this.name.startsWith(Util.ANONYMOUS_MARKER);
    }

    public boolean isClass() throws JavaScriptModelException {
        SourceTypeElementInfo info = (SourceTypeElementInfo)this.getElementInfo();
        return TypeDeclaration.kind(info.getModifiers()) == 1;
    }

    public boolean isEnum() throws JavaScriptModelException {
        SourceTypeElementInfo info = (SourceTypeElementInfo)this.getElementInfo();
        return TypeDeclaration.kind(info.getModifiers()) == 3;
    }

    public boolean isInterface() throws JavaScriptModelException {
        SourceTypeElementInfo info = (SourceTypeElementInfo)this.getElementInfo();
        switch (TypeDeclaration.kind(info.getModifiers())) {
            case 2: 
            case 4: {
                return true;
            }
        }
        return false;
    }

    public boolean isAnnotation() throws JavaScriptModelException {
        SourceTypeElementInfo info = (SourceTypeElementInfo)this.getElementInfo();
        return TypeDeclaration.kind(info.getModifiers()) == 4;
    }

    public boolean isLocal() {
        switch (this.parent.getElementType()) {
            case 8: 
            case 9: 
            case 10: {
                return true;
            }
        }
        return false;
    }

    public boolean isMember() {
        return this.getDeclaringType() != null;
    }

    public boolean isResolved() {
        return false;
    }

    public ITypeHierarchy loadTypeHierachy(InputStream input, IProgressMonitor monitor) throws JavaScriptModelException {
        return this.loadTypeHierachy(input, DefaultWorkingCopyOwner.PRIMARY, monitor);
    }

    public ITypeHierarchy loadTypeHierachy(InputStream input, WorkingCopyOwner owner, IProgressMonitor monitor) throws JavaScriptModelException {
        return TypeHierarchy.load(this, input, owner);
    }

    public ITypeHierarchy newSupertypeHierarchy(IProgressMonitor monitor) throws JavaScriptModelException {
        return this.newSupertypeHierarchy(DefaultWorkingCopyOwner.PRIMARY, monitor);
    }

    public ITypeHierarchy newSupertypeHierarchy(IJavaScriptUnit[] workingCopies, IProgressMonitor monitor) throws JavaScriptModelException {
        CreateTypeHierarchyOperation op = new CreateTypeHierarchyOperation((IType)this, workingCopies, SearchEngine.createWorkspaceScope(), false);
        op.runOperation(monitor);
        return op.getResult();
    }

    public ITypeHierarchy newSupertypeHierarchy(WorkingCopyOwner owner, IProgressMonitor monitor) throws JavaScriptModelException {
        IJavaScriptUnit[] workingCopies = JavaModelManager.getJavaModelManager().getWorkingCopies(owner, true);
        CreateTypeHierarchyOperation op = new CreateTypeHierarchyOperation((IType)this, workingCopies, SearchEngine.createWorkspaceScope(), false);
        op.runOperation(monitor);
        return op.getResult();
    }

    public ITypeHierarchy newTypeHierarchy(IJavaScriptProject project, IProgressMonitor monitor) throws JavaScriptModelException {
        return this.newTypeHierarchy(project, DefaultWorkingCopyOwner.PRIMARY, monitor);
    }

    public ITypeHierarchy newTypeHierarchy(IJavaScriptProject project, WorkingCopyOwner owner, IProgressMonitor monitor) throws JavaScriptModelException {
        if (project == null) {
            throw new IllegalArgumentException(Messages.hierarchy_nullProject);
        }
        IJavaScriptUnit[] workingCopies = JavaModelManager.getJavaModelManager().getWorkingCopies(owner, true);
        IJavaScriptUnit[] projectWCs = null;
        if (workingCopies != null) {
            int length = workingCopies.length;
            projectWCs = new IJavaScriptUnit[length];
            int index = 0;
            int i = 0;
            while (i < length) {
                IJavaScriptUnit wc = workingCopies[i];
                if (project.equals(wc.getJavaScriptProject())) {
                    projectWCs[index++] = wc;
                }
                ++i;
            }
            if (index != length) {
                IJavaScriptUnit[] iJavaScriptUnitArray = projectWCs;
                projectWCs = new IJavaScriptUnit[index];
                System.arraycopy(iJavaScriptUnitArray, 0, projectWCs, 0, index);
            }
        }
        CreateTypeHierarchyOperation op = new CreateTypeHierarchyOperation((IType)this, projectWCs, project, true);
        op.runOperation(monitor);
        return op.getResult();
    }

    public ITypeHierarchy newTypeHierarchy(IProgressMonitor monitor) throws JavaScriptModelException {
        CreateTypeHierarchyOperation op = new CreateTypeHierarchyOperation((IType)this, null, SearchEngine.createWorkspaceScope(), true);
        op.runOperation(monitor);
        return op.getResult();
    }

    public ITypeHierarchy newTypeHierarchy(IJavaScriptUnit[] workingCopies, IProgressMonitor monitor) throws JavaScriptModelException {
        CreateTypeHierarchyOperation op = new CreateTypeHierarchyOperation((IType)this, workingCopies, SearchEngine.createWorkspaceScope(), true);
        op.runOperation(monitor);
        return op.getResult();
    }

    public ITypeHierarchy newTypeHierarchy(IWorkingCopy[] workingCopies, IProgressMonitor monitor) throws JavaScriptModelException {
        IJavaScriptUnit[] copies;
        if (workingCopies == null) {
            copies = null;
        } else {
            int length = workingCopies.length;
            copies = new IJavaScriptUnit[length];
            System.arraycopy(workingCopies, 0, copies, 0, length);
        }
        return this.newTypeHierarchy(copies, monitor);
    }

    public ITypeHierarchy newTypeHierarchy(WorkingCopyOwner owner, IProgressMonitor monitor) throws JavaScriptModelException {
        IJavaScriptUnit[] workingCopies = JavaModelManager.getJavaModelManager().getWorkingCopies(owner, true);
        CreateTypeHierarchyOperation op = new CreateTypeHierarchyOperation((IType)this, workingCopies, SearchEngine.createWorkspaceScope(), true);
        op.runOperation(monitor);
        return op.getResult();
    }

    public JavaElement resolved(Binding binding) {
        ResolvedSourceType resolvedHandle = new ResolvedSourceType(this.parent, this.name, new String(binding.computeUniqueKey()));
        resolvedHandle.occurrenceCount = this.occurrenceCount;
        return resolvedHandle;
    }

    public String[][] resolveType(String typeName) throws JavaScriptModelException {
        return this.resolveType(typeName, DefaultWorkingCopyOwner.PRIMARY);
    }

    public String[][] resolveType(String typeName, WorkingCopyOwner owner) throws JavaScriptModelException {
        ISourceType info = (ISourceType)this.getElementInfo();
        JavaProject project = (JavaProject)this.getJavaScriptProject();
        SearchableEnvironment environment = this.newSearchableNameEnvironment(owner);
        class TypeResolveRequestor
        implements ISelectionRequestor {
            String[][] answers;
            final /* synthetic */ SourceType this$0;

            TypeResolveRequestor(SourceType sourceType) {
                this.this$0 = sourceType;
                this.answers = null;
            }

            public void acceptType(char[] packageName, char[] fileName, char[] tName, int modifiers, boolean isDeclaration, char[] uniqueKey, int start, int end) {
                String[] answer = new String[]{new String(packageName), new String(tName)};
                if (this.answers == null) {
                    this.answers = new String[][]{answer};
                } else {
                    int length = this.answers.length;
                    this.answers = new String[length + 1][];
                    System.arraycopy(this.answers, 0, this.answers, 0, length);
                    this.answers[length] = answer;
                }
            }

            public void acceptError(CategorizedProblem error) {
            }

            public void acceptField(char[] declaringTypePackageName, char[] fileName, char[] declaringTypeName, char[] fieldName, boolean isDeclaration, char[] uniqueKey, int start, int end) {
            }

            public void acceptMethod(char[] declaringTypePackageName, char[] fileName, char[] declaringTypeName, String enclosingDeclaringTypeSignature, char[] selector, char[][] parameterPackageNames, char[][] parameterTypeNames, String[] parameterSignatures, char[][] typeParameterNames, char[][][] typeParameterBoundNames, boolean isConstructor, boolean isDeclaration, char[] uniqueKey, int start, int end) {
            }

            public void acceptPackage(char[] packageName) {
            }

            public void acceptTypeParameter(char[] declaringTypePackageName, char[] fileName, char[] declaringTypeName, char[] typeParameterName, boolean isDeclaration, int start, int end) {
            }

            public void acceptMethodTypeParameter(char[] declaringTypePackageName, char[] fileName, char[] declaringTypeName, char[] selector, int selectorStart, int selcetorEnd, char[] typeParameterName, boolean isDeclaration, int start, int end) {
            }
        }
        TypeResolveRequestor requestor = new TypeResolveRequestor(this);
        SelectionEngine engine = new SelectionEngine(environment, requestor, project.getOptions(true));
        IType[] topLevelTypes = this.getJavaScriptUnit().getTypes();
        int length = topLevelTypes.length;
        SourceTypeElementInfo[] topLevelInfos = new SourceTypeElementInfo[length];
        int i = 0;
        while (i < length) {
            topLevelInfos[i] = (SourceTypeElementInfo)((SourceType)topLevelTypes[i]).getElementInfo();
            ++i;
        }
        engine.selectType(info, typeName.toCharArray(), topLevelInfos, false);
        if (NameLookup.VERBOSE) {
            System.out.println(Thread.currentThread() + " TIME SPENT in NameLoopkup#seekTypesInSourcePackage: " + environment.nameLookup.timeSpentInSeekTypesInSourcePackage + "ms");
            System.out.println(Thread.currentThread() + " TIME SPENT in NameLoopkup#seekTypesInBinaryPackage: " + environment.nameLookup.timeSpentInSeekTypesInBinaryPackage + "ms");
        }
        return requestor.answers;
    }

    public String getDisplayName() {
        if (this.isAnonymous()) {
            return "";
        }
        return super.getDisplayName();
    }

    protected void toStringInfo(int tab, StringBuffer buffer, Object info, boolean showResolvedInfo) {
        buffer.append(this.tabString(tab));
        if (info == null) {
            String elementName = this.getElementName();
            if (elementName.length() == 0) {
                buffer.append("<anonymous #");
                buffer.append(this.occurrenceCount);
                buffer.append(">");
            } else {
                this.toStringName(buffer);
            }
            buffer.append(" (not open)");
        } else if (info == NO_INFO) {
            String elementName = this.getElementName();
            if (elementName.length() == 0) {
                buffer.append("<anonymous #");
                buffer.append(this.occurrenceCount);
                buffer.append(">");
            } else {
                this.toStringName(buffer);
            }
        } else {
            try {
                if (this.isEnum()) {
                    buffer.append("enum ");
                } else if (this.isAnnotation()) {
                    buffer.append("@interface ");
                } else if (this.isInterface()) {
                    buffer.append("interface ");
                } else {
                    buffer.append("class ");
                }
                String elementName = this.getElementName();
                if (elementName.length() == 0) {
                    buffer.append("<anonymous #");
                    buffer.append(this.occurrenceCount);
                    buffer.append(">");
                } else {
                    this.toStringName(buffer);
                }
            }
            catch (JavaScriptModelException javaScriptModelException) {
                buffer.append("<JavaScriptModelException in toString of " + this.getElementName());
            }
        }
    }
}

