/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.core.search;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.wst.jsdt.core.IIncludePathEntry;
import org.eclipse.wst.jsdt.core.IJavaScriptElement;
import org.eclipse.wst.jsdt.core.IJavaScriptElementDelta;
import org.eclipse.wst.jsdt.core.IJavaScriptProject;
import org.eclipse.wst.jsdt.core.IMember;
import org.eclipse.wst.jsdt.core.IPackageFragmentRoot;
import org.eclipse.wst.jsdt.core.IType;
import org.eclipse.wst.jsdt.core.ITypeHierarchy;
import org.eclipse.wst.jsdt.core.JavaScriptCore;
import org.eclipse.wst.jsdt.core.JavaScriptModelException;
import org.eclipse.wst.jsdt.core.WorkingCopyOwner;
import org.eclipse.wst.jsdt.internal.compiler.util.SuffixConstants;
import org.eclipse.wst.jsdt.internal.core.JavaElement;
import org.eclipse.wst.jsdt.internal.core.JavaModel;
import org.eclipse.wst.jsdt.internal.core.JavaModelManager;
import org.eclipse.wst.jsdt.internal.core.JavaProject;
import org.eclipse.wst.jsdt.internal.core.hierarchy.TypeHierarchy;
import org.eclipse.wst.jsdt.internal.core.search.AbstractSearchScope;

public class HierarchyScope
extends AbstractSearchScope
implements SuffixConstants {
    public IType focusType;
    private String focusPath;
    private WorkingCopyOwner owner;
    private ITypeHierarchy hierarchy;
    private IType[] types;
    private HashSet resourcePaths;
    private IPath[] enclosingProjectsAndJars;
    protected IResource[] elements;
    protected int elementCount;
    public boolean needsRefresh;

    public void add(IResource element) {
        if (this.elementCount == this.elements.length) {
            this.elements = new IResource[this.elementCount * 2];
            System.arraycopy(this.elements, 0, this.elements, 0, this.elementCount);
        }
        this.elements[this.elementCount++] = element;
    }

    public HierarchyScope(IType type, WorkingCopyOwner owner) throws JavaScriptModelException {
        this.focusType = type;
        this.owner = owner;
        this.enclosingProjectsAndJars = this.computeProjectsAndJars(type);
        IPackageFragmentRoot cfr_ignored_0 = (IPackageFragmentRoot)type.getPackageFragment().getParent();
        this.focusPath = type.getPath().toString();
        this.needsRefresh = true;
    }

    private void buildResourceVector() {
        HashMap<IResource, IResource> resources = new HashMap<IResource, IResource>();
        HashMap<IPath, IType> paths = new HashMap<IPath, IType>();
        this.types = this.hierarchy.getAllTypes();
        ResourcesPlugin.getWorkspace().getRoot();
        int i = 0;
        while (i < this.types.length) {
            IType type = this.types[i];
            IResource resource = type.getResource();
            if (resource != null && resources.get(resource) == null) {
                resources.put(resource, resource);
                this.add(resource);
            }
            IPackageFragmentRoot cfr_ignored_0 = (IPackageFragmentRoot)type.getPackageFragment().getParent();
            paths.put(type.getJavaScriptProject().getProject().getFullPath(), type);
            ++i;
        }
        this.enclosingProjectsAndJars = new IPath[paths.size()];
        i = 0;
        Iterator iter = paths.keySet().iterator();
        while (iter.hasNext()) {
            this.enclosingProjectsAndJars[i++] = (IPath)iter.next();
        }
    }

    private IPath[] computeProjectsAndJars(IType type) throws JavaScriptModelException {
        HashSet<IPath> set = new HashSet<IPath>();
        IPackageFragmentRoot root = (IPackageFragmentRoot)type.getPackageFragment().getParent();
        if (root.isArchive()) {
            set.add(root.getPath());
            IPath rootPath = root.getPath();
            JavaModel model = JavaModelManager.getJavaModelManager().getJavaModel();
            IJavaScriptProject[] projects = model.getJavaScriptProjects();
            HashSet visited = new HashSet();
            int i = 0;
            while (i < projects.length) {
                JavaProject project = (JavaProject)projects[i];
                IIncludePathEntry entry = project.getClasspathEntryFor(rootPath);
                if (entry != null) {
                    IPackageFragmentRoot[] roots = project.getAllPackageFragmentRoots();
                    set.add(project.getPath());
                    int k = 0;
                    while (k < roots.length) {
                        IPackageFragmentRoot pkgFragmentRoot = roots[k];
                        if (pkgFragmentRoot.getKind() == 2) {
                            set.add(pkgFragmentRoot.getPath());
                        }
                        ++k;
                    }
                    this.computeDependents(project, set, visited);
                }
                ++i;
            }
        } else {
            IJavaScriptProject project = (IJavaScriptProject)root.getParent();
            IPackageFragmentRoot[] roots = project.getAllPackageFragmentRoots();
            int i = 0;
            while (i < roots.length) {
                IPackageFragmentRoot pkgFragmentRoot = roots[i];
                if (pkgFragmentRoot.getKind() == 2) {
                    set.add(pkgFragmentRoot.getPath());
                } else {
                    set.add(pkgFragmentRoot.getParent().getPath());
                }
                ++i;
            }
            this.computeDependents(project, set, new HashSet());
        }
        IPath[] result = new IPath[set.size()];
        set.toArray(result);
        return result;
    }

    private void computeDependents(IJavaScriptProject project, HashSet set, HashSet visited) {
        if (visited.contains(project)) {
            return;
        }
        visited.add(project);
        IProject[] dependents = project.getProject().getReferencingProjects();
        int i = 0;
        while (i < dependents.length) {
            try {
                IJavaScriptProject dependent = JavaScriptCore.create(dependents[i]);
                IPackageFragmentRoot[] roots = dependent.getPackageFragmentRoots();
                set.add(dependent.getPath());
                int j = 0;
                while (j < roots.length) {
                    IPackageFragmentRoot pkgFragmentRoot = roots[j];
                    if (pkgFragmentRoot.isArchive()) {
                        set.add(pkgFragmentRoot.getPath());
                    }
                    ++j;
                }
                this.computeDependents(dependent, set, visited);
            }
            catch (JavaScriptModelException javaScriptModelException) {}
            ++i;
        }
    }

    public boolean encloses(String resourcePath) {
        int separatorIndex;
        if (this.hierarchy == null) {
            if (resourcePath.equals(this.focusPath)) {
                return true;
            }
            if (this.needsRefresh) {
                try {
                    this.initialize();
                }
                catch (JavaScriptModelException javaScriptModelException) {
                    return false;
                }
            } else {
                return true;
            }
        }
        if (this.needsRefresh) {
            try {
                this.refresh();
            }
            catch (JavaScriptModelException javaScriptModelException) {
                return false;
            }
        }
        if ((separatorIndex = resourcePath.indexOf("|")) != -1) {
            return this.resourcePaths.contains(resourcePath);
        }
        int i = 0;
        while (i < this.elementCount) {
            if (resourcePath.startsWith(this.elements[i].getFullPath().toString())) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean encloses(IJavaScriptElement element) {
        if (this.hierarchy == null) {
            if (this.focusType.equals(element.getAncestor(7))) {
                return true;
            }
            if (this.needsRefresh) {
                try {
                    this.initialize();
                }
                catch (JavaScriptModelException javaScriptModelException) {
                    return false;
                }
            } else {
                return true;
            }
        }
        if (this.needsRefresh) {
            try {
                this.refresh();
            }
            catch (JavaScriptModelException javaScriptModelException) {
                return false;
            }
        }
        IType type = null;
        if (element instanceof IType) {
            type = (IType)element;
        } else if (element instanceof IMember) {
            type = ((IMember)element).getDeclaringType();
        }
        if (type != null) {
            IType original;
            if (this.hierarchy.contains(type)) {
                return true;
            }
            if (!type.isBinary() && (original = (IType)type.getPrimaryElement()) != null) {
                return this.hierarchy.contains(original);
            }
        }
        return false;
    }

    public IPath[] enclosingProjectsAndJars() {
        if (this.needsRefresh) {
            try {
                this.refresh();
            }
            catch (JavaScriptModelException javaScriptModelException) {
                return new IPath[0];
            }
        }
        return this.enclosingProjectsAndJars;
    }

    protected void initialize() throws JavaScriptModelException {
        this.resourcePaths = new HashSet();
        this.elements = new IResource[5];
        this.elementCount = 0;
        this.needsRefresh = false;
        if (this.hierarchy == null) {
            this.hierarchy = this.focusType.newTypeHierarchy(this.owner, null);
        } else {
            this.hierarchy.refresh(null);
        }
        this.buildResourceVector();
    }

    public void processDelta(IJavaScriptElementDelta delta) {
        if (this.needsRefresh) {
            return;
        }
        this.needsRefresh = this.hierarchy == null ? false : ((TypeHierarchy)this.hierarchy).isAffected(delta);
    }

    protected void refresh() throws JavaScriptModelException {
        if (this.hierarchy != null) {
            this.initialize();
        }
    }

    public String toString() {
        return "HierarchyScope on " + ((JavaElement)((Object)this.focusType)).toStringWithAncestors();
    }
}

