/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.validation.internal.el.operators;

import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.jst.jsf.common.internal.types.BooleanLiteralType;
import org.eclipse.jst.jsf.common.internal.types.LiteralType;
import org.eclipse.jst.jsf.common.internal.types.TypeCoercer;
import org.eclipse.jst.jsf.common.internal.types.TypeCoercionException;
import org.eclipse.jst.jsf.common.internal.types.TypeTransformer;
import org.eclipse.jst.jsf.common.internal.types.ValueType;
import org.eclipse.jst.jsf.validation.internal.el.diagnostics.DiagnosticFactory;
import org.eclipse.jst.jsf.validation.internal.el.operators.UnaryOperator;

class NotUnaryOperator
extends UnaryOperator {
    NotUnaryOperator(DiagnosticFactory diagnosticFactory) {
        super(diagnosticFactory);
    }

    public Diagnostic validate(ValueType type) {
        if ("Ljava.lang.Object;".equals(type.getSignature())) {
            return Diagnostic.OK_INSTANCE;
        }
        boolean canCoerce = TypeCoercer.canCoerceToBoolean((String)TypeTransformer.transformBoxPrimitives((String)type.getSignature()));
        if (canCoerce) {
            if (type instanceof LiteralType) {
                try {
                    Boolean coercedValue = ((LiteralType)type).coerceToBoolean();
                    return this._diagnosticFactory.create_UNARY_OP_CONSTANT_EXPRESSION_EVAL_SAME_ID("not", Boolean.valueOf(coercedValue == false).toString());
                }
                catch (TypeCoercionException typeCoercionException) {
                    throw new AssertionError((Object)"coerce should not throw exception");
                }
            }
            return Diagnostic.OK_INSTANCE;
        }
        return this._diagnosticFactory.create_UNARY_OP_CANNOT_COERCE_ARGUMENT_TO_BOOLEAN();
    }

    public ValueType performOperation(ValueType type) {
        boolean canCoerce = TypeCoercer.canCoerceToBoolean((String)TypeTransformer.transformBoxPrimitives((String)type.getSignature()));
        if (canCoerce) {
            if (type instanceof LiteralType) {
                try {
                    Boolean coercedValue = ((LiteralType)type).coerceToBoolean();
                    return coercedValue != false ? BooleanLiteralType.FALSE : BooleanLiteralType.TRUE;
                }
                catch (TypeCoercionException typeCoercionException) {
                    throw new AssertionError((Object)"coerce should not throw exception");
                }
            }
            return new ValueType("Z", type.getAssignability());
        }
        return null;
    }
}

