/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jem.java.internal.impl;

import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.impl.EClassImpl;
import org.eclipse.emf.ecore.util.EContentsEList;
import org.eclipse.emf.ecore.util.ECrossReferenceEList;
import org.eclipse.jem.internal.java.instantiation.IInstantiationInstance;
import org.eclipse.jem.java.JavaClass;
import org.eclipse.jem.java.JavaDataType;
import org.eclipse.jem.java.JavaRefFactory;
import org.eclipse.jem.java.JavaRefPackage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaDataTypeImpl
extends EClassImpl
implements JavaDataType {
    static final String FALSE = "false";
    static final String DOUBLE_ZERO = "0.0";
    static final String FLOAT_ZERO = "0.0f";
    static final String CHAR_ZERO = "'0'";
    static final String ZERO = "0";
    private int primitive_type = 0;

    protected JavaDataTypeImpl() {
    }

    protected EClass eStaticClass() {
        return JavaRefPackage.Literals.JAVA_DATA_TYPE;
    }

    @Override
    public String getDefaultValueString() {
        String typeName = this.getJavaName();
        if (typeName.equals("boolean")) {
            return FALSE;
        }
        if (typeName.equals("double")) {
            return DOUBLE_ZERO;
        }
        if (typeName.equals("float")) {
            return FLOAT_ZERO;
        }
        if (typeName.equals("char")) {
            return CHAR_ZERO;
        }
        return ZERO;
    }

    @Override
    public String getJavaName() {
        return this.getName();
    }

    @Override
    public JavaDataType getPrimitive() {
        return this;
    }

    @Override
    public int getPrimitiveID() {
        if (this.primitive_type == 0) {
            String name = this.getName();
            if (name.equals("boolean")) {
                this.primitive_type = 1;
            }
            if (name.equals("char")) {
                this.primitive_type = 2;
            }
            if (name.equals("byte")) {
                this.primitive_type = 3;
            }
            if (name.equals("short")) {
                this.primitive_type = 8;
            }
            if (name.equals("int")) {
                this.primitive_type = 6;
            }
            if (name.equals("long")) {
                this.primitive_type = 7;
            }
            if (name.equals("float")) {
                this.primitive_type = 5;
            }
            if (name.equals("double")) {
                this.primitive_type = 4;
            }
        }
        return this.primitive_type;
    }

    @Override
    public String getSimpleName() {
        return this.getName();
    }

    @Override
    public String getQualifiedName() {
        return this.getJavaName();
    }

    @Override
    public JavaClass getWrapper() {
        String wrapperName = this.getWrapperQualifiedName();
        if (wrapperName != null) {
            return (JavaClass)JavaRefFactory.eINSTANCE.reflectType(wrapperName, (EObject)this);
        }
        return null;
    }

    protected String getWrapperQualifiedName() {
        switch (this.getPrimitiveID()) {
            case 6: {
                return "java.lang.Integer";
            }
            case 2: {
                return "java.lang.Character";
            }
            case 1: {
                return "java.lang.Boolean";
            }
            case 3: {
                return "java.lang.Byte";
            }
            case 8: {
                return "java.lang.Short";
            }
            case 7: {
                return "java.lang.Long";
            }
            case 5: {
                return "java.lang.Float";
            }
            case 4: {
                return "java.lang.Double";
            }
        }
        return null;
    }

    @Override
    public boolean isArray() {
        return false;
    }

    @Override
    public boolean isAssignableFrom(EClassifier aClass) {
        return this == aClass;
    }

    public boolean isInstance(Object o) {
        return o instanceof IInstantiationInstance ? this.isAssignableFrom((EClassifier)((IInstantiationInstance)o).getJavaType()) : false;
    }

    @Override
    public boolean isPrimitive() {
        return true;
    }

    @Override
    public String getQualifiedNameForReflection() {
        return this.getJavaName();
    }

    public EList<EObject> eContents() {
        if (this.eContents == null) {
            this.eContents = (EList)EContentsEList.createEContentsEList((EObject)this);
        }
        return this.eContents;
    }

    public EList<EObject> eCrossReferences() {
        if (this.eCrossReferences == null) {
            this.eCrossReferences = (EList)ECrossReferenceEList.createECrossReferenceEList((EObject)this);
        }
        return this.eCrossReferences;
    }
}

