/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.dtd.core.internal.encoding;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;

public class ByteReader
extends Reader {
    public static final int DEFAULT_BUFFER_SIZE = 8192;
    protected byte[] fBuffer;
    protected InputStream fInputStream;

    protected ByteReader() {
    }

    public ByteReader(InputStream inputStream) {
        this(inputStream, 8192);
        if (!inputStream.markSupported()) {
            throw new IllegalArgumentException("ByteReader is required to have a resettable stream");
        }
    }

    public ByteReader(InputStream inputStream, int size) {
        this.fInputStream = inputStream;
        if (!inputStream.markSupported()) {
            throw new IllegalArgumentException("ByteReader is required to have a resettable stream");
        }
        this.fBuffer = new byte[size];
    }

    public void close() throws IOException {
        this.fInputStream.close();
    }

    public void mark(int readAheadLimit) {
        this.fInputStream.mark(readAheadLimit);
    }

    public boolean markSupported() {
        return true;
    }

    public int read() throws IOException {
        int b0 = this.fInputStream.read();
        return b0 & 0xFF;
    }

    public int read(char[] ch, int offset, int length) throws IOException {
        if (length > this.fBuffer.length) {
            length = this.fBuffer.length;
        }
        int count = this.fInputStream.read(this.fBuffer, 0, length);
        int i = 0;
        while (i < count) {
            char c0;
            byte b0 = this.fBuffer[i];
            ch[offset + i] = c0 = (char)(b0 & 0xFF);
            ++i;
        }
        return count;
    }

    public boolean ready() throws IOException {
        return this.fInputStream.available() > 0;
    }

    public void reset() throws IOException {
        this.fInputStream.reset();
    }

    public long skip(long n) throws IOException {
        return this.fInputStream.skip(n);
    }
}

