/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.ws.internal.explorer.platform.wsdl.transport;

import javax.wsdl.extensions.ExtensibilityElement;
import javax.wsdl.extensions.soap.SOAPBinding;
import org.eclipse.wst.ws.internal.explorer.platform.wsdl.transport.HTTPTransport;
import org.eclipse.wst.ws.internal.explorer.platform.wsdl.transport.SOAPMessageProcessor;
import org.eclipse.wst.ws.internal.explorer.plugin.ExplorerPlugin;
import org.eclipse.wst.ws.internal.explorer.transport.IDeserializer;
import org.eclipse.wst.ws.internal.explorer.transport.ISOAPMessage;
import org.eclipse.wst.ws.internal.explorer.transport.ISOAPTransport;
import org.eclipse.wst.ws.internal.explorer.transport.ISerializer;
import org.eclipse.wst.ws.internal.explorer.transport.MessageContext;
import org.eclipse.wst.ws.internal.explorer.transport.SOAPMessage;
import org.eclipse.wst.ws.internal.explorer.transport.TransportException;
import org.eclipse.wst.ws.internal.parser.discovery.NetUtils;

public class SOAPTransport
implements ISOAPTransport {
    static final String PROP_READ_ONLY = "prop_read_only";
    static final String PROP_RAW_BYTES = "prop_raw_bytes";

    SOAPTransport() {
    }

    public ISerializer newSerializer() {
        return new SOAPMessageProcessor();
    }

    public IDeserializer newDeserializer() {
        return new SOAPMessageProcessor();
    }

    private void checkBinding(ExtensibilityElement binding) throws TransportException {
        String bindingURI = binding.getElementType().getNamespaceURI();
        if (!(binding instanceof SOAPBinding) || !"http://schemas.xmlsoap.org/wsdl/soap/".equals(bindingURI)) {
            throw new TransportException(ExplorerPlugin.getMessage("%MSG_ERROR_UNSUPPORTED_BINDING", new String[]{bindingURI}));
        }
    }

    public ISOAPMessage newMessage(MessageContext context) throws TransportException {
        this.checkBinding(context.getBindingProtocol());
        SOAPMessageProcessor processor = new SOAPMessageProcessor();
        SOAPMessage message = new SOAPMessage(context, processor);
        processor.initMessage(message);
        return message;
    }

    private void checkMessage(ISOAPMessage message) throws TransportException {
        ExtensibilityElement binding = message.getMessageContext().getBindingProtocol();
        this.checkBinding(binding);
        SOAPBinding soapBinding = (SOAPBinding)binding;
        if (!"http://schemas.xmlsoap.org/soap/http".equals(soapBinding.getTransportURI())) {
            throw new TransportException(ExplorerPlugin.getMessage("%MSG_ERROR_UNSUPPORTED_TRANSPORT", new String[]{soapBinding.getTransportURI()}));
        }
    }

    private HTTPTransport createInternalTransport(String username, String password) {
        HTTPTransport internalTransport = new HTTPTransport();
        if (username != null && password != null) {
            internalTransport.setHttpBasicAuthUsername(username);
            internalTransport.setHttpBasicAuthPassword(password);
        }
        return internalTransport;
    }

    public ISOAPMessage send(String url, String username, String password, ISOAPMessage message) throws TransportException {
        this.checkMessage(message);
        try {
            HTTPTransport internalTransport = this.createInternalTransport(username, password);
            internalTransport.send(NetUtils.createURL((String)url), (String)message.getProperty("prop_soap_action"), message.toXML());
            SOAPMessageProcessor processor = new SOAPMessageProcessor();
            SOAPMessage reply = new SOAPMessage(message.getMessageContext(), processor);
            reply.setProperty(PROP_READ_ONLY, Boolean.TRUE);
            byte[] rawBytes = internalTransport.receiveBytes();
            try {
                processor.deserialize(0, rawBytes, (ISOAPMessage)reply);
            }
            catch (Exception exception) {
                reply.setProperty(PROP_RAW_BYTES, rawBytes);
            }
            return reply;
        }
        catch (TransportException e) {
            throw e;
        }
        catch (Exception e) {
            throw new TransportException(e);
        }
    }
}

