/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.server.core.internal;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.IModuleType;
import org.eclipse.wst.server.core.internal.IOrdered;
import org.eclipse.wst.server.core.internal.ServerPlugin;
import org.eclipse.wst.server.core.internal.Trace;
import org.eclipse.wst.server.core.model.InternalInitializer;
import org.eclipse.wst.server.core.model.ModuleFactoryDelegate;

public class ModuleFactory
implements IOrdered {
    private IConfigurationElement element;
    public ModuleFactoryDelegate delegate;
    private List<IModuleType> moduleTypes;

    public ModuleFactory(IConfigurationElement element) {
        this.element = element;
    }

    public String getId() {
        return this.element.getAttribute("id");
    }

    public int getOrder() {
        try {
            return Integer.parseInt(this.element.getAttribute("order"));
        }
        catch (NumberFormatException numberFormatException) {
            return -1;
        }
    }

    public IModuleType[] getModuleTypes() {
        if (this.moduleTypes == null) {
            this.moduleTypes = ServerPlugin.getModuleTypes(this.element.getChildren("moduleType"));
        }
        IModuleType[] mt = new IModuleType[this.moduleTypes.size()];
        this.moduleTypes.toArray(mt);
        return mt;
    }

    public boolean isProjectModuleFactory() {
        return "true".equalsIgnoreCase(this.element.getAttribute("projects"));
    }

    public ModuleFactoryDelegate getDelegate(IProgressMonitor monitor) {
        if (this.delegate == null) {
            try {
                long time = System.currentTimeMillis();
                this.delegate = (ModuleFactoryDelegate)this.element.createExecutableExtension("class");
                InternalInitializer.initializeModuleFactoryDelegate(this.delegate, this, monitor);
                Trace.trace(10, "ModuleFactory.getDelegate(): <" + (System.currentTimeMillis() - time) + "> " + this.getId());
            }
            catch (Throwable t) {
                Trace.trace(3, "Could not create delegate " + this.toString(), t);
            }
        }
        return this.delegate;
    }

    public IModule[] getModules() {
        return this.getModules(null);
    }

    public IModule[] getModules(IProgressMonitor monitor) {
        try {
            IModule[] modules = this.getDelegate(monitor).getModules();
            if (this.hasInvalidModules(modules)) {
                modules = this.filter(modules);
            }
            return modules;
        }
        catch (Throwable t) {
            Trace.trace(3, "Error calling delegate " + this.toString(), t);
            return new IModule[0];
        }
    }

    public IModule[] getModules(IProject project, IProgressMonitor monitor) {
        try {
            IModule[] modules = this.getDelegate(monitor).getModules(project);
            if (this.hasInvalidModules(modules)) {
                modules = this.filter(modules);
            }
            return modules;
        }
        catch (Throwable t) {
            Trace.trace(3, "Error calling delegate " + this.toString(), t);
            return new IModule[0];
        }
    }

    public IModule findModule(String id, IProgressMonitor monitor) {
        IModule module;
        block5: {
            block4: {
                try {
                    module = this.getDelegate(monitor).findModule(id);
                    if (module != null) break block4;
                    return null;
                }
                catch (Throwable t) {
                    Trace.trace(3, "Error calling delegate " + this.toString(), t);
                    return null;
                }
            }
            this.getModuleTypes();
            if (this.moduleTypes.contains(module.getModuleType())) break block5;
            return null;
        }
        return module;
    }

    private boolean hasInvalidModules(IModule[] modules) {
        if (modules == null) {
            return false;
        }
        this.getModuleTypes();
        int size = modules.length;
        int i = 0;
        while (i < size) {
            if (!this.moduleTypes.contains(modules[i].getModuleType())) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private IModule[] filter(IModule[] modules) {
        if (modules == null) {
            return modules;
        }
        this.getModuleTypes();
        ArrayList<IModule> list = new ArrayList<IModule>();
        int size = modules.length;
        int i = 0;
        while (i < size) {
            IModule m = modules[i];
            if (this.moduleTypes.contains(m.getModuleType())) {
                list.add(m);
            } else {
                Trace.trace(2, "Invalid module returned from factory, ignored: " + m);
            }
            ++i;
        }
        IModule[] m = new IModule[list.size()];
        list.toArray(m);
        return m;
    }

    public String toString() {
        return "ModuleFactory[" + this.getId() + "]";
    }
}

