/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.core.internal.jsflibraryconfig;

import java.io.IOException;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.InvalidRegistryObjectException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.jdt.core.IClasspathContainer;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jst.jsf.core.internal.JSFCorePlugin;
import org.eclipse.jst.jsf.core.internal.JSFLibraryClasspathContainer;
import org.eclipse.jst.jsf.core.internal.Messages;
import org.eclipse.jst.jsf.core.internal.RegistryUpgradeCommitHandler;
import org.eclipse.jst.jsf.core.internal.jsflibraryconfig.JSFLibraryInternalReference;
import org.eclipse.jst.jsf.core.internal.jsflibraryregistry.ArchiveFile;
import org.eclipse.jst.jsf.core.internal.jsflibraryregistry.JSFLibrary;
import org.eclipse.jst.jsf.core.internal.jsflibraryregistry.JSFLibraryRegistry;
import org.eclipse.jst.jsf.core.internal.jsflibraryregistry.JSFLibraryRegistryFactory;
import org.eclipse.jst.jsf.core.internal.jsflibraryregistry.adapter.MaintainDefaultImplementationAdapter;
import org.eclipse.jst.jsf.core.internal.jsflibraryregistry.impl.JSFLibraryRegistryPackageImpl;
import org.eclipse.jst.jsf.core.internal.jsflibraryregistry.util.JSFLibraryRegistryResourceFactoryImpl;
import org.eclipse.jst.jsf.core.internal.jsflibraryregistry.util.JSFLibraryRegistryResourceImpl;
import org.eclipse.jst.jsf.core.internal.jsflibraryregistry.util.JSFLibraryRegistryUpgradeUtil;
import org.eclipse.jst.jsf.core.jsflibraryregistry.PluginProvidedJSFLibraryCreationHelper;
import org.eclipse.jst.jsf.core.jsflibraryregistry.internal.PluginProvidedJSFLibraryCreationHelper2;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JSFLibraryRegistryUtil {
    private static JSFLibraryRegistryUtil instance = null;
    private List implLibs = null;
    private List compLibs = null;
    private static final String JSF_LIBRARY_REGISTRY_NSURI = "http://www.eclipse.org/webtools/jsf/schema/jsflibraryregistry.xsd";
    private static final String LIB_EXT_PT = "pluginProvidedJsfLibraries";
    private static final String OLD_LIB_EXT_PT = "jsfLibraries";
    private static JSFLibraryRegistryResourceImpl jsfLibraryRegistryResource = null;
    private JSFLibraryRegistry jsfLibraryRegistry;

    private JSFLibraryRegistryUtil() {
    }

    public static synchronized JSFLibraryRegistryUtil getInstance() {
        if (instance == null) {
            instance = new JSFLibraryRegistryUtil();
            instance.loadJSFLibraryRegistry();
        }
        return instance;
    }

    public JSFLibraryRegistry getJSFLibraryRegistry() {
        return this.jsfLibraryRegistry;
    }

    public JSFLibraryInternalReference getDefaultJSFImplementationLibrary() {
        JSFLibrary dftImplLib = this.getJSFLibraryRegistry().getDefaultImplementation();
        return dftImplLib != null ? this.getJSFLibraryReferencebyID(dftImplLib.getID()) : null;
    }

    List getJSFImplementationLibraries() {
        if (this.implLibs == null) {
            this.implLibs = this.wrapJSFLibraries(this.getJSFLibraryRegistry().getImplJSFLibraries());
        } else if (this.implLibs.size() != this.getJSFLibraryRegistry().getImplJSFLibraries().size() || this.isAnyLibraryChanged(this.implLibs)) {
            this.implLibs.clear();
            this.implLibs = this.wrapJSFLibraries(this.getJSFLibraryRegistry().getImplJSFLibraries());
        }
        return this.implLibs;
    }

    List getJSFComponentLibraries() {
        if (this.compLibs == null) {
            this.compLibs = this.wrapJSFLibraries(this.getJSFLibraryRegistry().getNonImplJSFLibraries());
        } else if (this.compLibs.size() != this.getJSFLibraryRegistry().getNonImplJSFLibraries().size() || this.isAnyLibraryChanged(this.compLibs)) {
            this.compLibs.clear();
            this.compLibs = this.wrapJSFLibraries(this.getJSFLibraryRegistry().getNonImplJSFLibraries());
        }
        return this.compLibs;
    }

    public JSFLibraryInternalReference getJSFLibraryReferencebyID(String id) {
        Iterator it = this.getJSFImplementationLibraries().iterator();
        JSFLibraryInternalReference crtItem2 = null;
        while (it.hasNext()) {
            crtItem2 = (JSFLibraryInternalReference)it.next();
            if (!id.equals(crtItem2.getID())) continue;
            return crtItem2;
        }
        for (JSFLibraryInternalReference crtItem2 : this.getJSFComponentLibraries()) {
            if (!id.equals(crtItem2.getID())) continue;
            return crtItem2;
        }
        return null;
    }

    public void addJSFLibrary(JSFLibraryInternalReference library) {
        if (library != null && this.getJSFLibraryRegistry().getJSFLibraryByID(library.getID()) == null) {
            JSFLibrary jsfLib = library.getLibrary();
            this.getJSFLibraryRegistry().addJSFLibrary(jsfLib.getWorkingCopy());
            List list = library.isImplementation() ? this.getJSFImplementationLibraries() : this.getJSFComponentLibraries();
            list.add(library);
        }
    }

    private List wrapJSFLibraries(EList libs) {
        ArrayList<JSFLibraryInternalReference> list = new ArrayList<JSFLibraryInternalReference>();
        if (libs != null) {
            for (JSFLibrary jsfLib : libs) {
                JSFLibraryInternalReference jsfLibDctr = new JSFLibraryInternalReference(jsfLib, false, false);
                list.add(jsfLibDctr);
            }
        }
        return list;
    }

    private boolean isAnyLibraryChanged(List list) {
        Iterator it = list.iterator();
        JSFLibraryInternalReference wclib = null;
        JSFLibrary lib = null;
        while (it.hasNext()) {
            wclib = (JSFLibraryInternalReference)it.next();
            lib = this.getJSFLibraryRegistry().getJSFLibraryByID(wclib.getID());
            if (lib == null) {
                return true;
            }
            if (wclib.getArchiveFiles().size() != lib.getArchiveFiles().size()) {
                return true;
            }
            if (!this.isAnyArchiveFileChanged(wclib.getArchiveFiles(), lib.getArchiveFiles())) continue;
            return true;
        }
        return false;
    }

    private boolean isAnyArchiveFileChanged(EList source, EList target) {
        ArchiveFile arSrc2 = null;
        for (ArchiveFile arSrc2 : source) {
            if (this.findMatchedArchive(arSrc2, target)) continue;
            return true;
        }
        return false;
    }

    private boolean findMatchedArchive(ArchiveFile source, EList list) {
        ArchiveFile target2 = null;
        for (ArchiveFile target2 : list) {
            if (!target2.equals(source)) continue;
            return true;
        }
        return false;
    }

    public IClasspathEntry[] getClasspathEntries(JSFLibrary lib) {
        ArrayList<IClasspathEntry> res = new ArrayList<IClasspathEntry>(lib.getArchiveFiles().size());
        for (ArchiveFile jar : lib.getArchiveFiles()) {
            IClasspathEntry entry;
            if (jar == null || !jar.exists() || (entry = this.getClasspathEntry(jar)) == null) continue;
            res.add(entry);
        }
        IClasspathEntry[] entries = res.toArray(new IClasspathEntry[res.size()]);
        return entries;
    }

    public IClasspathEntry getClasspathEntry(ArchiveFile jar) {
        IClasspathEntry entry = null;
        if (jar != null && jar.exists()) {
            entry = JavaCore.newLibraryEntry((IPath)new Path(jar.getResolvedSourceLocation()), null, null);
        }
        return entry;
    }

    public static void rebindClasspathContainerEntries(String oldId, String newId, IProgressMonitor monitor) throws JavaModelException {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IJavaProject[] projects = JavaCore.create((IWorkspaceRoot)root).getJavaProjects();
        IPath containerPath = new Path("org.eclipse.jst.jsf.core.internal.jsflibrarycontainer").append(newId);
        IPath oldContainerPath = new Path("org.eclipse.jst.jsf.core.internal.jsflibrarycontainer").append(oldId);
        JSFLibrary lib = JSFLibraryRegistryUtil.getInstance().getJSFLibraryRegistry().getJSFLibraryByID(newId);
        ArrayList<IJavaProject> affectedProjects = new ArrayList<IJavaProject>();
        boolean removeAndAddBecauseOfRename = !oldId.equals(newId);
        int i = 0;
        while (i < projects.length) {
            IJavaProject project = projects[i];
            IClasspathEntry[] entries = project.getRawClasspath();
            int k = 0;
            while (k < entries.length) {
                IClasspathEntry curr = entries[k];
                if (curr.getEntryKind() == 5 && oldContainerPath.equals((Object)curr.getPath())) {
                    affectedProjects.add(project);
                    break;
                }
                ++k;
            }
            ++i;
        }
        if (!affectedProjects.isEmpty()) {
            IJavaProject[] affected = affectedProjects.toArray(new IJavaProject[affectedProjects.size()]);
            IClasspathContainer[] containers = new IClasspathContainer[affected.length];
            boolean bl = removeAndAddBecauseOfRename = !oldId.equals(newId);
            if (removeAndAddBecauseOfRename) {
                IClasspathEntry newEntry = JavaCore.newContainerEntry((IPath)containerPath);
                int i2 = 0;
                while (i2 < affected.length) {
                    IJavaProject project = affected[i2];
                    IClasspathEntry[] entries = project.getRawClasspath();
                    ArrayList<IClasspathEntry> keptEntries = new ArrayList<IClasspathEntry>();
                    int k = 0;
                    while (k < entries.length) {
                        IClasspathEntry curr = entries[k];
                        if (curr.getEntryKind() == 5) {
                            if (!oldContainerPath.equals((Object)curr.getPath())) {
                                keptEntries.add(curr);
                            }
                        } else {
                            keptEntries.add(curr);
                        }
                        ++k;
                    }
                    keptEntries.add(newEntry);
                    JSFLibraryRegistryUtil.setRawClasspath(project, keptEntries, monitor);
                    ++i2;
                }
            } else {
                JSFLibraryClasspathContainer container = new JSFLibraryClasspathContainer(lib);
                containers[0] = container;
                JavaCore.setClasspathContainer((IPath)containerPath, (IJavaProject[])affected, (IClasspathContainer[])containers, (IProgressMonitor)monitor);
            }
        } else if (monitor != null) {
            monitor.done();
        }
    }

    public static void setRawClasspath(IJavaProject project, List cpEntries, IProgressMonitor monitor) {
        IClasspathEntry[] entries = cpEntries.toArray(new IClasspathEntry[0]);
        try {
            project.setRawClasspath(entries, monitor);
        }
        catch (JavaModelException e) {
            JSFCorePlugin.log((Exception)((Object)e), "Unable to set classpath for: " + project.getProject().getName());
        }
    }

    public static boolean doesProjectHaveV1JSFLibraries(IProject iproject) {
        if (iproject == null || !iproject.isAccessible()) {
            return false;
        }
        try {
            String compLib = iproject.getPersistentProperty(new QualifiedName("org.eclipse.jst.jsf.core.internal.jsflibraryconfig.JSFLibraryConfigProjectData", "jsf.component.libraries"));
            String implLib = iproject.getPersistentProperty(new QualifiedName("org.eclipse.jst.jsf.core.internal.jsflibraryconfig.JSFLibraryConfigProjectData", "jsf.implementation.libraries"));
            if (compLib != null || implLib != null) {
                return true;
            }
        }
        catch (CoreException ce) {
            JSFCorePlugin.log((Exception)((Object)ce), "Error checking age of project");
        }
        return false;
    }

    public static void removeV1JSFLibraryProperty(List<IProject> projects) {
        for (IProject project : projects) {
            try {
                if (!project.isAccessible()) continue;
                project.setPersistentProperty(new QualifiedName("org.eclipse.jst.jsf.core.internal.jsflibraryconfig.JSFLibraryConfigProjectData", "jsf.component.libraries"), null);
                project.setPersistentProperty(new QualifiedName("org.eclipse.jst.jsf.core.internal.jsflibraryconfig.JSFLibraryConfigProjectData", "jsf.implementation.libraries"), null);
            }
            catch (CoreException e) {
                JSFCorePlugin.log((Exception)((Object)e), "Error removing JSF library persistent property");
            }
        }
    }

    private void loadJSFLibraryRegistry() {
        try {
            EPackage.Registry.INSTANCE.put((Object)JSF_LIBRARY_REGISTRY_NSURI, (Object)JSFLibraryRegistryPackageImpl.init());
            URI jsfLibRegURI = JSFLibraryRegistryUpgradeUtil.getRegistryURI(".metadata/.plugins/org.eclipse.jst.jsf.core/JSFLibraryRegistryV2.xml");
            JSFLibraryRegistryUpgradeUtil.getInstance().upgradeRegistryIfNecessary(2);
            JSFLibraryRegistryResourceFactoryImpl resourceFactory = new JSFLibraryRegistryResourceFactoryImpl();
            jsfLibraryRegistryResource = (JSFLibraryRegistryResourceImpl)resourceFactory.createResource(jsfLibRegURI);
            try {
                HashMap<String, Boolean> options = new HashMap<String, Boolean>();
                options.put("DISABLE_NOTIFY", Boolean.TRUE);
                jsfLibraryRegistryResource.load(options);
                this.jsfLibraryRegistry = (JSFLibraryRegistry)jsfLibraryRegistryResource.getContents().get(0);
                this.loadJSFLibraryExtensions();
                this.loadDeprecatedJSFLibraryExtensions();
            }
            catch (IOException iOException) {
                this.jsfLibraryRegistry = JSFLibraryRegistryFactory.eINSTANCE.createJSFLibraryRegistry();
                jsfLibraryRegistryResource = (JSFLibraryRegistryResourceImpl)resourceFactory.createResource(jsfLibRegURI);
                jsfLibraryRegistryResource.getContents().add((Object)this.jsfLibraryRegistry);
                this.loadJSFLibraryExtensions();
                this.loadDeprecatedJSFLibraryExtensions();
                this.saveJSFLibraryRegistry();
            }
            if (this.jsfLibraryRegistry != null) {
                JSFLibrary defLib = this.jsfLibraryRegistry.getDefaultImplementation();
                if (defLib == null && this.jsfLibraryRegistry.getImplJSFLibraries().size() > 0) {
                    this.jsfLibraryRegistry.setDefaultImplementation((JSFLibrary)this.jsfLibraryRegistry.getImplJSFLibraries().get(0));
                    this.saveJSFLibraryRegistry();
                }
                this.jsfLibraryRegistry.eAdapters().add((Object)MaintainDefaultImplementationAdapter.getInstance());
                RegistryUpgradeCommitHandler.commitMigrationIfNecessary();
            }
        }
        catch (MalformedURLException mue) {
            JSFCorePlugin.log(4, Messages.JSFLibraryRegistry_ErrorCreatingURL, mue);
        }
    }

    private void loadJSFLibraryExtensions() {
        try {
            IExtensionPoint point = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.jst.jsf.core", LIB_EXT_PT);
            IExtension[] extensions = point.getExtensions();
            int i = 0;
            while (i < extensions.length) {
                IExtension ext = extensions[i];
                int j = 0;
                while (j < ext.getConfigurationElements().length) {
                    PluginProvidedJSFLibraryCreationHelper2 newLibCreator = new PluginProvidedJSFLibraryCreationHelper2(ext.getConfigurationElements()[j]);
                    JSFLibrary newLib = newLibCreator.create();
                    if (newLib != null) {
                        this.jsfLibraryRegistry.addJSFLibrary(newLib);
                    }
                    ++j;
                }
                ++i;
            }
        }
        catch (InvalidRegistryObjectException e) {
            JSFCorePlugin.log(4, Messages.JSFLibraryRegistry_ErrorLoadingFromExtPt, e);
        }
    }

    private void loadDeprecatedJSFLibraryExtensions() {
        try {
            IExtensionPoint point = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.jst.jsf.core", OLD_LIB_EXT_PT);
            IExtension[] extensions = point.getExtensions();
            int i = 0;
            while (i < extensions.length) {
                IExtension ext = extensions[i];
                int j = 0;
                while (j < ext.getConfigurationElements().length) {
                    PluginProvidedJSFLibraryCreationHelper newLibCreator = new PluginProvidedJSFLibraryCreationHelper(ext.getConfigurationElements()[j]);
                    JSFLibrary newLib = newLibCreator.create();
                    if (newLib != null) {
                        this.jsfLibraryRegistry.addJSFLibrary(newLib);
                    }
                    ++j;
                }
                ++i;
            }
        }
        catch (InvalidRegistryObjectException e) {
            JSFCorePlugin.log(4, Messages.JSFLibraryRegistry_ErrorLoadingFromExtPt, e);
        }
    }

    public boolean saveJSFLibraryRegistry() {
        boolean saved = false;
        if (jsfLibraryRegistryResource != null) {
            try {
                jsfLibraryRegistryResource.save(Collections.EMPTY_MAP);
                saved = true;
            }
            catch (IOException ioe) {
                JSFCorePlugin.log(4, Messages.JSFLibraryRegistry_ErrorSaving, ioe);
            }
        } else {
            JSFCorePlugin.log(4, Messages.JSFLibraryRegistry_ErrorSaving);
        }
        return saved;
    }
}

