/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.compare;

import org.eclipse.compare.ITypedElement;
import org.eclipse.compare.structuremergeviewer.DocumentRangeNode;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.IDocument;
import org.eclipse.swt.graphics.Image;
import org.eclipse.wst.jsdt.internal.ui.JavaScriptPlugin;
import org.eclipse.wst.jsdt.internal.ui.compare.CompareMessages;
import org.eclipse.wst.jsdt.internal.ui.compare.JavaCompareUtilities;

public class JavaNode
extends DocumentRangeNode
implements ITypedElement {
    public static final int CU = 0;
    public static final int PACKAGE = 1;
    public static final int IMPORT_CONTAINER = 2;
    public static final int IMPORT = 3;
    public static final int INTERFACE = 4;
    public static final int CLASS = 5;
    public static final int ENUM = 6;
    public static final int ANNOTATION = 7;
    public static final int FIELD = 8;
    public static final int INIT = 9;
    public static final int CONSTRUCTOR = 10;
    public static final int METHOD = 11;
    private int fInitializerCount = 1;

    public JavaNode(JavaNode parent, int type, String name, int start, int length) {
        super((DocumentRangeNode)parent, type, JavaCompareUtilities.buildID(type, name), parent.getDocument(), start, length);
        parent.addChild(this);
    }

    public JavaNode(IDocument document) {
        super(0, JavaCompareUtilities.buildID(0, "root"), document, 0, document.getLength());
    }

    public String getInitializerCount() {
        return Integer.toString(this.fInitializerCount++);
    }

    public String extractMethodName() {
        String id = this.getId();
        int pos = id.indexOf(40);
        if (pos > 0) {
            return id.substring(1, pos);
        }
        return id.substring(1);
    }

    public String extractArgumentList() {
        String id = this.getId();
        int pos = id.indexOf(40);
        if (pos >= 0) {
            return id.substring(pos + 1);
        }
        return id.substring(1);
    }

    public String getName() {
        switch (this.getTypeCode()) {
            case 9: {
                return CompareMessages.JavaNode_initializer;
            }
            case 2: {
                return CompareMessages.JavaNode_importDeclarations;
            }
            case 0: {
                return CompareMessages.JavaNode_compilationUnit;
            }
            case 1: {
                return CompareMessages.JavaNode_packageDeclaration;
            }
        }
        return this.getId().substring(1);
    }

    public String getType() {
        return "java2";
    }

    public Image getImage() {
        ImageDescriptor id = null;
        switch (this.getTypeCode()) {
            case 0: {
                id = JavaCompareUtilities.getImageDescriptor(5);
                break;
            }
            case 1: {
                id = JavaCompareUtilities.getImageDescriptor(11);
                break;
            }
            case 3: {
                id = JavaCompareUtilities.getImageDescriptor(13);
                break;
            }
            case 2: {
                id = JavaCompareUtilities.getImageDescriptor(12);
                break;
            }
            case 5: {
                id = JavaCompareUtilities.getTypeImageDescriptor(true);
                break;
            }
            case 4: {
                id = JavaCompareUtilities.getTypeImageDescriptor(false);
                break;
            }
            case 9: {
                id = JavaCompareUtilities.getImageDescriptor(10);
                break;
            }
            case 10: 
            case 11: {
                id = JavaCompareUtilities.getImageDescriptor(9);
                break;
            }
            case 8: {
                id = JavaCompareUtilities.getImageDescriptor(8);
                break;
            }
            case 6: {
                id = JavaCompareUtilities.getEnumImageDescriptor();
                break;
            }
            case 7: {
                id = JavaCompareUtilities.getAnnotationImageDescriptor();
            }
        }
        return JavaScriptPlugin.getImageDescriptorRegistry().get(id);
    }

    public String toString() {
        return String.valueOf(this.getType()) + ": " + this.getName() + "[" + this.getRange().offset + "+" + this.getRange().length + "]";
    }
}

