/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsp.core.internal.taglib;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jst.jsp.core.internal.Logger;
import org.eclipse.jst.jsp.core.internal.taglib.TaglibHelper;

class TaglibHelperCache {
    private static final boolean DEBUG;
    private List fHelpers;
    private int MAX_SIZE;

    static {
        String value = Platform.getDebugOption((String)"org.eclipse.jst.jsp.core/debug/taglibvars");
        DEBUG = value != null && value.equalsIgnoreCase("true");
    }

    public TaglibHelperCache(int size) {
        this.MAX_SIZE = size;
        this.fHelpers = Collections.synchronizedList(new ArrayList(this.MAX_SIZE));
    }

    public final synchronized TaglibHelper getHelper(IProject project) {
        TaglibHelper helper = null;
        Entry entry = null;
        String projectName = project.getName();
        int size = this.fHelpers.size();
        int i = 0;
        while (i < size) {
            entry = (Entry)this.fHelpers.get(i);
            if (entry.getProjectName().equals(projectName)) {
                helper = entry.getHelper();
                if (i <= 0) break;
                this.fHelpers.remove(entry);
                this.fHelpers.add(1, entry);
                if (!DEBUG) break;
                Logger.log(1, "(->) TaglibHelperCache moved: " + entry + " to the front of the list");
                this.printCacheContents();
                break;
            }
            ++i;
        }
        if (helper == null) {
            helper = this.createNewHelper(projectName, project);
        }
        return helper;
    }

    private TaglibHelper createNewHelper(String projectName, IProject project) {
        TaglibHelper helper = new TaglibHelper(project);
        Entry newEntry = new Entry(projectName, helper);
        this.fHelpers.add(0, newEntry);
        if (DEBUG) {
            Logger.log(1, "(+) TaglibHelperCache added: " + newEntry);
            this.printCacheContents();
        }
        if (this.fHelpers.size() > this.MAX_SIZE) {
            Object removed = this.fHelpers.remove(this.fHelpers.size() - 1);
            if (DEBUG) {
                Logger.log(1, "(-) TaglibHelperCache removed: " + removed);
                this.printCacheContents();
            }
        }
        return helper;
    }

    public final synchronized void removeHelper(String projectName) {
        Entry entry = null;
        Iterator it = this.fHelpers.iterator();
        while (it.hasNext()) {
            entry = (Entry)it.next();
            if (!entry.getProjectName().equals(projectName)) continue;
            this.fHelpers.remove(entry);
            if (!DEBUG) break;
            Logger.log(1, "(-) TaglibHelperCache removed: " + entry);
            this.printCacheContents();
            break;
        }
    }

    private void printCacheContents() {
        StringBuffer debugString = new StringBuffer();
        debugString.append("\n-----------------------------------------------------------");
        debugString.append("\ncache contents:");
        int i = 0;
        while (i < this.fHelpers.size()) {
            debugString.append("\n -" + i + "- " + this.fHelpers.get(i));
            ++i;
        }
        debugString.append("\n-----------------------------------------------------------");
        Logger.log(1, debugString.toString());
    }

    class Entry {
        private TaglibHelper fHelper;
        private String fProjectName;

        public Entry(String projectName, TaglibHelper helper) {
            this.setProjectName(projectName);
            this.setHelper(helper);
        }

        public TaglibHelper getHelper() {
            return this.fHelper;
        }

        public void setHelper(TaglibHelper helper) {
            this.fHelper = helper;
        }

        public String getProjectName() {
            return this.fProjectName;
        }

        public void setProjectName(String projectName) {
            this.fProjectName = projectName;
        }

        public String toString() {
            return "Taglib Helper Entry [" + this.getProjectName() + "]";
        }
    }
}

