/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.componentcore.internal.resources;

import java.util.ArrayList;
import java.util.HashSet;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.EList;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.internal.ComponentResource;
import org.eclipse.wst.common.componentcore.internal.StructureEdit;
import org.eclipse.wst.common.componentcore.internal.WorkbenchComponent;
import org.eclipse.wst.common.componentcore.internal.impl.ResourceTreeRoot;
import org.eclipse.wst.common.componentcore.internal.resources.VirtualFile;
import org.eclipse.wst.common.componentcore.internal.resources.VirtualResource;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualContainer;
import org.eclipse.wst.common.componentcore.resources.IVirtualFile;
import org.eclipse.wst.common.componentcore.resources.IVirtualFolder;
import org.eclipse.wst.common.componentcore.resources.IVirtualResource;

public abstract class VirtualContainer
extends VirtualResource
implements IVirtualContainer {
    public VirtualContainer(IProject aComponentProject, IPath aRuntimePath) {
        super(aComponentProject, aRuntimePath);
    }

    public boolean exists(IPath path) {
        throw new UnsupportedOperationException("Method not supported");
    }

    public IVirtualResource findMember(String aChildName) {
        return this.findMember((IPath)new Path(aChildName), 0);
    }

    public IVirtualResource findMember(String aChildName, int searchFlags) {
        return this.findMember((IPath)new Path(aChildName), searchFlags);
    }

    public IVirtualResource findMember(IPath aChildPath) {
        return this.findMember(aChildPath, 0);
    }

    public IVirtualResource findMember(IPath aPath, int theSearchFlags) {
        StructureEdit structureEdit = null;
        try {
            WorkbenchComponent component;
            structureEdit = StructureEdit.getStructureEditForRead(this.getProject());
            if (structureEdit != null && (component = structureEdit.getComponent()) != null) {
                ResourceTreeRoot root = ResourceTreeRoot.getDeployResourceTreeRoot(component);
                ComponentResource[] resources = root.findModuleResources(this.getRuntimePath().append(aPath), 0);
                int i = 0;
                while (i < resources.length) {
                    if (resources[i].getRuntimePath().equals((Object)this.getRuntimePath().append(aPath))) {
                        IResource platformResource = this.getProject().findMember(resources[i].getSourcePath());
                        if (platformResource == null) {
                            platformResource = ResourcesPlugin.getWorkspace().getRoot().findMember(resources[i].getSourcePath());
                        }
                        if (platformResource != null) {
                            switch (platformResource.getType()) {
                                case 2: 
                                case 4: {
                                    IVirtualFolder iVirtualFolder = ComponentCore.createFolder(this.getProject(), this.getRuntimePath().append(aPath));
                                    return iVirtualFolder;
                                }
                                case 1: {
                                    VirtualFile virtualFile = new VirtualFile(this.getProject(), this.getRuntimePath().append(aPath));
                                    return virtualFile;
                                }
                            }
                        }
                    }
                    ++i;
                }
            }
        }
        finally {
            if (structureEdit != null) {
                structureEdit.dispose();
            }
        }
        return null;
    }

    public IVirtualFile getFile(IPath aPath) {
        return new VirtualFile(this.getProject(), this.getRuntimePath().append(aPath));
    }

    public IVirtualFolder getFolder(IPath aPath) {
        return ComponentCore.createFolder(this.getProject(), this.getRuntimePath().append(aPath));
    }

    public IVirtualFile getFile(String name) {
        return new VirtualFile(this.getProject(), this.getRuntimePath().append(name));
    }

    public IVirtualFolder getFolder(String name) {
        return ComponentCore.createFolder(this.getProject(), this.getRuntimePath().append(name));
    }

    public IVirtualResource[] members() throws CoreException {
        return this.members(0);
    }

    public IVirtualResource[] members(boolean includePhantoms) throws CoreException {
        return this.members(includePhantoms ? 512 : 0);
    }

    public IVirtualResource[] members(int memberFlags) throws CoreException {
        ArrayList<IVirtualResource> virtualResources;
        block27: {
            virtualResources = new ArrayList<IVirtualResource>();
            HashSet<String> allNames = new HashSet<String>();
            IVirtualComponent component = this.getComponent();
            if (component == null) {
                return new IVirtualResource[0];
            }
            IPath[] metaPaths = component.getMetaResources();
            int i = 0;
            while (i < metaPaths.length) {
                String localName = this.getLocalName(metaPaths[i]);
                if (localName != null) {
                    allNames.add(localName);
                }
                ++i;
            }
            StructureEdit moduleCore = null;
            try {
                try {
                    moduleCore = StructureEdit.getStructureEditForRead(this.getProject());
                    WorkbenchComponent wbComponent = moduleCore.getComponent();
                    if (wbComponent != null) {
                        ResourceTreeRoot root = ResourceTreeRoot.getDeployResourceTreeRoot(wbComponent);
                        ComponentResource[] componentResources = root.findModuleResources(this.getRuntimePath(), 0);
                        int componentResourceIndex = 0;
                        while (componentResourceIndex < componentResources.length) {
                            IPath fullRuntimePath = componentResources[componentResourceIndex].getRuntimePath();
                            if (fullRuntimePath.equals((Object)this.getRuntimePath())) {
                                IResource realResource = this.getProject().findMember(componentResources[componentResourceIndex].getSourcePath());
                                if (realResource != null && (realResource.getType() == 2 || realResource.getType() == 4)) {
                                    IContainer realContainer = (IContainer)realResource;
                                    IResource[] realChildResources = realContainer.members(memberFlags);
                                    int realResourceIndex = 0;
                                    while (realResourceIndex < realChildResources.length) {
                                        IResource child = realChildResources[realResourceIndex];
                                        String localName = child.getName();
                                        if (allNames.add(localName)) {
                                            IPath newRuntimePath = this.getRuntimePath().append(localName);
                                            if (child instanceof IFile) {
                                                virtualResources.add(new VirtualFile(this.getProject(), newRuntimePath, (IFile)child));
                                            } else {
                                                virtualResources.add(ComponentCore.createFolder(this.getProject(), newRuntimePath));
                                            }
                                        }
                                        ++realResourceIndex;
                                    }
                                }
                            } else {
                                IResource realResource;
                                String localName = this.getLocalName(fullRuntimePath);
                                if (localName != null && allNames.add(localName) && (realResource = StructureEdit.getEclipseResource(componentResources[componentResourceIndex])) != null) {
                                    IPath newRuntimePath = this.getRuntimePath().append(localName);
                                    if (fullRuntimePath.segmentCount() > this.getRuntimePath().segmentCount() + 1) {
                                        virtualResources.add(ComponentCore.createFolder(this.getProject(), newRuntimePath));
                                    } else if (realResource instanceof IFile) {
                                        virtualResources.add(new VirtualFile(this.getProject(), newRuntimePath, (IFile)realResource));
                                    } else {
                                        virtualResources.add(ComponentCore.createFolder(this.getProject(), newRuntimePath));
                                    }
                                }
                            }
                            ++componentResourceIndex;
                        }
                    }
                }
                catch (Exception exception) {
                    if (virtualResources == null) {
                        IVirtualResource[] iVirtualResourceArray = new IVirtualResource[]{};
                        if (moduleCore != null) {
                            moduleCore.dispose();
                        }
                        return iVirtualResourceArray;
                    }
                    if (moduleCore != null) {
                        moduleCore.dispose();
                    }
                    break block27;
                }
            }
            catch (Throwable throwable) {
                if (moduleCore != null) {
                    moduleCore.dispose();
                }
                throw throwable;
            }
            if (moduleCore != null) {
                moduleCore.dispose();
            }
        }
        return virtualResources.toArray(new IVirtualResource[virtualResources.size()]);
    }

    private String getLocalName(IPath path) {
        if (!this.getRuntimePath().isPrefixOf(path)) {
            return null;
        }
        return path.segment(this.getRuntimePath().segmentCount());
    }

    public IVirtualFile[] findDeletedMembersWithHistory(int depth, IProgressMonitor monitor) throws CoreException {
        throw new UnsupportedOperationException("Method not supported");
    }

    public void createLink(IPath aProjectRelativeLocation, int updateFlags, IProgressMonitor monitor) throws CoreException {
        StructureEdit moduleCore = null;
        try {
            Object resource = null;
            resource = aProjectRelativeLocation.isRoot() || aProjectRelativeLocation.isEmpty() ? this.getProject() : this.getProject().getFolder(aProjectRelativeLocation);
            moduleCore = StructureEdit.getStructureEditForWrite(this.getProject());
            WorkbenchComponent component = moduleCore.getComponent();
            if (component != null) {
                ResourceTreeRoot root = ResourceTreeRoot.getDeployResourceTreeRoot(component);
                ComponentResource[] resources = root.findModuleResources(this.getRuntimePath(), 0);
                if (resources.length == 0) {
                    ComponentResource componentResource = moduleCore.createWorkbenchModuleResource((IResource)resource);
                    componentResource.setRuntimePath(this.getRuntimePath());
                    component.getResources().add((Object)componentResource);
                } else {
                    boolean foundMapping = false;
                    int resourceIndx = 0;
                    while (resourceIndx < resources.length && !foundMapping) {
                        if (aProjectRelativeLocation.makeAbsolute().equals((Object)resources[resourceIndx].getSourcePath())) {
                            foundMapping = true;
                        }
                        ++resourceIndx;
                    }
                    if (!foundMapping) {
                        ComponentResource componentResource = moduleCore.createWorkbenchModuleResource((IResource)resource);
                        componentResource.setRuntimePath(this.getRuntimePath());
                        component.getResources().add((Object)componentResource);
                    }
                }
                this.createResource((IContainer)resource, updateFlags, monitor);
            }
        }
        finally {
            if (moduleCore != null) {
                moduleCore.saveIfNecessary(monitor);
                moduleCore.dispose();
            }
        }
    }

    public int getType() {
        return 64;
    }

    public IResource getUnderlyingResource() {
        return null;
    }

    public IResource[] getUnderlyingResources() {
        return NO_RESOURCES;
    }

    protected void doDeleteMetaModel(int updateFlags, IProgressMonitor monitor) {
        StructureEdit moduleCore = null;
        try {
            moduleCore = StructureEdit.getStructureEditForWrite(this.getProject());
            WorkbenchComponent component = moduleCore.getComponent();
            if (component != null) {
                moduleCore.getComponentModelRoot().getComponents().remove((Object)component);
            }
        }
        finally {
            if (moduleCore != null) {
                moduleCore.saveIfNecessary(monitor);
                moduleCore.dispose();
            }
        }
    }

    protected void doDeleteRealResources(int updateFlags, IProgressMonitor monitor) throws CoreException {
        throw new UnsupportedOperationException("Method not supported");
    }

    public IVirtualResource[] getResources(String aResourceType) {
        StructureEdit core = null;
        try {
            core = StructureEdit.getStructureEditForRead(this.getProject());
            WorkbenchComponent component = core.getComponent();
            if (component != null) {
                EList currentResources = component.getResources();
                ArrayList<IVirtualResource> foundResources = new ArrayList<IVirtualResource>();
                if (aResourceType != null) {
                    for (ComponentResource resource : currentResources) {
                        IVirtualResource vres;
                        if (!aResourceType.equals(resource.getResourceType()) || (vres = this.createVirtualResource(resource)) == null) continue;
                        foundResources.add(vres);
                    }
                }
                IVirtualResource[] iVirtualResourceArray = foundResources.toArray(new IVirtualResource[foundResources.size()]);
                return iVirtualResourceArray;
            }
            IVirtualResource[] iVirtualResourceArray = new IVirtualResource[]{};
            return iVirtualResourceArray;
        }
        finally {
            if (core != null) {
                core.dispose();
            }
        }
    }

    private IVirtualResource createVirtualResource(ComponentResource aComponentResource) {
        IResource resource = StructureEdit.getEclipseResource(aComponentResource);
        switch (resource.getType()) {
            case 1: {
                return ComponentCore.createFile(this.getProject(), aComponentResource.getRuntimePath());
            }
            case 2: {
                return ComponentCore.createFolder(this.getProject(), aComponentResource.getRuntimePath());
            }
        }
        return null;
    }
}

