/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.ws.internal.explorer.platform.wsil.actions;

import java.util.Hashtable;
import org.eclipse.wst.ws.internal.explorer.platform.datamodel.ListElement;
import org.eclipse.wst.ws.internal.explorer.platform.datamodel.TreeElement;
import org.eclipse.wst.ws.internal.explorer.platform.engine.transformer.ITransformer;
import org.eclipse.wst.ws.internal.explorer.platform.perspective.Controller;
import org.eclipse.wst.ws.internal.explorer.platform.perspective.Node;
import org.eclipse.wst.ws.internal.explorer.platform.uddi.actions.RegFindBusinessUUIDAction;
import org.eclipse.wst.ws.internal.explorer.platform.wsil.actions.AddToUDDIPerspectiveAction;
import org.eclipse.wst.ws.internal.explorer.platform.wsil.datamodel.WsilElement;
import org.eclipse.wst.ws.internal.explorer.platform.wsil.datamodel.WsilUddiBusinessElement;
import org.eclipse.wst.ws.internal.explorer.platform.wsil.perspective.WSILPerspective;
import org.eclipse.wst.ws.internal.explorer.platform.wsil.transformer.WSILViewSelectionTransformer;

public class AddBusinessToUDDIPerspectiveAction
extends AddToUDDIPerspectiveAction {
    public AddBusinessToUDDIPerspectiveAction(Controller controller) {
        super(controller);
    }

    public ITransformer[] getTransformers() {
        ITransformer[] parentTransformers = super.getTransformers();
        ITransformer[] transformers = new ITransformer[parentTransformers.length + 1];
        System.arraycopy(parentTransformers, 0, transformers, 0, parentTransformers.length);
        transformers[transformers.length - 1] = new WSILViewSelectionTransformer(this.controller_, "uddiLinks", "viewId", 3);
        return transformers;
    }

    public boolean executeSingleLinkAction() {
        int nodeID = Integer.parseInt((String)this.propertyTable_.get("nodeId"));
        int viewID = Integer.parseInt((String)this.propertyTable_.get("viewId"));
        WSILPerspective wsilPerspective = this.controller_.getWSILPerspective();
        Node selectedNode = wsilPerspective.getNodeManager().getNode(nodeID);
        TreeElement selectedElement = selectedNode.getTreeElement();
        String inquiryURL = null;
        String businessKey = null;
        String businessName = null;
        if (selectedElement instanceof WsilElement) {
            ListElement le = ((WsilElement)selectedElement).getAllUDDILinks().getElementWithViewId(viewID);
            WsilUddiBusinessElement wsilUddiBusinessElement = (WsilUddiBusinessElement)((Object)le.getObject());
            inquiryURL = wsilUddiBusinessElement.getUDDILinkInquiryAPI();
            businessKey = wsilUddiBusinessElement.getUDDILinkBusinessKey();
            businessName = wsilUddiBusinessElement.getName();
            if (businessName == null) {
                businessName = businessKey;
            }
        } else {
            return false;
        }
        if (!this.createRegistryInUDDIPerspective(inquiryURL, null, inquiryURL)) {
            wsilPerspective.getMessageQueue().addMessage(wsilPerspective.getMessage("MSG_ERROR_ADD_TO_UDDI_PERSPECTIVE", businessName));
            return false;
        }
        RegFindBusinessUUIDAction action = new RegFindBusinessUUIDAction(this.controller_);
        Hashtable propertyTable = action.getPropertyTable();
        propertyTable.put("uuidBusinessKey", businessKey);
        propertyTable.put("queryName", businessName);
        if (!action.run()) {
            wsilPerspective.getMessageQueue().addMessage(wsilPerspective.getMessage("MSG_ERROR_BUSINESS_NOT_FOUND", businessName));
            return false;
        }
        wsilPerspective.getMessageQueue().addMessage(wsilPerspective.getMessage("MSG_INFO_ADD_TO_UDDI_PERSPECTIVE_SUCCESSFUL", businessName));
        return true;
    }
}

