/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.validation.internal.strategy;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jst.jsf.common.dom.AttrDOMAdapter;
import org.eclipse.jst.jsf.common.dom.AttributeIdentifier;
import org.eclipse.jst.jsf.common.dom.DOMAdapter;
import org.eclipse.jst.jsf.common.internal.types.CompositeType;
import org.eclipse.jst.jsf.common.internal.types.TypeComparator;
import org.eclipse.jst.jsf.common.internal.types.TypeComparatorDiagnosticFactory;
import org.eclipse.jst.jsf.common.internal.types.TypeComparatorPreferences;
import org.eclipse.jst.jsf.common.internal.types.TypeTransformer;
import org.eclipse.jst.jsf.common.runtime.internal.model.ViewObject;
import org.eclipse.jst.jsf.common.runtime.internal.model.component.ComponentFactory;
import org.eclipse.jst.jsf.common.runtime.internal.model.component.ComponentInfo;
import org.eclipse.jst.jsf.common.runtime.internal.model.decorator.ConverterDecorator;
import org.eclipse.jst.jsf.common.runtime.internal.model.decorator.ConverterTypeInfo;
import org.eclipse.jst.jsf.context.IModelContext;
import org.eclipse.jst.jsf.context.structureddocument.IStructuredDocumentContext;
import org.eclipse.jst.jsf.context.structureddocument.IStructuredDocumentContextFactory;
import org.eclipse.jst.jsf.core.internal.JSFCorePlugin;
import org.eclipse.jst.jsf.core.internal.region.Region2AttrAdapter;
import org.eclipse.jst.jsf.core.internal.region.Region2ElementAdapter;
import org.eclipse.jst.jsf.core.jsfappconfig.JSFAppConfigManager;
import org.eclipse.jst.jsf.designtime.DTAppManagerUtil;
import org.eclipse.jst.jsf.designtime.internal.view.DTUIViewRoot;
import org.eclipse.jst.jsf.designtime.internal.view.IDTViewHandler;
import org.eclipse.jst.jsf.designtime.internal.view.XMLViewDefnAdapter;
import org.eclipse.jst.jsf.designtime.internal.view.XMLViewObjectMappingService;
import org.eclipse.jst.jsf.facesconfig.emf.ConverterForClassType;
import org.eclipse.jst.jsf.facesconfig.emf.ConverterType;
import org.eclipse.jst.jsf.metadataprocessors.IMetaDataEnabledFeature;
import org.eclipse.jst.jsf.metadataprocessors.MetaDataEnabledProcessingFactory;
import org.eclipse.jst.jsf.metadataprocessors.features.ELIsNotValidException;
import org.eclipse.jst.jsf.metadataprocessors.features.IValidELValues;
import org.eclipse.jst.jsf.metadataprocessors.features.IValidValues;
import org.eclipse.jst.jsf.metadataprocessors.features.IValidationMessage;
import org.eclipse.jst.jsf.validation.internal.AbstractXMLViewValidationStrategy;
import org.eclipse.jst.jsf.validation.internal.JSFValidationContext;
import org.eclipse.jst.jsf.validation.internal.el.ELExpressionValidator;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegionCollection;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegionList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AttributeValidatingStrategy
extends AbstractXMLViewValidationStrategy {
    private static final String DISABLE_ALTERATIVE_TYPES_KEY = "jsfCoreDisableConverterValidation";
    static final boolean DEBUG;
    public static final String ID = "org.eclipse.jst.jsf.validation.strategy.AttributeValidatingStrategy";
    private static final String DISPLAY_NAME = "Attribute Validator";
    private final JSFValidationContext _validationContext;
    private final TypeComparator _typeComparator;
    private Set<String> _conversionTypes;

    static {
        String value = Platform.getDebugOption((String)"org.eclipse.jst.jsf.validation.internal.el/debug/jspsemanticsvalidator");
        DEBUG = value != null && value.equalsIgnoreCase("true");
    }

    public AttributeValidatingStrategy(JSFValidationContext validationContext) {
        super(ID, DISPLAY_NAME);
        this._validationContext = validationContext;
        this._typeComparator = new TypeComparator(new TypeComparatorDiagnosticFactory((TypeComparatorPreferences)validationContext.getPrefs().getTypeComparatorPrefs()));
    }

    @Override
    public boolean isInteresting(DOMAdapter domAdapter) {
        return domAdapter instanceof AttrDOMAdapter;
    }

    @Override
    public void validate(DOMAdapter domAdapter) {
        if (domAdapter instanceof AttrDOMAdapter) {
            long curTime = System.nanoTime();
            Region2AttrAdapter attrAdapter = (Region2AttrAdapter)domAdapter;
            if (attrAdapter.getAttributeValueRegion() != null) {
                IStructuredDocumentContext context = IStructuredDocumentContextFactory.INSTANCE.getContext(attrAdapter.getDocumentContext().getStructuredDocument(), attrAdapter.getOwningElement().getDocumentContext().getDocumentPosition() + attrAdapter.getAttributeValueRegion().getStart());
                this.validateAttributeValue(context, attrAdapter);
            }
            if (DEBUG) {
                System.out.println(String.format("Validation for attribute: %s took %d", domAdapter.toString(), System.nanoTime() - curTime));
            }
        }
    }

    private void validateAttributeValue(final IStructuredDocumentContext context, final Region2AttrAdapter attrAdapter) {
        SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

            public void handleException(Throwable exception) {
                JSFCorePlugin.log(String.format("Error validating attribute: %s on element %s", attrAdapter.getNodeName(), attrAdapter.getOwningElement().getNodeName()), exception);
            }

            public void run() throws Exception {
                Region2ElementAdapter elementAdapter = attrAdapter.getOwningElement();
                if (!AttributeValidatingStrategy.this.checkIfELAndValidate(elementAdapter, attrAdapter, context)) {
                    AttributeValidatingStrategy.this.validateNonELAttributeValue(context, attrAdapter);
                }
            }
        });
    }

    private boolean checkIfELAndValidate(Region2ElementAdapter elementAdapter, Region2AttrAdapter attrAdapter, IStructuredDocumentContext context) {
        int offsetOfFirstEL = -1;
        String attrValue = attrAdapter.getValue();
        offsetOfFirstEL = attrValue.indexOf(35);
        offsetOfFirstEL = offsetOfFirstEL != -1 && offsetOfFirstEL < attrValue.length() - 1 && attrValue.charAt(offsetOfFirstEL + 1) == '{' ? (offsetOfFirstEL += 2) : -1;
        XMLViewDefnAdapter adapter = DTAppManagerUtil.getXMLViewDefnAdapter(context);
        boolean isEL = false;
        if (adapter != null && offsetOfFirstEL != -1) {
            try {
                IStructuredDocumentContext elContext = IStructuredDocumentContextFactory.INSTANCE.getContext(context.getStructuredDocument(), context.getDocumentPosition() + offsetOfFirstEL + 1);
                XMLViewDefnAdapter.DTELExpression elExpression = adapter.getELExpression((IModelContext)elContext);
                if (elExpression != null) {
                    String elText = elExpression.getText();
                    if (DEBUG) {
                        System.out.println(String.valueOf(this.addDebugSpacer(3)) + "EL attrVal= " + elText);
                    }
                    elContext = elExpression.getDocumentContext();
                    if (this._validationContext.shouldValidateEL()) {
                        if ("".equals(elText.trim())) {
                            int offset = elContext.getDocumentPosition() - 1;
                            int length = elText.length() + 2;
                            Diagnostic diagnostic = this._validationContext.getDiagnosticFactory().create_EMPTY_EL_EXPRESSION();
                            if (this._validationContext.shouldValidateEL()) {
                                this._validationContext.getReporter().report(diagnostic, offset, length);
                            }
                        } else {
                            List<IMetaDataEnabledFeature> elVals = MetaDataEnabledProcessingFactory.getInstance().getAttributeValueRuntimeTypeFeatureProcessors(IValidELValues.class, elContext, attrAdapter.getAttributeIdentifier());
                            String safeELText = elText.replaceAll("[\n\r\t]", " ");
                            this.validateELExpression(context, elContext, elVals, elementAdapter, attrAdapter, safeELText);
                            isEL = true;
                        }
                    }
                }
            }
            catch (IDTViewHandler.ViewHandlerException viewHandlerException) {}
        }
        boolean isEL2 = this.checkIfELAndValidate2(attrAdapter, context);
        return isEL || isEL2;
    }

    private boolean checkIfELAndValidate2(Region2AttrAdapter attrAdapter, IStructuredDocumentContext sDocContext) {
        ITextRegionList regionList;
        ITextRegionCollection parentRegion;
        ITextRegion attrValueRegion = attrAdapter.getAttributeValueRegion();
        if (attrValueRegion instanceof ITextRegionCollection && (parentRegion = (ITextRegionCollection)attrValueRegion).getType() == "XML_TAG_ATTRIBUTE_VALUE" && (regionList = parentRegion.getRegions()).size() >= 3) {
            ITextRegion openQuote = regionList.get(0);
            ITextRegion vblOpen = regionList.get(1);
            if ((openQuote.getType() == "XML_TAG_ATTRIBUTE_VALUE_DQUOTE" || openQuote.getType() == "JSP_VBL_DQUOTE" || openQuote.getType() == "JSP_TAG_ATTRIBUTE_VALUE_DQUOTE") && vblOpen.getType() == "JSP_VBL_OPEN") {
                boolean foundClosingQuote = false;
                int i = 2;
                while (!foundClosingQuote && i < regionList.size()) {
                    ITextRegion searchRegion = regionList.get(i);
                    if (searchRegion.getType() == "JSP_VBL_CLOSE") {
                        foundClosingQuote = true;
                    }
                    ++i;
                }
                if (!foundClosingQuote && this._validationContext.shouldValidateEL()) {
                    int offset = sDocContext.getDocumentPosition() + 1;
                    int length = parentRegion.getText().length();
                    Diagnostic diagnostic = this._validationContext.getDiagnosticFactory().create_MISSING_CLOSING_EXPR_BRACKET();
                    this._validationContext.getReporter().report(diagnostic, offset, length);
                }
                return true;
            }
        }
        return false;
    }

    private void validateELExpression(IStructuredDocumentContext context, IStructuredDocumentContext elContext, List elVals, Region2ElementAdapter elementAdapter, Region2AttrAdapter attrAdapter, String elText) {
        ELExpressionValidator elValidator = new ELExpressionValidator(elContext, elText, this._validationContext.getSymbolResolverFactory(), this._validationContext.getReporter());
        elValidator.validateXMLNode();
        CompositeType exprType = elValidator.getExpressionType();
        if (exprType != null) {
            CompositeType boxedType = TypeTransformer.transformBoxPrimitives((CompositeType)exprType);
            String[] testSignatures = boxedType.getSignatures();
            if (testSignatures.length > 0 && "Ljava.lang.Object;".equals(testSignatures[0]) && elText.indexOf(46) != -1) {
                String elText2 = elText.substring(0, elText.lastIndexOf(46));
                ELExpressionValidator elValidator2 = new ELExpressionValidator(elContext, elText2, this._validationContext.getSymbolResolverFactory(), this._validationContext.getReporter());
                elValidator2.validateXMLNode();
                CompositeType exprType2 = elValidator.getExpressionType();
                CompositeType boxedType2 = TypeTransformer.transformBoxPrimitives((CompositeType)exprType2);
                String[] testSignatures2 = boxedType2.getSignatures();
                if (testSignatures2.length > 0 && "Ljava.lang.Object;".equals(testSignatures2[0])) {
                    return;
                }
            }
            for (IValidELValues elval : elVals) {
                String attributeVal = attrAdapter.getValue();
                Diagnostic status = null;
                try {
                    CompositeType expectedType = elval.getExpectedRuntimeType();
                    if (expectedType == null || (status = this._typeComparator.calculateTypeCompatibility(expectedType = this.maybeAddAlternativeTypes(expectedType, exprType, elementAdapter, attrAdapter), exprType)).getSeverity() == 0) continue;
                    this.reportValidationMessage(status, context, attributeVal);
                }
                catch (ELIsNotValidException e) {
                    this.reportValidationMessage(this.createValidationMessage(context, attributeVal, 2, e.getMessage(), this._validationContext.getFile()), context, attributeVal);
                }
            }
        }
    }

    private boolean disableAlternativeTypes() {
        String res = System.getProperty(DISABLE_ALTERATIVE_TYPES_KEY);
        if (res == null) {
            res = System.getenv(DISABLE_ALTERATIVE_TYPES_KEY);
        }
        if (res != null) {
            return true;
        }
        IPreferenceStore prefStore = JSFCorePlugin.getDefault().getPreferenceStore();
        return prefStore.getBoolean("org.eclipse.jst.jsf.core.jsfCoreDisableConverterValidation");
    }

    private CompositeType maybeAddAlternativeTypes(CompositeType expectedType, CompositeType exprTypes, Region2ElementAdapter elementAdapter, Region2AttrAdapter attrAdapter) {
        ComponentInfo component;
        XMLViewObjectMappingService.ElementData mappedElementData;
        String propName;
        XMLViewObjectMappingService.ElementData elementData;
        ViewObject viewObject;
        long curTime = System.nanoTime();
        if (this.disableAlternativeTypes()) {
            return expectedType;
        }
        IStructuredDocumentContext context = elementAdapter.getDocumentContext();
        DTUIViewRoot viewRoot = this._validationContext.getViewRootHandle().getCachedViewRoot();
        IAdaptable serviceAdaptable = viewRoot.getServices();
        XMLViewObjectMappingService mappingService = (XMLViewObjectMappingService)serviceAdaptable.getAdapter(XMLViewObjectMappingService.class);
        if (mappingService != null && (viewObject = mappingService.findViewObject(elementData = XMLViewObjectMappingService.createElementData(elementAdapter.getNamespace(), elementAdapter.getLocalName(), context, Collections.EMPTY_MAP))) instanceof ComponentInfo && ((ComponentInfo)viewObject).getComponentTypeInfo() != null && ((ComponentInfo)viewObject).getComponentTypeInfo().isInstanceOf("javax.faces.component.ValueHolder") && "value".equals(propName = (mappedElementData = mappingService.findElementData((ViewObject)(component = (ComponentInfo)viewObject))).getPropertyName(attrAdapter.getLocalName()))) {
            CompositeType alternativeTypes = this.createCompositeType(expectedType, exprTypes, component.getDecorators(ComponentFactory.CONVERTER));
            if (DEBUG) {
                System.out.println(String.format("maybeAddAlternative took %d", System.nanoTime() - curTime));
            }
            return alternativeTypes;
        }
        if (DEBUG) {
            System.out.println(String.format("maybeAddAlternative took %d", System.nanoTime() - curTime));
        }
        return expectedType;
    }

    private CompositeType createCompositeType(CompositeType initialTypes, CompositeType testTypes, List<ConverterDecorator> decorators) {
        HashSet<String> types = new HashSet<String>((Collection)Arrays.asList(initialTypes.getSignatures()));
        for (ConverterDecorator decorator : decorators) {
            if (decorator.getTypeInfo() == null) continue;
            ConverterTypeInfo converterTypeInfo = decorator.getTypeInfo();
            if (converterTypeInfo.getForClass().length == 0) {
                types.addAll((Collection)Arrays.asList(testTypes.getSignatures()));
                break;
            }
            types.addAll(this.createSignatures(converterTypeInfo.getForClass()));
        }
        types.addAll(this.getRegisteredConversionTypesByClass());
        return new CompositeType(types.toArray(new String[0]), initialTypes.getAssignmentTypeMask());
    }

    private Set<String> getRegisteredConversionTypesByClass() {
        if (this._conversionTypes == null) {
            this._conversionTypes = new HashSet<String>();
            IProject project = this._validationContext.getFile().getProject();
            JSFAppConfigManager appConfig = JSFAppConfigManager.getInstance(project);
            List converters = appConfig.getConverters();
            for (ConverterType converterType : converters) {
                String forClass;
                ConverterForClassType forClassType = converterType.getConverterForClass();
                if (forClassType == null || (forClass = forClassType.getTextContent()) == null) continue;
                String signature = forClass.trim();
                try {
                    if (Signature.getArrayCount((String)signature) > 0) {
                        this._conversionTypes.add(signature);
                    }
                }
                catch (IllegalArgumentException illegalArgumentException) {}
                try {
                    signature = Signature.createTypeSignature((String)signature, (boolean)true);
                    this._conversionTypes.add(signature);
                }
                catch (Exception exception) {}
            }
        }
        return this._conversionTypes;
    }

    private List<String> createSignatures(String[] classNames) {
        ArrayList<String> signatures = new ArrayList<String>();
        String[] stringArray = classNames;
        int n = classNames.length;
        int n2 = 0;
        while (n2 < n) {
            String className = stringArray[n2];
            try {
                String signature = Signature.createTypeSignature((String)className, (boolean)true);
                signatures.add(signature);
            }
            catch (Exception e) {
                JSFCorePlugin.log(e, "Trying to create signature");
            }
            ++n2;
        }
        return signatures;
    }

    private void validateNonELAttributeValue(IStructuredDocumentContext context, Region2AttrAdapter attrAdapter) {
        AttributeIdentifier attributeId;
        String attributeValue = attrAdapter.getValue();
        if (DEBUG) {
            System.out.println(String.valueOf(this.addDebugSpacer(3)) + "attrVal= " + (attributeValue != null ? attributeValue : "null"));
        }
        if ((attributeId = attrAdapter.getAttributeIdentifier()).getTagIdentifier() == null || attributeId.getTagIdentifier().getTagName() == null || attributeId.getName() == null) {
            return;
        }
        List<IMetaDataEnabledFeature> vv = MetaDataEnabledProcessingFactory.getInstance().getAttributeValueRuntimeTypeFeatureProcessors(IValidValues.class, context, attributeId);
        if (!vv.isEmpty()) {
            for (IValidValues iValidValues : vv) {
                if (!iValidValues.isValidValue(attributeValue.trim())) {
                    if (DEBUG) {
                        System.out.println(String.valueOf(this.addDebugSpacer(4)) + "NOT VALID ");
                    }
                    for (IValidationMessage msg : iValidValues.getValidationMessages()) {
                        this.reportValidationMessage(this.createValidationMessage(context, attributeValue, msg.getSeverity(), msg.getMessage(), this._validationContext.getFile()), context, attributeValue);
                    }
                    continue;
                }
                if (!DEBUG) continue;
                System.out.println(String.valueOf(this.addDebugSpacer(5)) + "VALID ");
            }
        } else if (DEBUG) {
            System.out.println(String.valueOf(this.addDebugSpacer(4)) + "NO META DATA ");
        }
    }

    private void reportValidationMessage(Diagnostic problem, IStructuredDocumentContext context, String attributeValue) {
        int start = context.getDocumentPosition() + 1;
        int length = attributeValue.length();
        this._validationContext.getReporter().report(problem, start, length);
    }

    private Diagnostic createValidationMessage(IStructuredDocumentContext context, String attributeValue, int severity, String msg, IFile file) {
        BasicDiagnostic diagnostic = new BasicDiagnostic(severity, "", -1, msg, null);
        return diagnostic;
    }

    private String addDebugSpacer(int count) {
        StringBuffer ret = new StringBuffer("");
        int i = 0;
        while (i <= count) {
            ret.append("\t");
            ++i;
        }
        return ret.toString();
    }
}

