/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsp.ui.internal.wizard;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jst.jsp.core.internal.provisional.contenttype.ContentTypeIdForJSP;
import org.eclipse.jst.jsp.core.internal.util.FacetModuleCoreSupport;
import org.eclipse.jst.jsp.ui.internal.JSPUIMessages;
import org.eclipse.jst.jsp.ui.internal.Logger;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.dialogs.WizardNewFileCreationPage;

class NewTagFileWizardPage
extends WizardNewFileCreationPage {
    private IContentType fContentType;
    private List fValidExtensions = null;

    public NewTagFileWizardPage(String pageName, IStructuredSelection selection) {
        super(pageName, selection);
    }

    protected void initialPopulateContainerNameField() {
        super.initialPopulateContainerNameField();
        IPath fullPath = this.getContainerFullPath();
        IProject project = this.getProjectFromPath(fullPath);
        IPath webContentPath = this.getWebContentPath(project);
        if (webContentPath != null && !webContentPath.isPrefixOf(fullPath)) {
            this.setContainerFullPath(webContentPath);
        }
    }

    protected boolean validatePage() {
        this.setMessage(null);
        this.setErrorMessage(null);
        if (!super.validatePage()) {
            return false;
        }
        String fileName = this.getFileName();
        IPath fullPath = this.getContainerFullPath();
        if (fullPath != null && !fullPath.isEmpty() && fileName != null) {
            IProject project;
            if (!this.extensionValidForContentType(fileName)) {
                this.setErrorMessage(NLS.bind((String)JSPUIMessages._ERROR_FILENAME_MUST_END_JSP, (Object)this.getValidExtensions().toString()));
                return false;
            }
            if (fileName.lastIndexOf(46) == -1) {
                String newFileName = this.addDefaultExtension(fileName);
                IPath resourcePath = fullPath.append(newFileName);
                IWorkspace workspace = ResourcesPlugin.getWorkspace();
                IStatus result = workspace.validatePath(resourcePath.toString(), 2);
                if (!result.isOK()) {
                    this.setErrorMessage(result.getMessage());
                    return false;
                }
                if (workspace.getRoot().getFolder(resourcePath).exists() || workspace.getRoot().getFile(resourcePath).exists()) {
                    this.setErrorMessage(JSPUIMessages.ResourceGroup_nameExists);
                    return false;
                }
            }
            if ((project = this.getProjectFromPath(fullPath)) != null && !this.isJavaProject(project)) {
                this.setMessage(JSPUIMessages._WARNING_FILE_MUST_BE_INSIDE_JAVA_PROJECT, 2);
            }
        }
        return true;
    }

    String addDefaultExtension(String filename) {
        StringBuffer newFileName = new StringBuffer(filename);
        String ext = "tag";
        newFileName.append(".");
        newFileName.append(ext);
        return newFileName.toString();
    }

    private IContentType getContentType() {
        if (this.fContentType == null) {
            this.fContentType = Platform.getContentTypeManager().getContentType(ContentTypeIdForJSP.ContentTypeID_JSPTAG);
        }
        return this.fContentType;
    }

    private List getValidExtensions() {
        if (this.fValidExtensions == null) {
            IContentType type = this.getContentType();
            this.fValidExtensions = new ArrayList<String>(Arrays.asList(type.getFileSpecs(8)));
        }
        return this.fValidExtensions;
    }

    private boolean extensionValidForContentType(String fileName) {
        boolean valid = false;
        IContentType type = this.getContentType();
        if (fileName.lastIndexOf(46) != -1) {
            IContentType[] types = Platform.getContentTypeManager().findContentTypesFor(fileName);
            int i = 0;
            while (i < types.length && !valid) {
                valid = types[i].isKindOf(type);
                ++i;
            }
        } else {
            valid = true;
        }
        return valid;
    }

    private IProject getProjectFromPath(IPath path) {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IProject project = null;
        if (path != null) {
            project = workspace.validatePath(path.toString(), 4).isOK() ? workspace.getRoot().getProject(path.toString()) : workspace.getRoot().getFile(path).getProject();
        }
        return project;
    }

    boolean isDynamicWebProject(IProject project) {
        boolean is = FacetModuleCoreSupport.isDynamicWebProject((IProject)project);
        return is;
    }

    private boolean isJavaProject(IProject project) {
        boolean isJava = false;
        try {
            isJava = project.hasNature("org.eclipse.jdt.core.javanature");
        }
        catch (CoreException e) {
            Logger.log(202, e.getMessage(), e);
        }
        return isJava;
    }

    private IPath getWebContentPath(IProject project) {
        IPath path = FacetModuleCoreSupport.getWebContentRootPath((IProject)project);
        return path;
    }
}

