/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.sse.ui.internal.provisional.style;

import java.util.Collection;
import java.util.HashMap;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.TextAttribute;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegionCollection;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegionList;
import org.eclipse.wst.sse.ui.internal.preferences.ui.ColorHelper;
import org.eclipse.wst.sse.ui.internal.provisional.style.Highlighter;
import org.eclipse.wst.sse.ui.internal.provisional.style.ReconcilerHighlighter;
import org.eclipse.wst.sse.ui.internal.util.EditorUtility;

public abstract class AbstractLineStyleProvider {
    protected IStructuredDocument fDocument;
    protected Highlighter fHighlighter;
    private boolean fInitialized;
    protected PropertyChangeListener fPreferenceListener = new PropertyChangeListener();
    protected ReconcilerHighlighter fRecHighlighter = null;
    private HashMap fTextAttributes = null;
    static /* synthetic */ Class class$0;

    protected AbstractLineStyleProvider() {
    }

    protected void addTextAttribute(String colorKey) {
        String prefString;
        String[] stylePrefs;
        if (this.getColorPreferences() != null && (stylePrefs = ColorHelper.unpackStylePreferences(prefString = this.getColorPreferences().getString(colorKey))) != null) {
            RGB foreground = ColorHelper.toRGB(stylePrefs[0]);
            RGB background = ColorHelper.toRGB(stylePrefs[1]);
            boolean bold = Boolean.valueOf(stylePrefs[2]);
            boolean italic = Boolean.valueOf(stylePrefs[3]);
            boolean strikethrough = Boolean.valueOf(stylePrefs[4]);
            boolean underline = Boolean.valueOf(stylePrefs[5]);
            int style = 0;
            if (bold) {
                style |= 1;
            }
            if (italic) {
                style |= 2;
            }
            if (strikethrough) {
                style |= 0x20000000;
            }
            if (underline) {
                style |= 0x40000000;
            }
            TextAttribute createTextAttribute = this.createTextAttribute(foreground, background, style);
            this.getTextAttributes().put(colorKey, createTextAttribute);
        }
    }

    protected void commonInit(IStructuredDocument document, Highlighter highlighter) {
        this.fDocument = document;
        this.fHighlighter = highlighter;
    }

    private StyleRange createStyleRange(ITextRegionCollection flatNode, ITextRegion region, TextAttribute attr, int startOffset, int length) {
        int start = flatNode.getStartOffset(region);
        if (start < startOffset) {
            start = startOffset;
        }
        int textEnd = start + flatNode.getText(region).length();
        int maxOffset = startOffset + length;
        int end = flatNode.getEndOffset(region);
        if (textEnd < end) {
            end = textEnd;
        }
        if (end > maxOffset) {
            end = maxOffset;
        }
        StyleRange result = new StyleRange(start, end - start, attr.getForeground(), attr.getBackground(), attr.getStyle());
        if ((attr.getStyle() & 0x20000000) != 0) {
            result.strikeout = true;
        }
        if ((attr.getStyle() & 0x40000000) != 0) {
            result.underline = true;
        }
        return result;
    }

    protected TextAttribute createTextAttribute(RGB foreground, RGB background, boolean bold) {
        return new TextAttribute(foreground != null ? EditorUtility.getColor(foreground) : null, background != null ? EditorUtility.getColor(background) : null, bold ? 1 : 0);
    }

    protected TextAttribute createTextAttribute(RGB foreground, RGB background, int style) {
        return new TextAttribute(foreground != null ? EditorUtility.getColor(foreground) : null, background != null ? EditorUtility.getColor(background) : null, style);
    }

    protected abstract TextAttribute getAttributeFor(ITextRegion var1);

    protected TextAttribute getAttributeFor(ITextRegionCollection collection, ITextRegion region) {
        return this.getAttributeFor(region);
    }

    protected abstract IPreferenceStore getColorPreferences();

    protected IStructuredDocument getDocument() {
        return this.fDocument;
    }

    public void setDocument(IStructuredDocument document) {
        this.fDocument = document;
    }

    protected Highlighter getHighlighter() {
        return this.fHighlighter;
    }

    protected HashMap getTextAttributes() {
        if (this.fTextAttributes == null) {
            this.fTextAttributes = new HashMap();
            this.loadColors();
        }
        return this.fTextAttributes;
    }

    protected void handlePropertyChange(PropertyChangeEvent event) {
        if (this.fRecHighlighter != null) {
            this.fRecHighlighter.refreshDisplay();
        }
    }

    public void init(IStructuredDocument structuredDocument, Highlighter highlighter) {
        this.commonInit(structuredDocument, highlighter);
        if (this.isInitialized()) {
            return;
        }
        this.registerPreferenceManager();
        this.setInitialized(true);
    }

    public void init(IStructuredDocument structuredDocument, ISourceViewer sourceViewer) {
        this.init(structuredDocument, (Highlighter)null);
    }

    public void init(IStructuredDocument structuredDocument, ReconcilerHighlighter highlighter) {
        this.fDocument = structuredDocument;
        this.fRecHighlighter = highlighter;
        if (this.isInitialized()) {
            return;
        }
        this.registerPreferenceManager();
        this.setInitialized(true);
    }

    public boolean isAdapterForType(Object type) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.wst.sse.ui.internal.provisional.style.LineStyleProvider");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return type == clazz;
    }

    public boolean isInitialized() {
        return this.fInitialized;
    }

    protected abstract void loadColors();

    public boolean prepareRegions(ITypedRegion typedRegion, int lineRequestStart, int lineRequestLength, Collection holdResults) {
        int partitionStartOffset = typedRegion.getOffset();
        int partitionLength = typedRegion.getLength();
        IStructuredDocumentRegion structuredDocumentRegion = this.getDocument().getRegionAtCharacterOffset(partitionStartOffset);
        boolean handled = false;
        handled = this.prepareTextRegions(structuredDocumentRegion, partitionStartOffset, partitionLength, holdResults);
        return handled;
    }

    private boolean prepareTextRegion(ITextRegionCollection blockedRegion, int partitionStartOffset, int partitionLength, Collection holdResults) {
        boolean handled = false;
        int partitionEndOffset = partitionStartOffset + partitionLength - 1;
        ITextRegion region = null;
        ITextRegionList regions = blockedRegion.getRegions();
        int nRegions = regions.size();
        StyleRange styleRange = null;
        int i = 0;
        while (i < nRegions) {
            region = regions.get(i);
            TextAttribute attr = null;
            TextAttribute previousAttr = null;
            if (blockedRegion.getStartOffset(region) > partitionEndOffset) break;
            if (blockedRegion.getEndOffset(region) > partitionStartOffset) {
                if (region instanceof ITextRegionCollection) {
                    handled = this.prepareTextRegion((ITextRegionCollection)region, partitionStartOffset, partitionLength, holdResults);
                } else {
                    attr = this.getAttributeFor(blockedRegion, region);
                    if (attr != null) {
                        handled = true;
                        if (styleRange != null && previousAttr != null && previousAttr.equals((Object)attr)) {
                            styleRange.length += region.getLength();
                        } else {
                            styleRange = this.createStyleRange(blockedRegion, region, attr, partitionStartOffset, partitionLength);
                            holdResults.add(styleRange);
                            previousAttr = attr;
                        }
                    } else {
                        previousAttr = null;
                    }
                }
            }
            ++i;
        }
        return handled;
    }

    private boolean prepareTextRegions(IStructuredDocumentRegion structuredDocumentRegion, int partitionStartOffset, int partitionLength, Collection holdResults) {
        boolean handled = false;
        int partitionEndOffset = partitionStartOffset + partitionLength - 1;
        while (structuredDocumentRegion != null && structuredDocumentRegion.getStartOffset() <= partitionEndOffset) {
            ITextRegion region = null;
            ITextRegionList regions = structuredDocumentRegion.getRegions();
            int nRegions = regions.size();
            StyleRange styleRange = null;
            int i = 0;
            while (i < nRegions) {
                region = regions.get(i);
                TextAttribute attr = null;
                TextAttribute previousAttr = null;
                if (structuredDocumentRegion.getStartOffset(region) > partitionEndOffset) break;
                if (structuredDocumentRegion.getEndOffset(region) > partitionStartOffset) {
                    if (region instanceof ITextRegionCollection) {
                        boolean handledCollection = this.prepareTextRegion((ITextRegionCollection)region, partitionStartOffset, partitionLength, holdResults);
                        handled = !handled ? handledCollection : handled;
                    } else {
                        attr = this.getAttributeFor((ITextRegionCollection)structuredDocumentRegion, region);
                        if (attr != null) {
                            handled = true;
                            if (styleRange != null && previousAttr != null && previousAttr.equals((Object)attr)) {
                                styleRange.length += region.getLength();
                            } else {
                                styleRange = this.createStyleRange((ITextRegionCollection)structuredDocumentRegion, region, attr, partitionStartOffset, partitionLength);
                                holdResults.add(styleRange);
                                previousAttr = attr;
                            }
                        } else {
                            previousAttr = null;
                        }
                    }
                }
                ++i;
            }
            structuredDocumentRegion = structuredDocumentRegion.getNext();
        }
        return handled;
    }

    protected void registerPreferenceManager() {
        IPreferenceStore pref = this.getColorPreferences();
        if (pref != null) {
            pref.addPropertyChangeListener((IPropertyChangeListener)this.fPreferenceListener);
        }
    }

    public void release() {
        this.unRegisterPreferenceManager();
        if (this.fTextAttributes != null) {
            this.fTextAttributes.clear();
            this.fTextAttributes = null;
        }
        this.setInitialized(false);
    }

    private void setInitialized(boolean initialized) {
        this.fInitialized = initialized;
    }

    protected void unRegisterPreferenceManager() {
        IPreferenceStore pref = this.getColorPreferences();
        if (pref != null) {
            pref.removePropertyChangeListener((IPropertyChangeListener)this.fPreferenceListener);
        }
    }

    private class PropertyChangeListener
    implements IPropertyChangeListener {
        private PropertyChangeListener() {
        }

        public void propertyChange(PropertyChangeEvent event) {
            AbstractLineStyleProvider.this.handlePropertyChange(event);
        }
    }
}

