/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wtp.j2ee.headless.tests.ejb.operations;

import java.io.File;
import java.io.InputStream;
import java.io.StringBufferInputStream;
import junit.framework.Assert;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.jst.j2ee.internal.ejb.project.operations.EJBComponentExportDataModelProvider;
import org.eclipse.jst.j2ee.internal.ejb.project.operations.EJBComponentImportDataModelProvider;
import org.eclipse.jst.j2ee.internal.ejb.project.operations.EjbFacetProjectCreationDataModelProvider;
import org.eclipse.wst.common.componentcore.internal.util.ComponentUtilities;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualFile;
import org.eclipse.wst.common.componentcore.resources.IVirtualFolder;
import org.eclipse.wst.common.frameworks.datamodel.DataModelFactory;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelProvider;
import org.eclipse.wst.common.tests.OperationTestCase;

public class EJBGeneraUseTest
extends OperationTestCase {
    private static String BASE_DATA_DIR = String.valueOf(System.getProperty("user.dir")) + File.separatorChar + "EJBTests" + File.separatorChar;
    private final String EJB_NAME = "TestEJB";
    private final String EJB_ARCHIVE_NAME = "TestEJB.jar";
    private final String FILE1 = "Test1.java";

    private static String getDataPath(String suffix) {
        return String.valueOf(BASE_DATA_DIR) + suffix;
    }

    public void test_GeneralUse() throws Exception {
        IDataModel model = DataModelFactory.createDataModel((IDataModelProvider)new EjbFacetProjectCreationDataModelProvider());
        model.setProperty("IProjectCreationPropertiesNew.PROJECT_NAME", (Object)"TestEJB");
        EJBGeneraUseTest.runAndVerify((IDataModel)model);
        IVirtualComponent ejb = ComponentUtilities.getComponent((String)"TestEJB");
        IProject ejbProject = ejb.getProject();
        IVirtualFolder ejbRootFolder = ejb.getRootFolder();
        Assert.assertNotNull((String)("New EJB project named " + "TestEJB" + " should exist."), (Object)ejb);
        IWorkspace workspace = ejbProject.getWorkspace();
        IWorkspaceRoot workspaceRoot = workspace.getRoot();
        IVirtualFile virtFile = ejbRootFolder.getFile("Test1.java");
        IFile file = virtFile.getUnderlyingFile();
        file.create((InputStream)new StringBufferInputStream(""), true, null);
        Assert.assertTrue((String)("The file " + "Test1.java" + " should exsist in the project."), (boolean)file.exists());
        model = DataModelFactory.createDataModel((IDataModelProvider)new EJBComponentExportDataModelProvider());
        model.setProperty("IJ2EEComponentExportDataModelProperties.PROJECT_NAME", (Object)ejbProject.getName());
        model.setProperty("IJ2EEComponentExportDataModelProperties.ARCHIVE_DESTINATION", (Object)EJBGeneraUseTest.getDataPath("TestEJB.jar"));
        model.setProperty("IJ2EEComponentExportDataModelProperties.EXPORT_SOURCE_FILES", (Object)Boolean.TRUE);
        EJBGeneraUseTest.runAndVerify((IDataModel)model);
        ejbProject.close(null);
        ejbProject.delete(4, null);
        Assert.assertNull((String)("The " + "TestEJB" + " project should no longer exsist."), (Object)ComponentUtilities.getComponent((String)"TestEJB"));
        ejb = null;
        ejbProject = null;
        ejbRootFolder = null;
        virtFile = null;
        file = null;
        ejbProject = workspaceRoot.getProject("TestEJB");
        Assert.assertFalse((String)"Project should not exsist.", (boolean)ejbProject.exists());
        model = DataModelFactory.createDataModel((IDataModelProvider)new EJBComponentImportDataModelProvider());
        model.setProperty("IJ2EEArtifactImportDataModelProperties.FILE_NAME", (Object)EJBGeneraUseTest.getDataPath("TestEJB.jar"));
        model.setProperty("IJ2EEComponentImportDataModelProperties.PROJECT_NAME", (Object)"TestEJB");
        EJBGeneraUseTest.runAndVerify((IDataModel)model);
        ejb = ComponentUtilities.getComponent((String)"TestEJB");
        Assert.assertNotNull((String)("New EJB project named " + "TestEJB" + " should exsist"), (Object)ejb);
        ejbRootFolder = ejb.getRootFolder();
        virtFile = ejbRootFolder.getFile("Test1.java");
        Assert.assertTrue((String)("The file " + "Test1.java" + " should exsist in the project."), (boolean)file.exists());
    }
}

