/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wtp.j2ee.headless.tests.utility.operations;

import junit.framework.Test;
import org.eclipse.jst.j2ee.project.facet.UtilityProjectCreationDataModelProvider;
import org.eclipse.wst.common.frameworks.datamodel.DataModelFactory;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelProvider;
import org.eclipse.wst.common.tests.OperationTestCase;
import org.eclipse.wst.common.tests.SimpleTestSuite;
import org.eclipse.wtp.j2ee.headless.tests.ear.operations.EARProjectCreationOperationTest;
import org.eclipse.wtp.j2ee.headless.tests.j2ee.operations.JavaEEFacetConstants;
import org.eclipse.wtp.j2ee.headless.tests.j2ee.operations.ModuleProjectCreationOperationTest;

public class UtilityProjectCreationOperationTest
extends ModuleProjectCreationOperationTest {
    public UtilityProjectCreationOperationTest() {
        super("JavaUtilityProjectCreationOperationTests");
    }

    public UtilityProjectCreationOperationTest(String name) {
        super(name);
    }

    public static Test suite() {
        return new SimpleTestSuite(UtilityProjectCreationOperationTest.class);
    }

    public void testUtility_Defaults() throws Exception {
        IDataModel dm = UtilityProjectCreationOperationTest.getUtilityDataModel("aJavaUtility", null);
        OperationTestCase.runAndVerify((IDataModel)dm);
    }

    public void testUtility_AddToEAR() throws Exception {
        IDataModel dm = UtilityProjectCreationOperationTest.getUtilityDataModel("bJavaUtility", "bEAR");
        OperationTestCase.runAndVerify((IDataModel)dm);
    }

    public void testUtility_AddToExisitingEAR12() throws Exception {
        IDataModel earModel = EARProjectCreationOperationTest.getEARDataModel("cEAR", null, null, null, JavaEEFacetConstants.EAR_12, true);
        UtilityProjectCreationOperationTest.runDataModel((IDataModel)earModel);
        IDataModel dm = UtilityProjectCreationOperationTest.getUtilityDataModel("cJavaUtility", "cEAR");
        OperationTestCase.runAndVerify((IDataModel)dm);
    }

    public void testUtility_AddToExisitingEAR13() throws Exception {
        IDataModel earModel = EARProjectCreationOperationTest.getEARDataModel("dEAR", null, null, null, JavaEEFacetConstants.EAR_13, true);
        UtilityProjectCreationOperationTest.runDataModel((IDataModel)earModel);
        IDataModel dm = UtilityProjectCreationOperationTest.getUtilityDataModel("dJavaUtility", "dEAR");
        OperationTestCase.runAndVerify((IDataModel)dm);
    }

    public void testUtility_AddToExisitingEAR14() throws Exception {
        IDataModel earModel = EARProjectCreationOperationTest.getEARDataModel("eEAR", null, null, null, JavaEEFacetConstants.EAR_14, true);
        UtilityProjectCreationOperationTest.runDataModel((IDataModel)earModel);
        IDataModel dm = UtilityProjectCreationOperationTest.getUtilityDataModel("eJavaUtility", "eEAR");
        OperationTestCase.runAndVerify((IDataModel)dm);
    }

    public void testUtility_AddToExisitingEAR5_WithoutDD() throws Exception {
        IDataModel earModel = EARProjectCreationOperationTest.getEARDataModel("fEAR", null, null, null, JavaEEFacetConstants.EAR_5, false);
        UtilityProjectCreationOperationTest.runDataModel((IDataModel)earModel);
        IDataModel dm = UtilityProjectCreationOperationTest.getUtilityDataModel("fJavaUtility", "fEAR");
        OperationTestCase.runAndVerify((IDataModel)dm);
    }

    public void testUtility_AddToExisitingEAR5_WithDD() throws Exception {
        IDataModel earModel = EARProjectCreationOperationTest.getEARDataModel("gEAR", null, null, null, JavaEEFacetConstants.EAR_5, true);
        UtilityProjectCreationOperationTest.runDataModel((IDataModel)earModel);
        IDataModel dm = UtilityProjectCreationOperationTest.getUtilityDataModel("gJavaUtility", "gEAR");
        OperationTestCase.runAndVerify((IDataModel)dm);
    }

    public static IDataModel getUtilityDataModel(String projName, String earName) {
        IDataModel model = DataModelFactory.createDataModel((IDataModelProvider)new UtilityProjectCreationDataModelProvider());
        model.setProperty("IFacetDataModelProperties.FACET_PROJECT_NAME", (Object)projName);
        if (earName != null) {
            model.setProperty("IJ2EEFacetProjectCreationDataModelProperties.ADD_TO_EAR", (Object)true);
            model.setProperty("IJ2EEFacetProjectCreationDataModelProperties.EAR_PROJECT_NAME", (Object)earName);
        } else {
            model.setProperty("IJ2EEFacetProjectCreationDataModelProperties.ADD_TO_EAR", (Object)false);
        }
        return model;
    }
}

