/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.ejb;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.Enumerator;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.jem.java.JavaClass;
import org.eclipse.jem.java.JavaRefFactory;
import org.eclipse.jem.java.Method;
import org.eclipse.jst.j2ee.ejb.ContainerManagedEntity;
import org.eclipse.jst.j2ee.ejb.EjbFactory;
import org.eclipse.jst.j2ee.ejb.EjbMethodElementComparator;
import org.eclipse.jst.j2ee.ejb.EjbPackage;
import org.eclipse.jst.j2ee.ejb.EnterpriseBean;
import org.eclipse.jst.j2ee.ejb.Entity;
import org.eclipse.jst.j2ee.ejb.MethodElement;
import org.eclipse.jst.j2ee.ejb.MethodElementKind;
import org.eclipse.jst.j2ee.ejb.MethodPermission;
import org.eclipse.jst.j2ee.ejb.MethodTransaction;
import org.eclipse.jst.j2ee.ejb.Query;
import org.eclipse.jst.j2ee.ejb.QueryMethod;
import org.eclipse.jst.j2ee.ejb.Session;
import org.eclipse.jst.j2ee.ejb.internal.impl.EjbFactoryImpl;

public class EjbMethodElementHelper {
    public static final int ALL_METHODS = 0;
    public static final int HOME_METHODS = 1;
    public static final int CLIENT_METHODS = 2;
    public static final int REMOTE_METHODS = 3;
    public static final int LOCAL_METHODS = 4;
    public static final int LOCAL_HOME_METHODS = 5;
    public static final int LOCAL_REMOTE_METHODS = 6;
    protected EjbMethodElementComparator defaultMEComparator;
    protected EjbMethodElementComparator defaultMethodElementComparator;
    private static EjbMethodElementHelper singleton;
    public static final String DEFAULT_METHOD_NAME = "*";
    protected static final String METHOD_ELEMENT_NAME = "MethodElement";

    public static EjbMethodElementHelper singleton() {
        if (singleton == null) {
            singleton = new EjbMethodElementHelper();
        }
        return singleton;
    }

    public boolean isMethodElementsEqual(MethodElement me1, MethodElement me2) {
        return me1.getSignature().equals(me2.getSignature()) && me1.getEnterpriseBean() == me2.getEnterpriseBean() && me1.getMethodParams().equals(me2.getMethodParams()) && me1.getType() == me2.getType();
    }

    public boolean isMethodElementinList(List meList, Object me) {
        if (!(me instanceof MethodElement)) {
            return false;
        }
        int i = 0;
        while (i < meList.size()) {
            MethodElement element;
            if (meList.get(i) instanceof MethodElement && this.isMethodElementsEqual(element = (MethodElement)meList.get(i), (MethodElement)me)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected EjbMethodElementComparator getDefaultMEComparator() {
        if (this.defaultMEComparator == null) {
            this.defaultMEComparator = new EjbMethodElementComparator();
        }
        return this.defaultMEComparator;
    }

    protected void excludeQueryMethods(List result, List someQueries) {
        if (someQueries.isEmpty()) {
            return;
        }
        int size = someQueries.size();
        ArrayList<QueryMethod> methods = new ArrayList<QueryMethod>(size);
        Query query = null;
        int i = 0;
        while (i < size) {
            query = (Query)someQueries.get(i);
            methods.add(query.getQueryMethod());
            ++i;
        }
        this.excludeMethodElements(result, methods);
    }

    public List getAvailableSelectQueryMethodsExcludingExisting(ContainerManagedEntity cmp) {
        if (cmp == null) {
            return Collections.EMPTY_LIST;
        }
        List result = cmp.getAvailableSelectQueryMethods();
        EList existing = cmp.getQueries();
        this.excludeQueryMethods(result, (List)existing);
        return result;
    }

    public List getAvailableFindQueryMethodsExcludingExisting(ContainerManagedEntity cmp) {
        if (cmp == null) {
            return Collections.EMPTY_LIST;
        }
        List result = cmp.getAvailableFindQueryMethods();
        EList existing = cmp.getQueries();
        this.excludeQueryMethods(result, (List)existing);
        return result;
    }

    public List getExistingOrAvailableTransactionMethodElements(EObject object, EnterpriseBean bean) {
        ArrayList result = new ArrayList();
        result.addAll(this.getAvailableMethodTransactionMethodElementsExcludingExisting(bean));
        this.unionMethodElements(result, this.getExistingMethodElements(object, bean));
        Collections.sort(result, this.getDefaultMethodElementComparator());
        return result;
    }

    protected EjbMethodElementComparator getDefaultMethodElementComparator() {
        if (this.defaultMethodElementComparator == null) {
            this.defaultMethodElementComparator = new EjbMethodElementComparator();
        }
        return this.defaultMethodElementComparator;
    }

    protected List getExistingMethodElements(EObject refObject, EnterpriseBean bean) {
        if (refObject != null) {
            EjbPackage pack = this.getEjbPackage();
            if (refObject.eClass() == pack.getMethodTransaction()) {
                return ((MethodTransaction)refObject).getMethodElements(bean);
            }
            if (refObject.eClass() == pack.getMethodPermission()) {
                return ((MethodPermission)refObject).getMethodElements(bean);
            }
        }
        return Collections.EMPTY_LIST;
    }

    protected void unionMethodElements(List sourceMethodElements, List additionalMethodElements) {
        int sourceSize = sourceMethodElements.size();
        int addSize = additionalMethodElements.size();
        ArrayList<MethodElement> foundElements = new ArrayList<MethodElement>(addSize);
        boolean found = false;
        int i = 0;
        while (i < addSize) {
            found = false;
            MethodElement additionalME = (MethodElement)additionalMethodElements.get(i);
            MethodElement sourceME = null;
            int ii = 0;
            while (ii < sourceSize) {
                sourceME = (MethodElement)sourceMethodElements.get(ii);
                if (sourceME.isEquivalent(additionalME)) {
                    found = true;
                    break;
                }
                ++ii;
            }
            if (found) {
                foundElements.add(sourceME);
            }
            ++i;
        }
        sourceMethodElements.removeAll(foundElements);
        sourceMethodElements.addAll(additionalMethodElements);
    }

    public List getAvailableMethodTransactionMethodElementsExcludingExisting(EnterpriseBean bean) {
        ArrayList result = new ArrayList();
        List<Object> filteredMethods = new ArrayList();
        if (bean.isEntity()) {
            if (bean.getRemoteInterface() != null) {
                filteredMethods = bean.getRemoteInterface().getMethodsExtendedWithFilters(Collections.EMPTY_LIST, this.getEntityMethodTransactionExcludedMethods((Entity)bean, 3));
                result.addAll(this.createMethodElements(this.getMethodElementSignatures(filteredMethods), (Enumerator)MethodElementKind.REMOTE_LITERAL, bean));
            }
            if (bean.getHomeInterface() != null) {
                filteredMethods = bean.getHomeInterface().getMethodsExtendedWithFilters(Collections.EMPTY_LIST, this.getEntityMethodTransactionExcludedMethods((Entity)bean, 1));
                result.addAll(this.createMethodElements(this.getMethodElementSignatures(filteredMethods), (Enumerator)MethodElementKind.HOME_LITERAL, bean));
            }
            if (bean.getLocalInterface() != null) {
                filteredMethods = bean.getLocalInterface().getMethodsExtendedWithFilters(Collections.EMPTY_LIST, this.getEntityMethodTransactionExcludedMethods((Entity)bean, 4));
                result.addAll(this.createMethodElements(this.getMethodElementSignatures(filteredMethods), (Enumerator)MethodElementKind.LOCAL_LITERAL, bean));
            }
            if (bean.getLocalHomeInterface() != null) {
                result.addAll(bean.getAvailableLocalHomeMethodElements());
            }
            result.addAll(bean.getAvailableUnspecifiedMethodElements());
        } else if (bean.isSession()) {
            if (bean.getRemoteInterface() != null) {
                filteredMethods = bean.getRemoteInterface().getMethodsExtendedWithFilters(this.getSessionMethodTransactionExcludedClasses((Session)bean, 3), Collections.EMPTY_LIST);
                result.addAll(this.createMethodElements(this.getMethodElementSignatures(filteredMethods), (Enumerator)MethodElementKind.REMOTE_LITERAL, bean));
            }
            if (bean.getLocalInterface() != null) {
                filteredMethods = bean.getLocalInterface().getMethodsExtendedWithFilters(this.getSessionMethodTransactionExcludedClasses((Session)bean, 4), Collections.EMPTY_LIST);
                result.addAll(this.createMethodElements(this.getMethodElementSignatures(filteredMethods), (Enumerator)MethodElementKind.LOCAL_LITERAL, bean));
            }
            result.add(bean.getAvailableUnspecifiedMethodElements().get(0));
        } else if (bean.isMessageDriven()) {
            filteredMethods = Arrays.asList(this.getMethod(bean.getEjbClass(), this.getMDBMethod_Sig()));
            result.addAll(bean.createMethodElements(filteredMethods, bean.getEjbClass()));
        }
        return result;
    }

    public List getMethodElementSignatures(List methods) {
        ArrayList<String> sameNames = new ArrayList<String>();
        ArrayList<String> signatures = new ArrayList<String>(methods.size() + 1);
        signatures.add(DEFAULT_METHOD_NAME);
        Iterator it = methods.iterator();
        while (it.hasNext()) {
            Method aMethod = (Method)it.next();
            String methodName = aMethod.getName();
            if (sameNames.contains(methodName)) {
                if (!signatures.contains(methodName)) {
                    signatures.add(methodName);
                }
            } else {
                sameNames.add(methodName);
            }
            signatures.add(aMethod.getMethodElementSignature());
        }
        Collections.sort(signatures);
        return signatures;
    }

    protected List createMethodElements(List signatures, Enumerator aType, EnterpriseBean bean) {
        return this.createMethodElements(METHOD_ELEMENT_NAME, signatures, aType, bean);
    }

    protected EjbPackage getEjbPackage() {
        return EjbFactoryImpl.getPackage();
    }

    protected EjbFactory getEjbFactory() {
        return ((EjbPackage)EPackage.Registry.INSTANCE.getEPackage("ejb.xmi")).getEjbFactory();
    }

    protected List createMethodElements(String meTypeName, List signatures, Enumerator aType, EnterpriseBean bean) {
        int size = signatures.size();
        ArrayList<MethodElement> methodElements = new ArrayList<MethodElement>(size);
        int i = 0;
        while (i < size) {
            String signature = (String)signatures.get(i);
            MethodElement me = (MethodElement)this.getEjbFactory().create((EClass)this.getEjbPackage().getEClassifier(meTypeName));
            me.initializeFromSignature(signature);
            me.setEnterpriseBean(bean);
            me.setType((MethodElementKind)aType);
            methodElements.add(me);
            ++i;
        }
        return methodElements;
    }

    protected List getEntityMethodTransactionExcludedMethods(Entity entity, int type) {
        ArrayList<Object> result = new ArrayList<Object>();
        switch (type) {
            case 3: {
                JavaClass aClass = this.getEJBObjectClass(entity);
                aClass.getClassImport();
                result.addAll(this.excludeMethods(aClass, Arrays.asList(this.getMethod(aClass, this.getRemoteRemoveMethod_Sig()))));
                break;
            }
            case 1: {
                JavaClass aClass = this.getEJBHomeClass(entity);
                aClass.getClassImport();
                result.addAll(Arrays.asList(this.getMethod(aClass, this.getEjbGetMetaDataMethod_Sig()), this.getMethod(aClass, this.getEjbGetHomeHandleMethod_Sig())));
                break;
            }
            case 4: {
                JavaClass aClass = this.getEJBLocalObjectClass(entity);
                aClass.getClassImport();
                result.addAll(this.excludeMethods(aClass, Arrays.asList(this.getMethod(aClass, this.getLocalRemoveMethod_Sig()))));
            }
        }
        return result;
    }

    protected List getSessionMethodTransactionExcludedClasses(Session session, int type) {
        ArrayList result = new ArrayList();
        switch (type) {
            case 3: {
                String className = this.getEJBObjectClassName();
                Object[] allInterfaces = session.getRemoteInterface().getImplementsInterfaces().toArray();
                result.addAll(this.getInterfaces(allInterfaces, className));
                break;
            }
            case 4: {
                String className = this.getEJBLocalObjectClassName();
                Object[] allInterfaces = session.getLocalInterface().getImplementsInterfaces().toArray();
                result.addAll(this.getInterfaces(allInterfaces, className));
            }
        }
        return result;
    }

    protected List excludeMethods(JavaClass aClass, List methods) {
        EList currentMethods = aClass.getMethods();
        ArrayList resultMethods = new ArrayList();
        int i = 0;
        while (i < currentMethods.size()) {
            if (!methods.contains(currentMethods.get(i))) {
                resultMethods.add(currentMethods.get(i));
            }
            ++i;
        }
        return resultMethods;
    }

    protected Method getMethod(JavaClass aClass, String methodName) {
        EList currentMethods = aClass.getMethods();
        int i = 0;
        while (i < currentMethods.size()) {
            Method method = (Method)currentMethods.get(i);
            if (methodName.equals(method.getSignature())) {
                return method;
            }
            ++i;
        }
        return null;
    }

    protected Method getMethodUsingMethodSig(JavaClass aClass, String methodName) {
        EList currentMethods = aClass.getMethods();
        int i = 0;
        while (i < currentMethods.size()) {
            Method method = (Method)currentMethods.get(i);
            if (methodName.equals(method.getSignature())) {
                return method;
            }
            ++i;
        }
        return null;
    }

    public List getInterfaces(Object[] interfaces, String aEjbObjectClassName) {
        ArrayList<Object> extractedInterfaces = new ArrayList<Object>();
        int i = 0;
        while (i < interfaces.length) {
            if (((JavaClass)interfaces[i]).getQualifiedName().equals(aEjbObjectClassName)) {
                extractedInterfaces.add(interfaces[i]);
            }
            ++i;
        }
        return extractedInterfaces;
    }

    public List getAvailableMethodElementsExcludingExisting(EnterpriseBean ejb, List someMethodElementOwners, EReference methodElementReference, int usageFlag) {
        return this.getAvailableMethodElementsExcludingExisting(ejb, someMethodElementOwners, methodElementReference, this.getDefaultMEComparator(), usageFlag);
    }

    public List getAvailableMethodElementsExcludingExisting(EnterpriseBean ejb, List someMethodElementOwners, EReference methodElementReference) {
        return this.getAvailableMethodElementsExcludingExisting(ejb, someMethodElementOwners, methodElementReference, this.getDefaultMEComparator());
    }

    public List getAvailableMethodElementsExcludingExisting(EnterpriseBean ejb, List someMethodElementOwners, EReference methodElementReference, Comparator comparator) {
        return this.getAvailableMethodElementsExcludingExisting(ejb, someMethodElementOwners, methodElementReference, comparator, 0);
    }

    protected List getExistingMethodElements(List someMethodElementOwners, EReference methodElementReference) {
        if (someMethodElementOwners == null || someMethodElementOwners.isEmpty() || methodElementReference == null || !methodElementReference.isMany()) {
            return Collections.EMPTY_LIST;
        }
        ArrayList result = new ArrayList();
        int size = someMethodElementOwners.size();
        EObject owner = null;
        int i = 0;
        while (i < size) {
            owner = (EObject)someMethodElementOwners.get(i);
            result.addAll((List)owner.eGet((EStructuralFeature)methodElementReference));
            ++i;
        }
        return result;
    }

    public List getAvailableMethodElementsExcludingExisting(EnterpriseBean ejb, List someMethodElementOwners, EReference methodElementReference, Comparator comparator, int usageFlag) {
        boolean showClients;
        if (ejb == null) {
            return Collections.EMPTY_LIST;
        }
        ArrayList result = new ArrayList();
        boolean showHomes = usageFlag == 0 || usageFlag == 1;
        boolean bl = showClients = usageFlag == 0 || usageFlag == 2;
        if (showHomes) {
            result.addAll(ejb.getAvailableHomeMethodElements());
        }
        if (showClients) {
            result.addAll(ejb.getAvailableRemoteMethodElements());
        }
        if (showHomes) {
            result.addAll(ejb.getAvailableLocalHomeMethodElements());
        }
        if (showClients) {
            result.addAll(ejb.getAvailableLocalMethodElements());
        }
        result.addAll(ejb.getAvailableUnspecifiedMethodElements());
        this.excludeMethodElements(result, this.getExistingMethodElements(someMethodElementOwners, methodElementReference));
        Collections.sort(result, comparator);
        return result;
    }

    protected void excludeMethodElements(List sourceMethodElements, List existingMethodElements) {
        int sourceSize = sourceMethodElements.size();
        int existingSize = existingMethodElements.size();
        ArrayList<MethodElement> foundElements = new ArrayList<MethodElement>(existingSize);
        boolean found = false;
        int i = 0;
        while (i < existingSize) {
            found = false;
            MethodElement existingME = (MethodElement)existingMethodElements.get(i);
            MethodElement sourceME = null;
            int ii = 0;
            while (ii < sourceSize) {
                sourceME = (MethodElement)sourceMethodElements.get(ii);
                if (existingME != null && existingME.getName() != null && sourceME.getSignature().equals(existingME.getSignature()) && sourceME.getTypeJavaClass() == existingME.getTypeJavaClass()) {
                    if (sourceME.getTypeJavaClass() != null) {
                        found = true;
                        break;
                    }
                    if (sourceME.getEnterpriseBean().getEjbClass() == existingME.getEnterpriseBean().getEjbClass()) {
                        found = true;
                        break;
                    }
                }
                ++ii;
            }
            if (found) {
                foundElements.add(sourceME);
            }
            ++i;
        }
        sourceMethodElements.removeAll(foundElements);
    }

    private String getEjbGetHomeHandleMethod_Sig() {
        return "Public abstract javax.ejb.HomeHandle javax.ejb.EJBHome.getHomeHandle() throws java.rmi.RemoteException";
    }

    private String getEjbGetMetaDataMethod_Sig() {
        return "Public abstract javax.ejb.EJBMetaData javax.ejb.EJBHome.getEJBMetaData() throws java.rmi.RemoteException";
    }

    private String getRemoteRemoveMethod_Sig() {
        return "Public abstract void javax.ejb.EJBObject.remove() throws java.rmi.RemoteException,javax.ejb.RemoveException";
    }

    private String getLocalRemoveMethod_Sig() {
        return "Public abstract void javax.ejb.EJBLocalObject.remove() throws java.rmi.RemoteException,javax.ejb.RemoveException";
    }

    private String getMDBMethod_Sig() {
        return "public void onMessage(javax.jms.Message msg)";
    }

    private String getEJBObjectClassName() {
        return "javax.ejb.EJBObject";
    }

    private String getEJBLocalObjectClassName() {
        return "javax.ejb.EJBLocalObject";
    }

    private JavaClass getEJBObjectClass(EnterpriseBean bean) {
        Resource res = bean.eResource();
        ResourceSet set = res != null ? res.getResourceSet() : null;
        return (JavaClass)JavaRefFactory.eINSTANCE.reflectType("javax.ejb", "EJBObject", set);
    }

    private JavaClass getEJBLocalObjectClass(EnterpriseBean bean) {
        Resource res = bean.eResource();
        ResourceSet set = res != null ? res.getResourceSet() : null;
        return (JavaClass)JavaRefFactory.eINSTANCE.reflectType("javax.ejb", "EJBLocalObject", set);
    }

    private JavaClass getEJBHomeClass(EnterpriseBean bean) {
        Resource res = bean.eResource();
        ResourceSet set = res != null ? res.getResourceSet() : null;
        return (JavaClass)JavaRefFactory.eINSTANCE.reflectType("javax.ejb", "EJBHome", set);
    }
}

