/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.ejb.annotations.internal.xdoclet;

import java.util.ArrayList;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jst.j2ee.ejb.annotations.internal.xdoclet.XDocletRuntime;

public class XDocletExtensionUtil {
    public static XDocletRuntime[] getRuntimes() {
        IExtension[] extensions = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.jst.j2ee.ejb.annotations.xdoclet.xdocletRuntime").getExtensions();
        XDocletRuntime[] runtimes = new XDocletRuntime[extensions.length];
        int i = 0;
        while (i < extensions.length) {
            runtimes[i] = new XDocletRuntime();
            IExtension extension = extensions[i];
            IConfigurationElement configurationElement = XDocletExtensionUtil.getRuntimeElement(extension);
            if (configurationElement != null) {
                runtimes[i].setVersion(configurationElement.getAttribute("xdoclet"));
                IConfigurationElement[] libs = XDocletExtensionUtil.getRuntimeLibraries(extension);
                String[] libsArray = new String[libs.length];
                int j = 0;
                while (j < libs.length) {
                    IConfigurationElement aLibrary = libs[j];
                    libsArray[j] = aLibrary.getAttribute("location");
                    ++j;
                }
                runtimes[i].setLibs(libsArray);
            }
            ++i;
        }
        return runtimes;
    }

    public static XDocletRuntime getRuntime(String versionID) {
        IExtension[] extensions = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.jst.j2ee.ejb.annotations.xdoclet.xdocletRuntime").getExtensions();
        int i = 0;
        while (i < extensions.length) {
            XDocletRuntime runtime = new XDocletRuntime();
            IExtension extension = extensions[i];
            IConfigurationElement configurationElement = XDocletExtensionUtil.getRuntimeElement(extension);
            if (configurationElement != null && versionID.equals(configurationElement.getAttribute("xdoclet"))) {
                runtime.setVersion(configurationElement.getAttribute("xdoclet"));
                IConfigurationElement[] libs = XDocletExtensionUtil.getRuntimeLibraries(extension);
                String[] libsArray = new String[libs.length];
                int j = 0;
                while (j < libs.length) {
                    IConfigurationElement aLibrary = libs[j];
                    libsArray[j] = aLibrary.getAttribute("location");
                    ++j;
                }
                runtime.setLibs(libsArray);
                return runtime;
            }
            ++i;
        }
        return null;
    }

    public static IConfigurationElement getRuntimeElement(IExtension extension) {
        IConfigurationElement[] elements = extension.getConfigurationElements();
        if (elements != null) {
            int j = 0;
            while (j < elements.length) {
                IConfigurationElement element = elements[j];
                if ("RuntimeVersion".equals(element.getName())) {
                    return element;
                }
                ++j;
            }
        }
        return null;
    }

    public static IConfigurationElement[] getRuntimeLibraries(IExtension extension) {
        ArrayList<IConfigurationElement> arrayList = new ArrayList<IConfigurationElement>();
        IConfigurationElement[] elements = extension.getConfigurationElements();
        if (elements != null) {
            int j = 0;
            while (j < elements.length) {
                IConfigurationElement element = elements[j];
                if ("RuntimeLib".equals(element.getName())) {
                    arrayList.add(element);
                }
                ++j;
            }
        }
        return arrayList.toArray(new IConfigurationElement[arrayList.size()]);
    }
}

