/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.ejb.annotations.internal.xdoclet.ui;

import java.util.HashMap;
import java.util.Iterator;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jst.j2ee.ejb.annotations.internal.xdoclet.XDocletPreferenceStore;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class AttributesDecorator {
    private IExtension extension;
    private IConfigurationElement tag;
    private IConfigurationElement[] params;
    HashMap allProperties = new HashMap();
    private XDocletPreferenceStore preferenceStore;

    public AttributesDecorator(IExtension extension, XDocletPreferenceStore preferenceStore) {
        this.extension = extension;
        this.params = this.extension.getConfigurationElements();
        this.tag = this.params[0];
        this.preferenceStore = preferenceStore;
    }

    public void decorate(Composite composite) {
        Group attributes = new Group(composite, 0);
        attributes.setText("Attributes " + this.tag.getAttribute("name"));
        attributes.setToolTipText(this.tag.getAttribute("description"));
        GridLayout layout = new GridLayout(4, false);
        attributes.setLayout((Layout)layout);
        GridData attributesGrid = new GridData(1808);
        attributes.setLayoutData((Object)attributesGrid);
        this.allProperties = new HashMap();
        int i = 1;
        while (i < this.params.length) {
            final IConfigurationElement attribute = this.params[i];
            Group attributeGroup = new Group((Composite)attributes, 0);
            attributeGroup.setText(attribute.getAttribute("label"));
            attributeGroup.setToolTipText(attribute.getAttribute("description"));
            layout = new GridLayout(3, false);
            attributeGroup.setLayout((Layout)layout);
            GridData gridData = new GridData(1808);
            attributeGroup.setLayoutData((Object)gridData);
            this.createAttributeControl((Composite)attributeGroup, attribute);
            String includeId = String.valueOf(attribute.getAttribute("id")) + ".include";
            Button bool = this.createLabeledCheck("include", this.preferenceStore.getBooleanProperty(includeId), (Composite)attributes);
            bool.setData((Object)attribute);
            this.allProperties.put(includeId, bool);
            bool.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    String id = attribute.getAttribute("id");
                    AttributesDecorator.this.preferenceStore.setProperty(String.valueOf(id) + ".include", ((Button)e.item).getSelection());
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                    this.widgetSelected(e);
                }
            });
            ++i;
        }
        Dialog.applyDialogFont((Control)composite);
    }

    private void createAttributeControl(Composite parent, IConfigurationElement attribute) {
        String type = attribute.getAttribute("type");
        if ("string".equals(type)) {
            Text str = this.createLabeledText("", this.preferenceStore.getProperty(attribute.getAttribute("id")), parent);
            str.setData((Object)attribute);
            this.allProperties.put(attribute.getAttribute("id"), str);
        } else if ("boolean".equals(type)) {
            Button bool = this.createLabeledCheck("", this.preferenceStore.getBooleanProperty(attribute.getAttribute("id")), parent);
            bool.setData((Object)attribute);
            this.allProperties.put(attribute.getAttribute("id"), bool);
        } else if ("enum".equals(type)) {
            Combo combo = this.createLabeledCombo(parent, attribute);
            combo.setData((Object)attribute);
            this.allProperties.put(attribute.getAttribute("id"), combo);
        }
    }

    private Combo createLabeledCombo(Composite defPanel, IConfigurationElement attribute) {
        Label label = new Label(defPanel, 64);
        GridData gridData = new GridData();
        label.setLayoutData((Object)gridData);
        label.setText("");
        Combo combo = new Combo(defPanel, 8);
        gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        combo.setLayoutData((Object)gridData);
        String value = this.preferenceStore.getProperty(attribute.getAttribute("id"));
        StringTokenizer tokenizer = new StringTokenizer(attribute.getAttribute("restriction"), ",");
        int i = 0;
        int sel = 0;
        while (tokenizer.hasMoreTokens()) {
            String item = tokenizer.nextToken().trim();
            if (item.equals(value)) {
                sel = i;
            }
            combo.add(item);
            ++i;
        }
        if (combo.getItemCount() > 0) {
            combo.select(sel);
        }
        return combo;
    }

    private Button createLabeledCheck(String title, boolean value, Composite defPanel) {
        Label label = new Label(defPanel, 64);
        GridData gridData = new GridData();
        label.setLayoutData((Object)gridData);
        label.setText(title);
        Button fButton = new Button(defPanel, 32);
        gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        fButton.setLayoutData((Object)gridData);
        fButton.setSelection(value);
        fButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        return fButton;
    }

    private Text createLabeledText(String title, String value, Composite defPanel) {
        Label label = new Label(defPanel, 64);
        GridData gridData = new GridData();
        label.setLayoutData((Object)gridData);
        label.setText(title);
        Text text = new Text(defPanel, 2052);
        gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        text.setLayoutData((Object)gridData);
        text.setText(value);
        return text;
    }

    public void save() {
        Iterator iterator = this.allProperties.keySet().iterator();
        while (iterator.hasNext()) {
            Combo combo;
            String value;
            String key = (String)iterator.next();
            Object widget = this.allProperties.get(key);
            if (widget instanceof Text) {
                Text text = (Text)widget;
                value = text.getText();
                this.preferenceStore.setProperty(key, value);
                continue;
            }
            if (widget instanceof Button) {
                Button bool = (Button)widget;
                this.preferenceStore.setProperty(key, bool.getSelection());
                continue;
            }
            if (!(widget instanceof Combo) || (combo = (Combo)widget).getSelectionIndex() < 0) continue;
            value = combo.getItem(combo.getSelectionIndex());
            this.preferenceStore.setProperty(key, value);
        }
    }
}

