/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.internal;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jst.j2ee.internal.AddModulestoEARPropertiesPage;
import org.eclipse.jst.j2ee.internal.IJ2EEDependenciesControl;
import org.eclipse.jst.j2ee.internal.JARDependencyPropertiesPage;
import org.eclipse.jst.j2ee.internal.ManifestUIResourceHandler;
import org.eclipse.jst.j2ee.internal.WebLibDependencyPropertiesPage;
import org.eclipse.jst.j2ee.internal.plugin.J2EEUIMessages;
import org.eclipse.jst.j2ee.internal.project.J2EEProjectUtilities;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.PropertyPage;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;

public class J2EEDependenciesPage
extends PropertyPage {
    public String DESCRIPTION = J2EEUIMessages.getResourceString("DESCRIPTION");
    private IProject project;
    private IJ2EEDependenciesControl[] controls;
    static /* synthetic */ Class class$0;

    protected Control createContents(Composite parent) {
        IAdaptable iAdaptable = this.getElement();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.core.resources.IResource");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.project = (IProject)iAdaptable.getAdapter((Class)clazz);
        boolean isEAR = false;
        boolean isWEB = false;
        try {
            IFacetedProject facetedProject = ProjectFacetsManager.create((IProject)this.project);
            isEAR = facetedProject.hasProjectFacet(ProjectFacetsManager.getProjectFacet((String)"jst.ear"));
            isWEB = facetedProject.hasProjectFacet(ProjectFacetsManager.getProjectFacet((String)"jst.web"));
        }
        catch (CoreException coreException) {
            String errorCheckingFacet = ManifestUIResourceHandler.Error_Checking_Project_Facets;
            this.setErrorMessage(errorCheckingFacet);
            this.setValid(false);
            return this.getErrorComposite(parent, errorCheckingFacet);
        }
        if (isEAR) {
            return this.createEARContent(parent);
        }
        if (isWEB) {
            return this.createWebContent(parent);
        }
        return this.createNonEARContent(parent);
    }

    private Composite getErrorComposite(Composite parent, String error) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginWidth = 0;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(1808));
        Label label = new Label(composite, 0);
        label.setText(error);
        return composite;
    }

    private Composite createEARContent(Composite parent) {
        this.controls = new IJ2EEDependenciesControl[1];
        this.controls[0] = new AddModulestoEARPropertiesPage(this.project, this);
        return this.controls[0].createContents(parent);
    }

    private Composite createWebContent(Composite parent) {
        boolean standalone = J2EEProjectUtilities.isStandaloneProject((IProject)this.project);
        if (standalone) {
            this.controls = new IJ2EEDependenciesControl[1];
            this.controls[0] = new WebLibDependencyPropertiesPage(this.project, this);
            return this.controls[0].createContents(parent);
        }
        TabFolder folder = new TabFolder(parent, 16384);
        folder.setLayoutData((Object)new GridData(1808));
        folder.setFont(parent.getFont());
        this.controls = new IJ2EEDependenciesControl[2];
        this.controls[0] = new JARDependencyPropertiesPage(this.project, this);
        TabItem tab = new TabItem(folder, 0);
        tab.setControl((Control)this.controls[0].createContents((Composite)folder));
        tab.setText(ManifestUIResourceHandler.J2EE_Modules);
        this.controls[1] = new WebLibDependencyPropertiesPage(this.project, this);
        tab = new TabItem(folder, 0);
        tab.setControl((Control)this.controls[1].createContents((Composite)folder));
        tab.setText(ManifestUIResourceHandler.Web_Libraries);
        folder.setSelection(0);
        return folder;
    }

    private Composite createNonEARContent(Composite parent) {
        this.controls = new IJ2EEDependenciesControl[1];
        this.controls[0] = new JARDependencyPropertiesPage(this.project, this);
        return this.controls[0].createContents(parent);
    }

    public boolean performOk() {
        int i = 0;
        while (i < this.controls.length) {
            if (!this.controls[i].performOk()) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public void performDefaults() {
        int i = 0;
        while (i < this.controls.length) {
            this.controls[i].performDefaults();
            ++i;
        }
    }

    public boolean performCancel() {
        int i = 0;
        while (i < this.controls.length) {
            if (!this.controls[i].performCancel()) {
                return false;
            }
            ++i;
        }
        return super.performCancel();
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        int i = 0;
        while (i < this.controls.length) {
            this.controls[i].setVisible(visible);
            ++i;
        }
    }

    public void dispose() {
        super.dispose();
        int i = 0;
        while (i < this.controls.length) {
            this.controls[i].dispose();
            ++i;
        }
    }

    protected static void createDescriptionComposite(Composite parent, String description) {
        Composite descriptionComp = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        descriptionComp.setLayout((Layout)layout);
        descriptionComp.setLayoutData((Object)new GridData(768));
        J2EEDependenciesPage.fillDescription(descriptionComp, description);
    }

    private static void fillDescription(Composite c, String s) {
        GridData data = new GridData();
        data.horizontalSpan = 2;
        data.horizontalIndent = 15;
        data = new GridData(768);
        data.horizontalSpan = 2;
        data.horizontalIndent = 15;
        data.widthHint = 250;
        data.heightHint = 50;
        Text text = new Text(c, 2626);
        text.setLayoutData((Object)data);
        text.setTextLimit(80);
        text.setSize(250, 50);
        text.setEditable(false);
        text.setText(s);
    }
}

