/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.server.tomcat.core.internal;

import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.IVMInstallType;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jst.server.tomcat.core.internal.ITomcatRuntime;
import org.eclipse.jst.server.tomcat.core.internal.ITomcatRuntimeWorkingCopy;
import org.eclipse.jst.server.tomcat.core.internal.ITomcatVersionHandler;
import org.eclipse.jst.server.tomcat.core.internal.Messages;
import org.eclipse.jst.server.tomcat.core.internal.TomcatPlugin;
import org.eclipse.wst.server.core.IRuntimeType;
import org.eclipse.wst.server.core.model.RuntimeDelegate;

public class TomcatRuntime
extends RuntimeDelegate
implements ITomcatRuntime,
ITomcatRuntimeWorkingCopy {
    protected static final String PROP_VM_INSTALL_TYPE_ID = "vm-install-type-id";
    protected static final String PROP_VM_INSTALL_ID = "vm-install-id";
    protected static Map sdkMap = new HashMap(2);

    public ITomcatVersionHandler getVersionHandler() {
        IRuntimeType type = this.getRuntime().getRuntimeType();
        return TomcatPlugin.getTomcatVersionHandler(type.getId());
    }

    protected String getVMInstallTypeId() {
        return this.getAttribute(PROP_VM_INSTALL_TYPE_ID, null);
    }

    protected String getVMInstallId() {
        return this.getAttribute(PROP_VM_INSTALL_ID, null);
    }

    public boolean isUsingDefaultJRE() {
        return this.getVMInstallTypeId() == null;
    }

    public IVMInstall getVMInstall() {
        if (this.getVMInstallTypeId() == null) {
            return JavaRuntime.getDefaultVMInstall();
        }
        try {
            IVMInstallType vmInstallType = JavaRuntime.getVMInstallType((String)this.getVMInstallTypeId());
            IVMInstall[] vmInstalls = vmInstallType.getVMInstalls();
            int size = vmInstalls.length;
            String id = this.getVMInstallId();
            int i = 0;
            while (i < size) {
                if (id.equals(vmInstalls[i].getId())) {
                    return vmInstalls[i];
                }
                ++i;
            }
        }
        catch (Exception exception) {}
        return null;
    }

    public List getRuntimeClasspath() {
        return this.getVersionHandler().getRuntimeClasspath(this.getRuntime().getLocation());
    }

    public boolean verifyLocation() {
        return this.getVersionHandler().verifyInstallPath(this.getRuntime().getLocation());
    }

    public IStatus validate() {
        String os;
        File toolsJar;
        IStatus status = super.validate();
        if (!status.isOK()) {
            return status;
        }
        if (!this.verifyLocation()) {
            return new Status(4, "org.eclipse.jst.server.tomcat.core", 0, Messages.errorInstallDir, null);
        }
        if (this.getRuntime().getLocation().hasTrailingSeparator()) {
            return new Status(4, "org.eclipse.jst.server.tomcat.core", 0, Messages.errorInstallDirTrailingSlash, null);
        }
        if (this.getVMInstall() == null) {
            return new Status(4, "org.eclipse.jst.server.tomcat.core", 0, Messages.errorJRE, null);
        }
        boolean found = false;
        File file = this.getVMInstall().getInstallLocation();
        if (file != null && (toolsJar = new File(file, "lib" + File.separator + "tools.jar")).exists()) {
            found = true;
        }
        if (!found && (os = Platform.getOS()) != null && os.toLowerCase().indexOf("mac") >= 0) {
            found = this.checkForCompiler();
        }
        if (!found) {
            return new Status(2, "org.eclipse.jst.server.tomcat.core", 0, Messages.warningJRE, null);
        }
        return Status.OK_STATUS;
    }

    public void setDefaults(IProgressMonitor monitor) {
        IVMInstall vmInstall = JavaRuntime.getDefaultVMInstall();
        this.setVMInstall(vmInstall.getVMInstallType().getId(), vmInstall.getId());
        IRuntimeType type = this.getRuntimeWorkingCopy().getRuntimeType();
        this.getRuntimeWorkingCopy().setLocation((IPath)new Path(TomcatPlugin.getPreference("location" + type.getId())));
    }

    public void setVMInstall(IVMInstall vmInstall) {
        if (vmInstall == null) {
            this.setVMInstall(null, null);
        } else {
            this.setVMInstall(vmInstall.getVMInstallType().getId(), vmInstall.getId());
        }
    }

    protected void setVMInstall(String typeId, String id) {
        if (typeId == null) {
            this.setAttribute(PROP_VM_INSTALL_TYPE_ID, null);
        } else {
            this.setAttribute(PROP_VM_INSTALL_TYPE_ID, typeId);
        }
        if (id == null) {
            this.setAttribute(PROP_VM_INSTALL_ID, null);
        } else {
            this.setAttribute(PROP_VM_INSTALL_ID, id);
        }
    }

    /*
     * Exception decompiling
     */
    protected boolean checkForCompiler() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 7[TRYBLOCK] [5 : 309->312)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

