/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.internal.axis.creation.ui.widgets.skeleton;

import java.io.File;
import java.net.MalformedURLException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jst.ws.internal.axis.consumption.core.common.JavaWSDLParameter;
import org.eclipse.jst.ws.internal.axis.consumption.ui.AxisConsumptionUIMessages;
import org.eclipse.jst.ws.internal.axis.creation.ui.AxisCreationUIMessages;
import org.eclipse.jst.ws.internal.common.ResourceUtils;
import org.eclipse.jst.ws.internal.consumption.ui.ConsumptionUIMessages;
import org.eclipse.jst.ws.internal.ui.common.UIUtils;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.command.internal.env.ui.widgets.SimpleWidgetDataContributor;
import org.eclipse.wst.command.internal.env.ui.widgets.WidgetDataEvents;

public class SkeletonConfigWidget
extends SimpleWidgetDataContributor {
    private JavaWSDLParameter javaWSDLParam;
    private static final String INFOPOP_PBSC_PAGE = "PBSC0001";
    private Text wsdlFolderText_;
    private final String INFOPOP_PBCF_TEXT_WSDL_FOLDER = "PBCF0006";
    private Text wsdlFileText_;
    private final String INFOPOP_PBCF_TEXT_WSDL_FILE = "PBCF0007";
    private Combo skeletonFolderText_;
    private static final String INFOPOP_PBSC_TEXT_SKELETON_FOLDER = "PBSC0004";
    private Button showMappingsCheckbox_;
    private String INFOPOP_N2P_SHOW_MAPPINGS = "PBSC0016";

    public WidgetDataEvents addControls(Composite parent, Listener statusListener) {
        String pluginId = "org.eclipse.jst.ws.axis.creation.ui";
        UIUtils uiUtils = new UIUtils(pluginId);
        UIUtils conUiUtils = new UIUtils(pluginId);
        UIUtils baseConUiUtils = new UIUtils(pluginId);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, String.valueOf(pluginId) + "." + INFOPOP_PBSC_PAGE);
        parent.setToolTipText(AxisCreationUIMessages.TOOLTIP_PBSC_PAGE);
        Composite textGroup = uiUtils.createComposite(parent, 2, 0, 0);
        this.wsdlFolderText_ = uiUtils.createText(textGroup, AxisCreationUIMessages.LABEL_OUTPUT_FOLDER_NAME, AxisCreationUIMessages.TOOLTIP_PBCF_TEXT_WSDL_FOLDER, "PBCF0006", 2060);
        this.wsdlFileText_ = uiUtils.createText(textGroup, AxisCreationUIMessages.LABEL_OUTPUT_FILE_NAME, AxisCreationUIMessages.TOOLTIP_PBCF_TEXT_WSDL_FILE, "PBCF0007", 2060);
        this.skeletonFolderText_ = baseConUiUtils.createCombo(textGroup, ConsumptionUIMessages.LABEL_SKELETON_ROOT_NAME, ConsumptionUIMessages.TOOLTIP_PBSC_TEXT_SKELETON_FOLDER, INFOPOP_PBSC_TEXT_SKELETON_FOLDER, 2060);
        uiUtils.createHorizontalSeparator(parent, 5);
        this.showMappingsCheckbox_ = conUiUtils.createCheckbox(parent, AxisConsumptionUIMessages.LABEL_EXPLORE_MAPPINGS_XML2BEAN, AxisConsumptionUIMessages.TOOLTIP_N2P_SHOW_MAPPINGS, this.INFOPOP_N2P_SHOW_MAPPINGS);
        return this;
    }

    public void setEndpointURI(String endpointURI) {
    }

    public void setOutputWSDLFolder(String outputWSDLFolder) {
        if (outputWSDLFolder != null) {
            this.wsdlFolderText_.setText(outputWSDLFolder);
        }
    }

    public void setOutputWSDLFile(String outputWSDLFile) {
        if (outputWSDLFile != null) {
            this.wsdlFileText_.setText(outputWSDLFile);
        }
    }

    public void setOutputJavaFolder(String outputJavaFolder) {
        if (outputJavaFolder != null) {
            int index = this.skeletonFolderText_.indexOf(outputJavaFolder);
            if (index != -1) {
                this.skeletonFolderText_.select(index);
            } else if (this.skeletonFolderText_.getItemCount() <= 0) {
                String root = this.getWorkspaceRootLocation();
                if (outputJavaFolder.startsWith(root)) {
                    this.skeletonFolderText_.setText(outputJavaFolder.substring(root.length()));
                } else {
                    this.skeletonFolderText_.setText(outputJavaFolder);
                }
            }
        }
    }

    public void setShowMapping(boolean showMapping) {
        this.showMappingsCheckbox_.setSelection(showMapping);
    }

    public boolean getShowMapping() {
        return this.showMappingsCheckbox_.getSelection();
    }

    public JavaWSDLParameter getJavaWSDLParam() {
        String root = this.getWorkspaceRootLocation();
        File file = new File(root);
        try {
            root = file.toURL().toString();
            char lastChar = root.charAt(root.length() - 1);
            if (lastChar == '/' || lastChar == '\\') {
                root = root.substring(0, root.length() - 1);
            }
        }
        catch (MalformedURLException malformedURLException) {}
        this.javaWSDLParam.setJavaOutput(String.valueOf(root) + this.skeletonFolderText_.getText());
        return this.javaWSDLParam;
    }

    public void setJavaWSDLParam(JavaWSDLParameter javaWSDLParam) {
        this.javaWSDLParam = javaWSDLParam;
    }

    public void setServerProject(IProject serviceProject) {
        String originalSkeletonFolder = this.skeletonFolderText_.getText();
        this.skeletonFolderText_.removeAll();
        IPath[] paths = ResourceUtils.getAllJavaSourceLocations((IProject)serviceProject);
        int i = 0;
        while (i < paths.length) {
            this.skeletonFolderText_.add(paths[i].toString());
            ++i;
        }
        int index = this.skeletonFolderText_.indexOf(originalSkeletonFolder);
        if (index != -1) {
            this.skeletonFolderText_.select(index);
        } else {
            this.skeletonFolderText_.select(0);
        }
    }

    private String getWorkspaceRootLocation() {
        return ResourcesPlugin.getWorkspace().getRoot().getLocation().removeTrailingSeparator().toString();
    }
}

