/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.internal.consumption.ui.common;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.wsdl.Definition;
import javax.wsdl.Port;
import javax.wsdl.Service;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jem.util.emf.workbench.ProjectUtilities;
import org.eclipse.jst.j2ee.internal.webservice.helper.WebServicesManager;
import org.eclipse.jst.j2ee.webservice.wsdd.PortComponent;
import org.eclipse.jst.j2ee.webservice.wsdd.WSDLPort;
import org.eclipse.jst.j2ee.webservice.wsdd.WebServiceDescription;
import org.eclipse.jst.server.core.FacetUtil;
import org.eclipse.jst.ws.internal.common.J2EEUtils;
import org.eclipse.jst.ws.internal.common.ResourceUtils;
import org.eclipse.jst.ws.internal.common.ServerUtils;
import org.eclipse.jst.ws.internal.consumption.common.FacetUtils;
import org.eclipse.jst.ws.internal.consumption.ui.ConsumptionUIMessages;
import org.eclipse.jst.ws.internal.consumption.ui.common.ServerSelectionUtils;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.command.internal.env.core.common.StatusUtils;
import org.eclipse.wst.command.internal.env.core.selection.SelectionListChoices;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IProjectFacet;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.eclipse.wst.common.project.facet.core.VersionFormatException;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.IServerType;
import org.eclipse.wst.server.core.ServerCore;
import org.eclipse.wst.ws.internal.parser.wsil.WebServicesParser;

public class ValidationUtils {
    public boolean doesServerSupportProject(String serverFactoryId, String projectName) {
        IProject project = ProjectUtilities.getProject((String)projectName);
        IFacetedProject fProject = null;
        if (project.exists()) {
            try {
                fProject = ProjectFacetsManager.create((IProject)project);
            }
            catch (CoreException coreException) {}
            if (fProject != null) {
                Set facets = fProject.getProjectFacets();
                return this.doesServerSupportFacets(serverFactoryId, facets);
            }
            return true;
        }
        return true;
    }

    public boolean doesServerSupportFacets(String serverFactoryId, Set facets) {
        Set runtimes = FacetUtils.getRuntimes((Set[])new Set[]{facets});
        Iterator itr = runtimes.iterator();
        IServerType st = ServerCore.findServerType((String)serverFactoryId);
        String runtimeTypeId = st.getRuntimeType().getId();
        while (itr.hasNext()) {
            org.eclipse.wst.common.project.facet.core.runtime.IRuntime fRuntime = (org.eclipse.wst.common.project.facet.core.runtime.IRuntime)itr.next();
            IRuntime sRuntime = FacetUtil.getRuntime((org.eclipse.wst.common.project.facet.core.runtime.IRuntime)fRuntime);
            if (!runtimeTypeId.equals(sRuntime.getRuntimeType().getId())) continue;
            return true;
        }
        return false;
    }

    /*
     * Unable to fully structure code
     */
    public boolean doesServerSupportTemplate(String serverFactoryId, String templateId) {
        template = ProjectFacetsManager.getTemplate((String)templateId);
        templateFacets = template.getFixedProjectFacets();
        templateFacetsItr = templateFacets.iterator();
        while (templateFacetsItr.hasNext()) {
            block7: {
                serverSupportsThisOne = false;
                fixedFacet = (IProjectFacet)templateFacetsItr.next();
                versions = null;
                try {
                    versions = fixedFacet.getSortedVersions(true);
                    break block7;
                }
                catch (VersionFormatException v0) {
                    versionSet = fixedFacet.getVersions();
                    itr = versionSet.iterator();
                    versions = new ArrayList<E>();
                    ** while (itr.hasNext())
                }
lbl-1000:
                // 1 sources

                {
                    versions.add(itr.next());
                    continue;
lbl19:
                    // 1 sources

                    break block7;
                }
                catch (CoreException v1) {
                    versionSet = fixedFacet.getVersions();
                    itr = versionSet.iterator();
                    versions = new ArrayList<E>();
                    ** while (itr.hasNext())
                }
lbl-1000:
                // 1 sources

                {
                    versions.add(itr.next());
                    continue;
                }
            }
            versionsItr = versions.iterator();
            while (versionsItr.hasNext()) {
                pfv = (IProjectFacetVersion)versionsItr.next();
                pfvs = new HashSet<IProjectFacetVersion>();
                pfvs.add(pfv);
                if (!this.doesServerSupportFacets(serverFactoryId, pfvs)) continue;
                serverSupportsThisOne = true;
                break;
            }
            if (serverSupportsThisOne) continue;
            return false;
        }
        return true;
    }

    public IStatus validateProjectTargetAndJ2EE(String projectName, String compName, String earName, String earCompName, String serverFactoryId, String j2eeLevel) {
        IProject p = ProjectUtilities.getProject((String)projectName);
        IProject earP = null;
        if (earName != null && !earName.equalsIgnoreCase("")) {
            earP = ProjectUtilities.getProject((String)earName);
        }
        IStatus targetStatus = this.doesProjectTargetMatchServerType(p, serverFactoryId);
        if (earP != null && targetStatus.getSeverity() == 0) {
            IStatus earTargetStatus = this.doesProjectTargetMatchServerType(earP, serverFactoryId);
            if (earTargetStatus.getSeverity() == 4) {
                return earTargetStatus;
            }
        } else {
            return targetStatus;
        }
        IStatus j2eeStatus = this.doesProjectMatchJ2EELevel(p, compName, j2eeLevel);
        if (earP != null && j2eeStatus.getSeverity() == 0) {
            IStatus earJ2EEStatus = this.doesProjectMatchJ2EELevel(earP, earCompName, j2eeLevel);
            if (earJ2EEStatus.getSeverity() == 4) {
                return earJ2EEStatus;
            }
        } else {
            return j2eeStatus;
        }
        return Status.OK_STATUS;
    }

    private IStatus doesProjectTargetMatchServerType(IProject p, String serverFactoryId) {
        IRuntime projectTarget;
        if (p != null && p.exists() && (projectTarget = ServerSelectionUtils.getRuntimeTarget(p.getName())) != null) {
            String projectTargetId = projectTarget.getRuntimeType().getId();
            String serverTargetId = ServerUtils.getRuntimeTargetIdFromFactoryId((String)serverFactoryId);
            if (serverTargetId != null && serverTargetId.length() > 0 && !projectTargetId.equals(serverTargetId)) {
                return StatusUtils.errorStatus((String)NLS.bind((String)ConsumptionUIMessages.MSG_SERVER_TARGET_MISMATCH, (Object[])new String[]{p.getName()}));
            }
        }
        return Status.OK_STATUS;
    }

    private IStatus doesProjectMatchJ2EELevel(IProject p, String compName, String j2eeLevel) {
        try {
            int projectJ2EELevel;
            if (p != null && p.exists() && (projectJ2EELevel = J2EEUtils.getJ2EEVersion((IProject)p)) != -1) {
                String projectJ2EELevelString = String.valueOf(projectJ2EELevel);
                if (j2eeLevel != null && j2eeLevel.length() > 0 && !projectJ2EELevelString.equals(j2eeLevel)) {
                    return StatusUtils.errorStatus((String)NLS.bind((String)ConsumptionUIMessages.MSG_J2EE_MISMATCH, (Object[])new String[]{p.getName()}));
                }
            }
        }
        catch (Exception exception) {}
        return Status.OK_STATUS;
    }

    public IStatus validateProjectType(String projectName, SelectionListChoices runtime2ClientTypes) {
        IStatus status = Status.OK_STATUS;
        IProject p = ProjectUtilities.getProject((String)projectName);
        if (p == null || !p.exists()) {
            return status;
        }
        String[] projectNames = runtime2ClientTypes.getChoice().getChoice().getList().getList();
        int i = 0;
        while (i < projectNames.length) {
            if (projectName.equals(projectNames[i])) {
                return status;
            }
            ++i;
        }
        String clientTypeLabel = this.getClientTypeLabel(runtime2ClientTypes.getChoice().getList().getSelection());
        String message = NLS.bind((String)ConsumptionUIMessages.MSG_WRONG_CLIENT_PROJECT_TYPE, (Object[])new String[]{projectName, clientTypeLabel});
        IStatus eStatus = StatusUtils.errorStatus((String)message);
        return eStatus;
    }

    private String getClientTypeLabel(String type) {
        if (type.equals("jst.web")) {
            return ConsumptionUIMessages.LABEL_CLIENT_COMP_TYPE_WEB;
        }
        if (type.equals("jst.ejb")) {
            return ConsumptionUIMessages.LABEL_CLIENT_COMP_TYPE_EJB;
        }
        if (type.equals("jst.appclient")) {
            return ConsumptionUIMessages.LABEL_CLIENT_COMP_TYPE_APP_CLIENT;
        }
        if (type.equals("jst.utility")) {
            return ConsumptionUIMessages.LABEL_CLIENT_COMP_TYPE_CONTAINERLESS;
        }
        return type;
    }

    public boolean isProjectServiceProject(IProject p, String wsdlURL, WebServicesParser parser) {
        if (p == null || wsdlURL == null || wsdlURL.length() == 0 || parser == null) {
            return false;
        }
        IResource wsXML = this.getWebServcesXML(p);
        if (wsXML == null) {
            return false;
        }
        WebServicesManager wsm = WebServicesManager.getInstance();
        Iterator wsDescs = wsm.getInternalWebServicesDescriptions().iterator();
        ArrayList<QualifiedName> wsdlPortList = new ArrayList<QualifiedName>();
        while (wsDescs.hasNext()) {
            WebServiceDescription wsDesc = (WebServiceDescription)wsDescs.next();
            Iterator pcs = wsDesc.getPortComponents().iterator();
            while (pcs.hasNext()) {
                PortComponent pc = (PortComponent)pcs.next();
                WSDLPort wsdlPort = pc.getWsdlPort();
                wsdlPortList.add(new QualifiedName(wsdlPort.getNamespaceURI(), wsdlPort.getLocalPart()));
            }
        }
        ArrayList portList = this.getPortNamesFromWsdl(wsdlURL, parser);
        Object[] ports = portList.toArray();
        Object[] wsdlPorts = wsdlPortList.toArray();
        int i = 0;
        while (i < ports.length) {
            QualifiedName portName = (QualifiedName)ports[i];
            int j = 0;
            while (j < wsdlPorts.length) {
                QualifiedName wsdlPortName = (QualifiedName)wsdlPorts[j];
                if (portName.equals(wsdlPortName)) {
                    return true;
                }
                ++j;
            }
            ++i;
        }
        return false;
    }

    private IResource getWebServcesXML(IProject p) {
        IContainer moduleRoot = J2EEUtils.getFirstWebContentContainer((IProject)p);
        if (!(moduleRoot instanceof IContainer)) {
            return null;
        }
        IResource webServicesXML = null;
        if (ResourceUtils.isWebProject((IProject)p)) {
            StringBuffer wsPath = new StringBuffer();
            wsPath.append("WEB-INF/");
            wsPath.append("webservices.xml");
            webServicesXML = moduleRoot.findMember(wsPath.toString());
        } else {
            StringBuffer wsPath = new StringBuffer();
            wsPath.append("META-INF/");
            wsPath.append("webservices.xml");
            webServicesXML = moduleRoot.findMember(wsPath.toString());
        }
        return webServicesXML;
    }

    private ArrayList getPortNamesFromWsdl(String wsdlURL, WebServicesParser parser) {
        ArrayList<QualifiedName> portNameList = new ArrayList<QualifiedName>();
        Definition def = parser.getWSDLDefinition(wsdlURL);
        Map services = def.getServices();
        Service service = null;
        Iterator it = services.values().iterator();
        while (it.hasNext()) {
            service = (Service)it.next();
            String namespace = service.getQName().getNamespaceURI();
            Map ports = service.getPorts();
            Iterator it2 = ports.values().iterator();
            while (it2.hasNext()) {
                Port port = (Port)it2.next();
                portNameList.add(new QualifiedName(namespace, port.getName()));
            }
        }
        return portNameList;
    }

    private class QualifiedName {
        String namespaceURI;
        String localPart;

        public QualifiedName(String namespaceURI, String localPart) {
            this.namespaceURI = namespaceURI;
            this.localPart = localPart;
        }

        public String getLocalPart() {
            return this.localPart;
        }

        public void setLocalPart(String localPart) {
            this.localPart = localPart;
        }

        public String getNamespaceURI() {
            return this.namespaceURI;
        }

        public void setNamespaceURI(String namespaceURI) {
            this.namespaceURI = namespaceURI;
        }

        public boolean equals(QualifiedName qn) {
            return qn.getNamespaceURI().equals(this.namespaceURI) && qn.getLocalPart().equals(this.localPart);
        }
    }
}

