/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.internal.consumption.ui.widgets;

import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jst.j2ee.webservice.wsclient.ServiceRef;
import org.eclipse.jst.ws.internal.common.J2EEActionAdapterFactory;
import org.eclipse.jst.ws.internal.common.ResourceUtils;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.frameworks.datamodel.AbstractDataModelOperation;
import org.eclipse.wst.wsdl.internal.impl.ServiceImpl;
import org.eclipse.wst.wsdl.util.WSDLResourceImpl;

public class WSDLSelectionWidgetDefaultingCommand
extends AbstractDataModelOperation {
    private IStructuredSelection selection_;

    public String getWebServiceURI() {
        if (this.selection_ != null && !this.selection_.isEmpty()) {
            IFile ifile;
            String ext;
            Object firstSel = this.selection_.getFirstElement();
            if (firstSel instanceof IFile && (ext = (ifile = (IFile)firstSel).getFileExtension()) != null && (ext.equals("wsdl") || ext.equals("wsil") || ext.equals("html"))) {
                return ifile.getFullPath().toString();
            }
            if (firstSel instanceof ServiceImpl) {
                ServiceImpl serviceImpl = (ServiceImpl)firstSel;
                return J2EEActionAdapterFactory.getWSDLURI((ServiceImpl)serviceImpl);
            }
            if (firstSel instanceof ServiceRef) {
                ServiceRef serviceRef = (ServiceRef)firstSel;
                return J2EEActionAdapterFactory.getWSDLURI((ServiceRef)serviceRef);
            }
            if (firstSel instanceof WSDLResourceImpl) {
                WSDLResourceImpl wsdlRI = (WSDLResourceImpl)firstSel;
                return J2EEActionAdapterFactory.getWSDLURI((WSDLResourceImpl)wsdlRI);
            }
            if (firstSel instanceof String) {
                return (String)firstSel;
            }
        }
        return "";
    }

    public void setInitialSelection(IStructuredSelection selection) {
        this.selection_ = selection;
    }

    public boolean getGenWSIL() {
        return false;
    }

    public String getWsilURI() {
        String wsURI = this.getWebServiceURI();
        if (wsURI != null && wsURI.length() > 0 && wsURI.endsWith("wsdl")) {
            StringBuffer sb = new StringBuffer(wsURI.substring(0, wsURI.length() - 4));
            sb.append("wsil");
            return sb.toString();
        }
        return "";
    }

    public IProject getProject() {
        IProject p = this.getProjectFromInitialSelection(this.selection_);
        return p;
    }

    public String getComponentName() {
        String cname = this.getComponentNameFromInitialSelection(this.selection_);
        return cname;
    }

    private IProject getProjectFromInitialSelection(IStructuredSelection selection) {
        Object obj;
        if (selection != null && selection.size() == 1 && (obj = selection.getFirstElement()) != null) {
            try {
                IResource resource = ResourceUtils.getResourceFromSelection((Object)obj);
                if (resource == null) {
                    return null;
                }
                IProject p = ResourceUtils.getProjectOf((IPath)resource.getFullPath());
                return p;
            }
            catch (CoreException coreException) {
                return null;
            }
        }
        return null;
    }

    private String getComponentNameFromInitialSelection(IStructuredSelection selection) {
        Object obj;
        if (selection != null && selection.size() == 1 && (obj = selection.getFirstElement()) != null) {
            try {
                IResource resource = ResourceUtils.getResourceFromSelection((Object)obj);
                if (resource == null) {
                    return null;
                }
                IVirtualComponent comp = ResourceUtils.getComponentOf((IResource)resource);
                if (comp != null) {
                    return comp.getName();
                }
            }
            catch (CoreException coreException) {
                return null;
            }
        }
        return null;
    }

    public IStatus execute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        return Status.OK_STATUS;
    }
}

