/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.internal.consumption.ui.widgets.extensions;

import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jst.ws.internal.consumption.ui.ConsumptionUIMessages;
import org.eclipse.jst.ws.internal.consumption.ui.wsrt.WebServiceRuntimeExtensionUtils2;
import org.eclipse.jst.ws.internal.data.TypeRuntimeServer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.command.internal.env.core.common.StatusUtils;
import org.eclipse.wst.common.environment.IEnvironment;
import org.eclipse.wst.common.frameworks.datamodel.AbstractDataModelOperation;
import org.eclipse.wst.ws.internal.parser.discovery.WebServicesParserExt;
import org.eclipse.wst.ws.internal.parser.wsil.WebServicesParser;

public class ServerExtensionDefaultingCommand
extends AbstractDataModelOperation {
    private Boolean installService;
    private Boolean startService;
    private Boolean testService;
    private Boolean publishService;
    private TypeRuntimeServer serviceIds_;
    private String serviceRuntimeId_;
    private String serviceProjectName_;
    private String serviceEarProjectName_;
    private String serviceComponentType_;
    private boolean serviceNeedEAR_;
    private WebServicesParser wsdlParser_;

    public void setServiceTypeRuntimeServer(TypeRuntimeServer ids) {
        this.serviceIds_ = ids;
    }

    public void setServiceExistingServerInstanceId(String serverInstId) {
        if (this.serviceIds_.getServerInstanceId() == null) {
            this.serviceIds_.setServerInstanceId(serverInstId);
        }
    }

    public TypeRuntimeServer getServiceTypeRuntimeServer() {
        return this.serviceIds_;
    }

    public void setServiceRuntimeId(String id) {
        this.serviceRuntimeId_ = id;
    }

    public String getServiceRuntimeId() {
        return this.serviceRuntimeId_;
    }

    public Boolean getPublishService() {
        return this.publishService;
    }

    public void setPublishService(Boolean publishService) {
        this.publishService = publishService;
    }

    public boolean getServerIsExistingServer() {
        return this.serviceIds_.getServerInstanceId() != null;
    }

    public String getServiceServerInstanceId() {
        return this.serviceIds_.getServerInstanceId();
    }

    public String getServerProject() {
        return String.valueOf(this.serviceProjectName_) + "/" + this.serviceProjectName_;
    }

    public String getServerProjectEAR() {
        if (this.serviceEarProjectName_ != null && this.serviceEarProjectName_.length() > 0) {
            return String.valueOf(this.serviceEarProjectName_) + "/" + this.serviceEarProjectName_;
        }
        return "";
    }

    public String getServerRuntime() {
        return this.serviceIds_.getRuntimeId();
    }

    public String getServerServer() {
        return this.serviceIds_.getServerId();
    }

    public String getServiceScenarioId() {
        return this.serviceIds_.getTypeId();
    }

    public Boolean getInstallService() {
        return this.installService;
    }

    public void setInstallService(Boolean installService) {
        this.installService = installService;
    }

    public Boolean getStartService() {
        return this.startService;
    }

    public void setStartService(Boolean startService) {
        this.startService = startService;
    }

    public Boolean getTestService() {
        return this.testService;
    }

    public void setTestService(Boolean testService) {
        this.testService = testService;
    }

    public Boolean getPublish() {
        return new Boolean(true);
    }

    public String getServiceJ2EEVersion() {
        return "14";
    }

    public boolean getServiceNeedEAR() {
        return this.serviceNeedEAR_;
    }

    public void setServiceNeedEAR(boolean serviceNeedEAR) {
        this.serviceNeedEAR_ = serviceNeedEAR;
    }

    public WebServicesParser getWebServicesParser() {
        if (this.wsdlParser_ == null) {
            this.wsdlParser_ = new WebServicesParserExt();
        }
        return this.wsdlParser_;
    }

    public void setWebServicesParser(WebServicesParser wsdlParser) {
        this.wsdlParser_ = wsdlParser;
    }

    public void setServiceProjectName(String serviceProjectName) {
        this.serviceProjectName_ = serviceProjectName;
    }

    public void setServiceEarProjectName(String serviceEarProjectName) {
        this.serviceEarProjectName_ = serviceEarProjectName;
    }

    public void setServiceComponentType(String type) {
        this.serviceComponentType_ = type;
    }

    public String getServiceComponentType() {
        return this.serviceComponentType_;
    }

    public IStatus execute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        IEnvironment env = this.getEnvironment();
        IStatus status = Status.OK_STATUS;
        String scenario = ConsumptionUIMessages.MSG_SERVICE_SUB;
        String runtimeId = this.serviceIds_.getRuntimeId();
        String serverId = this.serviceIds_.getServerId();
        String typeId = this.serviceIds_.getTypeId();
        if (runtimeId == null || runtimeId.length() == 0) {
            status = StatusUtils.errorStatus((String)NLS.bind((String)ConsumptionUIMessages.MSG_NO_RUNTIME, (Object[])new String[]{scenario}));
            env.getStatusHandler().reportError(status);
        }
        if (serverId == null || serverId.length() == 0) {
            status = StatusUtils.errorStatus((String)NLS.bind((String)ConsumptionUIMessages.MSG_NO_SERVER, (Object[])new String[]{scenario}));
            env.getStatusHandler().reportError(status);
        }
        if (!WebServiceRuntimeExtensionUtils2.isServerRuntimeTypeSupported(serverId, runtimeId, typeId)) {
            String serverLabel = WebServiceRuntimeExtensionUtils2.getServerLabelById(serverId);
            String runtimeLabel = WebServiceRuntimeExtensionUtils2.getRuntimeLabelById(runtimeId);
            status = StatusUtils.errorStatus((String)NLS.bind((String)ConsumptionUIMessages.MSG_INVALID_SRT_SELECTIONS, (Object[])new String[]{serverLabel, runtimeLabel}));
            env.getStatusHandler().reportError(status);
        }
        return status;
    }
}

