/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.internal.consumption.ui.widgets.object;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jst.ws.internal.common.ResourceUtils;
import org.eclipse.jst.ws.internal.consumption.ui.widgets.object.AbstractObjectSelectionWidget;
import org.eclipse.jst.ws.internal.consumption.ui.widgets.object.IObjectSelectionWidget;
import org.eclipse.jst.ws.internal.consumption.ui.widgets.object.ObjectSelectionRegistry;
import org.eclipse.jst.ws.internal.consumption.ui.wsrt.WebServiceImpl;
import org.eclipse.jst.ws.internal.consumption.ui.wsrt.WebServiceRuntimeExtensionUtils2;
import org.eclipse.jst.ws.internal.data.TypeRuntimeServer;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.wst.command.internal.env.ui.widgets.WidgetDataEvents;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;

public class ObjectSelectionWidget
extends AbstractObjectSelectionWidget
implements IObjectSelectionWidget {
    private IConfigurationElement[] elements;
    private Composite parent;
    private Listener statusListener;
    private Composite composite;
    private IStructuredSelection initialSelection;
    private IProject project;
    private String componentName;
    private IObjectSelectionWidget child;

    public WidgetDataEvents addControls(Composite parentComposite, Listener statListener) {
        this.elements = ObjectSelectionRegistry.getInstance().getConfigurationElements();
        this.parent = parentComposite;
        this.statusListener = statListener;
        this.composite = null;
        return this;
    }

    public void setTypeRuntimeServer(TypeRuntimeServer typeRuntimeServer) {
        if (this.composite != null) {
            this.composite.dispose();
            this.child = null;
        }
        if (typeRuntimeServer != null) {
            String wst = typeRuntimeServer.getTypeId();
            int scenario = WebServiceRuntimeExtensionUtils2.getScenarioFromTypeId(wst);
            String implId = WebServiceRuntimeExtensionUtils2.getWebServiceImplIdFromTypeId(wst);
            WebServiceImpl wsimpl = WebServiceRuntimeExtensionUtils2.getWebServiceImplById(implId);
            if (wsimpl != null) {
                String objectSelectionWidgetId = null;
                objectSelectionWidgetId = scenario == 1 ? "org.eclipse.jst.ws.internal.consumption.ui.widgets.object.WSDLSelectionWidget" : wsimpl.getObjectSelectionWidget();
                if (objectSelectionWidgetId != null && objectSelectionWidgetId.length() > 0) {
                    int i = 0;
                    while (i < this.elements.length) {
                        if (objectSelectionWidgetId.equals(this.elements[i].getAttribute("id"))) {
                            try {
                                Object object = this.elements[i].createExecutableExtension("class");
                                if (object instanceof IObjectSelectionWidget) {
                                    Shell shell = this.parent.getShell();
                                    int x = shell.getSize().x;
                                    this.composite = new Composite(this.parent, 0);
                                    GridLayout gl = new GridLayout();
                                    gl.marginHeight = 0;
                                    gl.marginWidth = 0;
                                    GridData gd = new GridData(1808);
                                    this.composite.setLayout((Layout)gl);
                                    this.composite.setLayoutData((Object)gd);
                                    this.child = (IObjectSelectionWidget)object;
                                    this.child.addControls(this.composite, this.statusListener);
                                    this.child.setInitialSelection(this.initialSelection);
                                    this.composite.setSize(x - 20, this.composite.computeSize((int)-1, (int)-1).y);
                                    this.parent.setSize(x - 10, this.parent.computeSize((int)-1, (int)-1).y);
                                    shell.setSize(x, shell.computeSize((int)-1, (int)-1).y);
                                    shell.setRedraw(true);
                                    shell.redraw();
                                    shell.update();
                                    return;
                                }
                            }
                            catch (CoreException coreException) {}
                        }
                        ++i;
                    }
                }
            }
        }
    }

    public IStatus getStatus() {
        return this.child != null ? this.child.getStatus() : Status.OK_STATUS;
    }

    public void setInitialSelection(IStructuredSelection initialSelection) {
        this.initialSelection = initialSelection;
        this.project = this.getProjectFromInitialSelection(initialSelection);
        this.componentName = this.getComponentNameFromInitialSelection(initialSelection);
        if (this.child != null) {
            this.child.setInitialSelection(initialSelection);
        }
    }

    public IStructuredSelection getObjectSelection() {
        return this.child != null ? this.child.getObjectSelection() : null;
    }

    public IStatus validateSelection(IStructuredSelection objectSelection) {
        return this.child != null ? this.child.validateSelection(objectSelection) : Status.OK_STATUS;
    }

    public IProject getProject() {
        if (this.child != null) {
            IProject p = this.child.getProject();
            if (p != null) {
                return p;
            }
            return this.project;
        }
        return null;
    }

    public String getComponentName() {
        if (this.child != null) {
            String cname = this.child.getComponentName();
            if (cname != null && cname.length() > 0) {
                return cname;
            }
            return this.componentName;
        }
        return null;
    }

    private IProject getProjectFromInitialSelection(IStructuredSelection selection) {
        Object obj;
        if (selection != null && selection.size() == 1 && (obj = selection.getFirstElement()) != null) {
            try {
                IResource resource = ResourceUtils.getResourceFromSelection((Object)obj);
                if (resource == null) {
                    return null;
                }
                IProject p = ResourceUtils.getProjectOf((IPath)resource.getFullPath());
                return p;
            }
            catch (CoreException coreException) {
                return null;
            }
        }
        return null;
    }

    private String getComponentNameFromInitialSelection(IStructuredSelection selection) {
        Object obj;
        if (selection != null && selection.size() == 1 && (obj = selection.getFirstElement()) != null) {
            try {
                IResource resource = ResourceUtils.getResourceFromSelection((Object)obj);
                if (resource == null) {
                    return null;
                }
                IVirtualComponent comp = ResourceUtils.getComponentOf((IResource)resource);
                if (comp != null) {
                    return comp.getName();
                }
            }
            catch (CoreException coreException) {
                return null;
            }
        }
        return null;
    }
}

