/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.internal.consumption.ui.widgets.runtime;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jem.util.emf.workbench.ProjectUtilities;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jst.server.core.FacetUtil;
import org.eclipse.jst.ws.internal.common.J2EEUtils;
import org.eclipse.jst.ws.internal.common.ResourceUtils;
import org.eclipse.jst.ws.internal.common.ServerUtils;
import org.eclipse.jst.ws.internal.consumption.common.FacetMatcher;
import org.eclipse.jst.ws.internal.consumption.common.FacetUtils;
import org.eclipse.jst.ws.internal.consumption.common.RequiredFacetVersion;
import org.eclipse.jst.ws.internal.consumption.ui.ConsumptionUIMessages;
import org.eclipse.jst.ws.internal.consumption.ui.plugin.WebServiceConsumptionUIPlugin;
import org.eclipse.jst.ws.internal.consumption.ui.preferences.PersistentServerRuntimeContext;
import org.eclipse.jst.ws.internal.consumption.ui.preferences.ProjectTopologyContext;
import org.eclipse.jst.ws.internal.consumption.ui.wsrt.ClientRuntimeDescriptor;
import org.eclipse.jst.ws.internal.consumption.ui.wsrt.WebServiceRuntimeExtensionUtils;
import org.eclipse.jst.ws.internal.consumption.ui.wsrt.WebServiceRuntimeExtensionUtils2;
import org.eclipse.jst.ws.internal.data.TypeRuntimeServer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.command.internal.env.core.common.StatusUtils;
import org.eclipse.wst.command.internal.env.core.context.ResourceContext;
import org.eclipse.wst.command.internal.env.core.selection.SelectionList;
import org.eclipse.wst.command.internal.env.core.selection.SelectionListChoices;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.environment.IEnvironment;
import org.eclipse.wst.common.frameworks.datamodel.AbstractDataModelOperation;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.IServerType;
import org.eclipse.wst.server.core.ServerCore;
import org.eclipse.wst.server.core.ServerUtil;
import org.eclipse.wst.ws.internal.parser.wsil.WebServicesParser;
import org.eclipse.wst.ws.internal.wsrt.IContext;
import org.eclipse.wst.ws.internal.wsrt.ISelection;
import org.eclipse.wst.ws.internal.wsrt.IWebServiceClient;
import org.eclipse.wst.ws.internal.wsrt.IWebServiceRuntime;
import org.eclipse.wst.ws.internal.wsrt.SimpleContext;
import org.eclipse.wst.ws.internal.wsrt.WebServiceClientInfo;
import org.eclipse.wst.ws.internal.wsrt.WebServiceScenario;
import org.eclipse.wst.ws.internal.wsrt.WebServiceState;

public class ClientRuntimeSelectionWidgetDefaultingCommand
extends AbstractDataModelOperation {
    private TypeRuntimeServer clientIds_;
    private boolean clientIdsFixed_ = false;
    private String clientRuntimeId_;
    private String clientProjectName_;
    private String clientEarProjectName_;
    protected boolean clientNeedEAR_ = true;
    private String clientComponentType_;
    private FacetMatcher clientFacetMatcher_;
    private IContext context_;
    private ISelection selection_;
    private IWebServiceClient webServiceClient_;
    private ResourceContext resourceContext_;
    private boolean test_;
    private IProject clientInitialProject_;
    private String wsdlURI_;

    public void setClientTypeRuntimeServer(TypeRuntimeServer ids) {
        this.clientIds_ = ids;
    }

    public TypeRuntimeServer getClientTypeRuntimeServer() {
        return this.clientIds_;
    }

    public void setClientIdsFixed(boolean b) {
        this.clientIdsFixed_ = b;
    }

    public String getClientRuntimeId() {
        return this.clientRuntimeId_;
    }

    public String getClientProjectName() {
        return this.clientProjectName_;
    }

    public String getClientEarProjectName() {
        return this.clientEarProjectName_;
    }

    public void setClientEarProjectName(String name) {
        this.clientEarProjectName_ = name;
    }

    public String getClientComponentType() {
        return this.clientComponentType_;
    }

    public IWebServiceClient getWebService() {
        return this.webServiceClient_;
    }

    public IContext getContext() {
        return this.context_;
    }

    public ISelection getSelection() {
        return this.selection_;
    }

    public IStatus execute(IProgressMonitor monitor, IAdaptable adaptable) {
        IEnvironment env = this.getEnvironment();
        try {
            IStatus serverStatus;
            IProject clientProject;
            if (this.clientIdsFixed_) {
                this.clientRuntimeId_ = this.getDefaultClientRuntimeForFixedRuntimeAndServer(this.clientInitialProject_);
            } else {
                this.clientRuntimeId_ = this.getDefaultClientRuntime(this.clientInitialProject_);
                this.clientIds_.setRuntimeId(WebServiceRuntimeExtensionUtils2.getClientRuntimeDescriptorById(this.clientRuntimeId_).getRuntime().getId());
            }
            if (this.clientProjectName_ == null) {
                this.clientProjectName_ = this.getDefaultClientProjectName();
            }
            this.clientComponentType_ = !(clientProject = ProjectUtilities.getProject((String)this.clientProjectName_)).exists() ? this.getDefaultClientProjectTemplate() : "";
            if (!this.clientIdsFixed_ && (serverStatus = this.setClientDefaultServer()).getSeverity() == 4) {
                env.getStatusHandler().reportError(serverStatus);
                return serverStatus;
            }
            this.setDefaultClientEarProject();
            this.setDefaultsForExtension(env);
            return Status.OK_STATUS;
        }
        catch (Exception e) {
            IStatus errorStatus = StatusUtils.errorStatus((String)NLS.bind((String)ConsumptionUIMessages.MSG_ERROR_TASK_EXCEPTED, (Object[])new String[]{e.getMessage()}), (Throwable)e);
            env.getStatusHandler().reportError(errorStatus);
            return errorStatus;
        }
    }

    private void setDefaultClientEarProject() {
        String serverTargetId;
        String serverId;
        IProject clientProject = ProjectUtilities.getProject((String)this.clientProjectName_);
        if (clientProject.exists()) {
            this.clientNeedEAR_ = !FacetUtils.isJavaProject((IProject)clientProject);
        } else {
            boolean bl = this.clientNeedEAR_ = !FacetUtils.isUtilityTemplate((String)this.clientComponentType_);
        }
        if (this.clientNeedEAR_ && (serverId = this.clientIds_.getServerId()) != null && (serverTargetId = ServerUtils.getRuntimeTargetIdFromFactoryId((String)serverId)) != null && serverTargetId.length() > 0 && !ServerUtils.isTargetValidForEAR((String)serverTargetId, (String)"13")) {
            this.clientNeedEAR_ = false;
        }
        this.clientEarProjectName_ = this.clientNeedEAR_ ? this.getDefaultClientEarProjectName() : "";
    }

    private IStatus setClientDefaultServer() {
        IServerType serverType;
        IServer server;
        IProject clientProject = ProjectUtilities.getProject((String)this.clientProjectName_);
        IServer[] configuredServers = ServerUtil.getServersByModule((IModule)ServerUtils.getModule((IProject)clientProject), null);
        if (configuredServers != null && configuredServers.length > 0) {
            this.clientIds_.setServerId(configuredServers[0].getServerType().getId());
            this.clientIds_.setServerInstanceId(configuredServers[0].getId());
            return Status.OK_STATUS;
        }
        if (clientProject.exists()) {
            server = this.getServerFromProject(this.clientProjectName_, this.clientFacetMatcher_);
            if (server != null) {
                this.clientIds_.setServerId(server.getServerType().getId());
                this.clientIds_.setServerInstanceId(server.getId());
                return Status.OK_STATUS;
            }
            serverType = this.getServerTypeFromProject(this.clientProjectName_, this.clientFacetMatcher_);
            if (serverType != null) {
                this.clientIds_.setServerId(serverType.getId());
                return Status.OK_STATUS;
            }
        }
        if ((server = this.getServerFromClientRuntimeId()) != null) {
            this.clientIds_.setServerId(server.getServerType().getId());
            this.clientIds_.setServerInstanceId(server.getId());
            return Status.OK_STATUS;
        }
        serverType = this.getServerTypeFromClientRuntimeId();
        if (serverType != null) {
            this.clientIds_.setServerId(serverType.getId());
            return Status.OK_STATUS;
        }
        String runtimeLabel = WebServiceRuntimeExtensionUtils2.getRuntimeLabelById(this.clientIds_.getRuntimeId());
        String serverLabels = this.getServerLabels(this.clientRuntimeId_);
        IStatus status = StatusUtils.errorStatus((String)NLS.bind((String)ConsumptionUIMessages.MSG_ERROR_NO_SERVER_RUNTIME, (Object[])new String[]{runtimeLabel, serverLabels}));
        return status;
    }

    private IServer getServerFromClientRuntimeId() {
        IServer[] servers = ServerCore.getServers();
        if (servers != null && servers.length > 0) {
            int i = 0;
            while (i < servers.length) {
                String serverFactoryId = servers[i].getServerType().getId();
                if (WebServiceRuntimeExtensionUtils2.doesClientRuntimeSupportServer(this.clientRuntimeId_, serverFactoryId)) {
                    return servers[i];
                }
                ++i;
            }
        }
        return null;
    }

    private IServerType getServerTypeFromClientRuntimeId() {
        String[] serverTypes = WebServiceRuntimeExtensionUtils2.getServerFactoryIdsByClientRuntime(this.clientRuntimeId_);
        if (serverTypes != null && serverTypes.length > 0) {
            PersistentServerRuntimeContext context = WebServiceConsumptionUIPlugin.getInstance().getServerRuntimeContext();
            String preferredServerFactoryId = context.getServerFactoryId();
            int i = 0;
            while (i < serverTypes.length) {
                if (serverTypes[i].equals(preferredServerFactoryId)) {
                    return ServerCore.findServerType((String)serverTypes[i]);
                }
                ++i;
            }
            return ServerCore.findServerType((String)serverTypes[0]);
        }
        return null;
    }

    protected IServer getServerFromProject(String projectName, FacetMatcher facetMatcher) {
        IServer server = null;
        IProject project = ProjectUtilities.getProject((String)projectName);
        IServer[] servers = ServerCore.getServers();
        if (servers.length > 0) {
            Set facets;
            org.eclipse.wst.common.project.facet.core.runtime.IRuntime fRuntime = null;
            IFacetedProject fProject = null;
            if (project != null && project.exists()) {
                try {
                    fProject = ProjectFacetsManager.create((IProject)project);
                    if (fProject != null) {
                        fRuntime = fProject.getRuntime();
                    }
                }
                catch (CoreException coreException) {}
            }
            if (fRuntime != null) {
                IRuntime sRuntime = FacetUtil.getRuntime(fRuntime);
                int i = 0;
                while (i < servers.length) {
                    IServer thisServer = servers[i];
                    if (thisServer.getRuntime().getId().equals(sRuntime.getId())) {
                        server = thisServer;
                        break;
                    }
                    ++i;
                }
            }
            if (server == null && project != null && project.exists() && (facets = FacetUtils.getFacetsForProject((String)project.getName())) != null) {
                if (facetMatcher.getFacetsToAdd() != null) {
                    Iterator itr = facetMatcher.getFacetsToAdd().iterator();
                    while (itr.hasNext()) {
                        facets.add(itr.next());
                    }
                }
                server = this.getServerFromFacets(facets);
            }
        }
        return server;
    }

    protected IServer getServerFromFacets(Set facets) {
        IServer server = null;
        Set runtimes = FacetUtils.getRuntimes((Set[])new Set[]{facets});
        Iterator itr = runtimes.iterator();
        IServer[] servers = ServerCore.getServers();
        block0: while (itr.hasNext()) {
            org.eclipse.wst.common.project.facet.core.runtime.IRuntime fRuntime = (org.eclipse.wst.common.project.facet.core.runtime.IRuntime)itr.next();
            IRuntime sRuntime = FacetUtil.getRuntime((org.eclipse.wst.common.project.facet.core.runtime.IRuntime)fRuntime);
            int i = 0;
            while (i < servers.length) {
                IServer thisServer = servers[i];
                if (thisServer.getRuntime().getId().equals(sRuntime.getId())) {
                    server = thisServer;
                    break block0;
                }
                ++i;
            }
        }
        return server;
    }

    protected IServerType getServerTypeFromProject(String projectName, FacetMatcher facetMatcher) {
        Set facets;
        IServerType serverType = null;
        IProject project = ProjectUtilities.getProject((String)projectName);
        IServerType[] serverTypes = ServerCore.getServerTypes();
        org.eclipse.wst.common.project.facet.core.runtime.IRuntime fRuntime = null;
        IFacetedProject fProject = null;
        if (project != null && project.exists()) {
            try {
                fProject = ProjectFacetsManager.create((IProject)project);
                if (fProject != null) {
                    fRuntime = fProject.getRuntime();
                }
            }
            catch (CoreException coreException) {}
        }
        if (fRuntime != null) {
            IRuntime sRuntime = FacetUtil.getRuntime(fRuntime);
            int i = 0;
            while (i < serverTypes.length) {
                IServerType thisServerType = serverTypes[i];
                if (thisServerType.getRuntimeType().getId().equals(sRuntime.getRuntimeType().getId())) {
                    serverType = thisServerType;
                    break;
                }
                ++i;
            }
        }
        if (serverType == null && project != null && project.exists() && (facets = FacetUtils.getFacetsForProject((String)project.getName())) != null) {
            if (facetMatcher.getFacetsToAdd() != null) {
                Iterator itr = facetMatcher.getFacetsToAdd().iterator();
                while (itr.hasNext()) {
                    facets.add(itr.next());
                }
            }
            serverType = this.getServerTypeFromFacets(facets);
        }
        return serverType;
    }

    protected IServerType getServerTypeFromFacets(Set facets) {
        IServerType serverType = null;
        Set runtimes = FacetUtils.getRuntimes((Set[])new Set[]{facets});
        Iterator itr = runtimes.iterator();
        IServerType[] serverTypes = ServerCore.getServerTypes();
        block0: while (itr.hasNext()) {
            org.eclipse.wst.common.project.facet.core.runtime.IRuntime fRuntime = (org.eclipse.wst.common.project.facet.core.runtime.IRuntime)itr.next();
            IRuntime sRuntime = FacetUtil.getRuntime((org.eclipse.wst.common.project.facet.core.runtime.IRuntime)fRuntime);
            int i = 0;
            while (i < serverTypes.length) {
                IServerType thisServerType = serverTypes[i];
                if (thisServerType.getRuntimeType().getId().equals(sRuntime.getRuntimeType().getId())) {
                    serverType = thisServerType;
                    break block0;
                }
                ++i;
            }
        }
        return serverType;
    }

    protected IServer getServerFromProjectType(String templateId, FacetMatcher facetMatcher) {
        IServer server = null;
        Set facets = FacetUtils.getInitialFacetVersionsFromTemplate((String)templateId);
        if (facetMatcher.getFacetsToAdd() != null) {
            Iterator itr = facetMatcher.getFacetsToAdd().iterator();
            while (itr.hasNext()) {
                facets.add(itr.next());
            }
        }
        server = this.getServerFromFacets(facets);
        return server;
    }

    protected IServerType getServerTypeFromProjectType(String templateId, FacetMatcher facetMatcher) {
        IServerType serverType = null;
        Set facets = FacetUtils.getInitialFacetVersionsFromTemplate((String)templateId);
        if (facetMatcher.getFacetsToAdd() != null) {
            Iterator itr = facetMatcher.getFacetsToAdd().iterator();
            while (itr.hasNext()) {
                facets.add(itr.next());
            }
        }
        serverType = this.getServerTypeFromFacets(facets);
        return serverType;
    }

    private String getDefaultClientProjectTemplate() {
        String[] templates = WebServiceRuntimeExtensionUtils2.getClientProjectTemplates(this.clientIds_.getTypeId(), this.clientIds_.getRuntimeId());
        RequiredFacetVersion[] rfv = WebServiceRuntimeExtensionUtils2.getClientRuntimeDescriptorById(this.clientRuntimeId_).getRequiredFacetVersions();
        ProjectTopologyContext ptc = WebServiceConsumptionUIPlugin.getInstance().getProjectTopologyContext();
        String[] preferredTemplateIds = ptc.getClientTypes();
        int j = 0;
        while (j < preferredTemplateIds.length) {
            int i = 0;
            while (i < templates.length) {
                Set facetVersions;
                FacetMatcher fm;
                String templateId = templates[i];
                if (templateId.equals(preferredTemplateIds[j]) && (fm = FacetUtils.match((RequiredFacetVersion[])rfv, (Set)(facetVersions = FacetUtils.getInitialFacetVersionsFromTemplate((String)templateId)))).isMatch()) {
                    this.clientFacetMatcher_ = fm;
                    return templates[i];
                }
                ++i;
            }
            ++j;
        }
        j = 0;
        while (j < templates.length) {
            String templateId = templates[j];
            Set facetVersions = FacetUtils.getInitialFacetVersionsFromTemplate((String)templateId);
            FacetMatcher fm = FacetUtils.match((RequiredFacetVersion[])rfv, (Set)facetVersions);
            if (fm.isMatch()) {
                this.clientFacetMatcher_ = fm;
                return templates[j];
            }
            ++j;
        }
        if (templates.length > 0) {
            return templates[0];
        }
        return "";
    }

    private String getDefaultClientProjectName() {
        IProject[] projects = FacetUtils.getAllProjects();
        ClientRuntimeDescriptor desc = WebServiceRuntimeExtensionUtils2.getClientRuntimeDescriptorById(this.clientRuntimeId_);
        RequiredFacetVersion[] rfvs = desc.getRequiredFacetVersions();
        int i = 0;
        while (i < projects.length) {
            FacetMatcher fm;
            Set facetVersions = FacetUtils.getFacetsForProject((String)projects[i].getName());
            if (facetVersions != null && (fm = FacetUtils.match((RequiredFacetVersion[])rfvs, (Set)facetVersions)).isMatch()) {
                this.clientFacetMatcher_ = fm;
                return projects[i].getName();
            }
            ++i;
        }
        return ResourceUtils.getDefaultWebProjectName();
    }

    private String getDefaultClientRuntimeForFixedRuntimeAndServer(IProject project) {
        String[] clientRuntimes = WebServiceRuntimeExtensionUtils2.getClientRuntimesByType(this.clientIds_.getTypeId());
        ArrayList<String> validClientRuntimes = new ArrayList<String>();
        int i = 0;
        while (i < clientRuntimes.length) {
            ClientRuntimeDescriptor desc = WebServiceRuntimeExtensionUtils2.getClientRuntimeDescriptorById(clientRuntimes[i]);
            if (desc.getRuntime().getId().equals(this.clientIds_.getRuntimeId()) && WebServiceRuntimeExtensionUtils2.doesClientRuntimeSupportServer(desc.getId(), this.clientIds_.getServerId())) {
                validClientRuntimes.add(desc.getId());
                if (project != null && project.exists()) {
                    FacetMatcher fm;
                    RequiredFacetVersion[] rfv = desc.getRequiredFacetVersions();
                    Set facetVersions = FacetUtils.getFacetsForProject((String)project.getName());
                    if (facetVersions != null && (fm = FacetUtils.match((RequiredFacetVersion[])rfv, (Set)facetVersions)).isMatch()) {
                        this.clientFacetMatcher_ = fm;
                        this.clientProjectName_ = project.getName();
                        return desc.getId();
                    }
                }
            }
            ++i;
        }
        if (validClientRuntimes.size() > 0) {
            return validClientRuntimes.toArray(new String[0])[0];
        }
        this.clientIdsFixed_ = false;
        return this.getDefaultClientRuntime(project);
    }

    private String getDefaultClientRuntime(IProject project) {
        FacetMatcher fm;
        Set facetVersions;
        String[] clientRuntimes = WebServiceRuntimeExtensionUtils2.getClientRuntimesByType(this.clientIds_.getTypeId());
        PersistentServerRuntimeContext context = WebServiceConsumptionUIPlugin.getInstance().getServerRuntimeContext();
        String runtimeId = context.getRuntimeId();
        ArrayList<String> preferredClientRuntimeIdsList = new ArrayList<String>();
        int k = 0;
        while (k < clientRuntimes.length) {
            ClientRuntimeDescriptor desc = WebServiceRuntimeExtensionUtils2.getClientRuntimeDescriptorById(clientRuntimes[k]);
            if (desc.getRuntime().getId().equals(runtimeId)) {
                preferredClientRuntimeIdsList.add(desc.getId());
            }
            ++k;
        }
        String[] preferredClientRuntimeIds = preferredClientRuntimeIdsList.toArray(new String[0]);
        if (project != null && project.exists() && (facetVersions = FacetUtils.getFacetsForProject((String)project.getName())) != null) {
            int p = 0;
            while (p < preferredClientRuntimeIds.length) {
                RequiredFacetVersion[] prfv = WebServiceRuntimeExtensionUtils2.getClientRuntimeDescriptorById(preferredClientRuntimeIds[p]).getRequiredFacetVersions();
                fm = FacetUtils.match((RequiredFacetVersion[])prfv, (Set)facetVersions);
                if (fm.isMatch()) {
                    this.clientFacetMatcher_ = fm;
                    this.clientProjectName_ = project.getName();
                    return preferredClientRuntimeIds[p];
                }
                ++p;
            }
        }
        if (project != null && project.exists()) {
            int i = 0;
            while (i < clientRuntimes.length) {
                RequiredFacetVersion[] rfv = WebServiceRuntimeExtensionUtils2.getClientRuntimeDescriptorById(clientRuntimes[i]).getRequiredFacetVersions();
                Set facetVersions2 = FacetUtils.getFacetsForProject((String)project.getName());
                if (facetVersions2 != null && (fm = FacetUtils.match((RequiredFacetVersion[])rfv, (Set)facetVersions2)).isMatch()) {
                    this.clientFacetMatcher_ = fm;
                    this.clientProjectName_ = project.getName();
                    return clientRuntimes[i];
                }
                ++i;
            }
        }
        ProjectTopologyContext ptc = WebServiceConsumptionUIPlugin.getInstance().getProjectTopologyContext();
        String[] preferredTemplateIds = ptc.getClientTypes();
        int n = 0;
        while (n < preferredTemplateIds.length) {
            String preferredTemplateId = preferredTemplateIds[n];
            Set facetVersions3 = FacetUtils.getInitialFacetVersionsFromTemplate((String)preferredTemplateId);
            int m = 0;
            while (m < preferredClientRuntimeIds.length) {
                ClientRuntimeDescriptor desc = WebServiceRuntimeExtensionUtils2.getClientRuntimeDescriptorById(preferredClientRuntimeIds[m]);
                RequiredFacetVersion[] rfv = desc.getRequiredFacetVersions();
                FacetMatcher fm2 = FacetUtils.match((RequiredFacetVersion[])rfv, (Set)facetVersions3);
                if (fm2.isMatch()) {
                    return preferredClientRuntimeIds[m];
                }
                ++m;
            }
            ++n;
        }
        if (preferredClientRuntimeIds.length > 0) {
            return preferredClientRuntimeIds[0];
        }
        if (clientRuntimes.length > 0) {
            return WebServiceRuntimeExtensionUtils2.getClientRuntimeDescriptorById(clientRuntimes[0]).getId();
        }
        return null;
    }

    protected SelectionListChoices getProjectEARChoice(IProject project) {
        String[] flexProjects = this.getAllFlexibleProjects();
        SelectionList list = new SelectionList(flexProjects, 0);
        return new SelectionListChoices(list, null);
    }

    protected SelectionList getEARProjects() {
        String[] flexProjects = this.getAllFlexibleProjects();
        return new SelectionList(flexProjects, 0);
    }

    protected IResource getResourceFromInitialSelection(IStructuredSelection selection) {
        Object obj;
        if (selection != null && selection.size() == 1 && (obj = selection.getFirstElement()) != null) {
            try {
                IResource resource = ResourceUtils.getResourceFromSelection((Object)obj);
                return resource;
            }
            catch (CoreException coreException) {
                return null;
            }
        }
        return null;
    }

    protected String getDefaultClientEarProjectName() {
        IProject clientProject = ProjectUtilities.getProject((String)this.clientProjectName_);
        IVirtualComponent[] earComps = J2EEUtils.getReferencingEARComponents((IProject)clientProject);
        if (earComps.length > 0) {
            return earComps[0].getName();
        }
        IVirtualComponent[] allEarComps = J2EEUtils.getAllEARComponents();
        if (allEarComps.length > 0) {
            return allEarComps[0].getName();
        }
        return ResourceUtils.getDefaultClientEARProjectName();
    }

    private String getServerLabels(String clientRuntimeId) {
        String[] validServerFactoryIds = WebServiceRuntimeExtensionUtils2.getServerFactoryIdsByClientRuntime(clientRuntimeId);
        StringBuffer validServerLabels = new StringBuffer();
        int i = 0;
        while (i < validServerFactoryIds.length) {
            if (i > 0) {
                validServerLabels.append(", ");
            }
            validServerLabels.append(WebServiceRuntimeExtensionUtils.getServerLabelById(validServerFactoryIds[i]));
            ++i;
        }
        return validServerLabels.toString();
    }

    protected void updateClientProject(String projectName, String serviceTypeId) {
        boolean isEJB = false;
        String implId = WebServiceRuntimeExtensionUtils2.getWebServiceImplIdFromTypeId(serviceTypeId);
        isEJB = implId.equals("org.eclipse.jst.ws.wsImpl.ejb");
        String[] updatedNames = ResourceUtils.getClientProjectComponentName((String)projectName, (String)projectName, (boolean)isEJB);
        this.clientProjectName_ = updatedNames[0];
        IProject clientProject = ProjectUtilities.getProject((String)this.clientProjectName_);
        if (clientProject.exists()) {
            this.clientComponentType_ = "";
            this.clientRuntimeId_ = WebServiceRuntimeExtensionUtils2.getClientRuntimeId(this.clientIds_, projectName, this.clientComponentType_);
        } else {
            String[] templateIds = WebServiceRuntimeExtensionUtils2.getClientProjectTemplates(this.clientIds_.getTypeId(), this.clientIds_.getRuntimeId());
            ProjectTopologyContext ptc = WebServiceConsumptionUIPlugin.getInstance().getProjectTopologyContext();
            String[] preferredTemplateIds = ptc.getClientTypes();
            int j = 0;
            block0: while (j < preferredTemplateIds.length) {
                int i = 0;
                while (i < templateIds.length) {
                    String newClientRuntimeId;
                    String templateId = templateIds[i];
                    if (templateId.equals(preferredTemplateIds[j]) && (newClientRuntimeId = WebServiceRuntimeExtensionUtils2.getClientRuntimeId(this.clientIds_, this.clientProjectName_, templateId)).length() > 0) {
                        this.clientRuntimeId_ = newClientRuntimeId;
                        this.clientComponentType_ = templateId;
                        break block0;
                    }
                    ++i;
                }
                ++j;
            }
        }
    }

    private void setDefaultsForExtension(IEnvironment env) {
        IWebServiceRuntime wsrt = WebServiceRuntimeExtensionUtils2.getClientRuntime(this.clientRuntimeId_);
        if (wsrt != null) {
            WebServiceClientInfo wsInfo = new WebServiceClientInfo();
            wsInfo.setServerFactoryId(this.clientIds_.getServerId());
            wsInfo.setServerInstanceId(this.clientIds_.getServerInstanceId());
            wsInfo.setState(WebServiceState.UNKNOWN_LITERAL);
            wsInfo.setWebServiceRuntimeId(this.clientIds_.getRuntimeId());
            wsInfo.setWsdlURL(this.wsdlURI_);
            this.webServiceClient_ = wsrt.getWebServiceClient(wsInfo);
            WebServiceScenario scenario = WebServiceScenario.CLIENT_LITERAL;
            if (this.resourceContext_ != null) {
                this.context_ = new SimpleContext(true, true, true, true, true, true, this.test_, false, scenario, this.resourceContext_.isOverwriteFilesEnabled(), this.resourceContext_.isCreateFoldersEnabled(), this.resourceContext_.isCheckoutFilesEnabled());
            }
        }
    }

    public void setClientInitialSelection(IStructuredSelection selection) {
        if (this.clientInitialProject_ == null) {
            this.clientInitialProject_ = this.getProjectFromInitialSelection(selection);
        }
    }

    public void setClientInitialProject(IProject clientInitialProject) {
        this.clientInitialProject_ = clientInitialProject;
    }

    public void setInitialInitialSelection(IStructuredSelection initialInitialSelection) {
    }

    public boolean getClientNeedEAR() {
        return this.clientNeedEAR_;
    }

    public void setWebServicesParser(WebServicesParser parser) {
    }

    public void setWsdlURI(String wsdlURI) {
        this.wsdlURI_ = wsdlURI;
    }

    public void setTestService(boolean testService) {
        this.test_ = testService;
    }

    public void setResourceContext(ResourceContext resourceContext) {
        this.resourceContext_ = resourceContext;
    }

    private IProject getProjectFromInitialSelection(IStructuredSelection selection) {
        Object obj;
        if (selection != null && selection.size() == 1 && (obj = selection.getFirstElement()) != null) {
            try {
                IResource resource = ResourceUtils.getResourceFromSelection((Object)obj);
                if (resource == null) {
                    return null;
                }
                IProject p = ResourceUtils.getProjectOf((IPath)resource.getFullPath());
                return p;
            }
            catch (CoreException coreException) {
                return null;
            }
        }
        return null;
    }

    protected String[] getAllFlexibleProjects() {
        Vector<String> v = new Vector<String>();
        IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int i = 0;
        while (i < projects.length) {
            if (!projects[i].getName().equals("Servers") && !projects[i].getName().startsWith(".")) {
                v.add(projects[i].getName());
            }
            ++i;
        }
        return v.toArray(new String[0]);
    }

    protected class WSRuntimeJ2EEType {
        private String wsrId_;
        private String j2eeVersionId_;
        private String clientProjectTypeId;

        public String getJ2eeVersionId() {
            return this.j2eeVersionId_;
        }

        public void setJ2eeVersionId(String versionId_) {
            this.j2eeVersionId_ = versionId_;
        }

        public String getWsrId() {
            return this.wsrId_;
        }

        public void setWsrId(String wsrId_) {
            this.wsrId_ = wsrId_;
        }

        public String getClientProjectTypeId() {
            return this.clientProjectTypeId;
        }

        public void setClientProjectTypeId(String clientProjectTypeId) {
            this.clientProjectTypeId = clientProjectTypeId;
        }
    }
}

