/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.internal.consumption.ui.widgets.runtime;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jst.ws.internal.consumption.ui.ConsumptionUIMessages;
import org.eclipse.jst.ws.internal.consumption.ui.wizard.RuntimeServerSelectionDialog;
import org.eclipse.jst.ws.internal.consumption.ui.wsrt.WebServiceRuntimeExtensionUtils2;
import org.eclipse.jst.ws.internal.data.TypeRuntimeServer;
import org.eclipse.jst.ws.internal.ui.common.UIUtils;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.wst.command.internal.env.core.common.StatusUtils;
import org.eclipse.wst.command.internal.env.ui.widgets.SimpleWidgetDataContributor;
import org.eclipse.wst.command.internal.env.ui.widgets.WidgetDataEvents;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.IServerType;
import org.eclipse.wst.server.core.ServerCore;
import org.eclipse.wst.server.core.ServerUtil;

public class RuntimeServerSelectionWidget
extends SimpleWidgetDataContributor {
    private String pluginId_ = "org.eclipse.jst.ws.consumption.ui";
    private Text runtime_;
    private Text server_;
    private Composite parent_;
    private boolean isClientContext_;
    private TypeRuntimeServer ids_;
    private Listener statusListener_;
    private String INFOPOP_PWRS_GROUP_SERVICE_RUNTIME = String.valueOf(this.pluginId_) + ".PWRS0004";
    private String INFOPOP_PWRS_GROUP_SERVICE_SERVER = String.valueOf(this.pluginId_) + ".PWRS0005";

    public RuntimeServerSelectionWidget(boolean isClientScenario) {
        this.isClientContext_ = isClientScenario;
    }

    public WidgetDataEvents addControls(Composite parent, Listener statusListener) {
        UIUtils uiUtils = new UIUtils(this.pluginId_);
        this.parent_ = parent;
        this.statusListener_ = statusListener;
        this.runtime_ = uiUtils.createText(parent, ConsumptionUIMessages.LABEL_RUNTIMES_LIST, ConsumptionUIMessages.TOOLTIP_PWRS_TEXT_RUNTIME, this.INFOPOP_PWRS_GROUP_SERVICE_RUNTIME, 8);
        this.server_ = uiUtils.createText(parent, ConsumptionUIMessages.LABEL_SERVERS_LIST, ConsumptionUIMessages.TOOLTIP_PWRS_TEXT_SERVER, this.INFOPOP_PWRS_GROUP_SERVICE_SERVER, 8);
        Button editButton = new Button(parent, 0);
        editButton.setText(ConsumptionUIMessages.LABEL_EDIT_BUTTON);
        editButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                RuntimeServerSelectionWidget.this.handleEditButton();
            }
        });
        new Label(parent, 0);
        return this;
    }

    public TypeRuntimeServer getTypeRuntimeServer() {
        return this.ids_;
    }

    public void setTypeRuntimeServer(TypeRuntimeServer ids) {
        this.ids_ = ids;
        this.setLabels();
    }

    private void setLabels() {
        String runtimeLabel = WebServiceRuntimeExtensionUtils2.getRuntimeLabelById(this.ids_.getRuntimeId());
        String serverLabel = null;
        if (this.ids_.getServerInstanceId() == null) {
            String serverId = this.ids_.getServerId();
            if (serverId != null) {
                serverLabel = WebServiceRuntimeExtensionUtils2.getServerLabelById(serverId);
            }
        } else {
            String serverInstanceId = this.ids_.getServerInstanceId();
            if (serverInstanceId != null) {
                serverLabel = WebServiceRuntimeExtensionUtils2.getServerInstanceLabelFromInstanceId(serverInstanceId);
            }
        }
        runtimeLabel = runtimeLabel == null ? "" : runtimeLabel;
        this.runtime_.setText(runtimeLabel);
        if (serverLabel != null) {
            this.server_.setText(serverLabel);
        }
    }

    public void handleEditButton() {
        byte mode = this.isClientContext_ ? (byte)1 : 0;
        RuntimeServerSelectionDialog dialog = new RuntimeServerSelectionDialog(this.parent_.getShell(), mode, this.ids_, "14");
        dialog.create();
        dialog.handleServerViewSelectionEvent();
        int result = dialog.open();
        if (result == 0) {
            this.ids_ = dialog.getTypeRuntimeServer();
            this.setLabels();
            this.statusListener_.handleEvent(null);
        }
    }

    public void addModifyListener(ModifyListener listener) {
        if (this.runtime_ != null) {
            this.runtime_.addModifyListener(listener);
        }
    }

    public void removeModifyListener(ModifyListener listener) {
        if (this.runtime_ != null) {
            this.runtime_.removeModifyListener(listener);
        }
    }

    public IStatus getStatus() {
        String serverLabel;
        IStatus status = Status.OK_STATUS;
        String scenario = this.isClientContext_ ? ConsumptionUIMessages.MSG_CLIENT_SUB : ConsumptionUIMessages.MSG_SERVICE_SUB;
        String runtimeLabel = WebServiceRuntimeExtensionUtils2.getRuntimeLabelById(this.ids_.getRuntimeId());
        String string = serverLabel = this.ids_.getServerId() == null ? "" : WebServiceRuntimeExtensionUtils2.getServerLabelById(this.ids_.getServerId());
        if (this.ids_.getRuntimeId() == null || runtimeLabel == null || runtimeLabel.equals("")) {
            status = StatusUtils.errorStatus((String)NLS.bind((String)ConsumptionUIMessages.MSG_NO_RUNTIME, (Object[])new String[]{scenario}));
        } else if (this.ids_.getServerId() == null || serverLabel.equals("")) {
            status = StatusUtils.errorStatus((String)NLS.bind((String)ConsumptionUIMessages.MSG_NO_SERVER, (Object[])new String[]{scenario}));
        }
        String serverFactoryId = this.ids_.getServerId();
        IServerType serverType = ServerCore.findServerType((String)serverFactoryId);
        if (serverType != null) {
            boolean foundNonStubRuntime = false;
            IRuntime[] runtimes = ServerUtil.getRuntimes(null, null);
            String serverRuntimeTypeId = serverType.getRuntimeType().getId();
            int i = 0;
            while (i < runtimes.length) {
                IRuntime runtime = runtimes[i];
                String thisRuntimeTypeId = runtime.getRuntimeType().getId();
                if (thisRuntimeTypeId.equals(serverRuntimeTypeId) && !runtime.isStub()) {
                    foundNonStubRuntime = true;
                    break;
                }
                ++i;
            }
            if (!foundNonStubRuntime) {
                String servertypeLabel = WebServiceRuntimeExtensionUtils2.getServerLabelById(serverFactoryId);
                status = StatusUtils.errorStatus((String)NLS.bind((String)ConsumptionUIMessages.MSG_ERROR_STUB_ONLY, (Object[])new String[]{servertypeLabel}));
            }
        }
        if (this.ids_.getServerId() != null && this.ids_.getRuntimeId() != null && this.isClientContext_ && !WebServiceRuntimeExtensionUtils2.isServerClientRuntimeTypeSupported(this.ids_.getServerId(), this.ids_.getRuntimeId(), this.ids_.getTypeId())) {
            status = StatusUtils.errorStatus((String)NLS.bind((String)ConsumptionUIMessages.MSG_INVALID_SRT_SELECTIONS, (Object[])new String[]{serverLabel, runtimeLabel}));
        }
        if (this.ids_.getServerId() != null && this.ids_.getRuntimeId() != null && !this.isClientContext_ && !WebServiceRuntimeExtensionUtils2.isServerRuntimeTypeSupported(this.ids_.getServerId(), this.ids_.getRuntimeId(), this.ids_.getTypeId())) {
            status = StatusUtils.errorStatus((String)NLS.bind((String)ConsumptionUIMessages.MSG_INVALID_SRT_SELECTIONS, (Object[])new String[]{serverLabel, runtimeLabel}));
        }
        return status;
    }
}

