/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.navigator.internal.provisional.views;

import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.wst.common.navigator.internal.provisional.views.NavigatorContentService;
import org.eclipse.wst.common.navigator.internal.views.NavigatorPlugin;
import org.eclipse.wst.common.navigator.internal.views.extensions.NavigatorContentDescriptorInstance;

public class NavigatorContentServiceContentProvider
implements ITreeContentProvider {
    private static final Object[] NO_CHILDREN = new Object[0];
    private final NavigatorContentService contentService;
    private final boolean isContentServiceSelfManaged;

    public NavigatorContentServiceContentProvider(String aViewerId) {
        this.contentService = new NavigatorContentService(aViewerId);
        this.isContentServiceSelfManaged = true;
    }

    public NavigatorContentServiceContentProvider(NavigatorContentService aContentService) {
        this.contentService = aContentService;
        this.isContentServiceSelfManaged = false;
    }

    public synchronized Object[] getElements(Object anInputElement) {
        ITreeContentProvider[] delegateProviders = this.contentService.findRootContentProviders(anInputElement);
        if (delegateProviders.length == 0) {
            return NO_CHILDREN;
        }
        ArrayList<Object> resultElements = new ArrayList<Object>();
        Object[] delegateChildren = null;
        int i = 0;
        while (i < delegateProviders.length) {
            try {
                delegateChildren = delegateProviders[i].getElements(anInputElement);
                if (delegateChildren != null && delegateChildren.length > 0) {
                    resultElements.addAll(Arrays.asList(delegateChildren));
                }
            }
            catch (RuntimeException re) {
                String msg = "Could not acquire children from extension: " + delegateProviders[i].getClass();
                NavigatorPlugin.log(msg, (IStatus)new Status(4, NavigatorPlugin.PLUGIN_ID, 0, msg, (Throwable)re));
            }
            ++i;
        }
        return resultElements.toArray();
    }

    public synchronized Object[] getChildren(Object aParentElement) {
        ITreeContentProvider[] delegateProviders = this.contentService.findRelevantContentProviders(aParentElement);
        if (delegateProviders.length == 0) {
            return NO_CHILDREN;
        }
        ArrayList<Object> resultChildren = new ArrayList<Object>();
        Object[] delegateChildren = null;
        int i = 0;
        while (i < delegateProviders.length) {
            String msg;
            try {
                delegateChildren = delegateProviders[i].getChildren(aParentElement);
                if (delegateChildren != null && delegateChildren.length > 0) {
                    resultChildren.addAll(Arrays.asList(delegateChildren));
                }
            }
            catch (RuntimeException re) {
                msg = "Could not acquire children from extension: " + delegateProviders[i].getClass();
                NavigatorPlugin.log(msg, (IStatus)new Status(4, NavigatorPlugin.PLUGIN_ID, 0, msg, (Throwable)re));
            }
            catch (Error e) {
                msg = "Could not acquire children from extension: " + delegateProviders[i].getClass();
                NavigatorPlugin.log(msg, (IStatus)new Status(4, NavigatorPlugin.PLUGIN_ID, 0, msg, (Throwable)e));
            }
            ++i;
        }
        return resultChildren.toArray();
    }

    public synchronized Object getParent(Object anElement) {
        ITreeContentProvider[] delegateProviders = this.contentService.findParentContentProviders(anElement);
        Object parent = null;
        int i = 0;
        while (i < delegateProviders.length) {
            try {
                parent = delegateProviders[i].getParent(anElement);
                if (parent != null) {
                    return parent;
                }
            }
            catch (RuntimeException re) {
                String msg = "Could not acquire parent from extension: " + delegateProviders[i].getClass();
                NavigatorPlugin.log(msg, (IStatus)new Status(4, NavigatorPlugin.PLUGIN_ID, 0, msg, (Throwable)re));
            }
            ++i;
        }
        return null;
    }

    public synchronized boolean hasChildren(Object anElement) {
        NavigatorContentDescriptorInstance[] resultInstances = this.contentService.findRelevantContentDescriptorInstances(anElement);
        int i = 0;
        while (i < resultInstances.length) {
            if (!resultInstances[i].isLoaded()) {
                return true;
            }
            if (resultInstances[i].getContentProvider().hasChildren(anElement)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public synchronized void dispose() {
        if (this.isContentServiceSelfManaged) {
            this.contentService.dispose();
        }
    }

    public synchronized void inputChanged(Viewer aViewer, Object anOldInput, Object aNewInput) {
        this.contentService.updateService(aViewer, anOldInput, aNewInput);
    }
}

