/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.project.facet.ui.internal;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.core.runtime.IAdapterManager;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.wst.common.project.facet.core.IActionConfig;
import org.eclipse.wst.common.project.facet.core.ICategory;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IPreset;
import org.eclipse.wst.common.project.facet.core.IProjectFacet;
import org.eclipse.wst.common.project.facet.core.runtime.IRuntime;
import org.eclipse.wst.common.project.facet.ui.AddRemoveFacetsWizard;
import org.eclipse.wst.common.project.facet.ui.IWizardContext;
import org.eclipse.wst.common.project.facet.ui.internal.FacetsSelectionPanel;

public final class FacetsSelectionPage
extends WizardPage {
    private IWizardContext context;
    private Set base;
    private IPreset initialPreset;
    private Set initialSelection;
    private final Set fixed;
    private FacetsSelectionPanel.IFilter[] filters;
    public FacetsSelectionPanel panel;
    private ArrayList listeners;
    private ArrayList runtimeListeners;
    static /* synthetic */ Class class$0;

    public FacetsSelectionPage(IWizardContext context, Set base) {
        super("facets.selection.page");
        this.setTitle("Select Project Facets");
        this.setDescription("Select facets for this project.");
        this.context = context;
        this.base = base;
        this.initialPreset = null;
        this.initialSelection = null;
        this.fixed = new HashSet();
        this.filters = new FacetsSelectionPanel.IFilter[0];
        this.listeners = new ArrayList();
        this.runtimeListeners = new ArrayList();
    }

    public void setInitialPreset(IPreset preset) {
        this.initialPreset = preset;
    }

    public void setInitialSelection(Set sel) {
        this.initialSelection = sel;
    }

    public void setFixedProjectFacets(Set fixed) {
        this.fixed.clear();
        this.fixed.addAll(fixed);
    }

    public void setFilters(FacetsSelectionPanel.IFilter[] filters) {
        this.filters = filters;
    }

    public Set getActions() {
        return this.panel.getActions();
    }

    public Set getSelectedProjectFacets() {
        return this.panel.getSelectedProjectFacets();
    }

    public void addSelectedFacetsChangedListener(Listener listener) {
        this.listeners.add(listener);
    }

    public void removeSelectedFacetsChangedListener(Listener listener) {
        this.listeners.remove(listener);
    }

    public final void addRuntimeListener(Listener listener) {
        this.runtimeListeners.add(listener);
    }

    public final void removeRuntimeListener(Listener listener) {
        this.runtimeListeners.remove(listener);
    }

    public IRuntime getSelectedRuntime() {
        return this.panel.getRuntime();
    }

    public void createControl(Composite parent) {
        AddRemoveFacetsWizard wizard = (AddRemoveFacetsWizard)this.getWizard();
        IRuntime initialRuntime = wizard.getRuntime();
        this.panel = new FacetsSelectionPanel(parent, 0, this.context, this.base);
        this.panel.setFixedProjectFacets(this.fixed);
        this.panel.setRuntime(initialRuntime);
        if (this.initialPreset != null) {
            this.panel.selectPreset(this.initialPreset);
        }
        if (this.initialSelection != null) {
            this.panel.setSelectedProjectFacets(this.initialSelection);
        }
        int i = 0;
        while (i < this.filters.length) {
            this.panel.addFilter(this.filters[i]);
            ++i;
        }
        this.panel.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent e) {
                FacetsSelectionPage.this.handleSelectionChangedEvent(e);
            }
        });
        this.panel.addProjectFacetsListener(new Listener(){

            public void handleEvent(Event event) {
                FacetsSelectionPage.this.handleSelectedFacetsChangedEvent(event);
            }
        });
        this.panel.addRuntimeListener(new Listener(){

            public void handleEvent(Event event) {
                FacetsSelectionPage.this.handleRuntimeChangedEvent(event);
            }
        });
        this.setControl((Control)this.panel);
    }

    private void handleSelectionChangedEvent(SelectionChangedEvent e) {
        IStructuredSelection ss = (IStructuredSelection)e.getSelection();
        Object sel = ss.getFirstElement();
        if (sel != null) {
            String desc = sel instanceof IProjectFacet ? ((IProjectFacet)sel).getDescription() : ((ICategory)sel).getDescription();
            this.setDescription(desc);
        }
    }

    private void handleSelectedFacetsChangedEvent(Event event) {
        this.setPageComplete(this.panel.isSelectionValid());
        int i = 0;
        int n = this.listeners.size();
        while (i < n) {
            ((Listener)this.listeners.get(i)).handleEvent(event);
            ++i;
        }
        this.getContainer().updateButtons();
    }

    private void handleRuntimeChangedEvent(Event event) {
        int i = 0;
        int n = this.runtimeListeners.size();
        while (i < n) {
            ((Listener)this.runtimeListeners.get(i)).handleEvent(event);
            ++i;
        }
    }

    public void setVisible(boolean visible) {
        if (visible) {
            Iterator itr = this.panel.getActions().iterator();
            while (itr.hasNext()) {
                Object config = ((IFacetedProject.Action)itr.next()).getConfig();
                if (config == null) continue;
                IActionConfig c = null;
                if (config instanceof IActionConfig) {
                    c = (IActionConfig)config;
                } else {
                    IAdapterManager m = Platform.getAdapterManager();
                    Class<?> clazz = class$0;
                    if (clazz == null) {
                        try {
                            clazz = Class.forName("org.eclipse.wst.common.project.facet.core.IActionConfig");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    String t = clazz.getName();
                    c = (IActionConfig)m.loadAdapter(config, t);
                }
                if (c == null) continue;
                c.setProjectName(this.context.getProjectName());
            }
        }
        super.setVisible(visible);
    }
}

