/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.project.facet.ui.internal;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IProjectFacet;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.eclipse.wst.common.project.facet.core.runtime.RuntimeManager;
import org.eclipse.wst.common.project.facet.ui.internal.FacetUiPlugin;
import org.osgi.framework.Bundle;

public final class ProjectFacetsUiManagerImpl {
    private static final String EXTENSION_ID = "wizard";
    private static final String IMAGES_EXTENSION_ID = "images";
    private static final HashMap metadata;
    private static final HashMap icons;
    private static ImageDescriptor defaultIcon;

    static {
        icons = new HashMap();
        ProjectFacetsManager.getProjectFacets();
        RuntimeManager.getRuntimeComponentTypes();
        metadata = new HashMap();
        Bundle bundle = Platform.getBundle((String)"org.eclipse.wst.common.project.facet.ui");
        URL url = bundle.getEntry("images/unknown.gif");
        defaultIcon = ImageDescriptor.createFromURL((URL)url);
        ProjectFacetsUiManagerImpl.readExtensions();
        ProjectFacetsUiManagerImpl.readImagesExtensions();
    }

    private ProjectFacetsUiManagerImpl() {
    }

    public static ImageDescriptor getIcon(Object obj) {
        ImageDescriptor imgdesc = (ImageDescriptor)icons.get(obj);
        return imgdesc != null ? imgdesc : defaultIcon;
    }

    public static List getWizardPages(IFacetedProject.Action.Type actionType, IProjectFacetVersion f) {
        List clnames;
        WizardPagesInfo info = (WizardPagesInfo)metadata.get(f);
        if (info != null && (clnames = (List)info.pagesets.get(actionType)) != null) {
            return ProjectFacetsUiManagerImpl.getWizardPages(info.plugin, clnames);
        }
        return Collections.EMPTY_LIST;
    }

    private static List getWizardPages(String plugin, List clnames) {
        ArrayList<Object> pages = new ArrayList<Object>();
        Iterator itr = clnames.iterator();
        while (itr.hasNext()) {
            try {
                pages.add(ProjectFacetsUiManagerImpl.create(plugin, (String)itr.next()));
            }
            catch (CoreException e) {
                FacetUiPlugin.log((Exception)((Object)e));
            }
        }
        return pages;
    }

    private static Object create(String plugin, String clname) throws CoreException {
        Bundle bundle = Platform.getBundle((String)plugin);
        try {
            Class cl = bundle.loadClass(clname);
            return cl.newInstance();
        }
        catch (Exception e) {
            String msg = NLS.bind((String)Resources.failedToCreate, (Object)clname);
            IStatus st = FacetUiPlugin.createErrorStatus(msg, e);
            throw new CoreException(st);
        }
    }

    private static void readExtensions() {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint point = registry.getExtensionPoint("org.eclipse.wst.common.project.facet.ui", EXTENSION_ID);
        if (point == null) {
            throw new RuntimeException("Extension point not found!");
        }
        IExtension[] extensions = point.getExtensions();
        int i = 0;
        while (i < extensions.length) {
            IConfigurationElement[] elements = extensions[i].getConfigurationElements();
            int j = 0;
            while (j < elements.length) {
                IConfigurationElement config = elements[j];
                String ename = config.getName();
                if (ename.equals("wizard-pages")) {
                    ProjectFacetsUiManagerImpl.readWizardPagesInfo(config);
                }
                ++j;
            }
            ++i;
        }
    }

    /*
     * WARNING - void declaration
     */
    private static void readWizardPagesInfo(IConfigurationElement config) {
        String id = config.getAttribute("facet");
        if (id == null) {
            ProjectFacetsUiManagerImpl.reportMissingAttribute(config, "facet");
            return;
        }
        if (!ProjectFacetsManager.isProjectFacetDefined((String)id)) {
            String msg = NLS.bind((String)Resources.facetNotDefined, (Object)config.getNamespace(), (Object)id);
            FacetUiPlugin.log(msg);
            return;
        }
        IProjectFacet f = ProjectFacetsManager.getProjectFacet((String)id);
        String version = config.getAttribute("version");
        if (version == null) {
            ProjectFacetsUiManagerImpl.reportMissingAttribute(config, "version");
            return;
        }
        if (!f.hasVersion(version)) {
            Object[] params = new String[]{config.getNamespace(), id, version};
            String msg = NLS.bind((String)Resources.facetVersionNotDefined, (Object[])params);
            FacetUiPlugin.log(msg);
            return;
        }
        IProjectFacetVersion fv = f.getVersion(version);
        WizardPagesInfo info = new WizardPagesInfo();
        info.plugin = config.getDeclaringExtension().getNamespace();
        IConfigurationElement[] children = config.getChildren();
        int i = 0;
        while (i < children.length) {
            void var10_13;
            IFacetedProject.Action.Type actionType;
            IConfigurationElement child = children[i];
            String childName = child.getName();
            if (childName.equals("install")) {
                actionType = IFacetedProject.Action.Type.INSTALL;
            } else if (childName.equals("uninstall")) {
                actionType = IFacetedProject.Action.Type.UNINSTALL;
            } else if (childName.equals("version-change")) {
                actionType = IFacetedProject.Action.Type.UNINSTALL;
            } else {
                String msg = NLS.bind((String)Resources.invalidActionType, (Object)config.getNamespace(), (Object)childName);
                FacetUiPlugin.log(msg);
                return;
            }
            info.pagesets.put(var10_13, ProjectFacetsUiManagerImpl.readPageList(child));
            ++i;
        }
        metadata.put(fv, info);
    }

    private static List readPageList(IConfigurationElement config) {
        ArrayList<String> list = new ArrayList<String>();
        IConfigurationElement[] children = config.getChildren();
        int i = 0;
        while (i < children.length) {
            IConfigurationElement child = children[i];
            String childName = child.getName();
            if (childName.equals("page")) {
                String clname = child.getAttribute("class");
                if (clname == null) {
                    ProjectFacetsUiManagerImpl.reportMissingAttribute(config, "class");
                } else {
                    list.add(clname);
                }
            }
            ++i;
        }
        return list;
    }

    private static void readImagesExtensions() {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint point = registry.getExtensionPoint("org.eclipse.wst.common.project.facet.ui", IMAGES_EXTENSION_ID);
        if (point == null) {
            throw new RuntimeException("Extension point not found!");
        }
        IExtension[] extensions = point.getExtensions();
        int i = 0;
        while (i < extensions.length) {
            IConfigurationElement[] elements = extensions[i].getConfigurationElements();
            int j = 0;
            while (j < elements.length) {
                IConfigurationElement config = elements[j];
                String ename = config.getName();
                if (ename.equals("image")) {
                    ProjectFacetsUiManagerImpl.readImage(config);
                }
                ++j;
            }
            ++i;
        }
    }

    private static void readImage(IConfigurationElement config) {
        String plugin;
        Bundle bundle;
        URL url;
        IProjectFacet target;
        String fid = config.getAttribute("facet");
        String cid = config.getAttribute("category");
        String rct = config.getAttribute("runtime-component-type");
        if (fid != null) {
            if (!ProjectFacetsManager.isProjectFacetDefined((String)fid)) {
                String msg = NLS.bind((String)Resources.facetNotDefined, (Object)config.getNamespace(), (Object)fid);
                FacetUiPlugin.log(msg);
                return;
            }
            target = ProjectFacetsManager.getProjectFacet((String)fid);
        } else if (cid != null) {
            if (!ProjectFacetsManager.isCategoryDefined((String)cid)) {
                String msg = NLS.bind((String)Resources.categoryNotDefined, (Object)config.getNamespace(), (Object)fid);
                FacetUiPlugin.log(msg);
                return;
            }
            target = ProjectFacetsManager.getCategory((String)cid);
        } else if (rct != null) {
            if (!RuntimeManager.isRuntimeComponentTypeDefined((String)rct)) {
                String msg = NLS.bind((String)Resources.runtimeComponentTypeNotDefined, (Object)config.getNamespace(), (Object)rct);
                FacetUiPlugin.log(msg);
                return;
            }
            target = RuntimeManager.getRuntimeComponentType((String)rct);
        } else {
            ProjectFacetsUiManagerImpl.reportMissingAttribute(config, "facet");
            return;
        }
        String path = config.getAttribute("path");
        if (path == null) {
            ProjectFacetsUiManagerImpl.reportMissingAttribute(config, "path");
        }
        if ((url = (bundle = Platform.getBundle((String)(plugin = config.getNamespace()))).getEntry(path)) == null) {
            String msg = NLS.bind((String)Resources.iconNotFound, (Object)plugin, (Object)path);
            FacetUiPlugin.log(msg);
        } else {
            ImageDescriptor imgdesc = ImageDescriptor.createFromURL((URL)url);
            icons.put(target, imgdesc);
        }
    }

    private static void reportMissingAttribute(IConfigurationElement el, String attribute) {
        Object[] params = new String[]{el.getNamespace(), el.getName(), attribute};
        String msg = NLS.bind((String)Resources.missingAttribute, (Object[])params);
        FacetUiPlugin.log(msg);
    }

    private static class WizardPagesInfo {
        public String plugin;
        public HashMap pagesets = new HashMap();

        WizardPagesInfo() {
        }
    }

    private static final class Resources
    extends NLS {
        public static String missingAttribute;
        public static String facetNotDefined;
        public static String facetVersionNotDefined;
        public static String categoryNotDefined;
        public static String runtimeComponentTypeNotDefined;
        public static String failedToCreate;
        public static String invalidActionType;
        public static String iconNotFound;
        static /* synthetic */ Class class$0;
        static /* synthetic */ Class class$1;

        static {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.wst.common.project.facet.ui.internal.ProjectFacetsUiManagerImpl");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            String string = clazz.getName();
            Class<?> clazz2 = class$1;
            if (clazz2 == null) {
                try {
                    clazz2 = class$1 = Class.forName("org.eclipse.wst.common.project.facet.ui.internal.ProjectFacetsUiManagerImpl$Resources");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            Resources.initializeMessages((String)string, (Class)clazz2);
        }

        Resources() {
        }
    }
}

