/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.html.core.internal.document;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.wst.html.core.internal.document.HTMLDocumentTypeAdapterFactory;
import org.eclipse.wst.html.core.internal.document.HTMLDocumentTypeConstants;
import org.eclipse.wst.html.core.internal.document.HTMLDocumentTypeEntry;
import org.eclipse.wst.html.core.internal.document.HTMLDocumentTypeRegistry;
import org.eclipse.wst.sse.core.internal.provisional.INodeAdapter;
import org.eclipse.wst.sse.core.internal.provisional.INodeNotifier;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.internal.contentproperties.ContentSettings;
import org.eclipse.wst.sse.internal.contentproperties.ContentSettingsChangeSubject;
import org.eclipse.wst.sse.internal.contentproperties.IContentSettings;
import org.eclipse.wst.sse.internal.contentproperties.IContentSettingsListener;
import org.eclipse.wst.xml.core.internal.document.DocumentTypeAdapterImpl;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocumentType;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Node;

public class HTMLDocumentTypeAdapter
extends DocumentTypeAdapterImpl
implements IContentSettingsListener,
HTMLDocumentTypeConstants {
    private HTMLDocumentTypeAdapterFactory fFactory = null;
    private HTMLDocumentTypeEntry entry = null;
    private boolean isXMLType = false;
    private static final String XML = "xml";
    private static final String XHTML = "xhtml";
    private static final String WML = "wml";
    static /* synthetic */ Class class$0;

    protected HTMLDocumentTypeAdapter() {
    }

    protected HTMLDocumentTypeAdapter(IDOMDocument document, HTMLDocumentTypeAdapterFactory factory) {
        super(document);
        this.fFactory = factory;
        this.documentTypeChanged();
        ContentSettingsChangeSubject.getSubject().addListener((IContentSettingsListener)this);
    }

    public void contentSettingsChanged(IResource resource) {
        if (resource == null) {
            return;
        }
        IDOMDocument document = this.getDocument();
        if (document == null) {
            return;
        }
        IDOMModel model = document.getModel();
        if (model == null) {
            return;
        }
        IFile file = this.getFile((IStructuredModel)model);
        if (file == null) {
            return;
        }
        IProject project = file.getProject();
        if (project == null) {
            return;
        }
        if (!project.equals((Object)resource.getProject())) {
            return;
        }
        this.documentTypeChanged();
    }

    private void documentTypeChanged() {
        DOMImplementation impl;
        DocumentType oldDocumentType;
        boolean newWMLType;
        IDOMDocument document = this.getDocument();
        if (document == null) {
            return;
        }
        IDOMModel model = document.getModel();
        if (model == null) {
            return;
        }
        IFile file = this.getFile((IStructuredModel)model);
        String publicId = null;
        Object newDocumentType = this.findDocumentType(document);
        publicId = newDocumentType != null ? newDocumentType.getPublicId() : this.getDefaultPublicId(file);
        HTMLDocumentTypeEntry newEntry = null;
        if (publicId != null) {
            newEntry = HTMLDocumentTypeRegistry.getInstance().getEntry(publicId);
        }
        boolean newXMLType = newEntry != null ? newEntry.isXMLType() : false;
        boolean bl = newWMLType = newEntry != null ? newEntry.isWMLType() : false;
        if (!newXMLType) {
            if (this.findXMLNode((Document)document) != null) {
                newXMLType = true;
            }
            if (file != null) {
                String ext = file.getFileExtension();
                if (ext != null && ext.equalsIgnoreCase(XHTML)) {
                    newXMLType = true;
                }
                if (ext != null && ext.equalsIgnoreCase(WML)) {
                    newXMLType = true;
                    newWMLType = true;
                }
            }
        }
        if (newEntry == null) {
            newEntry = newXMLType && newDocumentType == null ? (newWMLType ? HTMLDocumentTypeRegistry.getInstance().getDefaultEntry(2) : HTMLDocumentTypeRegistry.getInstance().getDefaultEntry(1)) : HTMLDocumentTypeRegistry.getInstance().getDefaultEntry(0);
            if (newEntry == null) {
                return;
            }
        }
        if (newDocumentType == null && ((oldDocumentType = this.getDocumentType()) == null || oldDocumentType.getName() != newEntry.getName()) && (impl = document.getImplementation()) != null) {
            String name = newEntry.getName();
            publicId = newEntry.getPublicId();
            String systemId = newEntry.getSystemId();
            newDocumentType = impl.createDocumentType(name, publicId, systemId);
        }
        boolean notify = false;
        if (this.entry != null) {
            boolean bl2 = notify = newEntry != this.entry || newXMLType != this.isXMLType;
        }
        if (newDocumentType != null) {
            this.setDocumentType((DocumentType)newDocumentType);
        }
        this.entry = newEntry;
        this.isXMLType = newXMLType;
        if (notify) {
            this.notifyDocumentTypeChanged();
        }
    }

    private IDOMDocumentType findDocumentType(IDOMDocument document) {
        IDOMDocumentType documentType = (IDOMDocumentType)document.getDoctype();
        if (documentType != null) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.wst.xml.core.internal.document.DocumentTypeAdapter");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (documentType.getExistingAdapter((Object)clazz) == null) {
                documentType.addAdapter((INodeAdapter)this);
            }
        }
        return documentType;
    }

    private Node findXMLNode(Document document) {
        Node child = document.getFirstChild();
        while (child != null) {
            String target;
            if (child.getNodeType() == 7 && (target = child.getNodeName()) != null && target.equals(XML)) {
                return child;
            }
            child = child.getNextSibling();
        }
        return null;
    }

    public int getAttrNameCase() {
        if (this.isXMLType()) {
            return 2;
        }
        return this.fFactory.getAttrNameCase();
    }

    private String getDefaultPublicId(IFile file) {
        if (file == null) {
            return null;
        }
        IProject project = file.getProject();
        if (project == null) {
            return null;
        }
        IContentSettings settings = ContentSettings.getInstance();
        if (settings == null) {
            return null;
        }
        String publicId = settings.getProperty((IResource)file, "html-document-type");
        if (publicId == null || publicId.length() == 0) {
            publicId = settings.getProperty((IResource)project, "html-document-type");
        }
        return publicId;
    }

    private IFile getFile(IStructuredModel model) {
        Path path;
        IFile result = null;
        String location = model.getBaseLocation();
        if (location != null && !(path = new Path(location)).toFile().exists() && path.segmentCount() > 1) {
            result = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)path);
        }
        return result;
    }

    public int getTagNameCase() {
        if (this.isXMLType()) {
            return 2;
        }
        return this.fFactory.getTagNameCase();
    }

    public boolean hasFeature(String feature) {
        if (feature == null) {
            return false;
        }
        if (feature.equals("HTML")) {
            return true;
        }
        if (feature.equals("SSI")) {
            return true;
        }
        if (feature.equals("FRAMESET")) {
            if (this.entry == null) {
                return false;
            }
            return this.entry.hasFrameset();
        }
        return false;
    }

    public boolean isXMLType() {
        return this.isXMLType;
    }

    public void notifyChanged(INodeNotifier notifier, int eventType, Object changedFeature, Object oldValue, Object newValue, int pos) {
        if (notifier == null) {
            return;
        }
        if (notifier instanceof IDOMDocument ? eventType != 4 : eventType != 1) {
            return;
        }
        this.documentTypeChanged();
    }

    public void release() {
        ContentSettingsChangeSubject.getSubject().removeListener((IContentSettingsListener)this);
        super.release();
    }
}

