/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.server.core.internal;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.ServerUtil;
import org.eclipse.wst.server.core.internal.DeletedModule;
import org.eclipse.wst.server.core.internal.IMemento;
import org.eclipse.wst.server.core.internal.ModulePublishInfo;
import org.eclipse.wst.server.core.internal.ModuleResourceDelta;
import org.eclipse.wst.server.core.internal.Trace;
import org.eclipse.wst.server.core.internal.XMLMemento;
import org.eclipse.wst.server.core.model.IModuleFile;
import org.eclipse.wst.server.core.model.IModuleFolder;
import org.eclipse.wst.server.core.model.IModuleResource;
import org.eclipse.wst.server.core.model.IModuleResourceDelta;
import org.eclipse.wst.server.core.model.ModuleDelegate;

public class ServerPublishInfo {
    protected IPath path;
    protected Map modulePublishInfo;
    static /* synthetic */ Class class$0;

    protected ServerPublishInfo(IPath path) {
        this.path = path;
        this.modulePublishInfo = new HashMap();
        this.load();
    }

    private String getKey(IModule[] module) {
        StringBuffer sb = new StringBuffer();
        if (module != null) {
            int size = module.length;
            int i = 0;
            while (i < size) {
                if (i != 0) {
                    sb.append("#");
                }
                sb.append(module[i].getId());
                ++i;
            }
        }
        return sb.toString();
    }

    private String getKey(String moduleId) {
        return moduleId;
    }

    private IModule[] getModule(String moduleId) {
        if (moduleId == null || moduleId.length() == 0) {
            return new IModule[0];
        }
        ArrayList<IModule> list = new ArrayList<IModule>();
        StringTokenizer st = new StringTokenizer(moduleId, "#");
        while (st.hasMoreTokens()) {
            String mid = st.nextToken();
            if (mid == null || mid.length() <= 0) continue;
            IModule m = ServerUtil.getModule(mid);
            if (m == null) {
                return null;
            }
            list.add(m);
        }
        IModule[] modules = new IModule[list.size()];
        list.toArray(modules);
        return modules;
    }

    public boolean hasModulePublishInfo(IModule[] module) {
        String key = this.getKey(module);
        return this.modulePublishInfo.containsKey(key);
    }

    public void removeDeletedModulePublishInfo(List moduleList) {
        String key;
        int size = moduleList.size();
        ArrayList<String> removed = new ArrayList<String>();
        Iterator<Object> iterator = this.modulePublishInfo.keySet().iterator();
        while (iterator.hasNext()) {
            key = (String)iterator.next();
            boolean found = false;
            int i = 0;
            while (i < size) {
                IModule[] module = (IModule[])moduleList.get(i);
                String key2 = this.getKey(module);
                if (key != null && key.equals(key2)) {
                    found = true;
                }
                ++i;
            }
            if (found) continue;
            removed.add(key);
        }
        iterator = removed.iterator();
        while (iterator.hasNext()) {
            key = (String)iterator.next();
            this.modulePublishInfo.remove(key);
        }
        this.save();
    }

    protected ModulePublishInfo getModulePublishInfo(IModule[] module) {
        String key = this.getKey(module);
        if (this.modulePublishInfo.containsKey(key)) {
            return (ModulePublishInfo)this.modulePublishInfo.get(key);
        }
        ModulePublishInfo mpi = new ModulePublishInfo(this.getKey(module), module[module.length - 1].getName());
        this.modulePublishInfo.put(key, mpi);
        return mpi;
    }

    public void addRemovedModules(List moduleList, List kindList) {
        int size = moduleList.size();
        ArrayList<ModulePublishInfo> removed = new ArrayList<ModulePublishInfo>();
        Iterator<Object> iterator = this.modulePublishInfo.keySet().iterator();
        while (iterator.hasNext()) {
            String key = (String)iterator.next();
            boolean found = false;
            int i = 0;
            while (i < size) {
                IModule[] module = (IModule[])moduleList.get(i);
                String key2 = this.getKey(module);
                if (key != null && key.equals(key2)) {
                    found = true;
                }
                ++i;
            }
            if (found) continue;
            ModulePublishInfo mpi = (ModulePublishInfo)this.modulePublishInfo.get(key);
            removed.add(mpi);
        }
        iterator = removed.iterator();
        while (iterator.hasNext()) {
            String moduleId;
            ModulePublishInfo mpi = (ModulePublishInfo)iterator.next();
            IModule[] module2 = this.getModule(mpi.getModuleId());
            if ((module2 == null || module2.length == 0) && (moduleId = mpi.getModuleId()) != null) {
                int index = moduleId.lastIndexOf("#");
                module2 = new IModule[]{new DeletedModule(moduleId.substring(index + 1), mpi.getName())};
            }
            if (module2 == null || module2.length <= 0) continue;
            moduleList.add(module2);
            kindList.add(new Integer(3));
        }
    }

    public void load() {
        String filename = this.path.toOSString();
        if (!new File(filename).exists()) {
            return;
        }
        Trace.trace(Trace.FINEST, "Loading publish info from " + filename);
        try {
            IMemento memento2 = XMLMemento.loadMemento(filename);
            IMemento[] children = memento2.getChildren("module");
            int size = children.length;
            int i = 0;
            while (i < size) {
                ModulePublishInfo mpi = new ModulePublishInfo(children[i]);
                this.modulePublishInfo.put(this.getKey(mpi.getModuleId()), mpi);
                ++i;
            }
        }
        catch (Exception e) {
            Trace.trace(Trace.WARNING, "Could not load publish information: " + e.getMessage());
        }
    }

    public void save() {
        String filename = this.path.toOSString();
        Trace.trace(Trace.FINEST, "Saving publish info to " + filename);
        try {
            XMLMemento memento = XMLMemento.createWriteRoot("server");
            Iterator iterator = this.modulePublishInfo.keySet().iterator();
            while (iterator.hasNext()) {
                String controlRef = (String)iterator.next();
                ModulePublishInfo mpi = (ModulePublishInfo)this.modulePublishInfo.get(controlRef);
                IMemento child = memento.createChild("module");
                mpi.save(child);
            }
            memento.saveToFile(filename);
        }
        catch (Exception e) {
            Trace.trace(Trace.SEVERE, "Could not save publish information", e);
        }
    }

    public void fill(IModule[] module) {
        ModulePublishInfo mpi = this.getModulePublishInfo(module);
        int size = module.length;
        IModule iModule = module[size - 1];
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.wst.server.core.model.ModuleDelegate");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ModuleDelegate pm = (ModuleDelegate)iModule.loadAdapter(clazz, null);
        try {
            if (pm != null) {
                mpi.setResources(pm.members());
            }
        }
        catch (CoreException coreException) {}
        this.save();
    }

    protected IModuleResourceDelta[] getDelta(IModule[] module) {
        if (module == null) {
            return new IModuleResourceDelta[0];
        }
        ModulePublishInfo mpi = this.getModulePublishInfo(module);
        int size = module.length;
        IModule iModule = module[size - 1];
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.wst.server.core.model.ModuleDelegate");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ModuleDelegate pm = (ModuleDelegate)iModule.loadAdapter(clazz, null);
        IModuleResource[] resources = null;
        try {
            if (pm != null) {
                resources = pm.members();
            }
        }
        catch (CoreException coreException) {}
        if (resources == null) {
            resources = new IModuleResource[]{};
        }
        return this.getDelta(mpi.getResources(), resources);
    }

    protected IModuleResourceDelta[] getDelta(IModuleResource[] original, IModuleResource[] current) {
        if (original == null || current == null) {
            return new IModuleResourceDelta[0];
        }
        ArrayList<ModuleResourceDelta> list = new ArrayList<ModuleResourceDelta>();
        int size = original.length;
        int size2 = current.length;
        HashMap<IModuleResource, IModuleResource> originalMap = new HashMap<IModuleResource, IModuleResource>(size);
        int i = 0;
        while (i < size) {
            originalMap.put(original[i], original[i]);
            ++i;
        }
        i = 0;
        while (i < size2) {
            IModuleResource mf2;
            IModuleResource mf1;
            IModuleResource old = (IModuleResource)originalMap.remove(current[i]);
            if (old == null) {
                ModuleResourceDelta delta = new ModuleResourceDelta(current[i], 1);
                if (current[i] instanceof IModuleFolder) {
                    IModuleFolder currentFolder = (IModuleFolder)current[i];
                    delta.setChildren(this.getDeltaTree(currentFolder.members(), 1));
                }
                list.add(delta);
            } else if (current[i] instanceof IModuleFile) {
                mf1 = (IModuleFile)old;
                mf2 = (IModuleFile)current[i];
                if (mf1.getModificationStamp() != mf2.getModificationStamp()) {
                    list.add(new ModuleResourceDelta(current[i], 2));
                }
            } else {
                mf1 = (IModuleFolder)old;
                mf2 = (IModuleFolder)current[i];
                IModuleResourceDelta[] mrdc = this.getDelta(mf1.members(), mf2.members());
                if (mrdc.length > 0) {
                    ModuleResourceDelta mrd = new ModuleResourceDelta(current[i], 0);
                    mrd.setChildren(mrdc);
                    list.add(mrd);
                }
            }
            ++i;
        }
        i = 0;
        while (i < size) {
            if (originalMap.containsKey(original[i])) {
                ModuleResourceDelta delta = new ModuleResourceDelta(original[i], 3);
                if (original[i] instanceof IModuleFolder) {
                    IModuleFolder removedFolder = (IModuleFolder)original[i];
                    delta.setChildren(this.getDeltaTree(removedFolder.members(), 3));
                }
                list.add(delta);
            }
            ++i;
        }
        return list.toArray(new IModuleResourceDelta[list.size()]);
    }

    protected boolean hasDelta(IModule[] module) {
        if (module == null) {
            return false;
        }
        ModulePublishInfo mpi = this.getModulePublishInfo(module);
        int size = module.length;
        IModule iModule = module[size - 1];
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.wst.server.core.model.ModuleDelegate");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ModuleDelegate pm = (ModuleDelegate)iModule.loadAdapter(clazz, null);
        IModuleResource[] resources = null;
        try {
            if (pm != null) {
                resources = pm.members();
            }
        }
        catch (CoreException coreException) {}
        if (resources == null) {
            resources = new IModuleResource[]{};
        }
        return this.hasDelta(mpi.getResources(), resources);
    }

    protected boolean hasDelta(IModuleResource[] original, IModuleResource[] current) {
        if (original == null || current == null) {
            return false;
        }
        int size = original.length;
        int size2 = current.length;
        HashMap<IModuleResource, IModuleResource> originalMap = new HashMap<IModuleResource, IModuleResource>(size);
        int i = 0;
        while (i < size) {
            originalMap.put(original[i], original[i]);
            ++i;
        }
        i = 0;
        while (i < size2) {
            IModuleResource mf2;
            IModuleResource mf1;
            IModuleResource old = (IModuleResource)originalMap.remove(current[i]);
            if (old == null) {
                return true;
            }
            if (current[i] instanceof IModuleFile) {
                mf1 = (IModuleFile)old;
                mf2 = (IModuleFile)current[i];
                if (mf1.getModificationStamp() != mf2.getModificationStamp()) {
                    return true;
                }
            } else {
                mf1 = (IModuleFolder)old;
                mf2 = (IModuleFolder)current[i];
                if (this.hasDelta(mf1.members(), mf2.members())) {
                    return true;
                }
            }
            ++i;
        }
        return !originalMap.isEmpty();
    }

    protected IModuleResourceDelta[] getDeltaTree(IModuleResource[] resources, int kind) {
        if (resources == null) {
            return new IModuleResourceDelta[0];
        }
        ArrayList<ModuleResourceDelta> list = new ArrayList<ModuleResourceDelta>();
        int size = resources.length;
        int i = 0;
        while (i < size) {
            ModuleResourceDelta mrd = new ModuleResourceDelta(resources[i], kind);
            if (resources[i] instanceof IModuleFolder) {
                IModuleFolder mf = (IModuleFolder)resources[i];
                mrd.setChildren(this.getDeltaTree(mf.members(), kind));
            }
            list.add(mrd);
            ++i;
        }
        IModuleResourceDelta[] delta = new IModuleResourceDelta[list.size()];
        list.toArray(delta);
        return delta;
    }

    protected boolean hasStructureChanged(List modules) {
        return modules.size() != this.modulePublishInfo.keySet().size();
    }
}

