/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.server.ui.internal.view.servers;

import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.internal.PublishServerJob;
import org.eclipse.wst.server.core.internal.RestartServerJob;
import org.eclipse.wst.server.ui.internal.ServerUIPlugin;
import org.eclipse.wst.server.ui.internal.Trace;
import org.eclipse.wst.server.ui.internal.provisional.UIDecoratorManager;
import org.eclipse.wst.server.ui.internal.view.servers.AbstractServerAction;

public class RestartAction
extends AbstractServerAction {
    protected String mode;

    public RestartAction(Shell shell, ISelectionProvider selectionProvider, String name) {
        this(shell, selectionProvider, name, null);
    }

    public RestartAction(Shell shell, ISelectionProvider selectionProvider, String name, String mode) {
        super(shell, selectionProvider, name);
        try {
            this.selectionChanged((IStructuredSelection)selectionProvider.getSelection());
        }
        catch (Exception exception) {}
        this.mode = mode;
    }

    public boolean accept(IServer server) {
        String mode2 = this.mode;
        if (mode2 == null) {
            mode2 = server.getMode();
        }
        return server.getServerType() != null && UIDecoratorManager.getUIDecorator(server.getServerType()).canRestart() && server.canRestart(mode2).isOK();
    }

    public void perform(IServer server) {
        if (!ServerUIPlugin.promptIfDirty(this.shell, server)) {
            return;
        }
        try {
            PublishServerJob publishJob = new PublishServerJob(server, 1, false);
            String launchMode = this.mode;
            if (launchMode == null) {
                launchMode = server.getMode();
            }
            RestartServerJob restartJob = new RestartServerJob(server, launchMode);
            publishJob.setNextJob((Job)restartJob);
            publishJob.schedule();
        }
        catch (Exception e) {
            Trace.trace(Trace.SEVERE, "Error restarting server", e);
        }
    }
}

