/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.sse.ui.internal.ui;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentExtension3;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.MarkerAnnotation;
import org.eclipse.ui.texteditor.MarkerUtilities;
import org.eclipse.ui.texteditor.StatusLineContributionItem;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ui.views.properties.IPropertySourceProvider;
import org.eclipse.ui.views.properties.PropertySheetPage;
import org.eclipse.ui.views.properties.TextPropertyDescriptor;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.internal.provisional.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegionCollection;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegionContainer;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegionList;
import org.eclipse.wst.sse.core.internal.util.Utilities;
import org.eclipse.wst.sse.ui.internal.SSEUIMessages;

public class OffsetStatusLineContributionItem
extends StatusLineContributionItem {
    IAction fShowPartitionAction = new ShowPartitionAction();
    ITextEditor fTextEditor = null;

    public OffsetStatusLineContributionItem(String id) {
        super(id);
    }

    public OffsetStatusLineContributionItem(String id, boolean visible, int widthInChars) {
        super(id, visible, widthInChars);
    }

    public void setActiveEditor(ITextEditor textEditor) {
        this.fTextEditor = textEditor;
        this.setActionHandler(this.fShowPartitionAction);
    }

    class InformationDialog
    extends Dialog {
        IDocument fDocument;

        public InformationDialog(Shell parentShell) {
            super(parentShell);
            this.fDocument = OffsetStatusLineContributionItem.this.fTextEditor.getDocumentProvider().getDocument((Object)OffsetStatusLineContributionItem.this.fTextEditor.getEditorInput());
            this.setShellStyle(this.getShellStyle() | 0x10);
        }

        private void createAnnotationContents(Composite annotationsTabComposite) {
            annotationsTabComposite.setLayout((Layout)new GridLayout());
            annotationsTabComposite.setLayoutData((Object)new GridData());
            Composite annotationsComposite = new Composite(annotationsTabComposite, 0);
            annotationsComposite.setLayout((Layout)new GridLayout(2, false));
            annotationsComposite.setLayoutData((Object)new GridData(4, 4, true, true));
            TableViewer annotationsTable = new TableViewer(annotationsComposite, 65536);
            GridData gd = new GridData(4, 4, true, true);
            gd.horizontalSpan = 2;
            annotationsTable.getControl().setLayoutData((Object)gd);
            annotationsTable.setContentProvider((IContentProvider)new ArrayContentProvider());
            annotationsTable.getTable().setHeaderVisible(true);
            annotationsTable.getTable().setLinesVisible(true);
            String[] columns = new String[]{"Line", "Owner", "Type", "Message"};
            annotationsTable.setLabelProvider((IBaseLabelProvider)new ITableLabelProvider(this){
                final /* synthetic */ InformationDialog this$1;
                {
                    this.this$1 = informationDialog;
                }

                public void addListener(ILabelProviderListener listener) {
                }

                public void dispose() {
                }

                public Image getColumnImage(Object element, int columnIndex) {
                    return null;
                }

                public String getColumnText(Object element, int columnIndex) {
                    Annotation annotation = (Annotation)element;
                    String text = null;
                    switch (columnIndex) {
                        case 0: {
                            text = annotation instanceof MarkerAnnotation ? Integer.toString(MarkerUtilities.getLineNumber((IMarker)((MarkerAnnotation)annotation).getMarker())) : "-1";
                            break;
                        }
                        case 1: {
                            text = annotation instanceof MarkerAnnotation ? ((MarkerAnnotation)annotation).getMarker().getAttribute("owner", "n/a") : "?";
                            break;
                        }
                        case 2: {
                            text = annotation instanceof MarkerAnnotation ? MarkerUtilities.getMarkerType((IMarker)((MarkerAnnotation)annotation).getMarker()) : "?";
                            break;
                        }
                        case 3: {
                            text = annotation.getText();
                        }
                    }
                    if (text == null) {
                        text = "";
                    }
                    return text;
                }

                public boolean isLabelProperty(Object element, String property) {
                    return false;
                }

                public void removeListener(ILabelProviderListener listener) {
                }
            });
            TableLayout tlayout = new TableLayout();
            CellEditor[] cellEditors = new CellEditor[columns.length];
            int[] columnWidths = new int[]{Display.getCurrent().getBounds().width / 14, Display.getCurrent().getBounds().width / 7, Display.getCurrent().getBounds().width / 7, Display.getCurrent().getBounds().width / 7};
            int i = 0;
            while (i < columns.length) {
                tlayout.addColumnData((ColumnLayoutData)new ColumnWeightData(1));
                TableColumn tc = new TableColumn(annotationsTable.getTable(), 0);
                tc.setText(columns[i]);
                tc.setResizable(true);
                tc.setWidth(columnWidths[i]);
                ++i;
            }
            annotationsTable.setCellEditors(cellEditors);
            annotationsTable.setColumnProperties(columns);
            ArrayList<Annotation> matchingAnnotations = new ArrayList<Annotation>(0);
            Iterator iterator = OffsetStatusLineContributionItem.this.fTextEditor.getDocumentProvider().getAnnotationModel((Object)OffsetStatusLineContributionItem.this.fTextEditor.getEditorInput()).getAnnotationIterator();
            while (iterator.hasNext()) {
                Annotation element = (Annotation)iterator.next();
                matchingAnnotations.add(element);
            }
            annotationsTable.setInput(matchingAnnotations);
            PropertySheetPage propertySheet = new PropertySheetPage();
            propertySheet.createControl(annotationsComposite);
            gd = new GridData(4, 4, true, true);
            gd.horizontalSpan = 2;
            propertySheet.getControl().setLayoutData((Object)gd);
            propertySheet.setPropertySourceProvider(new IPropertySourceProvider(this){
                final /* synthetic */ InformationDialog this$1;
                {
                    this.this$1 = informationDialog;
                }

                public IPropertySource getPropertySource(Object object) {
                    if (object instanceof MarkerAnnotation) {
                        MarkerAnnotationPropertySource markerAnnotationPropertySource = InformationDialog.access$0(this.this$1).new MarkerAnnotationPropertySource((MarkerAnnotation)object);
                        return markerAnnotationPropertySource;
                    }
                    return null;
                }
            });
            annotationsTable.addSelectionChangedListener(new ISelectionChangedListener(this, propertySheet){
                final /* synthetic */ InformationDialog this$1;
                private final /* synthetic */ PropertySheetPage val$propertySheet;
                {
                    this.this$1 = informationDialog;
                    this.val$propertySheet = propertySheetPage;
                }

                public void selectionChanged(SelectionChangedEvent event) {
                    this.val$propertySheet.selectionChanged(null, event.getSelection());
                }
            });
        }

        protected Control createDialogArea(Composite parent) {
            ISelection sel = OffsetStatusLineContributionItem.this.fTextEditor.getSelectionProvider().getSelection();
            ITextSelection textSelection = (ITextSelection)sel;
            parent.getShell().setText(String.valueOf(SSEUIMessages.OffsetStatusLineContributionItem_0) + textSelection.getOffset() + "-" + (textSelection.getOffset() + textSelection.getLength()));
            Composite composite = (Composite)super.createDialogArea(parent);
            TabFolder tabfolder = new TabFolder(composite, 0);
            tabfolder.setLayoutData((Object)new GridData(1808));
            TabItem partitionTab = new TabItem(tabfolder, 2048);
            partitionTab.setText(SSEUIMessages.OffsetStatusLineContributionItem_2);
            Composite partitions = new Composite((Composite)tabfolder, 0);
            partitionTab.setControl((Control)partitions);
            this.createPartitionContents(partitions);
            if (this.fDocument instanceof IStructuredDocument) {
                TabItem regionTab = new TabItem(tabfolder, 2048);
                regionTab.setText(SSEUIMessages.OffsetStatusLineContributionItem_3);
                SashForm regions = new SashForm((Composite)tabfolder, 0);
                regions.setOrientation(256);
                regionTab.setControl((Control)regions);
                this.createRegionsContents(regions);
            }
            TabItem annotationsTab = new TabItem(tabfolder, 2048);
            annotationsTab.setText("Annotations");
            Composite annotations = new Composite((Composite)tabfolder, 0);
            annotationsTab.setControl((Control)annotations);
            this.createAnnotationContents(annotations);
            return composite;
        }

        private void createPartitionContents(Composite area) {
            Object[] objectArray;
            area.setLayout((Layout)new GridLayout());
            area.setLayoutData((Object)new GridData());
            Composite partioningComposite = new Composite(area, 0);
            partioningComposite.setLayout((Layout)new GridLayout(2, false));
            partioningComposite.setLayoutData((Object)new GridData(4, 4, true, true));
            Text documentTypeLabel = new Text(partioningComposite, 12);
            GridData gd = new GridData(4, 4, true, false);
            gd.horizontalSpan = 2;
            documentTypeLabel.setLayoutData((Object)gd);
            documentTypeLabel.setText(String.valueOf(SSEUIMessages.OffsetStatusLineContributionItem_6) + this.fDocument.getClass().getName());
            Text documentProviderLabel = new Text(partioningComposite, 12);
            gd = new GridData(4, 4, true, false);
            gd.horizontalSpan = 2;
            documentProviderLabel.setLayoutData((Object)gd);
            documentProviderLabel.setText(String.valueOf(SSEUIMessages.OffsetStatusLineContributionItem_7) + OffsetStatusLineContributionItem.this.fTextEditor.getDocumentProvider().getClass().getName());
            Text editorInputLabel = new Text(partioningComposite, 12);
            gd = new GridData(4, 4, true, false);
            gd.horizontalSpan = 2;
            editorInputLabel.setLayoutData((Object)gd);
            editorInputLabel.setText(String.valueOf(SSEUIMessages.OffsetStatusLineContributionItem_12) + OffsetStatusLineContributionItem.this.fTextEditor.getEditorInput().getClass().getName());
            IStructuredModel model = StructuredModelManager.getModelManager().getExistingModelForRead(this.fDocument);
            if (model != null) {
                Text modelContentTypeLabel = new Text(partioningComposite, 12);
                gd = new GridData(4, 4, true, false);
                gd.horizontalSpan = 2;
                modelContentTypeLabel.setLayoutData((Object)gd);
                modelContentTypeLabel.setText(String.valueOf(SSEUIMessages.OffsetStatusLineContributionItem_4) + model.getContentTypeIdentifier());
                Text modelHandlerContentTypeLabel = new Text(partioningComposite, 74);
                gd = new GridData(4, 4, true, false);
                gd.horizontalSpan = 2;
                modelHandlerContentTypeLabel.setLayoutData((Object)gd);
                modelHandlerContentTypeLabel.setText(String.valueOf(SSEUIMessages.OffsetStatusLineContributionItem_5) + model.getModelHandler() + " (" + model.getModelHandler().getAssociatedContentTypeId() + ")");
                Label blankRow = new Label(partioningComposite, 0);
                gd = new GridData(4, 4, true, false);
                gd.horizontalSpan = 2;
                blankRow.setLayoutData((Object)gd);
            }
            if (model != null) {
                model.releaseFromRead();
            }
            Text label = new Text(partioningComposite, 12);
            label.setText(SSEUIMessages.OffsetStatusLineContributionItem_8);
            label.setLayoutData((Object)new GridData(4, 4, false, false));
            Combo partitioningCombo = new Combo(partioningComposite, 8);
            partitioningCombo.setLayoutData((Object)new GridData(4, 4, true, false));
            Text partitionerInstanceLabel = new Text(partioningComposite, 12);
            gd = new GridData(4, 4, true, false);
            gd.horizontalSpan = 2;
            partitionerInstanceLabel.setLayoutData((Object)gd);
            TableViewer fPartitionTable = new TableViewer(partioningComposite, 65536);
            gd = new GridData(4, 4, true, true);
            gd.horizontalSpan = 2;
            fPartitionTable.getControl().setLayoutData((Object)gd);
            fPartitionTable.setContentProvider((IContentProvider)new ArrayContentProvider());
            fPartitionTable.getTable().setHeaderVisible(true);
            fPartitionTable.getTable().setLinesVisible(true);
            String[] columns = new String[]{SSEUIMessages.OffsetStatusLineContributionItem_9, SSEUIMessages.OffsetStatusLineContributionItem_10, SSEUIMessages.OffsetStatusLineContributionItem_11};
            fPartitionTable.setLabelProvider((IBaseLabelProvider)new ITableLabelProvider(this){
                final /* synthetic */ InformationDialog this$1;
                {
                    this.this$1 = informationDialog;
                }

                public void addListener(ILabelProviderListener listener) {
                }

                public void dispose() {
                }

                public Image getColumnImage(Object element, int columnIndex) {
                    return null;
                }

                public String getColumnText(Object element, int columnIndex) {
                    ITypedRegion partition = (ITypedRegion)element;
                    String text = null;
                    switch (columnIndex) {
                        case 0: {
                            text = Integer.toString(partition.getOffset());
                            break;
                        }
                        case 1: {
                            text = Integer.toString(partition.getLength());
                            break;
                        }
                        case 2: {
                            text = partition.getType();
                        }
                    }
                    if (text == null) {
                        text = "";
                    }
                    return text;
                }

                public boolean isLabelProperty(Object element, String property) {
                    return false;
                }

                public void removeListener(ILabelProviderListener listener) {
                }
            });
            TableLayout tlayout = new TableLayout();
            CellEditor[] cellEditors = new CellEditor[columns.length];
            int[] columnWidths = new int[]{Display.getCurrent().getBounds().width / 14, Display.getCurrent().getBounds().width / 14, Display.getCurrent().getBounds().width / 5};
            int i = 0;
            while (i < columns.length) {
                tlayout.addColumnData((ColumnLayoutData)new ColumnWeightData(1));
                TableColumn tc = new TableColumn(fPartitionTable.getTable(), 0);
                tc.setText(columns[i]);
                tc.setResizable(true);
                tc.setWidth(columnWidths[i]);
                ++i;
            }
            fPartitionTable.setCellEditors(cellEditors);
            fPartitionTable.setColumnProperties(columns);
            if (this.fDocument instanceof IDocumentExtension3) {
                objectArray = ((IDocumentExtension3)this.fDocument).getPartitionings();
            } else {
                Object[] objectArray2 = new String[1];
                objectArray = objectArray2;
                objectArray2[0] = "__dftl_partitioning";
            }
            Object[] partitionings = objectArray;
            partitioningCombo.setItems((String[])partitionings);
            partitioningCombo.addSelectionListener((SelectionListener)new SelectionAdapter(this, partitioningCombo, partitionerInstanceLabel, fPartitionTable){
                final /* synthetic */ InformationDialog this$1;
                private final /* synthetic */ Combo val$partitioningCombo;
                private final /* synthetic */ Text val$partitionerInstanceLabel;
                private final /* synthetic */ TableViewer val$fPartitionTable;
                {
                    this.this$1 = informationDialog;
                    this.val$partitioningCombo = combo;
                    this.val$partitionerInstanceLabel = text;
                    this.val$fPartitionTable = tableViewer;
                }

                public void widgetSelected(SelectionEvent e) {
                    ISelection sel = InformationDialog.access$0((InformationDialog)this.this$1).fTextEditor.getSelectionProvider().getSelection();
                    ITextSelection textSelection = (ITextSelection)sel;
                    try {
                        String partitionerText = this.this$1.fDocument instanceof IDocumentExtension3 ? ((IDocumentExtension3)this.this$1.fDocument).getDocumentPartitioner(this.val$partitioningCombo.getItem(this.val$partitioningCombo.getSelectionIndex())).toString() : "" + this.this$1.fDocument.getDocumentPartitioner();
                        this.val$partitionerInstanceLabel.setText(String.valueOf(SSEUIMessages.OffsetStatusLineContributionItem_13) + partitionerText);
                        this.val$fPartitionTable.setInput((Object)TextUtilities.computePartitioning((IDocument)this.this$1.fDocument, (String)this.val$partitioningCombo.getItem(this.val$partitioningCombo.getSelectionIndex()), (int)textSelection.getOffset(), (int)textSelection.getLength(), (boolean)true));
                    }
                    catch (BadLocationException badLocationException) {
                        this.val$fPartitionTable.setInput((Object)new ITypedRegion[0]);
                    }
                }
            });
            try {
                String selectedPartitioning = partitioningCombo.getItem(0);
                if (Utilities.contains((Object[])partitionings, (Object)"org.eclipse.wst.sse.core.default_structured_text_partitioning")) {
                    selectedPartitioning = "org.eclipse.wst.sse.core.default_structured_text_partitioning";
                    int i2 = 0;
                    while (i2 < partitionings.length) {
                        if (((String)partitionings[i2]).equals("org.eclipse.wst.sse.core.default_structured_text_partitioning")) {
                            partitioningCombo.select(i2);
                        }
                        ++i2;
                    }
                } else {
                    partitioningCombo.select(0);
                }
                ISelection sel = OffsetStatusLineContributionItem.this.fTextEditor.getSelectionProvider().getSelection();
                ITextSelection textSelection = (ITextSelection)sel;
                fPartitionTable.setInput((Object)TextUtilities.computePartitioning((IDocument)this.fDocument, (String)selectedPartitioning, (int)textSelection.getOffset(), (int)textSelection.getLength(), (boolean)true));
                String partitionerText = this.fDocument instanceof IDocumentExtension3 ? ((IDocumentExtension3)this.fDocument).getDocumentPartitioner(partitioningCombo.getItem(partitioningCombo.getSelectionIndex())).toString() : "" + this.fDocument.getDocumentPartitioner();
                partitionerInstanceLabel.setText(String.valueOf(SSEUIMessages.OffsetStatusLineContributionItem_13) + partitionerText);
            }
            catch (BadLocationException badLocationException) {
                fPartitionTable.setInput((Object)new ITypedRegion[0]);
            }
            partitioningCombo.setFocus();
        }

        private Composite createRegionsContents(SashForm sashForm) {
            ISelection sel = OffsetStatusLineContributionItem.this.fTextEditor.getSelectionProvider().getSelection();
            ITextSelection textSelection = (ITextSelection)sel;
            ArrayList<IStructuredDocumentRegion> documentRegions = new ArrayList<IStructuredDocumentRegion>();
            if (this.fDocument instanceof IStructuredDocument) {
                IStructuredDocument structuredDocument = (IStructuredDocument)this.fDocument;
                int pos = textSelection.getOffset();
                int end = textSelection.getOffset() + textSelection.getLength();
                IStructuredDocumentRegion docRegion = structuredDocument.getRegionAtCharacterOffset(pos);
                IStructuredDocumentRegion endRegion = structuredDocument.getRegionAtCharacterOffset(end);
                if (pos < end) {
                    while (docRegion != endRegion) {
                        documentRegions.add(docRegion);
                        docRegion = docRegion.getNext();
                    }
                }
                documentRegions.add(docRegion);
            }
            TreeViewer tree = new TreeViewer((Composite)sashForm, 768);
            String START = SSEUIMessages.OffsetStatusLineContributionItem_15;
            String LENGTH = SSEUIMessages.OffsetStatusLineContributionItem_16;
            String TEXTLENGTH = SSEUIMessages.OffsetStatusLineContributionItem_17;
            String CONTEXT = SSEUIMessages.OffsetStatusLineContributionItem_18;
            tree.setContentProvider((IContentProvider)new ITreeContentProvider(this, documentRegions, CONTEXT, START, TEXTLENGTH, LENGTH, textSelection){
                final /* synthetic */ InformationDialog this$1;
                private final /* synthetic */ List val$documentRegions;
                private final /* synthetic */ String val$CONTEXT;
                private final /* synthetic */ String val$START;
                private final /* synthetic */ String val$TEXTLENGTH;
                private final /* synthetic */ String val$LENGTH;
                private final /* synthetic */ ITextSelection val$textSelection;
                {
                    this.this$1 = informationDialog;
                    this.val$documentRegions = list;
                    this.val$CONTEXT = string;
                    this.val$START = string2;
                    this.val$TEXTLENGTH = string3;
                    this.val$LENGTH = string4;
                    this.val$textSelection = iTextSelection;
                }

                public void dispose() {
                }

                public Object[] getChildren(Object parentElement) {
                    ArrayList<Object> children = new ArrayList<Object>(0);
                    if (parentElement instanceof ITextSelection) {
                        children.addAll(this.val$documentRegions);
                    }
                    if (parentElement instanceof ITextRegionCollection) {
                        children.add(((ITextRegionCollection)parentElement).getRegions().toArray());
                    }
                    if (parentElement instanceof ITextRegion) {
                        children.add(new Pair(this.val$CONTEXT, ((ITextRegion)parentElement).getType()));
                        children.add(new Pair(this.val$START, Integer.toString(((ITextRegion)parentElement).getStart())));
                        children.add(new Pair(this.val$TEXTLENGTH, Integer.toString(((ITextRegion)parentElement).getTextLength())));
                        children.add(new Pair(this.val$LENGTH, Integer.toString(((ITextRegion)parentElement).getLength())));
                    }
                    if (parentElement instanceof ITextRegionList) {
                        children.add(Arrays.asList(((ITextRegionList)parentElement).toArray()));
                    }
                    if (parentElement instanceof Collection) {
                        children.addAll((Collection)parentElement);
                    }
                    if (parentElement instanceof Object[]) {
                        children.addAll(Arrays.asList((Object[])parentElement));
                    }
                    return children.toArray();
                }

                public Object[] getElements(Object inputElement) {
                    return new Object[]{this.val$textSelection};
                }

                public Object getParent(Object element) {
                    if (element instanceof IStructuredDocumentRegion) {
                        return ((IStructuredDocumentRegion)element).getParentDocument();
                    }
                    if (element instanceof ITextRegionContainer) {
                        return ((ITextRegionContainer)element).getParent();
                    }
                    return null;
                }

                public boolean hasChildren(Object element) {
                    return !(element instanceof Pair);
                }

                public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
                }
            });
            tree.setLabelProvider((IBaseLabelProvider)new LabelProvider(this){
                final /* synthetic */ InformationDialog this$1;
                {
                    this.this$1 = informationDialog;
                }

                public String getText(Object element) {
                    if (element instanceof Pair) {
                        return String.valueOf(((Pair)element).fKey.toString().toLowerCase()) + ": " + ((Pair)element).fValue;
                    }
                    if (element instanceof IStructuredDocumentRegion) {
                        IStructuredDocumentRegion documentRegion = (IStructuredDocumentRegion)element;
                        int packageNameLength = documentRegion.getClass().getPackage().getName().length();
                        if (packageNameLength > 0) {
                            ++packageNameLength;
                        }
                        String name = documentRegion.getClass().getName().substring(packageNameLength);
                        String text = "[" + documentRegion.getStartOffset() + "-" + documentRegion.getEndOffset() + "] " + name + "@" + element.hashCode() + " " + documentRegion.getType();
                        return text;
                    }
                    if (element instanceof ITextRegion) {
                        ITextRegion textRegion = (ITextRegion)element;
                        int packageNameLength = textRegion.getClass().getPackage().getName().length();
                        if (packageNameLength > 0) {
                            ++packageNameLength;
                        }
                        String name = textRegion.getClass().getName().substring(packageNameLength);
                        String text = "[" + textRegion.getStart() + "-" + textRegion.getEnd() + "] " + name + "@" + element.hashCode() + " " + textRegion.getType();
                        return text;
                    }
                    return super.getText(element);
                }
            });
            tree.setInput((Object)this.fDocument);
            Text displayText = new Text((Composite)sashForm, 2824);
            displayText.setBackground(sashForm.getDisplay().getSystemColor(25));
            tree.addSelectionChangedListener(new ISelectionChangedListener(this, displayText){
                final /* synthetic */ InformationDialog this$1;
                private final /* synthetic */ Text val$displayText;
                {
                    this.this$1 = informationDialog;
                    this.val$displayText = text;
                }

                public void selectionChanged(SelectionChangedEvent event) {
                    if (event.getSelection() instanceof IStructuredSelection) {
                        Object o = ((IStructuredSelection)event.getSelection()).getFirstElement();
                        if (o instanceof Pair) {
                            this.val$displayText.setText(((Pair)o).fValue.toString());
                        } else if (o instanceof ITextSelection) {
                            ITextSelection text = (ITextSelection)o;
                            try {
                                this.val$displayText.setText(this.this$1.fDocument.get(text.getOffset(), text.getLength()));
                            }
                            catch (BadLocationException badLocationException) {
                                this.val$displayText.setText("");
                            }
                        } else {
                            this.val$displayText.setText("" + o);
                        }
                    }
                }
            });
            sashForm.setWeights(new int[]{3, 2});
            return sashForm;
        }

        static /* synthetic */ OffsetStatusLineContributionItem access$0(InformationDialog informationDialog) {
            return informationDialog.OffsetStatusLineContributionItem.this;
        }
    }

    class MarkerAnnotationPropertySource
    implements IPropertySource {
        MarkerAnnotation fMarkerAnnotation = null;
        IPropertyDescriptor[] fDescriptors = null;

        public MarkerAnnotationPropertySource(MarkerAnnotation markerAnnotation) {
            this.fMarkerAnnotation = markerAnnotation;
        }

        public Object getEditableValue() {
            return null;
        }

        public IPropertyDescriptor[] getPropertyDescriptors() {
            if (this.fDescriptors == null) {
                try {
                    Map attrs = this.fMarkerAnnotation.getMarker().getAttributes();
                    Object[] keys = attrs.keySet().toArray();
                    this.fDescriptors = new IPropertyDescriptor[keys.length];
                    int i = 0;
                    while (i < keys.length) {
                        TextPropertyDescriptor descriptor = new TextPropertyDescriptor((Object)keys[i].toString(), keys[i].toString());
                        this.fDescriptors[i] = descriptor;
                        ++i;
                    }
                }
                catch (CoreException e) {
                    e.printStackTrace();
                }
            }
            return this.fDescriptors;
        }

        public Object getPropertyValue(Object id) {
            return this.fMarkerAnnotation.getMarker().getAttribute(id.toString(), "");
        }

        public boolean isPropertySet(Object id) {
            return this.fMarkerAnnotation.getMarker().getAttribute(id.toString(), null) != null;
        }

        public void resetPropertyValue(Object id) {
            try {
                this.fMarkerAnnotation.getMarker().getAttributes().remove(id);
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }

        public void setPropertyValue(Object id, Object value) {
            try {
                this.fMarkerAnnotation.getMarker().setAttribute(id.toString(), value);
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }
    }

    static class Pair {
        Object fKey;
        String fValue;

        public Pair(Object key, String value) {
            this.fKey = key;
            this.fValue = value;
        }
    }

    class ShowPartitionAction
    extends Action {
        static /* synthetic */ Class class$0;

        public void run() {
            super.run();
            ITextEditor iTextEditor = OffsetStatusLineContributionItem.this.fTextEditor;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.swt.widgets.Control");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            new InformationDialog(((Control)iTextEditor.getAdapter((Class)clazz)).getShell()).open();
        }
    }
}

