/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsdl.ui.internal;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.IPostSelectionProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.INavigationLocation;
import org.eclipse.ui.INavigationLocationProvider;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.TextSelectionNavigationLocation;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;
import org.eclipse.ui.views.properties.IPropertySheetPage;
import org.eclipse.wst.common.ui.properties.internal.provisional.ITabbedPropertySheetPageContributor;
import org.eclipse.wst.sse.core.internal.provisional.INodeAdapter;
import org.eclipse.wst.sse.core.internal.provisional.INodeNotifier;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.internal.provisional.IndexedRegion;
import org.eclipse.wst.sse.ui.StructuredTextEditor;
import org.eclipse.wst.sse.ui.internal.contentoutline.ConfigurableContentOutlinePage;
import org.eclipse.wst.wsdl.Binding;
import org.eclipse.wst.wsdl.Definition;
import org.eclipse.wst.wsdl.WSDLElement;
import org.eclipse.wst.wsdl.XSDSchemaExtensibilityElement;
import org.eclipse.wst.wsdl.internal.generator.BindingGenerator;
import org.eclipse.wst.wsdl.ui.internal.Logger;
import org.eclipse.wst.wsdl.ui.internal.WSDLEditorPlugin;
import org.eclipse.wst.wsdl.ui.internal.WSDLEditorResourceChangeHandler;
import org.eclipse.wst.wsdl.ui.internal.WSDLMultiPageEditorPart;
import org.eclipse.wst.wsdl.ui.internal.WSDLSelectionManager;
import org.eclipse.wst.wsdl.ui.internal.actions.WSDLMenuActionContributor;
import org.eclipse.wst.wsdl.ui.internal.dialogs.GenerateBindingOnSaveDialog;
import org.eclipse.wst.wsdl.ui.internal.extension.WSDLEditorExtension;
import org.eclipse.wst.wsdl.ui.internal.graph.WSDLGraphViewer;
import org.eclipse.wst.wsdl.ui.internal.graph.editparts.WSDLEditPartFactory;
import org.eclipse.wst.wsdl.ui.internal.model.WSDLGroupObject;
import org.eclipse.wst.wsdl.ui.internal.model.WSDLModelAdapterFactory;
import org.eclipse.wst.wsdl.ui.internal.outline.ModelAdapterContentProvider;
import org.eclipse.wst.wsdl.ui.internal.outline.ModelAdapterLabelProvider;
import org.eclipse.wst.wsdl.ui.internal.properties.section.WSDLTabbedPropertySheetPage;
import org.eclipse.wst.wsdl.ui.internal.text.WSDLModelAdapter;
import org.eclipse.wst.wsdl.ui.internal.util.ComponentReferenceUtil;
import org.eclipse.wst.wsdl.ui.internal.util.WSDLEditorUtil;
import org.eclipse.wst.wsdl.ui.internal.util.WSDLNodeAssociationProvider;
import org.eclipse.wst.wsdl.ui.internal.util.WSDLResourceUtil;
import org.eclipse.wst.wsdl.ui.internal.viewers.WSDLDetailsViewer;
import org.eclipse.wst.wsdl.ui.internal.viewers.WSDLDetailsViewerProvider;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class WSDLEditor
extends WSDLMultiPageEditorPart
implements INavigationLocationProvider,
ITabbedPropertySheetPageContributor {
    protected StructuredTextEditor textEditor;
    protected WSDLGraphViewer graphViewer;
    protected WSDLDetailsViewer detailsViewer;
    protected WSDLSelectionManager selectionManager = new WSDLSelectionManager();
    protected SashForm sashForm;
    int graphPageIndex;
    protected WSDLModelAdapter modelAdapter;
    protected WSDLEditorResourceChangeHandler resourceChangeHandler;
    protected WSDLElement clipboardElement;
    private IPropertySheetPage fPropertySheetPage;
    private IContentOutlinePage fContentOutlinePage;
    private SourceEditorSelectionListener fSourceEditorSelectionListener;
    private WSDLSelectionManagerSelectionListener fWSDLSelectionListener;
    private OutlineTreeSelectionChangeListener fOutlineTreeListener = null;
    int sourcePageIndex = -1;
    int[] weights;
    private static Color dividerColor;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        super.init(site, input);
        try {
            IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
            IWorkbenchPage page = window.getActivePage();
            if (page != null) {
                page.showView("org.eclipse.ui.views.PropertySheet");
            }
        }
        catch (PartInitException partInitException) {
        }
        catch (Exception exception) {}
    }

    public Object getAdapter(Class key) {
        Object result = null;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.jface.viewers.ISelectionProvider");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (key == clazz) {
            result = this.selectionManager;
        } else {
            Class<?> clazz2 = class$1;
            if (clazz2 == null) {
                try {
                    clazz2 = class$1 = Class.forName("org.eclipse.ui.views.properties.IPropertySheetPage");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (clazz2.equals(key)) {
                if (this.fPropertySheetPage == null || this.fPropertySheetPage.getControl() == null || this.fPropertySheetPage.getControl().isDisposed()) {
                    this.fPropertySheetPage = new WSDLTabbedPropertySheetPage(this, this);
                    ((WSDLTabbedPropertySheetPage)this.fPropertySheetPage).setSelectionManager(this.getSelectionManager());
                }
                return this.fPropertySheetPage;
            }
            Class<?> clazz3 = class$2;
            if (clazz3 == null) {
                try {
                    clazz3 = class$2 = Class.forName("org.eclipse.ui.views.contentoutline.IContentOutlinePage");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (clazz3.equals(key)) {
                if (this.fContentOutlinePage == null || this.fContentOutlinePage.getControl() == null || this.fContentOutlinePage.getControl().isDisposed()) {
                    this.fContentOutlinePage = (IContentOutlinePage)super.getAdapter(key);
                    if (this.fContentOutlinePage != null) {
                        this.fOutlineTreeListener = new OutlineTreeSelectionChangeListener();
                        this.fOutlineTreeListener.connect(this.fContentOutlinePage);
                    }
                }
                result = this.fContentOutlinePage;
            } else {
                result = super.getAdapter(key);
            }
        }
        return result;
    }

    public void dispose() {
        ISelectionProvider provider;
        if (this.resourceChangeHandler != null) {
            this.resourceChangeHandler.dispose();
        }
        if ((provider = this.getTextEditor().getSelectionProvider()) instanceof IPostSelectionProvider) {
            ((IPostSelectionProvider)provider).removePostSelectionChangedListener((ISelectionChangedListener)this.fSourceEditorSelectionListener);
        } else {
            provider.removeSelectionChangedListener((ISelectionChangedListener)this.fSourceEditorSelectionListener);
        }
        if (this.fOutlineTreeListener != null) {
            this.fOutlineTreeListener.disconnect();
            this.fOutlineTreeListener = null;
        }
        this.getSelectionManager().removeSelectionChangedListener(this.fWSDLSelectionListener);
        super.dispose();
    }

    public WSDLSelectionManager getSelectionManager() {
        return this.selectionManager;
    }

    public WSDLGraphViewer getGraphViewer() {
        return this.graphViewer;
    }

    public IStructuredModel getStructuredModel() {
        return this.textEditor.getModel();
    }

    public Document getXMLDocument() {
        return ((IDOMModel)this.getStructuredModel()).getDocument();
    }

    public Definition getDefinition() {
        return this.modelAdapter != null ? this.modelAdapter.getDefinition() : null;
    }

    protected void createPages() {
        try {
            if (this.resourceChangeHandler == null) {
                this.resourceChangeHandler = new WSDLEditorResourceChangeHandler(this);
                this.resourceChangeHandler.attach();
            }
            this.createSourcePage();
            this.addSourcePage();
            this.lookupOrCreateWSDLModel();
            this.createAndAddGraphPage();
            int pageIndexToShow = this.getDefaultPageIndex();
            this.setActivePage(pageIndexToShow);
            this.getSelectionManager().setSelection((ISelection)new StructuredSelection((Object)this.getDefinition()));
            ISelectionProvider provider = this.getTextEditor().getSelectionProvider();
            this.fSourceEditorSelectionListener = new SourceEditorSelectionListener();
            if (provider instanceof IPostSelectionProvider) {
                ((IPostSelectionProvider)provider).addPostSelectionChangedListener((ISelectionChangedListener)this.fSourceEditorSelectionListener);
            } else {
                provider.addSelectionChangedListener((ISelectionChangedListener)this.fSourceEditorSelectionListener);
            }
            this.fWSDLSelectionListener = new WSDLSelectionManagerSelectionListener();
            this.getSelectionManager().addSelectionChangedListener(this.fWSDLSelectionListener);
        }
        catch (PartInitException e) {
            Logger.log(1, e.getMessage());
        }
    }

    protected void lookupOrCreateWSDLModel() {
        block6: {
            try {
                IDOMDocument document = ((IDOMModel)this.getModel()).getDocument();
                if (!(document instanceof INodeNotifier)) break block6;
                INodeNotifier notifier = (INodeNotifier)document;
                Class<?> clazz = class$3;
                if (clazz == null) {
                    try {
                        clazz = class$3 = Class.forName("org.eclipse.wst.wsdl.ui.internal.text.WSDLModelAdapter");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                this.modelAdapter = (WSDLModelAdapter)notifier.getAdapterFor((Object)clazz);
                if (this.modelAdapter == null) {
                    this.modelAdapter = new WSDLModelAdapter();
                    notifier.addAdapter((INodeAdapter)this.modelAdapter);
                    this.modelAdapter.createDefinition(document.getDocumentElement());
                }
            }
            catch (Exception exception) {}
        }
    }

    protected int getDefaultPageIndex() {
        if (WSDLEditorPlugin.getInstance().getDefaultPage().equals("org.eclipse.wst.wsdl.ui.internal.graphpage") && this.graphPageIndex != -1) {
            return this.graphPageIndex;
        }
        return this.sourcePageIndex;
    }

    protected StructuredTextEditor createTextEditor() {
        this.textEditor = new StructuredTextEditor();
        return this.textEditor;
    }

    protected void createSourcePage() throws PartInitException {
        super.createSourcePage();
        this.textEditor = this.getTextEditor();
    }

    protected void addSourcePage() throws PartInitException {
        this.sourcePageIndex = this.addPage((IEditorPart)this.textEditor, this.getEditorInput());
        this.setPageText(this.sourcePageIndex, WSDLEditorPlugin.getWSDLString("_UI_TAB_SOURCE"));
        this.textEditor.update();
    }

    public void setDesignWeights(int[] weights, boolean updateSourceDesign) {
        this.weights = weights;
        if (updateSourceDesign) {
            this.sashForm.setWeights(weights);
        }
    }

    protected void pageChange(int arg) {
        super.pageChange(arg);
        if (!this.getPageText(arg).equals(WSDLEditorPlugin.getWSDLString("_UI_TAB_SOURCE"))) {
            this.getPageText(arg).equals(WSDLEditorPlugin.getWSDLString("_UI_TAB_GRAPH"));
        }
    }

    protected void createAndAddGraphPage() throws PartInitException {
        this.sashForm = new SashForm(this.getContainer(), 2048);
        this.sashForm.setLayoutData((Object)new GridData(1808));
        this.sashForm.setOrientation(512);
        this.graphPageIndex = this.addPage((Control)this.sashForm);
        this.setPageText(this.graphPageIndex, WSDLEditorPlugin.getWSDLString("_UI_TAB_GRAPH"));
        this.graphViewer = new WSDLGraphViewer(this);
        this.graphViewer.createControl((Composite)this.sashForm);
        if (dividerColor == null) {
            dividerColor = new Color((Device)this.getContainer().getDisplay(), 143, 141, 138);
        }
        this.getContainer().addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                Object source = e.getSource();
                if (source instanceof Composite) {
                    Composite comp = (Composite)source;
                    Rectangle boundary = comp.getClientArea();
                    e.gc.setForeground(dividerColor);
                    e.gc.drawLine(boundary.x, boundary.y, boundary.x + boundary.width, boundary.y);
                    WSDLEditor.this.setDesignWeights(WSDLEditor.this.sashForm.getWeights(), true);
                }
            }
        });
    }

    public void setFocus() {
        super.setFocus();
        int activePage = this.getActivePage();
        if (activePage == this.sourcePageIndex) {
            WSDLEditorPlugin.getInstance().setDefaultPage("org.eclipse.wst.wsdl.ui.internal.sourcepage");
        } else {
            WSDLEditorPlugin.getInstance().setDefaultPage("org.eclipse.wst.wsdl.ui.internal.graphpage");
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void reloadDependencies() {
        try {
            this.getGraphViewer().getComponentViewer().setPreserveExpansionEnabled(true);
            Definition definition = this.getDefinition();
            if (definition != null) {
                WSDLResourceUtil.reloadDirectives(definition);
                ComponentReferenceUtil.updateBindingReferences(definition);
                ComponentReferenceUtil.updatePortTypeReferences(definition);
                ComponentReferenceUtil.updateMessageReferences(definition);
                ComponentReferenceUtil.updateSchemaReferences(definition);
                definition.setDocumentationElement(definition.getDocumentationElement());
            }
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            this.getGraphViewer().getComponentViewer().setPreserveExpansionEnabled(false);
            throw throwable;
        }
        {
            Object var2_4 = null;
            this.getGraphViewer().getComponentViewer().setPreserveExpansionEnabled(false);
            return;
        }
    }

    public void openOnSelection(String specification) {
        EObject eObject = this.getDefinition().eResource().getEObject(specification);
        if (eObject != null) {
            this.getSelectionManager().setSelection((ISelection)new StructuredSelection((Object)eObject));
        }
    }

    public INavigationLocation createEmptyNavigationLocation() {
        return new InternalTextSelectionNavigationLocation((ITextEditor)this.textEditor, false);
    }

    public INavigationLocation createNavigationLocation() {
        return new InternalTextSelectionNavigationLocation((ITextEditor)this.textEditor, true);
    }

    public WSDLElement getClipboardContents() {
        return this.clipboardElement;
    }

    public void setClipboardContents(WSDLElement element) {
        this.clipboardElement = element;
    }

    public String getContributorId() {
        return "org.eclipse.wst.wsdl.ui.internal.WSDLEditor";
    }

    public void doSave(IProgressMonitor monitor) {
        try {
            boolean continueRegeneration = false;
            if (WSDLEditorPlugin.getInstance().getPluginPreferences().getBoolean("Prompt Regenerate Binding on save")) {
                Shell shell = Display.getCurrent().getActiveShell();
                GenerateBindingOnSaveDialog dialog = new GenerateBindingOnSaveDialog(shell);
                int rValue = dialog.open();
                if (rValue == 64) {
                    continueRegeneration = true;
                } else if (rValue == 128) {
                    continueRegeneration = false;
                } else {
                    if (rValue == 256) {
                        return;
                    }
                    System.out.println("\nNothing: " + rValue);
                }
            } else {
                continueRegeneration = WSDLEditorPlugin.getInstance().getPluginPreferences().getBoolean(WSDLEditorPlugin.getWSDLString("_UI_PREF_PAGE_AUTO_REGENERATE_BINDING"));
            }
            if (continueRegeneration) {
                Iterator bindingsIt = this.getDefinition().getEBindings().iterator();
                while (bindingsIt.hasNext()) {
                    Binding binding = (Binding)bindingsIt.next();
                    BindingGenerator generator = new BindingGenerator(binding.getEnclosingDefinition(), binding);
                    generator.setOverwrite(false);
                    generator.generateBinding();
                }
                this.getDefinition().setQName(this.getDefinition().getQName());
            }
        }
        catch (Exception exception) {}
        super.doSave(monitor);
    }

    class OutlineTreeSelectionChangeListener
    implements ISelectionChangedListener,
    IDoubleClickListener {
        private ISelectionProvider fProvider = null;

        void connect(IContentOutlinePage provider) {
            this.fProvider = provider;
            this.fProvider.addSelectionChangedListener((ISelectionChangedListener)this);
            if (provider instanceof ConfigurableContentOutlinePage) {
                ((ConfigurableContentOutlinePage)provider).addDoubleClickListener((IDoubleClickListener)this);
            }
        }

        void disconnect() {
            this.fProvider.removeSelectionChangedListener((ISelectionChangedListener)this);
            if (this.fProvider instanceof ConfigurableContentOutlinePage) {
                ((ConfigurableContentOutlinePage)this.fProvider).removeDoubleClickListener((IDoubleClickListener)this);
            }
            this.fProvider = null;
        }

        private ISelection getWSDLSelection(ISelection selection) {
            IStructuredSelection structuredSelection;
            Object o;
            StructuredSelection sel = null;
            if (selection instanceof IStructuredSelection && (o = (structuredSelection = (IStructuredSelection)selection).getFirstElement()) != null) {
                sel = new StructuredSelection(o);
            }
            return sel;
        }

        public void doubleClick(DoubleClickEvent event) {
            if (WSDLEditor.this.getSelectionManager() != null && WSDLEditor.this.getSelectionManager().enableNotify) {
                ISelection selection = this.getWSDLSelection(event.getSelection());
                if (selection != null) {
                    WSDLEditor.this.getSelectionManager().setSelection(selection, this.fProvider);
                }
                if (WSDLEditor.this.getTextEditor() != null && selection instanceof IStructuredSelection) {
                    int start = -1;
                    int length = 0;
                    Object o = ((IStructuredSelection)selection).getFirstElement();
                    if (o != null) {
                        o = WSDLEditorUtil.getInstance().getNodeForObject(o);
                    }
                    if (o instanceof IndexedRegion) {
                        start = ((IndexedRegion)o).getStartOffset();
                        length = ((IndexedRegion)o).getEndOffset() - start;
                    }
                    if (start > -1) {
                        WSDLEditor.this.getTextEditor().selectAndReveal(start, length);
                    }
                }
            }
        }

        public void selectionChanged(SelectionChangedEvent event) {
            ISelection selection;
            if (WSDLEditor.this.getSelectionManager() != null && WSDLEditor.this.getSelectionManager().enableNotify && (selection = this.getWSDLSelection(event.getSelection())) != null) {
                WSDLEditor.this.getSelectionManager().setSelection(selection, this.fProvider);
            }
        }
    }

    private class SourceEditorSelectionListener
    implements ISelectionChangedListener {
        SourceEditorSelectionListener() {
        }

        private Object getWSDLNode(Object object) {
            Object modelObject;
            Node node;
            Element element = null;
            if (object instanceof Node && (node = (Node)object) != null) {
                if (node.getNodeType() == 1) {
                    element = (Element)node;
                } else if (node.getNodeType() == 2) {
                    element = ((Attr)node).getOwnerElement();
                }
            }
            Object o = element;
            if (element != null && (modelObject = WSDLEditorUtil.getInstance().findModelObjectForElement(WSDLEditor.this.getDefinition(), element)) != null) {
                o = modelObject;
            }
            return o;
        }

        public void selectionChanged(SelectionChangedEvent event) {
            ISelection selection = event.getSelection();
            if (selection instanceof IStructuredSelection) {
                ArrayList<Object> wsdlSelections = new ArrayList<Object>();
                Iterator i = ((IStructuredSelection)selection).iterator();
                while (i.hasNext()) {
                    Object domNode = i.next();
                    Object wsdlNode = this.getWSDLNode(domNode);
                    if (wsdlNode == null) continue;
                    wsdlSelections.add(wsdlNode);
                }
                if (!wsdlSelections.isEmpty()) {
                    StructuredSelection wsdlSelection = new StructuredSelection(wsdlSelections);
                    WSDLEditor.this.getSelectionManager().setSelection((ISelection)wsdlSelection, WSDLEditor.this.getTextEditor().getSelectionProvider());
                }
            }
        }
    }

    private class WSDLSelectionManagerSelectionListener
    implements ISelectionChangedListener {
        WSDLSelectionManagerSelectionListener() {
        }

        private Object getObjectForOtherModel(Object object) {
            Node node = null;
            node = object instanceof Node ? (Node)object : WSDLEditorUtil.getInstance().getNodeForObject(object);
            if (!(node instanceof IDOMNode)) {
                node = null;
            }
            return node;
        }

        public void selectionChanged(SelectionChangedEvent event) {
            ISelection selection;
            if (event.getSource() != WSDLEditor.this.getTextEditor().getSelectionProvider() && (selection = event.getSelection()) instanceof IStructuredSelection) {
                ArrayList<Object> otherModelObjectList = new ArrayList<Object>();
                Iterator i = ((IStructuredSelection)selection).iterator();
                while (i.hasNext()) {
                    Object modelObject = i.next();
                    Object otherModelObject = this.getObjectForOtherModel(modelObject);
                    if (otherModelObject == null) continue;
                    otherModelObjectList.add(otherModelObject);
                }
                if (!otherModelObjectList.isEmpty()) {
                    StructuredSelection nodeSelection = new StructuredSelection(otherModelObjectList);
                    WSDLEditor.this.getTextEditor().getSelectionProvider().setSelection((ISelection)nodeSelection);
                }
            }
        }
    }

    public static class BuiltInWSDLEditorExtension
    implements WSDLEditorExtension {
        public boolean isExtensionTypeSupported(int type) {
            return type == 1 || type == 2 || type == 5 || type == 4 || type == 3 || type == 7 || type == 8;
        }

        public boolean isApplicable(Object object) {
            return object instanceof WSDLElement && !(object instanceof XSDSchemaExtensibilityElement) || object instanceof WSDLGroupObject;
        }

        public Object createExtensionObject(int type, WSDLEditor wsdlEditor) {
            Object result = null;
            switch (type) {
                case 1: {
                    result = new ModelAdapterContentProvider(WSDLModelAdapterFactory.getWSDLModelAdapterFactory());
                    break;
                }
                case 2: {
                    result = new ModelAdapterLabelProvider(WSDLModelAdapterFactory.getWSDLModelAdapterFactory());
                    break;
                }
                case 4: {
                    result = new WSDLDetailsViewerProvider();
                    break;
                }
                case 3: {
                    result = new WSDLMenuActionContributor((IEditorPart)wsdlEditor);
                    break;
                }
                case 8: {
                    result = new WSDLNodeAssociationProvider();
                    break;
                }
                case 5: {
                    result = new WSDLEditPartFactory();
                }
            }
            return result;
        }
    }

    static class InternalTextSelectionNavigationLocation
    extends TextSelectionNavigationLocation {
        public InternalTextSelectionNavigationLocation(ITextEditor part, boolean initialize) {
            super(part, initialize);
        }

        protected IEditorPart getEditorPart() {
            IEditorPart part = super.getEditorPart();
            if (part instanceof WSDLEditor) {
                part = ((WSDLEditor)part).getTextEditor();
            }
            return part;
        }

        public String getText() {
            return super.getText();
        }
    }
}

