/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsdl.ui.internal.outline;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.views.contentoutline.ContentOutlinePage;
import org.eclipse.wst.wsdl.ui.internal.WSDLEditor;
import org.eclipse.wst.wsdl.ui.internal.WSDLSelectionManager;
import org.eclipse.wst.wsdl.ui.internal.actions.WSDLMenuListener;
import org.eclipse.wst.wsdl.ui.internal.util.OpenOnSelectionHelper;

public class WSDLContentOutlinePage
extends ContentOutlinePage {
    protected WSDLEditor wsdlEditor;
    protected int level = 0;
    protected Object model;
    protected ITreeContentProvider contentProvider;
    protected ILabelProvider labelProvider;
    protected WSDLSelectionManager selectionManager;
    protected SelectionManagerSelectionChangeListener selectionManagerSelectionChangeListener = new SelectionManagerSelectionChangeListener();
    protected TreeSelectionChangeListener treeSelectionChangeListener = new TreeSelectionChangeListener();

    public WSDLContentOutlinePage(WSDLEditor wsdlEditor) {
        this.wsdlEditor = wsdlEditor;
    }

    public void setContentProvider(ITreeContentProvider contentProvider) {
        this.contentProvider = contentProvider;
    }

    public void setLabelProvider(ILabelProvider labelProvider) {
        this.labelProvider = labelProvider;
    }

    public TreeViewer getTreeViewer() {
        return super.getTreeViewer();
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        this.getTreeViewer().setContentProvider((IContentProvider)this.contentProvider);
        this.getTreeViewer().setLabelProvider((IBaseLabelProvider)this.labelProvider);
        this.getTreeViewer().setInput(this.model);
        this.getTreeViewer().addSelectionChangedListener((ISelectionChangedListener)this);
        KeyAdapter keyListener = new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                Object object;
                ISelection selection;
                if (e.keyCode == 0x100000C && (selection = WSDLContentOutlinePage.this.selectionManager.getSelection()) instanceof IStructuredSelection && (object = ((IStructuredSelection)selection).getFirstElement()) instanceof EObject) {
                    OpenOnSelectionHelper helper = new OpenOnSelectionHelper(WSDLContentOutlinePage.this.wsdlEditor.getDefinition());
                    helper.openEditor((EObject)object);
                }
            }
        };
        this.getTreeViewer().getTree().addKeyListener((KeyListener)keyListener);
        MenuManager menuManager = new MenuManager("#popup");
        menuManager.setRemoveAllWhenShown(true);
        Menu menu = menuManager.createContextMenu(this.getTreeViewer().getControl());
        this.getTreeViewer().getControl().setMenu(menu);
        WSDLMenuListener menuListener = new WSDLMenuListener(this.wsdlEditor, this.wsdlEditor.getSelectionManager());
        menuManager.addMenuListener((IMenuListener)menuListener);
        this.setSelectionManager(this.wsdlEditor.getSelectionManager());
        this.getSite().registerContextMenu("org.eclipse.wst.wsdl.ui.popup.outline", menuManager, (ISelectionProvider)this.wsdlEditor.getSelectionManager());
    }

    public void setModel(Object object) {
        this.model = object;
    }

    public void setExpandToLevel(int i) {
        this.level = i;
    }

    public void setInput(Object value) {
        this.getTreeViewer().setInput(value);
        this.getTreeViewer().expandToLevel(this.level);
    }

    public void setSelectionManager(WSDLSelectionManager newSelectionManager) {
        TreeViewer treeViewer = this.getTreeViewer();
        if (this.selectionManager != null) {
            this.selectionManager.removeSelectionChangedListener(this.selectionManagerSelectionChangeListener);
            treeViewer.removeSelectionChangedListener((ISelectionChangedListener)this.treeSelectionChangeListener);
        }
        this.selectionManager = newSelectionManager;
        if (this.selectionManager != null) {
            this.selectionManager.addSelectionChangedListener(this.selectionManagerSelectionChangeListener);
            treeViewer.addSelectionChangedListener((ISelectionChangedListener)this.treeSelectionChangeListener);
        }
    }

    class SelectionManagerSelectionChangeListener
    implements ISelectionChangedListener {
        SelectionManagerSelectionChangeListener() {
        }

        public void selectionChanged(SelectionChangedEvent event) {
            if (event.getSelectionProvider() != WSDLContentOutlinePage.this.getTreeViewer()) {
                WSDLContentOutlinePage.this.getTreeViewer().setSelection(event.getSelection(), true);
            }
        }
    }

    class TreeSelectionChangeListener
    implements ISelectionChangedListener {
        TreeSelectionChangeListener() {
        }

        public void selectionChanged(SelectionChangedEvent event) {
            ISelection selection;
            if (WSDLContentOutlinePage.this.selectionManager != null && (selection = event.getSelection()) instanceof IStructuredSelection) {
                IStructuredSelection structuredSelection = (IStructuredSelection)selection;
                Object o = structuredSelection.getFirstElement();
                if (o != null) {
                    WSDLContentOutlinePage.this.selectionManager.setSelection((ISelection)new StructuredSelection(o), (ISelectionProvider)WSDLContentOutlinePage.this.getTreeViewer());
                } else {
                    WSDLContentOutlinePage.this.selectionManager.setSelection((ISelection)new StructuredSelection(), (ISelectionProvider)WSDLContentOutlinePage.this.getTreeViewer());
                }
            }
        }
    }
}

