/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsdl.ui.internal.text;

import org.eclipse.wst.sse.core.internal.provisional.INodeNotifier;
import org.eclipse.wst.wsdl.Definition;
import org.eclipse.wst.wsdl.internal.impl.DefinitionImpl;
import org.eclipse.wst.wsdl.internal.impl.WSDLElementImpl;
import org.eclipse.wst.wsdl.internal.impl.XSDSchemaExtensibilityElementImpl;
import org.eclipse.wst.wsdl.ui.internal.reconciler.ExtensibleNodeReconciler;
import org.eclipse.wst.wsdl.ui.internal.text.DocumentAdapter;
import org.eclipse.wst.wsdl.ui.internal.util.WSDLEditorUtil;
import org.eclipse.xsd.XSDConcreteComponent;
import org.eclipse.xsd.impl.XSDSchemaImpl;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

class WSDLModelReconcileAdapter
extends DocumentAdapter {
    protected Definition definition;
    protected ExtensibleNodeReconciler extensibleNodeReconciler;

    public WSDLModelReconcileAdapter(Document document, Definition definition) {
        super(document);
        this.definition = definition;
        this.extensibleNodeReconciler = new ExtensibleNodeReconciler();
    }

    public void notifyChanged(INodeNotifier notifier, int eventType, Object feature, Object oldValue, Object newValue, int index) {
        if (eventType == 2 && newValue instanceof Element) {
            String ns;
            this.adapt((Element)newValue);
            Element newDocumentElement = (Element)newValue;
            String wsdlPrefix = newDocumentElement.getPrefix();
            if (wsdlPrefix == null) {
                wsdlPrefix = "";
            }
            if ((ns = this.definition.getNamespace(wsdlPrefix)) != null && ns.equals("http://schemas.xmlsoap.org/wsdl/") && newDocumentElement.getLocalName().equals("definitions")) {
                this.definition.setElement(newDocumentElement);
            }
        }
        switch (eventType) {
            case 1: 
            case 4: 
            case 5: {
                if (notifier instanceof Element) {
                    this.reconcileModelObjectForElement((Element)notifier, eventType, feature, oldValue, newValue, index);
                    break;
                }
                if (!(notifier instanceof Document)) break;
                Document document = (Document)notifier;
                Element definitionElement = null;
                Node node = document.getFirstChild();
                while (node != null) {
                    if (node.getNodeType() == 1) {
                        Element element = (Element)node;
                        if (WSDLEditorUtil.getInstance().getWSDLType(element) == 1) {
                            definitionElement = element;
                            break;
                        }
                    }
                    node = node.getNextSibling();
                }
                if (definitionElement != null) {
                    ((DefinitionImpl)this.definition).elementChanged(definitionElement);
                    break;
                }
                ((DefinitionImpl)this.definition).removeAll();
            }
        }
    }

    protected void reconcileModelObjectForElement(Element element, int eventType, Object feature, Object oldValue, Object newValue, int index) {
        Object modelObject = WSDLEditorUtil.getInstance().findModelObjectForElement(this.definition, element);
        if (modelObject != null) {
            if (modelObject instanceof XSDSchemaExtensibilityElementImpl) {
                XSDSchemaExtensibilityElementImpl ee = (XSDSchemaExtensibilityElementImpl)modelObject;
                ((XSDSchemaImpl)ee.getSchema()).elementChanged(element);
                ee.elementChanged(element);
            } else if (modelObject instanceof WSDLElementImpl) {
                ((WSDLElementImpl)modelObject).elementChanged(element);
            } else if (modelObject instanceof XSDConcreteComponent) {
                ((XSDConcreteComponent)modelObject).elementChanged(element);
                this.extensibleNodeReconciler.notifyChanged(modelObject, element, eventType, feature, oldValue, newValue, index);
            }
        }
    }
}

