/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsdl.ui.internal.xsd.actions;

import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.wst.wsdl.Definition;
import org.eclipse.wst.wsdl.ui.internal.actions.DeleteInterfaceAction;
import org.eclipse.wst.wsdl.ui.internal.util.WSDLEditorUtil;
import org.eclipse.wst.xml.core.internal.document.DocumentImpl;
import org.eclipse.wst.xsd.ui.internal.XSDEditorPlugin;
import org.eclipse.wst.xsd.ui.internal.util.TypesHelper;
import org.eclipse.wst.xsd.ui.internal.util.XSDDOMHelper;
import org.eclipse.xsd.XSDComponent;
import org.eclipse.xsd.XSDConcreteComponent;
import org.eclipse.xsd.XSDImport;
import org.eclipse.xsd.XSDInclude;
import org.eclipse.xsd.XSDRedefine;
import org.eclipse.xsd.XSDSchema;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class DeleteAction
extends Action
implements DeleteInterfaceAction {
    XSDSchema xsdSchema;
    Definition definition;
    List deleteList;

    public DeleteAction(String text) {
        super(XSDEditorPlugin.getXSDString((String)"_UI_ACTION_DELETE"));
    }

    public XSDSchema getSchema() {
        return this.xsdSchema;
    }

    public void setSchema(XSDSchema xsdSchema) {
        this.xsdSchema = xsdSchema;
    }

    public void setDeleteList(List list) {
        this.deleteList = list;
    }

    public List getDeleteList() {
        return this.deleteList;
    }

    public void run() {
        List selections = this.getDeleteList();
        if (selections.isEmpty()) {
            return;
        }
        Iterator iter = selections.iterator();
        DocumentImpl doc = null;
        while (iter.hasNext()) {
            Element node;
            Object obj = iter.next();
            if (obj instanceof Element) {
                node = (Element)obj;
                Object elem = WSDLEditorUtil.getInstance().findModelObjectForElement(this.definition, node);
                if (elem instanceof XSDComponent) {
                    this.xsdSchema = ((XSDComponent)elem).getSchema();
                }
            } else if (obj instanceof XSDComponent) {
                node = ((XSDComponent)obj).getElement();
                this.xsdSchema = ((XSDComponent)obj).getSchema();
            } else if (obj instanceof XSDConcreteComponent) {
                node = ((XSDConcreteComponent)obj).getElement();
                this.xsdSchema = ((XSDConcreteComponent)obj).getSchema();
            } else {
                return;
            }
            if (XSDDOMHelper.inputEquals((Object)node, (String)"schema", (boolean)false)) continue;
            if (doc == null) {
                doc = (DocumentImpl)node.getOwnerDocument();
                doc.getModel().beginRecording((Object)this, XSDEditorPlugin.getXSDString((String)"_UI_ACTION_DELETE_NODES"));
            }
            boolean refresh = this.cleanupReferences(node);
            XSDDOMHelper.removeNodeAndWhitespace((Node)node);
        }
        if (doc != null) {
            doc.getModel().endRecording((Object)this);
        }
    }

    protected boolean cleanupReferences(Node deletedNode) {
        boolean refresh = false;
        XSDConcreteComponent comp = this.getSchema().getCorrespondingComponent(deletedNode);
        if (comp instanceof XSDInclude || comp instanceof XSDImport || comp instanceof XSDRedefine) {
            XSDSchema referencedSchema = null;
            if (comp instanceof XSDInclude) {
                referencedSchema = ((XSDInclude)comp).getIncorporatedSchema();
                refresh = true;
            } else if (comp instanceof XSDRedefine) {
                referencedSchema = ((XSDRedefine)comp).getIncorporatedSchema();
                refresh = true;
            } else if (comp instanceof XSDImport) {
                referencedSchema = ((XSDImport)comp).getResolvedSchema();
            }
            if (comp instanceof XSDImport) {
                TypesHelper typesHelper = new TypesHelper(this.getSchema());
                typesHelper.updateMapAfterDelete((XSDImport)comp);
            }
        } else {
            this.getSchema().equals(comp.getContainer());
        }
        return refresh;
    }
}

