/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.core.internal.provisional.format;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.wst.sse.core.internal.format.IStructuredFormatContraints;
import org.eclipse.wst.sse.core.internal.format.IStructuredFormatPreferences;
import org.eclipse.wst.sse.core.internal.format.IStructuredFormatter;
import org.eclipse.wst.sse.core.internal.format.StructuredFormatContraints;
import org.eclipse.wst.sse.core.internal.parser.ContextRegion;
import org.eclipse.wst.sse.core.internal.provisional.INodeNotifier;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegionList;
import org.eclipse.wst.sse.core.internal.util.StringUtils;
import org.eclipse.wst.xml.core.internal.Logger;
import org.eclipse.wst.xml.core.internal.XMLCorePlugin;
import org.eclipse.wst.xml.core.internal.document.CDATASectionImpl;
import org.eclipse.wst.xml.core.internal.document.CharacterDataImpl;
import org.eclipse.wst.xml.core.internal.document.CommentImpl;
import org.eclipse.wst.xml.core.internal.parser.regions.TagNameRegion;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.eclipse.wst.xml.core.internal.provisional.format.CommentNodeFormatter;
import org.eclipse.wst.xml.core.internal.provisional.format.DocumentNodeFormatter;
import org.eclipse.wst.xml.core.internal.provisional.format.ElementNodeFormatter;
import org.eclipse.wst.xml.core.internal.provisional.format.IStructuredFormatPreferencesXML;
import org.eclipse.wst.xml.core.internal.provisional.format.StructuredFormatPreferencesXML;
import org.eclipse.wst.xml.core.internal.provisional.format.TextNodeFormatter;
import org.w3c.dom.Node;

public class NodeFormatter
implements IStructuredFormatter {
    protected static final String CR = "\r";
    protected static final String CRLF = "\r\n";
    protected static final String DELIMITERS = " \t\n\r\f";
    protected static final String EMPTY_STRING = "";
    protected static final String FF = "\f";
    protected static final String LF = "\n";
    protected static final String SPACE = " ";
    protected static final char SPACE_CHAR = ' ';
    protected static final String TAB = "\t";
    protected static final char TAB_CHAR = '\t';
    protected IStructuredFormatContraints fFormatContraints = null;
    protected IStructuredFormatPreferences fFormatPreferences = null;
    protected IProgressMonitor fProgressMonitor = null;
    static /* synthetic */ Class class$0;

    protected String compressSpaces(String string, IStructuredFormatContraints formatContraints) {
        String[] stringArray = null;
        boolean clearAllBlankLines = formatContraints.getClearAllBlankLines();
        stringArray = clearAllBlankLines ? StringUtils.asArray((String)string) : StringUtils.asArray((String)string, (String)DELIMITERS, (boolean)true);
        StringBuffer compressedString = new StringBuffer();
        if (stringArray.length > 0) {
            boolean cr = false;
            boolean lf = false;
            boolean cr2 = false;
            boolean nonSpace = true;
            if (stringArray[0].compareTo(CR) == 0) {
                cr = true;
            } else if (stringArray[0].compareTo(LF) == 0) {
                lf = true;
            } else if (stringArray[0].compareTo(SPACE) != 0 && stringArray[0].compareTo(TAB) != 0 && stringArray[0].compareTo(FF) != 0) {
                compressedString.append(stringArray[0]);
                nonSpace = true;
            }
            int i = 1;
            while (i < stringArray.length) {
                if (stringArray[i].compareTo(CR) == 0) {
                    if (cr && lf) {
                        if (nonSpace) {
                            compressedString.append(CRLF);
                            nonSpace = false;
                        }
                        compressedString.append(stringArray[i]);
                        cr2 = true;
                    } else if (cr) {
                        if (nonSpace) {
                            compressedString.append(CR);
                            nonSpace = false;
                        }
                        compressedString.append(stringArray[i]);
                        cr2 = true;
                    } else {
                        cr = true;
                    }
                } else if (stringArray[i].compareTo(LF) == 0) {
                    if (cr && lf && cr2) {
                        compressedString.append(stringArray[i]);
                    } else if (lf) {
                        if (nonSpace) {
                            compressedString.append(LF);
                            nonSpace = false;
                        }
                        compressedString.append(stringArray[i]);
                    } else {
                        lf = true;
                    }
                } else if (stringArray[i].compareTo(SPACE) != 0 && stringArray[i].compareTo(TAB) != 0 && stringArray[i].compareTo(FF) != 0) {
                    if (compressedString.length() > 0) {
                        compressedString.append(SPACE);
                    }
                    compressedString.append(stringArray[i]);
                    cr = false;
                    lf = false;
                    cr2 = false;
                    nonSpace = true;
                }
                ++i;
            }
        }
        return compressedString.toString();
    }

    protected boolean firstStructuredDocumentRegionContainsLineDelimiters(IDOMNode node) {
        IStructuredDocumentRegion firstStructuredDocumentRegion;
        boolean result = false;
        if (node != null && (firstStructuredDocumentRegion = node.getFirstStructuredDocumentRegion()) != null && firstStructuredDocumentRegion.getText() != null) {
            String firstStructuredDocumentRegionText = firstStructuredDocumentRegion.getText();
            result = StringUtils.containsLineDelimiter((String)firstStructuredDocumentRegionText);
        }
        return result;
    }

    public void format(Node node) {
        IStructuredFormatContraints formatContraints = this.getFormatContraints();
        this.format(node, formatContraints);
    }

    public void format(Node node, IStructuredFormatContraints formatContraints) {
        if (formatContraints.getFormatWithSiblingIndent()) {
            formatContraints.setCurrentIndent(this.getSiblingIndent(node));
        }
        if (node instanceof IDOMNode) {
            this.formatNode((IDOMNode)node, formatContraints);
        }
    }

    protected void formatIndentationAfterNode(IDOMNode node, IStructuredFormatContraints formatContraints) {
        if (node != null) {
            IDOMNode nextSibling = (IDOMNode)node.getNextSibling();
            IStructuredDocument doc = node.getModel().getStructuredDocument();
            int line = doc.getLineOfOffset(node.getEndOffset());
            String lineDelimiter = doc.getLineDelimiter();
            try {
                lineDelimiter = doc.getLineDelimiter(line);
                if (lineDelimiter == null) {
                    lineDelimiter = EMPTY_STRING;
                }
            }
            catch (BadLocationException e) {
                Logger.log(1, e.getMessage());
            }
            if (node.getParentNode() != null) {
                if (node.getParentNode().getNodeType() == 9) {
                    if (nextSibling != null) {
                        if (nextSibling.getNodeType() == 3) {
                            this.getFormatter(nextSibling).format((Node)nextSibling, formatContraints);
                        } else if (nextSibling.getNodeType() != 8) {
                            String lineIndent = formatContraints.getCurrentIndent();
                            this.insertAfterNode(node, String.valueOf(lineDelimiter) + lineIndent);
                        }
                    }
                } else if (nextSibling != null) {
                    if (nextSibling.getNodeType() == 3) {
                        this.getFormatter(nextSibling).format((Node)nextSibling, formatContraints);
                    } else if (nextSibling.getNodeType() != 8) {
                        String lineIndent = formatContraints.getCurrentIndent();
                        this.insertAfterNode(node, String.valueOf(lineDelimiter) + lineIndent);
                    }
                } else {
                    IDOMNode indentNode = this.getParentIndentNode(node);
                    String lineIndent = this.getNodeIndent(indentNode);
                    IDOMNode lastChild = this.getDeepestChildNode(node);
                    boolean clearAllBlankLines = formatContraints.getClearAllBlankLines();
                    if (!(lastChild == null || lastChild.getNodeType() == 3 && lastChild.getNodeValue().endsWith(String.valueOf(lineDelimiter) + lineIndent))) {
                        if (lastChild.getNodeType() == 3 && lastChild.getNodeValue() != null && lastChild.getNodeValue().endsWith(lineDelimiter)) {
                            if (clearAllBlankLines) {
                                this.replaceNodeValue(lastChild, String.valueOf(lineDelimiter) + lineIndent);
                            } else {
                                this.insertAfterNode(lastChild, lineIndent);
                            }
                        } else if (lastChild.getNodeType() == 3) {
                            if (lastChild.getNodeValue().length() == 0) {
                                this.replaceNodeValue(lastChild, String.valueOf(lineDelimiter) + lineIndent);
                            } else {
                                this.insertAfterNode(lastChild, String.valueOf(lineDelimiter) + lineIndent);
                            }
                        } else {
                            this.insertAfterNode(lastChild, String.valueOf(lineDelimiter) + lineIndent);
                        }
                    }
                }
            }
        }
    }

    protected void formatIndentationBeforeNode(IDOMNode node, IStructuredFormatContraints formatContraints) {
        if (node != null) {
            IDOMNode previousSibling = (IDOMNode)node.getPreviousSibling();
            IStructuredDocument doc = node.getModel().getStructuredDocument();
            int line = doc.getLineOfOffset(node.getStartOffset());
            String lineDelimiter = doc.getLineDelimiter();
            try {
                if (line > 0 && (lineDelimiter = doc.getLineDelimiter(line - 1)) == null) {
                    lineDelimiter = EMPTY_STRING;
                }
            }
            catch (BadLocationException e) {
                Logger.log(1, e.getMessage());
            }
            String lineIndent = formatContraints.getCurrentIndent();
            if (node.getParentNode() != null) {
                if (node.getParentNode().getNodeType() == 9) {
                    if (previousSibling != null) {
                        if (previousSibling.getNodeType() == 3) {
                            this.getFormatter(previousSibling).format((Node)previousSibling, formatContraints);
                        } else {
                            this.insertBeforeNode(node, String.valueOf(lineDelimiter) + lineIndent);
                        }
                    }
                } else if (previousSibling == null || previousSibling.getNodeType() != 3) {
                    int prevEndNodeOffset = -1;
                    int prevEndRegionOffset = -1;
                    if (previousSibling != null) {
                        prevEndNodeOffset = previousSibling.getEndOffset();
                        IStructuredDocumentRegion endRegion = previousSibling.getEndStructuredDocumentRegion();
                        if (endRegion != null) {
                            prevEndRegionOffset = endRegion.getTextEndOffset();
                        }
                    }
                    if (previousSibling == null || prevEndNodeOffset != -1 && prevEndNodeOffset == prevEndRegionOffset) {
                        this.insertBeforeNode(node, String.valueOf(lineDelimiter) + lineIndent);
                    }
                } else if (previousSibling.getNodeValue().length() == 0) {
                    this.replaceNodeValue(previousSibling, String.valueOf(lineDelimiter) + lineIndent);
                } else if (!previousSibling.getNodeValue().endsWith(String.valueOf(lineDelimiter) + lineIndent)) {
                    if (previousSibling.getNodeValue().endsWith(lineDelimiter)) {
                        this.insertAfterNode(previousSibling, lineIndent);
                    } else {
                        this.getFormatter(previousSibling).format((Node)previousSibling, formatContraints);
                    }
                }
            }
        }
    }

    protected void formatNode(IDOMNode node, IStructuredFormatContraints formatContraints) {
        if (!(node == null || this.fProgressMonitor != null && this.fProgressMonitor.isCanceled())) {
            this.formatIndentationBeforeNode(node, formatContraints);
            this.formatIndentationAfterNode(node, formatContraints);
        }
    }

    protected void formatTrailingText(IDOMNode node, IStructuredFormatContraints formatContraints) {
        String lineDelimiter = node.getModel().getStructuredDocument().getLineDelimiter();
        String lineIndent = formatContraints.getCurrentIndent();
        String parentLineIndent = this.getNodeIndent(node.getParentNode());
        boolean clearAllBlankLines = formatContraints.getClearAllBlankLines();
        if (node != null && node.getNodeType() != 9) {
            IDOMNode nextSibling = (IDOMNode)node.getNextSibling();
            if (nextSibling != null && nextSibling.getNodeType() == 3) {
                String nextSiblingText = nextSibling.getNodeValue();
                if (nextSibling.getNextSibling() == null) {
                    if (nextSibling.getParentNode().getNodeType() == 9 && nextSiblingText.trim().length() == 0) {
                        this.replaceNodeValue(nextSibling, EMPTY_STRING);
                    } else {
                        this.replaceNodeValue(nextSibling, String.valueOf(lineDelimiter) + parentLineIndent);
                    }
                } else {
                    this.replaceNodeValue(nextSibling, String.valueOf(lineDelimiter) + lineIndent);
                }
            } else if (nextSibling == null) {
                lineIndent = parentLineIndent;
                if (!(node.getParentNode().getNodeType() == 9 || node.getNodeType() == 3 && node.getNodeValue().endsWith(String.valueOf(lineDelimiter) + lineIndent))) {
                    if (node.getNodeType() == 3 && node.getNodeValue().endsWith(lineDelimiter)) {
                        if (clearAllBlankLines) {
                            this.replaceNodeValue(node, String.valueOf(lineDelimiter) + lineIndent);
                        } else {
                            this.insertAfterNode(node, lineIndent);
                        }
                    } else if (node.getNodeType() == 3) {
                        if (node.getNodeValue().length() == 0) {
                            this.replaceNodeValue(node, String.valueOf(lineDelimiter) + lineIndent);
                        } else if (!node.getNodeValue().endsWith(String.valueOf(lineDelimiter) + lineIndent)) {
                            if (node.getNodeValue().endsWith(lineDelimiter)) {
                                this.insertAfterNode(node, lineIndent);
                            } else {
                                this.insertAfterNode(node, String.valueOf(lineDelimiter) + lineIndent);
                            }
                        } else {
                            this.replaceNodeValue(node, String.valueOf(lineDelimiter) + lineIndent);
                        }
                    }
                }
            } else if (node.getNodeType() != 3 || !node.getNodeValue().endsWith(String.valueOf(lineDelimiter) + lineIndent)) {
                if (node.getNodeType() == 3 && node.getNodeValue().endsWith(lineDelimiter)) {
                    if (clearAllBlankLines) {
                        this.replaceNodeValue(node, String.valueOf(lineDelimiter) + lineIndent);
                    } else {
                        this.insertAfterNode(node, lineIndent);
                    }
                } else if (node.getNodeType() == 3) {
                    if (node.getNodeValue().length() == 0) {
                        this.replaceNodeValue(node, String.valueOf(lineDelimiter) + lineIndent);
                    } else {
                        this.insertAfterNode(node, String.valueOf(lineDelimiter) + lineIndent);
                    }
                } else {
                    this.insertAfterNode(node, String.valueOf(lineDelimiter) + lineIndent);
                }
            }
        }
    }

    protected String getCompressedNodeText(IDOMNode node, IStructuredFormatContraints formatContraints) {
        return this.compressSpaces(this.getNodeText(node), formatContraints);
    }

    protected IDOMNode getDeepestChildNode(IDOMNode node) {
        IDOMNode result = null;
        IDOMNode lastChild = (IDOMNode)node.getLastChild();
        if (lastChild == null) {
            result = node;
        } else {
            result = this.getDeepestChildNode(lastChild);
            if (!(result.getNodeType() != 3 && result.getNodeType() != 8 || this.isEndTagMissing(node))) {
                result = node;
            }
        }
        return result;
    }

    public IStructuredFormatContraints getFormatContraints() {
        if (this.fFormatContraints == null) {
            this.fFormatContraints = new StructuredFormatContraints();
            this.fFormatContraints.setClearAllBlankLines(this.getFormatPreferences().getClearAllBlankLines());
        }
        return this.fFormatContraints;
    }

    public IStructuredFormatPreferences getFormatPreferences() {
        if (this.fFormatPreferences == null) {
            this.fFormatPreferences = new StructuredFormatPreferencesXML();
            Preferences preferences = this.getModelPreferences();
            if (preferences != null) {
                this.fFormatPreferences.setLineWidth(preferences.getInt("lineWidth"));
                ((IStructuredFormatPreferencesXML)this.fFormatPreferences).setSplitMultiAttrs(preferences.getBoolean("splitMultiAttrs"));
                this.fFormatPreferences.setClearAllBlankLines(preferences.getBoolean("clearAllBlankLines"));
                char indentChar = ' ';
                String indentCharPref = preferences.getString("indentationChar");
                if ("tab".equals(indentCharPref)) {
                    indentChar = '\t';
                }
                int indentationWidth = preferences.getInt("indentationSize");
                StringBuffer indent = new StringBuffer();
                int i = 0;
                while (i < indentationWidth) {
                    indent.append(indentChar);
                    ++i;
                }
                this.fFormatPreferences.setIndent(indent.toString());
            }
        }
        return this.fFormatPreferences;
    }

    protected IStructuredFormatter getFormatter(IDOMNode node) {
        if (node == null) {
            return null;
        }
        short nodeType = node.getNodeType();
        NodeFormatter formatter = null;
        switch (nodeType) {
            case 1: {
                formatter = new ElementNodeFormatter();
                break;
            }
            case 3: {
                if (node instanceof CDATASectionImpl) {
                    formatter = new NodeFormatter();
                    break;
                }
                formatter = new TextNodeFormatter();
                break;
            }
            case 8: {
                formatter = new CommentNodeFormatter();
                break;
            }
            case 7: {
                formatter = new NodeFormatter();
                break;
            }
            case 9: {
                formatter = new DocumentNodeFormatter();
                break;
            }
            default: {
                formatter = new NodeFormatter();
            }
        }
        formatter.setFormatPreferences(this.getFormatPreferences());
        formatter.setProgressMonitor(this.fProgressMonitor);
        return formatter;
    }

    protected int getIndentationLength(String indent) {
        int indentationLength = 0;
        int i = 0;
        while (i < indent.length()) {
            indentationLength = indent.substring(i, i + 1).compareTo(TAB) == 0 ? (indentationLength += 4) : ++indentationLength;
            ++i;
        }
        return indentationLength;
    }

    protected Preferences getModelPreferences() {
        return XMLCorePlugin.getDefault().getPluginPreferences();
    }

    protected String getNodeIndent(Node node) {
        IDOMNode siblingTextNode;
        String result = EMPTY_STRING;
        if (node != null && node.getNodeType() != 9 && node.getParentNode() != null && node.getParentNode().getNodeType() != 9 && (siblingTextNode = (IDOMNode)node.getPreviousSibling()) != null && siblingTextNode.getNodeType() == 3) {
            String siblingText = siblingTextNode.getNodeValue();
            int siblingTextLength = siblingText.length();
            if (siblingText != null && siblingTextLength > 0 && (siblingText.charAt(siblingTextLength - 1) == ' ' || siblingText.charAt(siblingTextLength - 1) == '\t')) {
                int searchIndex = siblingTextLength - 1;
                while (searchIndex >= 0 && (siblingText.charAt(searchIndex) == ' ' || siblingText.charAt(searchIndex) == '\t')) {
                    --searchIndex;
                }
                if (searchIndex < siblingTextLength) {
                    result = siblingText.substring(searchIndex + 1, siblingTextLength);
                }
            }
        }
        return result;
    }

    protected String getNodeName(IDOMNode node) {
        return node.getNodeName();
    }

    protected String getNodeText(IDOMNode node) {
        String text = null;
        text = node instanceof CharacterDataImpl && !(node instanceof CommentImpl) && !(node instanceof CDATASectionImpl) && !this.isJSPTag(node) ? ((CharacterDataImpl)node).getSource() : node.getFirstStructuredDocumentRegion().getText();
        return text;
    }

    protected IDOMNode getParentIndentNode(IDOMNode node) {
        ITextRegion region;
        IDOMNode result = null;
        IDOMNode parentNode = (IDOMNode)node.getParentNode();
        result = parentNode.getNodeType() == 9 ? parentNode : ((region = parentNode.getLastStructuredDocumentRegion().getFirstRegion()).getType() == "XML_END_TAG_OPEN" ? parentNode : this.getParentIndentNode(parentNode));
        return result;
    }

    protected String getSiblingIndent(Node node) {
        String result = EMPTY_STRING;
        if (node != null && node.getNodeType() != 9 && node.getParentNode() != null && node.getParentNode().getNodeType() != 9) {
            String nodeIndent;
            String nodeIndent2;
            String siblingIndent;
            IDOMNode sibling = (IDOMNode)node.getPreviousSibling();
            while (sibling != null && (sibling.getNodeType() == 3 || sibling.getNodeType() == 8)) {
                if (sibling.getNodeType() == 8 && sibling.getPreviousSibling() != null && sibling.getPreviousSibling().getNodeType() == 3 && StringUtils.containsLineDelimiter((String)sibling.getPreviousSibling().getNodeValue())) break;
                sibling = (IDOMNode)sibling.getPreviousSibling();
            }
            if (sibling == null) {
                sibling = (IDOMNode)node.getNextSibling();
                while (sibling != null && sibling.getNodeType() == 3) {
                    sibling = (IDOMNode)sibling.getNextSibling();
                }
            }
            String singleIndent = this.getFormatPreferences().getIndent();
            String parentLineIndent = this.getNodeIndent(node.getParentNode());
            result = sibling != null ? ((siblingIndent = this.getNodeIndent(sibling)).length() > 0 ? siblingIndent : ((nodeIndent2 = this.getNodeIndent(node)).length() > parentLineIndent.length() ? nodeIndent2 : String.valueOf(parentLineIndent) + singleIndent)) : ((nodeIndent = this.getNodeIndent(node)).length() > parentLineIndent.length() ? nodeIndent : String.valueOf(parentLineIndent) + singleIndent);
        }
        return result;
    }

    protected void insertAfterNode(IDOMNode node, String string) {
        IDOMModel structuredModel = node.getModel();
        IStructuredDocument structuredDocument = structuredModel.getStructuredDocument();
        int offset = node.getEndOffset();
        int length = 0;
        if (node.getEndStructuredDocumentRegion() != null) {
            offset = node.getEndStructuredDocumentRegion().getTextEndOffset();
            length = node.getEndOffset() - offset;
        }
        this.replace(structuredDocument, offset, length, string);
    }

    protected void insertBeforeNode(IDOMNode node, String string) {
        IDOMModel structuredModel = node.getModel();
        IStructuredDocument structuredDocument = structuredModel.getStructuredDocument();
        this.replace(structuredDocument, node.getStartOffset(), 0, string);
    }

    public boolean isAdapterForType(Object type) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.wst.sse.core.internal.format.IStructuredFormatter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return type.equals(clazz);
    }

    protected boolean isEndTagMissing(IDOMNode node) {
        boolean result = false;
        if (node != null && node.getNodeType() != 9 && !this.isJSPTag(node)) {
            IStructuredDocumentRegion startTagStructuredDocumentRegion = node.getFirstStructuredDocumentRegion();
            IStructuredDocumentRegion endTagStructuredDocumentRegion = node.getLastStructuredDocumentRegion();
            ITextRegion startTagNameRegion = null;
            if (startTagStructuredDocumentRegion.getRegions().size() > 1) {
                startTagNameRegion = startTagStructuredDocumentRegion.getRegions().get(1);
            }
            ITextRegion endTagNameRegion = null;
            if (endTagStructuredDocumentRegion.getRegions().size() > 1) {
                endTagNameRegion = endTagStructuredDocumentRegion.getRegions().get(1);
            }
            ITextRegionList startTagRegions = startTagStructuredDocumentRegion.getRegions();
            if (startTagNameRegion == endTagNameRegion && startTagNameRegion != null && startTagRegions.get(0).getType() != "XML_END_TAG_OPEN" && startTagRegions.get(startTagRegions.size() - 1).getType() != "XML_EMPTY_TAG_CLOSE") {
                result = true;
            }
        }
        return result;
    }

    protected boolean nodeHasSiblings(IDOMNode node) {
        return node.getPreviousSibling() != null || node.getNextSibling() != null;
    }

    public void notifyChanged(INodeNotifier notifier, int eventType, Object changedFeature, Object oldValue, Object newValue, int pos) {
    }

    protected void removeRegionSpaces(IDOMNode node, IStructuredDocumentRegion flatNode, ITextRegion region) {
        if (region != null && (region instanceof ContextRegion || region instanceof TagNameRegion) && flatNode.getEndOffset(region) > flatNode.getTextEndOffset(region)) {
            IDOMModel structuredModel = node.getModel();
            IStructuredDocument structuredDocument = structuredModel.getStructuredDocument();
            this.replace(structuredDocument, flatNode.getTextEndOffset(region), flatNode.getEndOffset(region) - flatNode.getTextEndOffset(region), EMPTY_STRING);
        }
    }

    protected void replace(IStructuredDocument structuredDocument, int offset, int length, String string) {
        try {
            String structuredDocumentString = structuredDocument.get(offset, length);
            if (structuredDocumentString.compareTo(string) != 0) {
                structuredDocument.replaceText((Object)structuredDocument, offset, length, string);
            }
        }
        catch (BadLocationException e) {
            Logger.log(1, e.getMessage());
        }
    }

    protected void replaceNodeValue(IDOMNode node, String string) {
        IDOMModel structuredModel = node.getModel();
        IStructuredDocument structuredDocument = structuredModel.getStructuredDocument();
        int offset = node.getStartOffset();
        int length = node.getEndOffset() - node.getStartOffset();
        try {
            String structuredDocumentString = structuredDocument.get(offset, length);
            if (structuredDocumentString.compareTo(string) != 0) {
                this.replace(structuredDocument, offset, length, string);
            }
        }
        catch (BadLocationException e) {
            Logger.log(1, e.getMessage());
        }
    }

    public void setFormatPreferences(IStructuredFormatPreferences formatPreferences) {
        this.fFormatPreferences = formatPreferences;
    }

    public void setProgressMonitor(IProgressMonitor monitor) {
        this.fProgressMonitor = monitor;
    }

    private boolean isJSPTag(Node node) {
        String flatNodeType;
        IStructuredDocumentRegion flatNode;
        boolean result = false;
        if (node instanceof IDOMNode && (flatNode = ((IDOMNode)node).getFirstStructuredDocumentRegion()) != null && (flatNodeType = flatNode.getType()) != null && (flatNodeType.equals("JSP_CONTENT") || flatNodeType.equals("JSP_EXPRESSION_OPEN") || flatNodeType.equals("JSP_SCRIPTLET_OPEN") || flatNodeType.equals("JSP_DECLARATION_OPEN") || flatNodeType.equals("JSP_DIRECTIVE_CLOSE") || flatNodeType.equals("JSP_DIRECTIVE_NAME") || flatNodeType.equals("JSP_DIRECTIVE_OPEN") || flatNodeType.equals("JSP_CLOSE"))) {
            result = true;
        }
        return result;
    }
}

